/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.Legend$LegendItem;
import java.util.ArrayList;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.ParallelTransition;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.BubbleChart$1;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.ValueAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.chart.XYChart$Data;
import javafx.scene.chart.XYChart$Series;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Ellipse;
import javafx.util.Duration;

public class BubbleChart<X, Y>
extends XYChart<X, Y> {
    private ParallelTransition parallelTransition;

    public BubbleChart(@NamedArg(value="xAxis") Axis<X> axis, @NamedArg(value="yAxis") Axis<Y> axis2) {
        this(axis, axis2, FXCollections.observableArrayList());
    }

    public BubbleChart(@NamedArg(value="xAxis") Axis<X> axis, @NamedArg(value="yAxis") Axis<Y> axis2, @NamedArg(value="data") ObservableList<XYChart$Series<X, Y>> observableList) {
        super(axis, axis2);
        if (!(axis instanceof ValueAxis) || !(axis2 instanceof ValueAxis)) {
            throw new IllegalArgumentException("Axis type incorrect, X and Y should both be NumberAxis");
        }
        this.setData(observableList);
    }

    private static double getDoubleValue(Object object, double d2) {
        if (!(object instanceof Number)) {
            return d2;
        }
        return ((Number)object).doubleValue();
    }

    @Override
    protected void layoutPlotChildren() {
        for (int i2 = 0; i2 < this.getDataSize(); ++i2) {
            Object object = (XYChart$Series)this.getData().get(i2);
            object = this.getDisplayedDataIterator(object);
            while (object.hasNext()) {
                Ellipse ellipse;
                Node node;
                XYChart$Data xYChart$Data = (XYChart$Data)object.next();
                double d2 = this.getXAxis().getDisplayPosition(xYChart$Data.getCurrentX());
                double d3 = this.getYAxis().getDisplayPosition(xYChart$Data.getCurrentY());
                if (Double.isNaN(d2) || Double.isNaN(d3) || (node = xYChart$Data.getNode()) == null || !(node instanceof StackPane)) continue;
                StackPane stackPane = (StackPane)xYChart$Data.getNode();
                if (stackPane.getShape() == null) {
                    ellipse = new Ellipse(BubbleChart.getDoubleValue(xYChart$Data.getExtraValue(), 1.0), BubbleChart.getDoubleValue(xYChart$Data.getExtraValue(), 1.0));
                } else if (stackPane.getShape() instanceof Ellipse) {
                    ellipse = (Ellipse)stackPane.getShape();
                } else {
                    return;
                }
                ellipse.setRadiusX(BubbleChart.getDoubleValue(xYChart$Data.getExtraValue(), 1.0) * (this.getXAxis() instanceof NumberAxis ? Math.abs(((NumberAxis)this.getXAxis()).getScale()) : 1.0));
                ellipse.setRadiusY(BubbleChart.getDoubleValue(xYChart$Data.getExtraValue(), 1.0) * (this.getYAxis() instanceof NumberAxis ? Math.abs(((NumberAxis)this.getYAxis()).getScale()) : 1.0));
                stackPane.setShape(null);
                stackPane.setShape(ellipse);
                stackPane.setScaleShape(false);
                stackPane.setCenterShape(false);
                stackPane.setCacheShape(false);
                node.setLayoutX(d2);
                node.setLayoutY(d3);
            }
        }
    }

    @Override
    protected void dataItemAdded(XYChart$Series<X, Y> object, int n2, XYChart$Data<X, Y> xYChart$Data) {
        object = this.createBubble((XYChart$Series<X, Y>)object, this.getData().indexOf(object), xYChart$Data, n2);
        if (this.shouldAnimate()) {
            ((Node)object).setOpacity(0.0);
            this.getPlotChildren().add((Node)object);
            object = new FadeTransition(Duration.millis(500.0), (Node)object);
            ((FadeTransition)object).setToValue(1.0);
            ((Animation)object).play();
            return;
        }
        this.getPlotChildren().add((Node)object);
    }

    @Override
    protected void dataItemRemoved(XYChart$Data<X, Y> xYChart$Data, XYChart$Series<X, Y> xYChart$Series) {
        Node node = xYChart$Data.getNode();
        if (this.shouldAnimate()) {
            FadeTransition fadeTransition = new FadeTransition(Duration.millis(500.0), node);
            fadeTransition.setToValue(0.0);
            fadeTransition.setOnFinished(actionEvent -> {
                this.getPlotChildren().remove(node);
                this.removeDataItemFromDisplay(xYChart$Series, xYChart$Data);
                node.setOpacity(1.0);
            });
            fadeTransition.play();
            return;
        }
        this.getPlotChildren().remove(node);
        this.removeDataItemFromDisplay(xYChart$Series, xYChart$Data);
    }

    @Override
    protected void dataItemChanged(XYChart$Data<X, Y> xYChart$Data) {
    }

    @Override
    protected void seriesAdded(XYChart$Series<X, Y> xYChart$Series, int n2) {
        for (int i2 = 0; i2 < xYChart$Series.getData().size(); ++i2) {
            Object object = (XYChart$Data)xYChart$Series.getData().get(i2);
            object = this.createBubble(xYChart$Series, n2, (XYChart$Data<X, Y>)object, i2);
            if (this.shouldAnimate()) {
                ((Node)object).setOpacity(0.0);
                this.getPlotChildren().add((Node)object);
                object = new FadeTransition(Duration.millis(500.0), (Node)object);
                ((FadeTransition)object).setToValue(1.0);
                ((Animation)object).play();
                continue;
            }
            this.getPlotChildren().add((Node)object);
        }
    }

    @Override
    protected void seriesRemoved(XYChart$Series<X, Y> object) {
        if (this.shouldAnimate()) {
            this.parallelTransition = new ParallelTransition();
            this.parallelTransition.setOnFinished(arg_0 -> this.lambda$seriesRemoved$1((XYChart$Series)object, arg_0));
            for (XYChart$Data object3 : ((XYChart$Series)object).getData()) {
                Node object2 = object3.getNode();
                object = new FadeTransition(Duration.millis(500.0), object2);
                ((FadeTransition)object).setToValue(0.0);
                ((Animation)object).setOnFinished(actionEvent -> {
                    this.getPlotChildren().remove(object2);
                    object2.setOpacity(1.0);
                });
                this.parallelTransition.getChildren().add((Animation)object);
            }
            this.parallelTransition.play();
            return;
        }
        for (XYChart$Data xYChart$Data : ((XYChart$Series)object).getData()) {
            Node node = xYChart$Data.getNode();
            this.getPlotChildren().remove(node);
        }
        this.removeSeriesFromDisplay(object);
    }

    @Override
    void seriesBeingRemovedIsAdded(XYChart$Series<X, Y> xYChart$Series) {
        if (this.parallelTransition != null) {
            this.parallelTransition.setOnFinished(null);
            this.parallelTransition.stop();
            this.parallelTransition = null;
            this.getPlotChildren().remove(xYChart$Series.getNode());
            for (XYChart$Data xYChart$Data : xYChart$Series.getData()) {
                this.getPlotChildren().remove(xYChart$Data.getNode());
            }
            this.removeSeriesFromDisplay(xYChart$Series);
        }
    }

    private Node createBubble(XYChart$Series<X, Y> xYChart$Series, int n2, XYChart$Data<X, Y> xYChart$Data, int n3) {
        Node node = xYChart$Data.getNode();
        if (node == null) {
            node = new BubbleChart$1(this, xYChart$Data);
            node.setAccessibleRole(AccessibleRole.TEXT);
            node.setAccessibleRoleDescription("Bubble");
            node.focusTraversableProperty().bind(Platform.accessibilityActiveProperty());
            xYChart$Data.setNode(node);
        }
        node.getStyleClass().setAll((String[])new String[]{"chart-bubble", "series" + n2, "data" + n3, xYChart$Series.defaultColorStyleClass});
        return node;
    }

    @Override
    protected void updateAxisRange() {
        Axis axis = this.getXAxis();
        Axis axis2 = this.getYAxis();
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        if (axis.isAutoRanging()) {
            arrayList = new ArrayList();
        }
        if (axis2.isAutoRanging()) {
            arrayList2 = new ArrayList();
        }
        boolean bl2 = axis instanceof CategoryAxis;
        boolean bl3 = axis2 instanceof CategoryAxis;
        if (arrayList != null || arrayList2 != null) {
            for (XYChart$Series xYChart$Series : this.getData()) {
                for (XYChart$Data xYChart$Data : xYChart$Series.getData()) {
                    if (arrayList != null) {
                        if (bl2) {
                            arrayList.add(xYChart$Data.getXValue());
                        } else {
                            Axis axis3 = axis;
                            arrayList.add(axis3.toRealValue(axis3.toNumericValue(xYChart$Data.getXValue()) + BubbleChart.getDoubleValue(xYChart$Data.getExtraValue(), 0.0)));
                            Axis axis4 = axis;
                            arrayList.add(axis4.toRealValue(axis4.toNumericValue(xYChart$Data.getXValue()) - BubbleChart.getDoubleValue(xYChart$Data.getExtraValue(), 0.0)));
                        }
                    }
                    if (arrayList2 == null) continue;
                    if (bl3) {
                        arrayList2.add(xYChart$Data.getYValue());
                        continue;
                    }
                    Axis axis5 = axis2;
                    arrayList2.add(axis5.toRealValue(axis5.toNumericValue(xYChart$Data.getYValue()) + BubbleChart.getDoubleValue(xYChart$Data.getExtraValue(), 0.0)));
                    Axis axis6 = axis2;
                    arrayList2.add(axis6.toRealValue(axis6.toNumericValue(xYChart$Data.getYValue()) - BubbleChart.getDoubleValue(xYChart$Data.getExtraValue(), 0.0)));
                }
            }
            if (arrayList != null) {
                axis.invalidateRange(arrayList);
            }
            if (arrayList2 != null) {
                axis2.invalidateRange(arrayList2);
            }
        }
    }

    @Override
    Legend$LegendItem createLegendItemForSeries(XYChart$Series<X, Y> xYChart$Series, int n2) {
        Legend$LegendItem legend$LegendItem = new Legend$LegendItem(xYChart$Series.getName());
        legend$LegendItem.getSymbol().getStyleClass().addAll((String[])new String[]{"series" + n2, "chart-bubble", "bubble-legend-symbol", xYChart$Series.defaultColorStyleClass});
        return legend$LegendItem;
    }
}

