/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.Legend$LegendItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.animation.Animation;
import javafx.animation.Animation$Status;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener$Change;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.chart.AreaChart;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart$1;
import javafx.scene.chart.LineChart$2;
import javafx.scene.chart.LineChart$SortingPolicy;
import javafx.scene.chart.LineChart$StyleableProperties;
import javafx.scene.chart.XYChart;
import javafx.scene.chart.XYChart$Data;
import javafx.scene.chart.XYChart$Series;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.StrokeLineJoin;
import javafx.util.Duration;

public class LineChart<X, Y>
extends XYChart<X, Y> {
    private Map<XYChart$Series<X, Y>, DoubleProperty> seriesYMultiplierMap = new HashMap<XYChart$Series<X, Y>, DoubleProperty>();
    private Timeline dataRemoveTimeline;
    private XYChart$Series<X, Y> seriesOfDataRemoved = null;
    private XYChart$Data<X, Y> dataItemBeingRemoved = null;
    private FadeTransition fadeSymbolTransition = null;
    private Map<XYChart$Data<X, Y>, Double> XYValueMap = new HashMap<XYChart$Data<X, Y>, Double>();
    private Timeline seriesRemoveTimeline = null;
    private BooleanProperty createSymbols = new LineChart$1(this, true);
    private ObjectProperty<LineChart$SortingPolicy> axisSortingPolicy = new LineChart$2(this, LineChart$SortingPolicy.X_AXIS);

    public final boolean getCreateSymbols() {
        return this.createSymbols.getValue();
    }

    public final void setCreateSymbols(boolean bl2) {
        this.createSymbols.setValue(bl2);
    }

    public final BooleanProperty createSymbolsProperty() {
        return this.createSymbols;
    }

    public final LineChart$SortingPolicy getAxisSortingPolicy() {
        return (LineChart$SortingPolicy)((Object)this.axisSortingPolicy.getValue());
    }

    public final void setAxisSortingPolicy(LineChart$SortingPolicy lineChart$SortingPolicy) {
        this.axisSortingPolicy.setValue(lineChart$SortingPolicy);
    }

    public final ObjectProperty<LineChart$SortingPolicy> axisSortingPolicyProperty() {
        return this.axisSortingPolicy;
    }

    public LineChart(@NamedArg(value="xAxis") Axis<X> axis, @NamedArg(value="yAxis") Axis<Y> axis2) {
        this(axis, axis2, FXCollections.observableArrayList());
    }

    public LineChart(@NamedArg(value="xAxis") Axis<X> axis, @NamedArg(value="yAxis") Axis<Y> axis2, @NamedArg(value="data") ObservableList<XYChart$Series<X, Y>> observableList) {
        super(axis, axis2);
        this.setData(observableList);
    }

    @Override
    protected void updateAxisRange() {
        Axis axis = this.getXAxis();
        Axis axis2 = this.getYAxis();
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        if (axis.isAutoRanging()) {
            arrayList = new ArrayList();
        }
        if (axis2.isAutoRanging()) {
            arrayList2 = new ArrayList();
        }
        if (arrayList != null || arrayList2 != null) {
            for (XYChart$Series xYChart$Series : this.getData()) {
                for (XYChart$Data xYChart$Data : xYChart$Series.getData()) {
                    if (arrayList != null) {
                        arrayList.add(xYChart$Data.getXValue());
                    }
                    if (arrayList2 == null) continue;
                    arrayList2.add(xYChart$Data.getYValue());
                }
            }
            if (arrayList != null && (arrayList.size() != 1 || this.getXAxis().toNumericValue(arrayList.get(0)) != 0.0)) {
                axis.invalidateRange(arrayList);
            }
            if (arrayList2 != null && (arrayList2.size() != 1 || this.getYAxis().toNumericValue(arrayList2.get(0)) != 0.0)) {
                axis2.invalidateRange(arrayList2);
            }
        }
    }

    @Override
    protected void dataItemAdded(XYChart$Series<X, Y> object, int n2, XYChart$Data<X, Y> xYChart$Data) {
        Node node = this.createSymbol((XYChart$Series<X, Y>)object, this.getData().indexOf(object), xYChart$Data, n2);
        if (this.shouldAnimate()) {
            if (this.dataRemoveTimeline != null && this.dataRemoveTimeline.getStatus().equals((Object)Animation$Status.RUNNING) && this.seriesOfDataRemoved == object) {
                ((Animation)this.dataRemoveTimeline).stop();
                this.dataRemoveTimeline = null;
                this.getPlotChildren().remove(this.dataItemBeingRemoved.getNode());
                LineChart lineChart = this;
                lineChart.removeDataItemFromDisplay(lineChart.seriesOfDataRemoved, this.dataItemBeingRemoved);
                this.seriesOfDataRemoved = null;
                this.dataItemBeingRemoved = null;
            }
            boolean bl2 = false;
            if (n2 > 0 && n2 < ((XYChart$Series)object).getData().size() - 1) {
                bl2 = true;
                XYChart$Data xYChart$Data2 = (XYChart$Data)((XYChart$Series)object).getData().get(n2 - 1);
                object = (XYChart$Data)((XYChart$Series)object).getData().get(n2 + 1);
                if (xYChart$Data2 != null && object != null) {
                    double d2;
                    double d3 = this.getXAxis().toNumericValue(xYChart$Data2.getXValue());
                    double d4 = this.getYAxis().toNumericValue(xYChart$Data2.getYValue());
                    double d5 = this.getXAxis().toNumericValue(((XYChart$Data)object).getXValue());
                    double d6 = this.getYAxis().toNumericValue(((XYChart$Data)object).getYValue());
                    double d7 = this.getXAxis().toNumericValue(xYChart$Data.getXValue());
                    if (d2 > d3 && d7 < d5) {
                        double d8 = (d6 - d4) / (d5 - d3) * d7 + (d5 * d4 - d6 * d3) / (d5 - d3);
                        xYChart$Data.setCurrentY(this.getYAxis().toRealValue(d8));
                        xYChart$Data.setCurrentX(this.getXAxis().toRealValue(d7));
                    } else {
                        double d9 = (d5 + d3) / 2.0;
                        double d10 = (d6 + d4) / 2.0;
                        xYChart$Data.setCurrentX(this.getXAxis().toRealValue(d9));
                        xYChart$Data.setCurrentY(this.getYAxis().toRealValue(d10));
                    }
                }
            } else if (n2 == 0 && ((XYChart$Series)object).getData().size() > 1) {
                bl2 = true;
                xYChart$Data.setCurrentX(((XYChart$Data)((XYChart$Series)object).getData().get(1)).getXValue());
                xYChart$Data.setCurrentY(((XYChart$Data)((XYChart$Series)object).getData().get(1)).getYValue());
            } else if (n2 == ((XYChart$Series)object).getData().size() - 1 && ((XYChart$Series)object).getData().size() > 1) {
                bl2 = true;
                int n3 = ((XYChart$Series)object).getData().size() - 2;
                xYChart$Data.setCurrentX(((XYChart$Data)((XYChart$Series)object).getData().get(n3)).getXValue());
                xYChart$Data.setCurrentY(((XYChart$Data)((XYChart$Series)object).getData().get(n3)).getYValue());
            } else if (node != null) {
                node.setOpacity(0.0);
                this.getPlotChildren().add(node);
                FadeTransition fadeTransition = new FadeTransition(Duration.millis(500.0), node);
                fadeTransition.setToValue(1.0);
                fadeTransition.play();
            }
            if (bl2) {
                this.animate(new KeyFrame(Duration.ZERO, actionEvent -> {
                    if (node != null && !this.getPlotChildren().contains(node)) {
                        this.getPlotChildren().add(node);
                    }
                }, new KeyValue(xYChart$Data.currentYProperty(), xYChart$Data.getCurrentY()), new KeyValue(xYChart$Data.currentXProperty(), xYChart$Data.getCurrentX())), new KeyFrame(Duration.millis(700.0), new KeyValue(xYChart$Data.currentYProperty(), xYChart$Data.getYValue(), Interpolator.EASE_BOTH), new KeyValue(xYChart$Data.currentXProperty(), xYChart$Data.getXValue(), Interpolator.EASE_BOTH)));
            }
            return;
        }
        if (node != null) {
            this.getPlotChildren().add(node);
        }
    }

    @Override
    protected void dataItemRemoved(XYChart$Data<X, Y> xYChart$Data, XYChart$Series<X, Y> xYChart$Series) {
        Node node = xYChart$Data.getNode();
        if (node != null) {
            node.focusTraversableProperty().unbind();
        }
        int n2 = xYChart$Series.getItemIndex(xYChart$Data);
        if (this.shouldAnimate()) {
            this.XYValueMap.clear();
            boolean bl2 = false;
            int n3 = xYChart$Series.getDataSize();
            int n4 = xYChart$Series.getData().size();
            if (n2 > 0 && n2 < n3 - 1) {
                bl2 = true;
                XYChart$Data<X, Y> xYChart$Data2 = xYChart$Series.getItem(n2 - 1);
                XYChart$Data<X, Y> xYChart$Data3 = xYChart$Series.getItem(n2 + 1);
                double d2 = this.getXAxis().toNumericValue(xYChart$Data2.getXValue());
                double d3 = this.getYAxis().toNumericValue(xYChart$Data2.getYValue());
                double d4 = this.getXAxis().toNumericValue(xYChart$Data3.getXValue());
                double d5 = this.getYAxis().toNumericValue(xYChart$Data3.getYValue());
                double d6 = this.getXAxis().toNumericValue(xYChart$Data.getXValue());
                double d7 = this.getYAxis().toNumericValue(xYChart$Data.getYValue());
                if (d6 > d2 && d6 < d4) {
                    double d8 = (d5 - d3) / (d4 - d2) * d6 + (d4 * d3 - d5 * d2) / (d4 - d2);
                    xYChart$Data.setCurrentX(this.getXAxis().toRealValue(d6));
                    xYChart$Data.setCurrentY(this.getYAxis().toRealValue(d7));
                    xYChart$Data.setXValue(this.getXAxis().toRealValue(d6));
                    xYChart$Data.setYValue(this.getYAxis().toRealValue(d8));
                } else {
                    double d9 = (d4 + d2) / 2.0;
                    double d10 = (d5 + d3) / 2.0;
                    xYChart$Data.setCurrentX(this.getXAxis().toRealValue(d9));
                    xYChart$Data.setCurrentY(this.getYAxis().toRealValue(d10));
                }
            } else if (n2 == 0 && n4 > 1) {
                bl2 = true;
                xYChart$Data.setXValue(((XYChart$Data)xYChart$Series.getData().get(0)).getXValue());
                xYChart$Data.setYValue(((XYChart$Data)xYChart$Series.getData().get(0)).getYValue());
            } else if (n2 == n3 - 1 && n4 > 1) {
                bl2 = true;
                n3 = n4 - 1;
                xYChart$Data.setXValue(((XYChart$Data)xYChart$Series.getData().get(n3)).getXValue());
                xYChart$Data.setYValue(((XYChart$Data)xYChart$Series.getData().get(n3)).getYValue());
            } else if (node != null) {
                this.fadeSymbolTransition = new FadeTransition(Duration.millis(500.0), node);
                this.fadeSymbolTransition.setToValue(0.0);
                this.fadeSymbolTransition.setOnFinished(actionEvent -> {
                    xYChart$Data.setSeries(null);
                    this.getPlotChildren().remove(node);
                    this.removeDataItemFromDisplay(xYChart$Series, xYChart$Data);
                    node.setOpacity(1.0);
                });
                this.fadeSymbolTransition.play();
            } else {
                xYChart$Data.setSeries(null);
                this.removeDataItemFromDisplay(xYChart$Series, xYChart$Data);
            }
            if (bl2) {
                this.dataRemoveTimeline = this.createDataRemoveTimeline(xYChart$Data, node, xYChart$Series);
                this.seriesOfDataRemoved = xYChart$Series;
                this.dataItemBeingRemoved = xYChart$Data;
                this.dataRemoveTimeline.play();
            }
            return;
        }
        xYChart$Data.setSeries(null);
        if (node != null) {
            this.getPlotChildren().remove(node);
        }
        this.removeDataItemFromDisplay(xYChart$Series, xYChart$Data);
    }

    @Override
    protected void dataItemChanged(XYChart$Data<X, Y> xYChart$Data) {
    }

    @Override
    protected void seriesChanged(ListChangeListener$Change<? extends XYChart$Series> listChangeListener$Change) {
        for (int i2 = 0; i2 < this.getDataSize(); ++i2) {
            XYChart$Series xYChart$Series = (XYChart$Series)this.getData().get(i2);
            Node node = xYChart$Series.getNode();
            if (node != null) {
                node.getStyleClass().setAll((String[])new String[]{"chart-series-line", "series" + i2, xYChart$Series.defaultColorStyleClass});
            }
            for (int i3 = 0; i3 < xYChart$Series.getData().size(); ++i3) {
                Node node2 = ((XYChart$Data)xYChart$Series.getData().get(i3)).getNode();
                if (node2 == null) continue;
                node2.getStyleClass().setAll((String[])new String[]{"chart-line-symbol", "series" + i2, "data" + i3, xYChart$Series.defaultColorStyleClass});
            }
        }
    }

    @Override
    protected void seriesAdded(XYChart$Series<X, Y> xYChart$Series, int n2) {
        Path path = new Path();
        path.setStrokeLineJoin(StrokeLineJoin.BEVEL);
        xYChart$Series.setNode(path);
        Object object = new SimpleDoubleProperty(this, "seriesYMultiplier");
        this.seriesYMultiplierMap.put(xYChart$Series, (DoubleProperty)object);
        if (this.shouldAnimate()) {
            path.setOpacity(0.0);
            ((DoubleProperty)object).setValue(0.0);
        } else {
            ((DoubleProperty)object).setValue(1.0);
        }
        this.getPlotChildren().add(path);
        ArrayList<KeyFrame> arrayList = new ArrayList<KeyFrame>();
        if (this.shouldAnimate()) {
            arrayList.add(new KeyFrame(Duration.ZERO, new KeyValue(path.opacityProperty(), 0), new KeyValue(object, 0)));
            arrayList.add(new KeyFrame(Duration.millis(200.0), new KeyValue(path.opacityProperty(), 1)));
            arrayList.add(new KeyFrame(Duration.millis(500.0), new KeyValue(object, 1)));
        }
        for (int i2 = 0; i2 < xYChart$Series.getData().size(); ++i2) {
            object = (XYChart$Data)xYChart$Series.getData().get(i2);
            if ((object = this.createSymbol(xYChart$Series, n2, (XYChart$Data<X, Y>)object, i2)) == null) continue;
            if (this.shouldAnimate()) {
                ((Node)object).setOpacity(0.0);
            }
            this.getPlotChildren().add((Node)object);
            if (!this.shouldAnimate()) continue;
            arrayList.add(new KeyFrame(Duration.ZERO, new KeyValue(((Node)object).opacityProperty(), 0)));
            arrayList.add(new KeyFrame(Duration.millis(200.0), new KeyValue(((Node)object).opacityProperty(), 1)));
        }
        if (this.shouldAnimate()) {
            ArrayList<KeyFrame> arrayList2 = arrayList;
            this.animate(arrayList2.toArray(new KeyFrame[arrayList2.size()]));
        }
    }

    @Override
    protected void seriesRemoved(XYChart$Series<X, Y> xYChart$Series) {
        this.seriesYMultiplierMap.remove(xYChart$Series);
        if (this.shouldAnimate()) {
            this.seriesRemoveTimeline = new Timeline(this.createSeriesRemoveTimeLine(xYChart$Series, 900L));
            this.seriesRemoveTimeline.play();
            return;
        }
        this.getPlotChildren().remove(xYChart$Series.getNode());
        for (XYChart$Data xYChart$Data : xYChart$Series.getData()) {
            this.getPlotChildren().remove(xYChart$Data.getNode());
        }
        this.removeSeriesFromDisplay(xYChart$Series);
    }

    @Override
    protected void layoutPlotChildren() {
        ArrayList<LineTo> arrayList = new ArrayList<LineTo>(this.getDataSize());
        for (int i2 = 0; i2 < this.getDataSize(); ++i2) {
            XYChart$Series xYChart$Series = (XYChart$Series)this.getData().get(i2);
            DoubleProperty doubleProperty = this.seriesYMultiplierMap.get(xYChart$Series);
            Node node = xYChart$Series.getNode();
            if (!(node instanceof Path)) continue;
            AreaChart.makePaths(this, xYChart$Series, arrayList, null, (Path)node, doubleProperty.get(), this.getAxisSortingPolicy());
        }
    }

    @Override
    void dataBeingRemovedIsAdded(XYChart$Data xYChart$Data, XYChart$Series object) {
        Node node;
        if (this.fadeSymbolTransition != null) {
            this.fadeSymbolTransition.setOnFinished(null);
            this.fadeSymbolTransition.stop();
        }
        if (this.dataRemoveTimeline != null) {
            this.dataRemoveTimeline.setOnFinished(null);
            ((Animation)this.dataRemoveTimeline).stop();
        }
        if ((node = xYChart$Data.getNode()) != null) {
            this.getPlotChildren().remove(node);
        }
        xYChart$Data.setSeries(null);
        this.removeDataItemFromDisplay(object, xYChart$Data);
        object = this.XYValueMap.get(xYChart$Data);
        if (object != null) {
            xYChart$Data.setYValue(object);
            xYChart$Data.setCurrentY(object);
        }
        this.XYValueMap.clear();
    }

    @Override
    void seriesBeingRemovedIsAdded(XYChart$Series<X, Y> xYChart$Series) {
        if (this.seriesRemoveTimeline != null) {
            this.seriesRemoveTimeline.setOnFinished(null);
            ((Animation)this.seriesRemoveTimeline).stop();
            this.seriesRemoveTimeline = null;
            this.getPlotChildren().remove(xYChart$Series.getNode());
            for (XYChart$Data xYChart$Data : xYChart$Series.getData()) {
                this.getPlotChildren().remove(xYChart$Data.getNode());
            }
            this.removeSeriesFromDisplay(xYChart$Series);
        }
    }

    private Timeline createDataRemoveTimeline(XYChart$Data<X, Y> xYChart$Data, Node node, XYChart$Series<X, Y> xYChart$Series) {
        Timeline timeline = new Timeline();
        XYChart$Data<X, Y> xYChart$Data2 = xYChart$Data;
        this.XYValueMap.put(xYChart$Data2, ((Number)xYChart$Data2.getYValue()).doubleValue());
        timeline.getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue(xYChart$Data.currentYProperty(), xYChart$Data.getCurrentY()), new KeyValue(xYChart$Data.currentXProperty(), xYChart$Data.getCurrentX())), new KeyFrame(Duration.millis(500.0), actionEvent -> {
            if (node != null) {
                this.getPlotChildren().remove(node);
            }
            this.removeDataItemFromDisplay(xYChart$Series, xYChart$Data);
            this.XYValueMap.clear();
        }, new KeyValue(xYChart$Data.currentYProperty(), xYChart$Data.getYValue(), Interpolator.EASE_BOTH), new KeyValue(xYChart$Data.currentXProperty(), xYChart$Data.getXValue(), Interpolator.EASE_BOTH))});
        return timeline;
    }

    private Node createSymbol(XYChart$Series<X, Y> xYChart$Series, int n2, XYChart$Data<X, Y> xYChart$Data, int n3) {
        Node node = xYChart$Data.getNode();
        if (node == null && this.getCreateSymbols()) {
            node = new StackPane();
            node.setAccessibleRole(AccessibleRole.TEXT);
            node.setAccessibleRoleDescription("Point");
            node.focusTraversableProperty().bind(Platform.accessibilityActiveProperty());
            xYChart$Data.setNode(node);
        }
        if (node != null) {
            node.getStyleClass().addAll((String[])new String[]{"chart-line-symbol", "series" + n2, "data" + n3, xYChart$Series.defaultColorStyleClass});
        }
        return node;
    }

    @Override
    Legend$LegendItem createLegendItemForSeries(XYChart$Series<X, Y> xYChart$Series, int n2) {
        Legend$LegendItem legend$LegendItem = new Legend$LegendItem(xYChart$Series.getName());
        legend$LegendItem.getSymbol().getStyleClass().addAll((String[])new String[]{"chart-line-symbol", "series" + n2, xYChart$Series.defaultColorStyleClass});
        return legend$LegendItem;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return LineChart$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return LineChart.getClassCssMetaData();
    }
}

