/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.Legend$LegendItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.beans.property.DoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ListChangeListener$Change;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.geometry.Orientation;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.StackedBarChart$1;
import javafx.scene.chart.StackedBarChart$2;
import javafx.scene.chart.StackedBarChart$StyleableProperties;
import javafx.scene.chart.ValueAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.chart.XYChart$Data;
import javafx.scene.chart.XYChart$Series;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

public class StackedBarChart<X, Y>
extends XYChart<X, Y> {
    private Map<XYChart$Series<X, Y>, Map<String, List<XYChart$Data<X, Y>>>> seriesCategoryMap = new HashMap<XYChart$Series<X, Y>, Map<String, List<XYChart$Data<X, Y>>>>();
    private final Orientation orientation;
    private CategoryAxis categoryAxis;
    private ValueAxis valueAxis;
    private ParallelTransition parallelTransition;
    private ListChangeListener<String> categoriesListener = new StackedBarChart$1(this);
    private DoubleProperty categoryGap = new StackedBarChart$2(this, 10.0);
    private static final PseudoClass VERTICAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("vertical");
    private static final PseudoClass HORIZONTAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("horizontal");

    public double getCategoryGap() {
        return this.categoryGap.getValue();
    }

    public void setCategoryGap(double d2) {
        this.categoryGap.setValue(d2);
    }

    public DoubleProperty categoryGapProperty() {
        return this.categoryGap;
    }

    public StackedBarChart(@NamedArg(value="xAxis") Axis<X> axis, @NamedArg(value="yAxis") Axis<Y> axis2) {
        this(axis, axis2, FXCollections.observableArrayList());
    }

    public StackedBarChart(@NamedArg(value="xAxis") Axis<X> axis, @NamedArg(value="yAxis") Axis<Y> axis2, @NamedArg(value="data") ObservableList<XYChart$Series<X, Y>> observableList) {
        super(axis, axis2);
        this.getStyleClass().add("stacked-bar-chart");
        if (!(axis instanceof ValueAxis && axis2 instanceof CategoryAxis || axis2 instanceof ValueAxis && axis instanceof CategoryAxis)) {
            throw new IllegalArgumentException("Axis type incorrect, one of X,Y should be CategoryAxis and the other NumberAxis");
        }
        if (axis instanceof CategoryAxis) {
            this.categoryAxis = (CategoryAxis)axis;
            this.valueAxis = (ValueAxis)axis2;
            this.orientation = Orientation.VERTICAL;
        } else {
            this.categoryAxis = (CategoryAxis)axis2;
            this.valueAxis = (ValueAxis)axis;
            this.orientation = Orientation.HORIZONTAL;
        }
        this.pseudoClassStateChanged(HORIZONTAL_PSEUDOCLASS_STATE, this.orientation == Orientation.HORIZONTAL);
        this.pseudoClassStateChanged(VERTICAL_PSEUDOCLASS_STATE, this.orientation == Orientation.VERTICAL);
        this.setData(observableList);
        this.categoryAxis.getCategories().addListener(this.categoriesListener);
    }

    public StackedBarChart(@NamedArg(value="xAxis") Axis<X> axis, @NamedArg(value="yAxis") Axis<Y> axis2, @NamedArg(value="data") ObservableList<XYChart$Series<X, Y>> observableList, @NamedArg(value="categoryGap") double d2) {
        this(axis, axis2);
        this.setData(observableList);
        this.setCategoryGap(d2);
    }

    @Override
    protected void dataItemAdded(XYChart$Series<X, Y> object, int n2, XYChart$Data<X, Y> xYChart$Data) {
        String string = this.orientation == Orientation.VERTICAL ? (String)xYChart$Data.getXValue() : (String)xYChart$Data.getYValue();
        Map<String, List<XYChart$Data<X, Y>>> map = this.seriesCategoryMap.get(object);
        if (map == null) {
            map = new HashMap<String, List<XYChart$Data<X, Y>>>();
            this.seriesCategoryMap.put((XYChart$Series<X, Y>)object, map);
        }
        List<Object> list = map.get(string) != null ? map.get(string) : new ArrayList();
        list.add(xYChart$Data);
        map.put(string, list);
        object = this.createBar((XYChart$Series<X, Y>)object, this.getData().indexOf(object), xYChart$Data, n2);
        if (this.shouldAnimate()) {
            this.animateDataAdd(xYChart$Data, (Node)object);
            return;
        }
        this.getPlotChildren().add((Node)object);
    }

    @Override
    protected void dataItemRemoved(XYChart$Data<X, Y> xYChart$Data, XYChart$Series<X, Y> xYChart$Series) {
        Object object = xYChart$Data.getNode();
        if (object != null) {
            ((Node)object).focusTraversableProperty().unbind();
        }
        if (this.shouldAnimate()) {
            object = this.createDataRemoveTimeline(xYChart$Data, (Node)object, xYChart$Series);
            ((Animation)object).setOnFinished(actionEvent -> this.removeDataItemFromDisplay(xYChart$Series, xYChart$Data));
            ((Animation)object).play();
            return;
        }
        this.processDataRemove(xYChart$Series, xYChart$Data);
        this.removeDataItemFromDisplay(xYChart$Series, xYChart$Data);
    }

    @Override
    protected void dataItemChanged(XYChart$Data<X, Y> xYChart$Data) {
        double d2;
        double d3;
        if (this.orientation == Orientation.VERTICAL) {
            d3 = ((Number)xYChart$Data.getYValue()).doubleValue();
            d2 = ((Number)this.getCurrentDisplayedYValue(xYChart$Data)).doubleValue();
        } else {
            d3 = ((Number)xYChart$Data.getXValue()).doubleValue();
            d2 = ((Number)this.getCurrentDisplayedXValue(xYChart$Data)).doubleValue();
        }
        if (d2 > 0.0 && d3 < 0.0) {
            xYChart$Data.getNode().getStyleClass().add("negative");
            return;
        }
        if (d2 < 0.0 && d3 > 0.0) {
            xYChart$Data.getNode().getStyleClass().remove("negative");
        }
    }

    @Override
    protected void seriesChanged(ListChangeListener$Change<? extends XYChart$Series> listChangeListener$Change) {
        for (int i2 = 0; i2 < this.getDataSize(); ++i2) {
            XYChart$Series xYChart$Series = (XYChart$Series)this.getData().get(i2);
            for (int i3 = 0; i3 < xYChart$Series.getData().size(); ++i3) {
                Object object = (XYChart$Data)xYChart$Series.getData().get(i3);
                object = ((XYChart$Data)object).getNode();
                ((Node)object).getStyleClass().setAll((String[])new String[]{"chart-bar", "series" + i2, "data" + i3, xYChart$Series.defaultColorStyleClass});
            }
        }
    }

    @Override
    protected void seriesAdded(XYChart$Series<X, Y> xYChart$Series, int n2) {
        HashMap hashMap = new HashMap();
        for (int i2 = 0; i2 < xYChart$Series.getData().size(); ++i2) {
            double d2;
            XYChart$Data xYChart$Data = (XYChart$Data)xYChart$Series.getData().get(i2);
            Node node = this.createBar(xYChart$Series, n2, xYChart$Data, i2);
            String string = this.orientation == Orientation.VERTICAL ? (String)xYChart$Data.getXValue() : (String)xYChart$Data.getYValue();
            List<XYChart$Data> list = hashMap.get(string) != null ? (List)hashMap.get(string) : new ArrayList();
            list.add(xYChart$Data);
            hashMap.put(string, list);
            if (this.shouldAnimate()) {
                this.animateDataAdd(xYChart$Data, node);
                continue;
            }
            double d3 = d2 = this.orientation == Orientation.VERTICAL ? ((Number)xYChart$Data.getYValue()).doubleValue() : ((Number)xYChart$Data.getXValue()).doubleValue();
            if (d3 < 0.0) {
                node.getStyleClass().add("negative");
            }
            this.getPlotChildren().add(node);
        }
        if (hashMap.size() > 0) {
            this.seriesCategoryMap.put(xYChart$Series, hashMap);
        }
    }

    @Override
    protected void seriesRemoved(XYChart$Series<X, Y> xYChart$Series) {
        if (this.shouldAnimate()) {
            this.parallelTransition = new ParallelTransition();
            this.parallelTransition.setOnFinished(actionEvent -> {
                this.removeSeriesFromDisplay(xYChart$Series);
                this.requestChartLayout();
            });
            for (XYChart$Data xYChart$Data : xYChart$Series.getData()) {
                Animation animation;
                Node node = xYChart$Data.getNode();
                if (this.getSeriesSize() > 1) {
                    animation = this.createDataRemoveTimeline(xYChart$Data, node, xYChart$Series);
                    this.parallelTransition.getChildren().add(animation);
                    continue;
                }
                animation = new FadeTransition(Duration.millis(700.0), node);
                ((FadeTransition)animation).setFromValue(1.0);
                ((FadeTransition)animation).setToValue(0.0);
                animation.setOnFinished(actionEvent -> {
                    this.processDataRemove(xYChart$Series, xYChart$Data);
                    node.setOpacity(1.0);
                });
                this.parallelTransition.getChildren().add(animation);
            }
            this.parallelTransition.play();
            return;
        }
        for (XYChart$Data xYChart$Data : xYChart$Series.getData()) {
            this.processDataRemove(xYChart$Series, xYChart$Data);
        }
        this.removeSeriesFromDisplay(xYChart$Series);
        this.requestChartLayout();
    }

    @Override
    protected void updateAxisRange() {
        ArrayList<Object> arrayList;
        boolean bl2;
        boolean bl3 = bl2 = this.categoryAxis == this.getXAxis();
        if (this.categoryAxis.isAutoRanging()) {
            arrayList = new ArrayList<Object>();
            for (XYChart$Series object : this.getData()) {
                for (XYChart$Data xYChart$Data : object.getData()) {
                    if (xYChart$Data == null) continue;
                    arrayList.add(bl2 ? xYChart$Data.getXValue() : xYChart$Data.getYValue());
                }
            }
            ((Axis)this.categoryAxis).invalidateRange(arrayList);
        }
        if (this.valueAxis.isAutoRanging()) {
            arrayList = new ArrayList();
            for (String string : this.categoryAxis.getAllDataCategories()) {
                double d2 = 0.0;
                double d3 = 0.0;
                Iterator iterator = this.getDisplayedSeriesIterator();
                while (iterator.hasNext()) {
                    XYChart$Series xYChart$Series = iterator.next();
                    for (XYChart$Data xYChart$Data : this.getDataItem(xYChart$Series, string)) {
                        if (xYChart$Data == null) continue;
                        boolean bl4 = xYChart$Data.getNode().getStyleClass().contains("negative");
                        Number number = (Number)(bl2 ? xYChart$Data.getYValue() : xYChart$Data.getXValue());
                        if (!bl4) {
                            d3 += this.valueAxis.toNumericValue(number);
                            continue;
                        }
                        d2 += this.valueAxis.toNumericValue(number);
                    }
                }
                arrayList.add(d3);
                arrayList.add(d2);
            }
            ((Axis)this.valueAxis).invalidateRange(arrayList);
        }
    }

    @Override
    protected void layoutPlotChildren() {
        double d2;
        double d3 = this.categoryAxis.getCategorySpacing();
        double d4 = d2 = d3 - this.getCategoryGap();
        double d5 = -((d3 - this.getCategoryGap()) / 2.0);
        for (String string : this.categoryAxis.getCategories()) {
            double d6 = 0.0;
            double d7 = 0.0;
            Iterator iterator = this.getDisplayedSeriesIterator();
            while (iterator.hasNext()) {
                XYChart$Series xYChart$Series = iterator.next();
                for (XYChart$Data xYChart$Data : this.getDataItem(xYChart$Series, string)) {
                    double d8;
                    double d9;
                    double d10;
                    double d11;
                    if (xYChart$Data == null) continue;
                    Node node = xYChart$Data.getNode();
                    Object x2 = this.getCurrentDisplayedXValue(xYChart$Data);
                    Object bl2 = this.getCurrentDisplayedYValue(xYChart$Data);
                    if (this.orientation == Orientation.VERTICAL) {
                        d11 = this.getXAxis().getDisplayPosition(x2);
                        d10 = this.getYAxis().toNumericValue(bl2);
                    } else {
                        d11 = this.getYAxis().getDisplayPosition(bl2);
                        d10 = this.getXAxis().toNumericValue(x2);
                    }
                    boolean bl3 = node.getStyleClass().contains("negative");
                    if (!bl3) {
                        d9 = this.valueAxis.getDisplayPosition(d6);
                        d8 = this.valueAxis.getDisplayPosition(d6 + d10);
                        d6 += d10;
                    } else {
                        d9 = this.valueAxis.getDisplayPosition(d7 + d10);
                        d8 = this.valueAxis.getDisplayPosition(d7);
                        d7 += d10;
                    }
                    if (this.orientation == Orientation.VERTICAL) {
                        node.resizeRelocate(d11 + d5, d8, d4, d9 - d8);
                        continue;
                    }
                    node.resizeRelocate(d9, d11 + d5, d8 - d9, d4);
                }
            }
        }
    }

    @Override
    Legend$LegendItem createLegendItemForSeries(XYChart$Series<X, Y> xYChart$Series, int n2) {
        Legend$LegendItem legend$LegendItem = new Legend$LegendItem(xYChart$Series.getName());
        legend$LegendItem.getSymbol().getStyleClass().addAll((String[])new String[]{"chart-bar", "series" + n2, "bar-legend-symbol", xYChart$Series.defaultColorStyleClass});
        return legend$LegendItem;
    }

    private void updateMap(XYChart$Series<X, Y> xYChart$Series, XYChart$Data<X, Y> object) {
        object = this.orientation == Orientation.VERTICAL ? (String)((XYChart$Data)object).getXValue() : (String)((XYChart$Data)object).getYValue();
        Map<String, List<XYChart$Data<X, Y>>> map = this.seriesCategoryMap.get(xYChart$Series);
        if (map != null) {
            map.remove(object);
            if (map.isEmpty()) {
                this.seriesCategoryMap.remove(xYChart$Series);
            }
        }
        if (this.seriesCategoryMap.isEmpty() && this.categoryAxis.isAutoRanging()) {
            this.categoryAxis.getCategories().clear();
        }
    }

    private void processDataRemove(XYChart$Series<X, Y> xYChart$Series, XYChart$Data<X, Y> xYChart$Data) {
        Node node = xYChart$Data.getNode();
        this.getPlotChildren().remove(node);
        this.updateMap(xYChart$Series, xYChart$Data);
    }

    private void animateDataAdd(XYChart$Data<X, Y> xYChart$Data, Node node) {
        double d2;
        if (this.orientation == Orientation.VERTICAL) {
            double d3;
            double d4 = ((Number)xYChart$Data.getYValue()).doubleValue();
            if (d3 < 0.0) {
                node.getStyleClass().add("negative");
            }
            xYChart$Data.setYValue(this.getYAxis().toRealValue(this.getYAxis().getZeroPosition()));
            this.setCurrentDisplayedYValue(xYChart$Data, this.getYAxis().toRealValue(this.getYAxis().getZeroPosition()));
            this.getPlotChildren().add(node);
            xYChart$Data.setYValue(this.getYAxis().toRealValue(d4));
            this.animate(new KeyFrame(Duration.ZERO, new KeyValue(this.currentDisplayedYValueProperty(xYChart$Data), this.getCurrentDisplayedYValue(xYChart$Data))), new KeyFrame(Duration.millis(700.0), new KeyValue(this.currentDisplayedYValueProperty(xYChart$Data), xYChart$Data.getYValue(), Interpolator.EASE_BOTH)));
            return;
        }
        double d5 = ((Number)xYChart$Data.getXValue()).doubleValue();
        if (d2 < 0.0) {
            node.getStyleClass().add("negative");
        }
        xYChart$Data.setXValue(this.getXAxis().toRealValue(this.getXAxis().getZeroPosition()));
        this.setCurrentDisplayedXValue(xYChart$Data, this.getXAxis().toRealValue(this.getXAxis().getZeroPosition()));
        this.getPlotChildren().add(node);
        xYChart$Data.setXValue(this.getXAxis().toRealValue(d5));
        this.animate(new KeyFrame(Duration.ZERO, new KeyValue(this.currentDisplayedXValueProperty(xYChart$Data), this.getCurrentDisplayedXValue(xYChart$Data))), new KeyFrame(Duration.millis(700.0), new KeyValue(this.currentDisplayedXValueProperty(xYChart$Data), xYChart$Data.getXValue(), Interpolator.EASE_BOTH)));
    }

    private Timeline createDataRemoveTimeline(XYChart$Data<X, Y> xYChart$Data, Node object, XYChart$Series<X, Y> xYChart$Series) {
        object = new Timeline();
        if (this.orientation == Orientation.VERTICAL) {
            ((Timeline)object).getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue(this.currentDisplayedYValueProperty(xYChart$Data), this.getCurrentDisplayedYValue(xYChart$Data))), new KeyFrame(Duration.millis(700.0), actionEvent -> this.processDataRemove(xYChart$Series, xYChart$Data), new KeyValue(this.currentDisplayedYValueProperty(xYChart$Data), xYChart$Data.getYValue(), Interpolator.EASE_BOTH))});
        } else {
            xYChart$Data.setXValue(this.getXAxis().toRealValue(this.getXAxis().getZeroPosition()));
            ((Timeline)object).getKeyFrames().addAll((KeyFrame[])new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue(this.currentDisplayedXValueProperty(xYChart$Data), this.getCurrentDisplayedXValue(xYChart$Data))), new KeyFrame(Duration.millis(700.0), actionEvent -> this.processDataRemove(xYChart$Series, xYChart$Data), new KeyValue(this.currentDisplayedXValueProperty(xYChart$Data), xYChart$Data.getXValue(), Interpolator.EASE_BOTH))});
        }
        return object;
    }

    private Node createBar(XYChart$Series<X, Y> xYChart$Series, int n2, XYChart$Data<X, Y> xYChart$Data, int n3) {
        Node node = xYChart$Data.getNode();
        if (node == null) {
            node = new StackPane();
            node.setAccessibleRole(AccessibleRole.TEXT);
            node.setAccessibleRoleDescription("Bar");
            node.focusTraversableProperty().bind(Platform.accessibilityActiveProperty());
            xYChart$Data.setNode(node);
        }
        node.getStyleClass().setAll((String[])new String[]{"chart-bar", "series" + n2, "data" + n3, xYChart$Series.defaultColorStyleClass});
        return node;
    }

    private List<XYChart$Data<X, Y>> getDataItem(XYChart$Series<X, Y> object, String string) {
        if ((object = this.seriesCategoryMap.get(object)) != null) {
            if (object.get(string) != null) {
                return (List)object.get(string);
            }
            return new ArrayList<XYChart$Data<X, Y>>();
        }
        return new ArrayList<XYChart$Data<X, Y>>();
    }

    @Override
    void seriesBeingRemovedIsAdded(XYChart$Series<X, Y> xYChart$Series) {
        if (this.parallelTransition != null) {
            this.parallelTransition.setOnFinished(null);
            this.parallelTransition.stop();
            this.parallelTransition = null;
            this.getPlotChildren().remove(xYChart$Series.getNode());
            for (XYChart$Data xYChart$Data : xYChart$Series.getData()) {
                this.getPlotChildren().remove(xYChart$Data.getNode());
            }
            this.removeSeriesFromDisplay(xYChart$Series);
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StackedBarChart$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return StackedBarChart.getClassCssMetaData();
    }
}

