/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.geometry.Side;
import javafx.scene.chart.Axis;
import javafx.scene.chart.ValueAxis$1;
import javafx.scene.chart.ValueAxis$2;
import javafx.scene.chart.ValueAxis$3;
import javafx.scene.chart.ValueAxis$4;
import javafx.scene.chart.ValueAxis$5;
import javafx.scene.chart.ValueAxis$6;
import javafx.scene.chart.ValueAxis$7;
import javafx.scene.chart.ValueAxis$StyleableProperties;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.util.StringConverter;

public abstract class ValueAxis<T extends Number>
extends Axis<T> {
    private final Path minorTickPath = new Path();
    private double offset;
    double dataMinValue;
    double dataMaxValue;
    private List<T> minorTickMarkValues = null;
    private boolean minorTickMarksDirty = true;
    protected final DoubleProperty currentLowerBound = new SimpleDoubleProperty(this, "currentLowerBound");
    private BooleanProperty minorTickVisible = new ValueAxis$1(this, true);
    private ReadOnlyDoubleWrapper scale;
    private DoubleProperty upperBound;
    private DoubleProperty lowerBound;
    private final ObjectProperty<StringConverter<T>> tickLabelFormatter;
    private DoubleProperty minorTickLength;
    private IntegerProperty minorTickCount;

    public final boolean isMinorTickVisible() {
        return this.minorTickVisible.get();
    }

    public final void setMinorTickVisible(boolean bl2) {
        this.minorTickVisible.set(bl2);
    }

    public final BooleanProperty minorTickVisibleProperty() {
        return this.minorTickVisible;
    }

    public final double getScale() {
        return this.scale.get();
    }

    protected final void setScale(double d2) {
        this.scale.set(d2);
    }

    public final ReadOnlyDoubleProperty scaleProperty() {
        return this.scale.getReadOnlyProperty();
    }

    ReadOnlyDoubleWrapper scalePropertyImpl() {
        return this.scale;
    }

    public final double getUpperBound() {
        return this.upperBound.get();
    }

    public final void setUpperBound(double d2) {
        this.upperBound.set(d2);
    }

    public final DoubleProperty upperBoundProperty() {
        return this.upperBound;
    }

    public final double getLowerBound() {
        return this.lowerBound.get();
    }

    public final void setLowerBound(double d2) {
        this.lowerBound.set(d2);
    }

    public final DoubleProperty lowerBoundProperty() {
        return this.lowerBound;
    }

    public final StringConverter<T> getTickLabelFormatter() {
        return (StringConverter)this.tickLabelFormatter.getValue();
    }

    public final void setTickLabelFormatter(StringConverter<T> stringConverter) {
        this.tickLabelFormatter.setValue(stringConverter);
    }

    public final ObjectProperty<StringConverter<T>> tickLabelFormatterProperty() {
        return this.tickLabelFormatter;
    }

    public final double getMinorTickLength() {
        return this.minorTickLength.get();
    }

    public final void setMinorTickLength(double d2) {
        this.minorTickLength.set(d2);
    }

    public final DoubleProperty minorTickLengthProperty() {
        return this.minorTickLength;
    }

    public final int getMinorTickCount() {
        return this.minorTickCount.get();
    }

    public final void setMinorTickCount(int n2) {
        this.minorTickCount.set(n2);
    }

    public final IntegerProperty minorTickCountProperty() {
        return this.minorTickCount;
    }

    public ValueAxis() {
        ValueAxis valueAxis = this;
        this.scale = new ValueAxis$2(valueAxis, valueAxis, "scale", 0.0);
        this.upperBound = new ValueAxis$3(this, 100.0);
        this.lowerBound = new ValueAxis$4(this, 0.0);
        this.tickLabelFormatter = new ValueAxis$5(this, null);
        this.minorTickLength = new ValueAxis$6(this, 5.0);
        this.minorTickCount = new ValueAxis$7(this, 5);
        this.minorTickPath.getStyleClass().add("axis-minor-tick-mark");
        this.getChildren().add(this.minorTickPath);
    }

    public ValueAxis(double d2, double d3) {
        this();
        this.setAutoRanging(false);
        this.setLowerBound(d2);
        this.setUpperBound(d3);
    }

    @Override
    protected final Object autoRange(double d2) {
        if (this.isAutoRanging()) {
            double d3 = this.getTickLabelFont().getSize() * 2.0;
            ValueAxis valueAxis = this;
            return valueAxis.autoRange(valueAxis.dataMinValue, this.dataMaxValue, d2, d3);
        }
        return this.getRange();
    }

    protected final double calculateNewScale(double d2, double d3, double d4) {
        double d5;
        Side side = this.getEffectiveSide();
        if (side.isVertical()) {
            this.offset = d2;
            d5 = d4 - d3 == 0.0 ? -d2 : -(d2 / (d4 - d3));
        } else {
            this.offset = 0.0;
            d5 = d4 - d3 == 0.0 ? d2 : d2 / (d4 - d3);
        }
        return d5;
    }

    protected Object autoRange(double d2, double d3, double d4, double d5) {
        return null;
    }

    protected abstract List<T> calculateMinorTickMarks();

    @Override
    protected void tickMarksUpdated() {
        super.tickMarksUpdated();
        this.minorTickMarkValues = this.calculateMinorTickMarks();
        this.minorTickMarksDirty = true;
    }

    @Override
    protected void layoutChildren() {
        double d2;
        Side side = this.getEffectiveSide();
        double d3 = d2 = side.isVertical() ? this.getHeight() : this.getWidth();
        if (!this.isAutoRanging()) {
            ValueAxis valueAxis = this;
            valueAxis.setScale(valueAxis.calculateNewScale(d2, this.getLowerBound(), this.getUpperBound()));
            this.currentLowerBound.set(this.getLowerBound());
        }
        super.layoutChildren();
        if (this.minorTickMarksDirty) {
            this.minorTickMarksDirty = false;
            this.updateMinorTickPath(side, d2);
        }
    }

    private void updateMinorTickPath(Side object, double d2) {
        double d3;
        int n2 = (this.getTickMarks().size() - 1) * (Math.max(1, this.getMinorTickCount()) - 1);
        double d4 = this.getTickMarks().size() + n2 << 1;
        this.minorTickPath.getElements().clear();
        double d5 = Math.max(0.0, this.getMinorTickLength());
        if (d3 > 0.0 && d2 > d4) {
            if (Side.LEFT.equals(object)) {
                this.minorTickPath.setLayoutX(-0.5);
                this.minorTickPath.setLayoutY(0.5);
                for (Number number : this.minorTickMarkValues) {
                    double d6;
                    double d7 = this.getDisplayPosition((T)number);
                    if (!(d6 >= 0.0) || !(d7 <= d2)) continue;
                    this.minorTickPath.getElements().addAll((PathElement[])new PathElement[]{new MoveTo(this.getWidth() - d5, d7), new LineTo(this.getWidth() - 1.0, d7)});
                }
                return;
            }
            if (Side.RIGHT.equals(object)) {
                this.minorTickPath.setLayoutX(0.5);
                this.minorTickPath.setLayoutY(0.5);
                for (Number number : this.minorTickMarkValues) {
                    double d8;
                    double d9 = this.getDisplayPosition((T)number);
                    if (!(d8 >= 0.0) || !(d9 <= d2)) continue;
                    this.minorTickPath.getElements().addAll((PathElement[])new PathElement[]{new MoveTo(1.0, d9), new LineTo(d5, d9)});
                }
                return;
            }
            if (Side.TOP.equals(object)) {
                this.minorTickPath.setLayoutX(0.5);
                this.minorTickPath.setLayoutY(-0.5);
                for (Number number : this.minorTickMarkValues) {
                    double d10;
                    double d11 = this.getDisplayPosition((T)number);
                    if (!(d10 >= 0.0) || !(d11 <= d2)) continue;
                    this.minorTickPath.getElements().addAll((PathElement[])new PathElement[]{new MoveTo(d11, this.getHeight() - 1.0), new LineTo(d11, this.getHeight() - d5)});
                }
                return;
            }
            this.minorTickPath.setLayoutX(0.5);
            this.minorTickPath.setLayoutY(0.5);
            for (Number number : this.minorTickMarkValues) {
                double d12;
                double d13 = this.getDisplayPosition((T)number);
                if (!(d12 >= 0.0) || !(d13 <= d2)) continue;
                this.minorTickPath.getElements().addAll((PathElement[])new PathElement[]{new MoveTo(d13, 1.0), new LineTo(d13, d5)});
            }
        }
    }

    @Override
    public void invalidateRange(List<T> list) {
        if (list.isEmpty()) {
            this.dataMaxValue = this.getUpperBound();
            this.dataMinValue = this.getLowerBound();
        } else {
            this.dataMinValue = Double.MAX_VALUE;
            this.dataMaxValue = -1.7976931348623157E308;
        }
        for (Number number : list) {
            this.dataMinValue = Math.min(this.dataMinValue, number.doubleValue());
            this.dataMaxValue = Math.max(this.dataMaxValue, number.doubleValue());
        }
        super.invalidateRange(list);
    }

    @Override
    public double getDisplayPosition(T t2) {
        return this.offset + (((Number)t2).doubleValue() - this.currentLowerBound.get()) * this.getScale();
    }

    @Override
    public T getValueForDisplay(double d2) {
        return (T)this.toRealValue((d2 - this.offset) / this.getScale() + this.currentLowerBound.get());
    }

    @Override
    public double getZeroPosition() {
        if (0.0 < this.getLowerBound() || 0.0 > this.getUpperBound()) {
            return Double.NaN;
        }
        return this.getDisplayPosition(0.0);
    }

    @Override
    public boolean isValueOnAxis(T t2) {
        double d2;
        double d3 = ((Number)t2).doubleValue();
        return d2 >= this.getLowerBound() && d3 <= this.getUpperBound();
    }

    @Override
    public double toNumericValue(T t2) {
        if (t2 == null) {
            return Double.NaN;
        }
        return ((Number)t2).doubleValue();
    }

    @Override
    public T toRealValue(double d2) {
        return (T)Double.valueOf(d2);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return ValueAxis$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return ValueAxis.getClassCssMetaData();
    }
}

