/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.charts.Legend;
import com.sun.javafx.charts.Legend$LegendItem;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ListChangeListener$Change;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.Axis$TickMark;
import javafx.scene.chart.Chart;
import javafx.scene.chart.XYChart$1;
import javafx.scene.chart.XYChart$10;
import javafx.scene.chart.XYChart$2;
import javafx.scene.chart.XYChart$3;
import javafx.scene.chart.XYChart$4;
import javafx.scene.chart.XYChart$5;
import javafx.scene.chart.XYChart$6;
import javafx.scene.chart.XYChart$7;
import javafx.scene.chart.XYChart$8;
import javafx.scene.chart.XYChart$9;
import javafx.scene.chart.XYChart$Data;
import javafx.scene.chart.XYChart$Series;
import javafx.scene.chart.XYChart$StyleableProperties;
import javafx.scene.layout.Region;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public abstract class XYChart<X, Y>
extends Chart {
    private final BitSet colorBits = new BitSet(8);
    static String DEFAULT_COLOR = "default-color";
    final Map<XYChart$Series<X, Y>, Integer> seriesColorMap = new HashMap<XYChart$Series<X, Y>, Integer>();
    private boolean rangeValid = false;
    private final Line verticalZeroLine = new Line();
    private final Line horizontalZeroLine = new Line();
    private final Path verticalGridLines = new Path();
    private final Path horizontalGridLines = new Path();
    private final Path horizontalRowFill = new Path();
    private final Path verticalRowFill = new Path();
    private final Region plotBackground = new Region();
    private final Group plotArea = new XYChart$1(this);
    private final Group plotContent = new Group();
    private final Rectangle plotAreaClip = new Rectangle();
    private final List<XYChart$Series<X, Y>> displayedSeries = new ArrayList<XYChart$Series<X, Y>>();
    private Legend legend = new Legend();
    private final ListChangeListener<XYChart$Series<X, Y>> seriesChanged = listChangeListener$Change -> {
        ObservableList observableList = listChangeListener$Change.getList();
        while (listChangeListener$Change.next()) {
            if (listChangeListener$Change.wasPermutated()) {
                this.displayedSeries.sort((xYChart$Series, xYChart$Series2) -> observableList.indexOf(xYChart$Series2) - observableList.indexOf(xYChart$Series));
            }
            if (listChangeListener$Change.getRemoved().size() > 0) {
                this.updateLegend();
            }
            HashSet<XYChart$Series<X, Y>> hashSet = new HashSet<XYChart$Series<X, Y>>(this.displayedSeries);
            hashSet.removeAll(listChangeListener$Change.getRemoved());
            for (XYChart$Series xYChart$Series3 : listChangeListener$Change.getAddedSubList()) {
                if (hashSet.add(xYChart$Series3) || xYChart$Series3.setToRemove) continue;
                throw new IllegalArgumentException("Duplicate series added");
            }
            for (XYChart$Series xYChart$Series3 : listChangeListener$Change.getRemoved()) {
                ((XYChart$Series)var4_6.next()).setToRemove = true;
                this.seriesRemoved(xYChart$Series3);
            }
            for (int i2 = listChangeListener$Change.getFrom(); i2 < listChangeListener$Change.getTo() && !listChangeListener$Change.wasPermutated(); ++i2) {
                XYChart$Series xYChart$Series3;
                xYChart$Series3 = (XYChart$Series)listChangeListener$Change.getList().get(i2);
                if (xYChart$Series3.setToRemove) {
                    xYChart$Series3.setToRemove = false;
                    xYChart$Series3.getChart().seriesBeingRemovedIsAdded(xYChart$Series3);
                }
                xYChart$Series3.setChart(this);
                this.displayedSeries.add(xYChart$Series3);
                int n2 = this.colorBits.nextClearBit(0);
                this.colorBits.set(n2, true);
                xYChart$Series3.defaultColorStyleClass = DEFAULT_COLOR + n2 % 8;
                this.seriesColorMap.put(xYChart$Series3, n2 % 8);
                this.seriesAdded(xYChart$Series3, i2);
            }
            if (listChangeListener$Change.getFrom() < listChangeListener$Change.getTo()) {
                this.updateLegend();
            }
            this.seriesChanged(listChangeListener$Change);
        }
        this.invalidateRange();
        this.requestChartLayout();
    };
    private final Axis<X> xAxis;
    private ReadOnlyObjectProperty<Axis<X>> xAxisProperty = new XYChart$2(this);
    private final Axis<Y> yAxis;
    private ReadOnlyObjectProperty<Axis<Y>> yAxisProperty = new XYChart$3(this);
    private ObjectProperty<ObservableList<XYChart$Series<X, Y>>> data = new XYChart$4(this);
    private BooleanProperty verticalGridLinesVisible = new XYChart$5(this, true);
    private BooleanProperty horizontalGridLinesVisible = new XYChart$6(this, true);
    private BooleanProperty alternativeColumnFillVisible = new XYChart$7(this, false);
    private BooleanProperty alternativeRowFillVisible = new XYChart$8(this, true);
    private BooleanProperty verticalZeroLineVisible = new XYChart$9(this, true);
    private BooleanProperty horizontalZeroLineVisible = new XYChart$10(this, true);

    public Axis<X> getXAxis() {
        return this.xAxis;
    }

    private ObservableValue<Axis<X>> xAxisProperty() {
        return this.xAxisProperty;
    }

    public Axis<Y> getYAxis() {
        return this.yAxis;
    }

    private ObservableValue<Axis<Y>> yAxisProperty() {
        return this.yAxisProperty;
    }

    public final ObservableList<XYChart$Series<X, Y>> getData() {
        return (ObservableList)this.data.getValue();
    }

    public final void setData(ObservableList<XYChart$Series<X, Y>> observableList) {
        this.data.setValue(observableList);
    }

    public final ObjectProperty<ObservableList<XYChart$Series<X, Y>>> dataProperty() {
        return this.data;
    }

    public final boolean getVerticalGridLinesVisible() {
        return this.verticalGridLinesVisible.get();
    }

    public final void setVerticalGridLinesVisible(boolean bl2) {
        this.verticalGridLinesVisible.set(bl2);
    }

    public final BooleanProperty verticalGridLinesVisibleProperty() {
        return this.verticalGridLinesVisible;
    }

    public final boolean isHorizontalGridLinesVisible() {
        return this.horizontalGridLinesVisible.get();
    }

    public final void setHorizontalGridLinesVisible(boolean bl2) {
        this.horizontalGridLinesVisible.set(bl2);
    }

    public final BooleanProperty horizontalGridLinesVisibleProperty() {
        return this.horizontalGridLinesVisible;
    }

    public final boolean isAlternativeColumnFillVisible() {
        return this.alternativeColumnFillVisible.getValue();
    }

    public final void setAlternativeColumnFillVisible(boolean bl2) {
        this.alternativeColumnFillVisible.setValue(bl2);
    }

    public final BooleanProperty alternativeColumnFillVisibleProperty() {
        return this.alternativeColumnFillVisible;
    }

    public final boolean isAlternativeRowFillVisible() {
        return this.alternativeRowFillVisible.getValue();
    }

    public final void setAlternativeRowFillVisible(boolean bl2) {
        this.alternativeRowFillVisible.setValue(bl2);
    }

    public final BooleanProperty alternativeRowFillVisibleProperty() {
        return this.alternativeRowFillVisible;
    }

    public final boolean isVerticalZeroLineVisible() {
        return this.verticalZeroLineVisible.get();
    }

    public final void setVerticalZeroLineVisible(boolean bl2) {
        this.verticalZeroLineVisible.set(bl2);
    }

    public final BooleanProperty verticalZeroLineVisibleProperty() {
        return this.verticalZeroLineVisible;
    }

    public final boolean isHorizontalZeroLineVisible() {
        return this.horizontalZeroLineVisible.get();
    }

    public final void setHorizontalZeroLineVisible(boolean bl2) {
        this.horizontalZeroLineVisible.set(bl2);
    }

    public final BooleanProperty horizontalZeroLineVisibleProperty() {
        return this.horizontalZeroLineVisible;
    }

    protected ObservableList<Node> getPlotChildren() {
        return this.plotContent.getChildren();
    }

    public XYChart(Axis<X> axis, Axis<Y> axis2) {
        this.xAxis = axis;
        if (axis.getSide() == null) {
            axis.setSide(Side.BOTTOM);
        }
        axis.setEffectiveOrientation(Orientation.HORIZONTAL);
        this.yAxis = axis2;
        if (axis2.getSide() == null) {
            axis2.setSide(Side.LEFT);
        }
        axis2.setEffectiveOrientation(Orientation.VERTICAL);
        axis.autoRangingProperty().addListener((observableValue, bl2, bl3) -> this.updateAxisRange());
        axis2.autoRangingProperty().addListener((observableValue, bl2, bl3) -> this.updateAxisRange());
        this.getChartChildren().addAll((Node[])new Node[]{this.plotBackground, this.plotArea, axis, axis2});
        this.plotArea.setAutoSizeChildren(false);
        this.plotContent.setAutoSizeChildren(false);
        this.plotAreaClip.setSmooth(false);
        this.plotArea.setClip(this.plotAreaClip);
        this.plotArea.getChildren().addAll((Node[])new Node[]{this.verticalRowFill, this.horizontalRowFill, this.verticalGridLines, this.horizontalGridLines, this.verticalZeroLine, this.horizontalZeroLine, this.plotContent});
        this.plotContent.getStyleClass().setAll((String[])new String[]{"plot-content"});
        this.plotBackground.getStyleClass().setAll((String[])new String[]{"chart-plot-background"});
        this.verticalRowFill.getStyleClass().setAll((String[])new String[]{"chart-alternative-column-fill"});
        this.horizontalRowFill.getStyleClass().setAll((String[])new String[]{"chart-alternative-row-fill"});
        this.verticalGridLines.getStyleClass().setAll((String[])new String[]{"chart-vertical-grid-lines"});
        this.horizontalGridLines.getStyleClass().setAll((String[])new String[]{"chart-horizontal-grid-lines"});
        this.verticalZeroLine.getStyleClass().setAll((String[])new String[]{"chart-vertical-zero-line"});
        this.horizontalZeroLine.getStyleClass().setAll((String[])new String[]{"chart-horizontal-zero-line"});
        this.plotContent.setManaged(false);
        this.plotArea.setManaged(false);
        this.animatedProperty().addListener((observableValue, bl2, bl3) -> {
            if (this.getXAxis() != null) {
                this.getXAxis().setAnimated((boolean)bl3);
            }
            if (this.getYAxis() != null) {
                this.getYAxis().setAnimated((boolean)bl3);
            }
        });
        XYChart xYChart = this;
        xYChart.setLegend(xYChart.legend);
    }

    final int getDataSize() {
        ObservableList<XYChart$Series<X, Y>> observableList = this.getData();
        if (observableList != null) {
            return observableList.size();
        }
        return 0;
    }

    private void seriesNameChanged() {
        this.updateLegend();
        this.requestChartLayout();
    }

    private void dataItemsChanged(XYChart$Series<X, Y> xYChart$Series, List<XYChart$Data<X, Y>> object, int n2, int n3, boolean bl2) {
        object = object.iterator();
        while (object.hasNext()) {
            XYChart$Data xYChart$Data = (XYChart$Data)object.next();
            this.dataItemRemoved(xYChart$Data, xYChart$Series);
        }
        for (int i2 = n2; i2 < n3; ++i2) {
            XYChart$Data xYChart$Data = (XYChart$Data)xYChart$Series.getData().get(i2);
            this.dataItemAdded(xYChart$Series, i2, xYChart$Data);
        }
        this.invalidateRange();
        this.requestChartLayout();
    }

    private <T> void dataValueChanged(XYChart$Data<X, Y> xYChart$Data, T t2, ObjectProperty<T> objectProperty) {
        if (objectProperty.get() != t2) {
            this.invalidateRange();
        }
        this.dataItemChanged(xYChart$Data);
        if (this.shouldAnimate()) {
            KeyFrame[] keyFrameArray = new KeyFrame[2];
            KeyValue[] keyValueArray = new KeyValue[1];
            ObjectProperty<T> objectProperty2 = objectProperty;
            keyValueArray[0] = new KeyValue(objectProperty2, objectProperty2.get());
            keyFrameArray[0] = new KeyFrame(Duration.ZERO, keyValueArray);
            keyFrameArray[1] = new KeyFrame(Duration.millis(700.0), new KeyValue(objectProperty, t2, Interpolator.EASE_BOTH));
            this.animate(keyFrameArray);
            return;
        }
        objectProperty.set(t2);
        this.requestChartLayout();
    }

    protected void updateLegend() {
        ArrayList<Legend$LegendItem> arrayList = new ArrayList<Legend$LegendItem>();
        if (this.getData() != null) {
            for (int i2 = 0; i2 < this.getData().size(); ++i2) {
                XYChart$Series xYChart$Series = (XYChart$Series)this.getData().get(i2);
                arrayList.add(this.createLegendItemForSeries(xYChart$Series, i2));
            }
        }
        this.legend.getItems().setAll((Collection<Legend$LegendItem>)arrayList);
        if (arrayList.size() > 0) {
            if (this.getLegend() == null) {
                XYChart xYChart = this;
                xYChart.setLegend(xYChart.legend);
                return;
            }
        } else {
            this.setLegend(null);
        }
    }

    Legend$LegendItem createLegendItemForSeries(XYChart$Series<X, Y> xYChart$Series, int n2) {
        return new Legend$LegendItem(xYChart$Series.getName());
    }

    void seriesBeingRemovedIsAdded(XYChart$Series<X, Y> xYChart$Series) {
    }

    void dataBeingRemovedIsAdded(XYChart$Data<X, Y> xYChart$Data, XYChart$Series<X, Y> xYChart$Series) {
    }

    protected abstract void dataItemAdded(XYChart$Series<X, Y> var1, int var2, XYChart$Data<X, Y> var3);

    protected abstract void dataItemRemoved(XYChart$Data<X, Y> var1, XYChart$Series<X, Y> var2);

    protected abstract void dataItemChanged(XYChart$Data<X, Y> var1);

    protected abstract void seriesAdded(XYChart$Series<X, Y> var1, int var2);

    protected abstract void seriesRemoved(XYChart$Series<X, Y> var1);

    protected void seriesChanged(ListChangeListener$Change<? extends XYChart$Series> listChangeListener$Change) {
    }

    private void invalidateRange() {
        this.rangeValid = false;
    }

    protected void updateAxisRange() {
        Axis<X> axis = this.getXAxis();
        Axis<Y> axis2 = this.getYAxis();
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        if (axis.isAutoRanging()) {
            arrayList = new ArrayList();
        }
        if (axis2.isAutoRanging()) {
            arrayList2 = new ArrayList();
        }
        if (arrayList != null || arrayList2 != null) {
            for (XYChart$Series xYChart$Series : this.getData()) {
                for (XYChart$Data xYChart$Data : xYChart$Series.getData()) {
                    if (arrayList != null) {
                        arrayList.add(xYChart$Data.getXValue());
                    }
                    if (arrayList2 == null) continue;
                    arrayList2.add(xYChart$Data.getYValue());
                }
            }
            if (arrayList != null) {
                axis.invalidateRange(arrayList);
            }
            if (arrayList2 != null) {
                axis2.invalidateRange(arrayList2);
            }
        }
    }

    protected abstract void layoutPlotChildren();

    @Override
    protected final void layoutChartChildren(double d2, double d3, double d4, double d5) {
        double d6;
        double d7;
        double d8;
        Object object;
        if (this.getData() == null) {
            return;
        }
        if (!this.rangeValid) {
            this.rangeValid = true;
            if (this.getData() != null) {
                this.updateAxisRange();
            }
        }
        d2 = this.snapPositionY(d2);
        d3 = this.snapPositionX(d3);
        Axis<X> axis = this.getXAxis();
        ObservableList<Axis$TickMark<X>> observableList = axis.getTickMarks();
        Axis<Y> axis2 = this.getYAxis();
        ObservableList<Axis$TickMark<Y>> observableList2 = axis2.getTickMarks();
        if (axis == null || axis2 == null) {
            return;
        }
        double d9 = 0.0;
        double d10 = 30.0;
        double d11 = 0.0;
        double d12 = 0.0;
        for (int i2 = 0; i2 < 5; ++i2) {
            double d13;
            double d14;
            double d15;
            d12 = this.snapSizeY(d5 - d10);
            if (d15 < 0.0) {
                d12 = 0.0;
            }
            d11 = ((Node)axis2).prefWidth(d12);
            d9 = this.snapSizeX(d4 - d11);
            if (d14 < 0.0) {
                d9 = 0.0;
            }
            if ((d13 = ((Node)axis).prefHeight(d9)) == d10) break;
            d10 = d13;
        }
        d9 = Math.ceil(d9);
        d10 = Math.ceil(d10);
        d11 = Math.ceil(d11);
        d12 = Math.ceil(d12);
        double d16 = 0.0;
        switch (axis.getEffectiveSide()) {
            case TOP: {
                axis.setVisible(true);
                d16 = d2 + 1.0;
                d2 += d10;
                break;
            }
            case BOTTOM: {
                axis.setVisible(true);
                d16 = d2 + d12;
            }
        }
        double d17 = 0.0;
        switch (axis2.getEffectiveSide()) {
            case LEFT: {
                axis2.setVisible(true);
                d17 = d3 + 1.0;
                d3 += d11;
                break;
            }
            case RIGHT: {
                axis2.setVisible(true);
                d17 = d3 + d9;
            }
        }
        axis.resizeRelocate(d3, d16, d9, d10);
        axis2.resizeRelocate(d17, d2, d11, d12);
        axis.requestAxisLayout();
        axis.layout();
        axis2.requestAxisLayout();
        axis2.layout();
        this.layoutPlotChildren();
        double d18 = axis.getZeroPosition();
        double d19 = axis2.getZeroPosition();
        if (Double.isNaN(d18) || !this.isVerticalZeroLineVisible()) {
            this.verticalZeroLine.setVisible(false);
        } else {
            this.verticalZeroLine.setStartX(d3 + d18 + 0.5);
            this.verticalZeroLine.setStartY(d2);
            this.verticalZeroLine.setEndX(d3 + d18 + 0.5);
            this.verticalZeroLine.setEndY(d2 + d12);
            this.verticalZeroLine.setVisible(true);
        }
        if (Double.isNaN(d19) || !this.isHorizontalZeroLineVisible()) {
            this.horizontalZeroLine.setVisible(false);
        } else {
            this.horizontalZeroLine.setStartX(d3);
            this.horizontalZeroLine.setStartY(d2 + d19 + 0.5);
            this.horizontalZeroLine.setEndX(d3 + d9);
            this.horizontalZeroLine.setEndY(d2 + d19 + 0.5);
            this.horizontalZeroLine.setVisible(true);
        }
        this.plotBackground.resizeRelocate(d3, d2, d9, d12);
        this.plotAreaClip.setX(d3);
        this.plotAreaClip.setY(d2);
        this.plotAreaClip.setWidth(d9 + 1.0);
        this.plotAreaClip.setHeight(d12 + 1.0);
        this.plotContent.setLayoutX(d3);
        this.plotContent.setLayoutY(d2);
        this.plotContent.requestLayout();
        this.verticalGridLines.getElements().clear();
        if (this.getVerticalGridLinesVisible()) {
            for (int i3 = 0; i3 < observableList.size(); ++i3) {
                object = (Axis$TickMark)observableList.get(i3);
                d8 = axis.getDisplayPosition(((Axis$TickMark)object).getValue());
                if (d8 == d18 && this.isVerticalZeroLineVisible() || !(d8 > 0.0) || !(d8 <= d9)) continue;
                this.verticalGridLines.getElements().add(new MoveTo(d3 + d8 + 0.5, d2));
                this.verticalGridLines.getElements().add(new LineTo(d3 + d8 + 0.5, d2 + d12));
            }
        }
        this.horizontalGridLines.getElements().clear();
        if (this.isHorizontalGridLinesVisible()) {
            for (int i4 = 0; i4 < observableList2.size(); ++i4) {
                object = (Axis$TickMark)observableList2.get(i4);
                d8 = axis2.getDisplayPosition(((Axis$TickMark)object).getValue());
                if (d8 == d19 && this.isHorizontalZeroLineVisible() || !(d8 >= 0.0) || !(d8 < d12)) continue;
                this.horizontalGridLines.getElements().add(new MoveTo(d3, d2 + d8 + 0.5));
                this.horizontalGridLines.getElements().add(new LineTo(d3 + d9, d2 + d8 + 0.5));
            }
        }
        this.verticalRowFill.getElements().clear();
        if (this.isAlternativeColumnFillVisible()) {
            int n2;
            ArrayList<Double> arrayList = new ArrayList<Double>();
            object = new ArrayList();
            for (n2 = 0; n2 < observableList.size(); ++n2) {
                d7 = axis.getDisplayPosition(((Axis$TickMark)observableList.get(n2)).getValue());
                if (d7 == d18) {
                    arrayList.add(d7);
                    object.add(d7);
                    continue;
                }
                if (d7 < d18) {
                    arrayList.add(d7);
                    continue;
                }
                object.add(d7);
            }
            Collections.sort(arrayList);
            Collections.sort(object);
            for (n2 = 1; n2 < arrayList.size(); n2 += 2) {
                if (n2 + 1 >= arrayList.size()) continue;
                d7 = (Double)arrayList.get(n2);
                d6 = (Double)arrayList.get(n2 + 1);
                this.verticalRowFill.getElements().addAll((PathElement[])new PathElement[]{new MoveTo(d3 + d7, d2), new LineTo(d3 + d7, d2 + d12), new LineTo(d3 + d6, d2 + d12), new LineTo(d3 + d6, d2), new ClosePath()});
            }
            for (n2 = 0; n2 < object.size(); n2 += 2) {
                if (n2 + 1 >= object.size()) continue;
                d7 = (Double)object.get(n2);
                d6 = (Double)object.get(n2 + 1);
                this.verticalRowFill.getElements().addAll((PathElement[])new PathElement[]{new MoveTo(d3 + d7, d2), new LineTo(d3 + d7, d2 + d12), new LineTo(d3 + d6, d2 + d12), new LineTo(d3 + d6, d2), new ClosePath()});
            }
        }
        this.horizontalRowFill.getElements().clear();
        if (this.isAlternativeRowFillVisible()) {
            int n3;
            ArrayList<Double> arrayList = new ArrayList<Double>();
            object = new ArrayList<Double>();
            for (n3 = 0; n3 < observableList2.size(); ++n3) {
                d7 = axis2.getDisplayPosition(((Axis$TickMark)observableList2.get(n3)).getValue());
                if (d7 == d19) {
                    arrayList.add(d7);
                    object.add(d7);
                    continue;
                }
                if (d7 < d19) {
                    arrayList.add(d7);
                    continue;
                }
                object.add(d7);
            }
            Collections.sort(arrayList);
            Collections.sort(object);
            for (n3 = 1; n3 < arrayList.size(); n3 += 2) {
                if (n3 + 1 >= arrayList.size()) continue;
                d7 = (Double)arrayList.get(n3);
                d6 = (Double)arrayList.get(n3 + 1);
                this.horizontalRowFill.getElements().addAll((PathElement[])new PathElement[]{new MoveTo(d3, d2 + d7), new LineTo(d3 + d9, d2 + d7), new LineTo(d3 + d9, d2 + d6), new LineTo(d3, d2 + d6), new ClosePath()});
            }
            for (n3 = 0; n3 < object.size(); n3 += 2) {
                if (n3 + 1 >= object.size()) continue;
                d7 = (Double)object.get(n3);
                d6 = (Double)object.get(n3 + 1);
                this.horizontalRowFill.getElements().addAll((PathElement[])new PathElement[]{new MoveTo(d3, d2 + d7), new LineTo(d3 + d9, d2 + d7), new LineTo(d3 + d9, d2 + d6), new LineTo(d3, d2 + d6), new ClosePath()});
            }
        }
    }

    int getSeriesIndex(XYChart$Series<X, Y> xYChart$Series) {
        return this.displayedSeries.indexOf(xYChart$Series);
    }

    int getSeriesSize() {
        return this.displayedSeries.size();
    }

    protected final void removeSeriesFromDisplay(XYChart$Series<X, Y> xYChart$Series) {
        if (xYChart$Series != null) {
            xYChart$Series.setToRemove = false;
        }
        xYChart$Series.setChart(null);
        this.displayedSeries.remove(xYChart$Series);
        int n2 = this.seriesColorMap.remove(xYChart$Series);
        this.colorBits.clear(n2);
    }

    protected final Iterator<XYChart$Series<X, Y>> getDisplayedSeriesIterator() {
        return Collections.unmodifiableList(this.displayedSeries).iterator();
    }

    final KeyFrame[] createSeriesRemoveTimeLine(XYChart$Series<X, Y> xYChart$Series, long l2) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.add(xYChart$Series.getNode());
        for (XYChart$Data keyValueArray2 : xYChart$Series.getData()) {
            if (keyValueArray2.getNode() == null) continue;
            arrayList.add(keyValueArray2.getNode());
        }
        KeyValue[] keyValueArray3 = new KeyValue[arrayList.size()];
        KeyValue[] keyValueArray = new KeyValue[arrayList.size()];
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            keyValueArray3[i2] = new KeyValue(((Node)arrayList.get(i2)).opacityProperty(), 1);
            keyValueArray[i2] = new KeyValue(((Node)arrayList.get(i2)).opacityProperty(), 0);
        }
        return new KeyFrame[]{new KeyFrame(Duration.ZERO, keyValueArray3), new KeyFrame(Duration.millis(l2), actionEvent -> {
            this.getPlotChildren().removeAll((Collection<?>)arrayList);
            this.removeSeriesFromDisplay(xYChart$Series);
        }, keyValueArray)};
    }

    protected final X getCurrentDisplayedXValue(XYChart$Data<X, Y> xYChart$Data) {
        return xYChart$Data.getCurrentX();
    }

    protected final void setCurrentDisplayedXValue(XYChart$Data<X, Y> xYChart$Data, X x2) {
        xYChart$Data.setCurrentX(x2);
    }

    protected final ObjectProperty<X> currentDisplayedXValueProperty(XYChart$Data<X, Y> xYChart$Data) {
        return xYChart$Data.currentXProperty();
    }

    protected final Y getCurrentDisplayedYValue(XYChart$Data<X, Y> xYChart$Data) {
        return xYChart$Data.getCurrentY();
    }

    protected final void setCurrentDisplayedYValue(XYChart$Data<X, Y> xYChart$Data, Y y2) {
        xYChart$Data.setCurrentY(y2);
    }

    protected final ObjectProperty<Y> currentDisplayedYValueProperty(XYChart$Data<X, Y> xYChart$Data) {
        return xYChart$Data.currentYProperty();
    }

    protected final Object getCurrentDisplayedExtraValue(XYChart$Data<X, Y> xYChart$Data) {
        return xYChart$Data.getCurrentExtraValue();
    }

    protected final void setCurrentDisplayedExtraValue(XYChart$Data<X, Y> xYChart$Data, Object object) {
        xYChart$Data.setCurrentExtraValue(object);
    }

    protected final ObjectProperty<Object> currentDisplayedExtraValueProperty(XYChart$Data<X, Y> xYChart$Data) {
        return xYChart$Data.currentExtraValueProperty();
    }

    protected final Iterator<XYChart$Data<X, Y>> getDisplayedDataIterator(XYChart$Series<X, Y> xYChart$Series) {
        return Collections.unmodifiableList(xYChart$Series.displayedData).iterator();
    }

    protected final void removeDataItemFromDisplay(XYChart$Series<X, Y> xYChart$Series, XYChart$Data<X, Y> xYChart$Data) {
        xYChart$Series.removeDataItemRef(xYChart$Data);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return XYChart$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return XYChart.getClassCssMetaData();
    }
}

