/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.property.ObjectProperty;
import javafx.collections.ObservableList;
import javafx.css.StyleableProperty;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Accordion$1;
import javafx.scene.control.Accordion$2;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.TitledPane;
import javafx.scene.control.skin.AccordionSkin;

public class Accordion
extends Control {
    private boolean biasDirty = true;
    private Orientation bias;
    private final ObservableList<TitledPane> panes = new Accordion$1(this);
    private ObjectProperty<TitledPane> expandedPane = new Accordion$2(this);
    private static final String DEFAULT_STYLE_CLASS = "accordion";

    public Accordion() {
        this(null);
    }

    public Accordion(TitledPane ... titledPaneArray) {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        if (titledPaneArray != null) {
            this.getPanes().addAll((TitledPane[])titledPaneArray);
        }
        ((StyleableProperty)((Object)this.focusTraversableProperty())).applyStyle(null, Boolean.FALSE);
    }

    public final void setExpandedPane(TitledPane titledPane) {
        this.expandedPaneProperty().set(titledPane);
    }

    public final TitledPane getExpandedPane() {
        return (TitledPane)this.expandedPane.get();
    }

    public final ObjectProperty<TitledPane> expandedPaneProperty() {
        return this.expandedPane;
    }

    public final ObservableList<TitledPane> getPanes() {
        return this.panes;
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new AccordionSkin(this);
    }

    @Override
    public void requestLayout() {
        this.biasDirty = true;
        this.bias = null;
        super.requestLayout();
    }

    @Override
    public Orientation getContentBias() {
        if (this.biasDirty) {
            this.bias = null;
            Object object = this.getManagedChildren();
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (Node)object.next();
                if ((object2 = object2.getContentBias()) == null) continue;
                this.bias = object2;
                if (object2 != Orientation.HORIZONTAL) continue;
            }
            this.biasDirty = false;
        }
        return this.bias;
    }

    @Override
    protected Boolean getInitialFocusTraversable() {
        return Boolean.FALSE;
    }
}

