/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.property.BooleanProperty;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.Button$1;
import javafx.scene.control.Button$2;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Skin;
import javafx.scene.control.skin.ButtonSkin;

public class Button
extends ButtonBase {
    private BooleanProperty defaultButton;
    private BooleanProperty cancelButton;
    private static final String DEFAULT_STYLE_CLASS = "button";
    private static final PseudoClass PSEUDO_CLASS_DEFAULT = PseudoClass.getPseudoClass("default");
    private static final PseudoClass PSEUDO_CLASS_CANCEL = PseudoClass.getPseudoClass("cancel");

    public Button() {
        this.initialize();
    }

    public Button(String string) {
        super(string);
        this.initialize();
    }

    public Button(String string, Node node) {
        super(string, node);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.BUTTON);
        this.setMnemonicParsing(true);
    }

    public final void setDefaultButton(boolean bl2) {
        this.defaultButtonProperty().set(bl2);
    }

    public final boolean isDefaultButton() {
        if (this.defaultButton == null) {
            return false;
        }
        return this.defaultButton.get();
    }

    public final BooleanProperty defaultButtonProperty() {
        if (this.defaultButton == null) {
            this.defaultButton = new Button$1(this, false);
        }
        return this.defaultButton;
    }

    public final void setCancelButton(boolean bl2) {
        this.cancelButtonProperty().set(bl2);
    }

    public final boolean isCancelButton() {
        if (this.cancelButton == null) {
            return false;
        }
        return this.cancelButton.get();
    }

    public final BooleanProperty cancelButtonProperty() {
        if (this.cancelButton == null) {
            this.cancelButton = new Button$2(this, false);
        }
        return this.cancelButton;
    }

    @Override
    public void fire() {
        if (!this.isDisabled()) {
            this.fireEvent(new ActionEvent());
        }
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new ButtonSkin(this);
    }
}

