/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.util.Utils;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.css.StyleableProperty;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar$ButtonData;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.skin.ButtonBarSkin;

public class ButtonBar
extends Control {
    public static final String BUTTON_ORDER_WINDOWS = "L_E+U+FBXI_YNOCAH_R";
    public static final String BUTTON_ORDER_MAC_OS = "L_HE+U+FBIX_NCYOA_R";
    public static final String BUTTON_ORDER_LINUX = "L_HE+UNYACBXIO_R";
    public static final String BUTTON_ORDER_NONE = "";
    private ObservableList<Node> buttons = FXCollections.observableArrayList();
    private final StringProperty buttonOrderProperty = new SimpleStringProperty(this, "buttonOrder");
    private final DoubleProperty buttonMinWidthProperty = new SimpleDoubleProperty(this, "buttonMinWidthProperty");

    public static void setButtonData(Node object, ButtonBar$ButtonData buttonBar$ButtonData) {
        ObservableMap<Object, Object> observableMap = ((Node)object).getProperties();
        object = observableMap.getOrDefault("javafx.scene.control.ButtonBar.ButtonData", new SimpleObjectProperty<ButtonBar$ButtonData>(object, "buttonData", buttonBar$ButtonData));
        object.set(buttonBar$ButtonData);
        observableMap.putIfAbsent("javafx.scene.control.ButtonBar.ButtonData", object);
    }

    public static ButtonBar$ButtonData getButtonData(Node object) {
        if ((object = ((Node)object).getProperties()).containsKey("javafx.scene.control.ButtonBar.ButtonData")) {
            if ((object = (ObjectProperty)object.get("javafx.scene.control.ButtonBar.ButtonData")) == null) {
                return null;
            }
            return (ButtonBar$ButtonData)((Object)object.get());
        }
        return null;
    }

    public static void setButtonUniformSize(Node node, boolean bl2) {
        if (bl2) {
            node.getProperties().remove("javafx.scene.control.ButtonBar.independentSize");
            return;
        }
        node.getProperties().put("javafx.scene.control.ButtonBar.independentSize", bl2);
    }

    public static boolean isButtonUniformSize(Node node) {
        return (Boolean)node.getProperties().getOrDefault("javafx.scene.control.ButtonBar.independentSize", Boolean.TRUE);
    }

    public ButtonBar() {
        this(null);
    }

    public ButtonBar(String string) {
        boolean bl2;
        this.getStyleClass().add("button-bar");
        ((StyleableProperty)((Object)this.focusTraversableProperty())).applyStyle(null, Boolean.FALSE);
        boolean bl3 = bl2 = string == null || string.isEmpty();
        if (Utils.isMac()) {
            this.setButtonOrder(bl2 ? BUTTON_ORDER_MAC_OS : string);
            this.setButtonMinWidth(70.0);
            return;
        }
        if (Utils.isUnix()) {
            this.setButtonOrder(bl2 ? BUTTON_ORDER_LINUX : string);
            this.setButtonMinWidth(85.0);
            return;
        }
        this.setButtonOrder(bl2 ? BUTTON_ORDER_WINDOWS : string);
        this.setButtonMinWidth(75.0);
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new ButtonBarSkin(this);
    }

    public final ObservableList<Node> getButtons() {
        return this.buttons;
    }

    public final StringProperty buttonOrderProperty() {
        return this.buttonOrderProperty;
    }

    public final void setButtonOrder(String string) {
        this.buttonOrderProperty.set(string);
    }

    public final String getButtonOrder() {
        return (String)this.buttonOrderProperty.get();
    }

    public final DoubleProperty buttonMinWidthProperty() {
        return this.buttonMinWidthProperty;
    }

    public final void setButtonMinWidth(double d2) {
        this.buttonMinWidthProperty.set(d2);
    }

    public final double getButtonMinWidth() {
        return this.buttonMinWidthProperty.get();
    }

    @Override
    protected Boolean getInitialFocusTraversable() {
        return Boolean.FALSE;
    }
}

