/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.control.ChoiceBox$1;
import javafx.scene.control.ChoiceBox$10;
import javafx.scene.control.ChoiceBox$2;
import javafx.scene.control.ChoiceBox$3;
import javafx.scene.control.ChoiceBox$4;
import javafx.scene.control.ChoiceBox$5;
import javafx.scene.control.ChoiceBox$6;
import javafx.scene.control.ChoiceBox$7;
import javafx.scene.control.ChoiceBox$8;
import javafx.scene.control.ChoiceBox$9;
import javafx.scene.control.ChoiceBox$ChoiceBoxSelectionModel;
import javafx.scene.control.Control;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Skin;
import javafx.scene.control.skin.ChoiceBoxSkin;
import javafx.util.StringConverter;

@DefaultProperty(value="items")
public class ChoiceBox<T>
extends Control {
    public static final EventType<Event> ON_SHOWING = new EventType<Event>(Event.ANY, "CHOICE_BOX_ON_SHOWING");
    public static final EventType<Event> ON_SHOWN = new EventType<Event>(Event.ANY, "CHOICE_BOX_ON_SHOWN");
    public static final EventType<Event> ON_HIDING = new EventType<Event>(Event.ANY, "CHOICE_BOX_ON_HIDING");
    public static final EventType<Event> ON_HIDDEN = new EventType<Event>(Event.ANY, "CHOICE_BOX_ON_HIDDEN");
    private ObjectProperty<SingleSelectionModel<T>> selectionModel;
    private ChangeListener<T> selectedItemListener;
    private ReadOnlyBooleanWrapper showing;
    private ObjectProperty<ObservableList<T>> items;
    private final ListChangeListener<T> itemsListener;
    private ObjectProperty<StringConverter<T>> converter;
    private ObjectProperty<T> value;
    private ObjectProperty<EventHandler<ActionEvent>> onAction;
    private ObjectProperty<EventHandler<Event>> onShowing;
    private ObjectProperty<EventHandler<Event>> onShown;
    private ObjectProperty<EventHandler<Event>> onHiding;
    private ObjectProperty<EventHandler<Event>> onHidden;
    private static final PseudoClass SHOWING_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("showing");

    public ChoiceBox() {
        this(FXCollections.observableArrayList());
    }

    public ChoiceBox(ObservableList<T> observableList) {
        ChoiceBox choiceBox = this;
        this.selectionModel = new ChoiceBox$1(choiceBox, choiceBox, "selectionModel");
        this.selectedItemListener = (observableValue, object, object2) -> {
            if (!this.valueProperty().isBound()) {
                this.setValue(object2);
            }
        };
        this.showing = new ChoiceBox$2(this);
        this.items = new ChoiceBox$3(this);
        this.itemsListener = listChangeListener$Change -> {
            SingleSelectionModel<T> singleSelectionModel = this.getSelectionModel();
            if (singleSelectionModel != null) {
                if (this.getItems() == null || this.getItems().isEmpty()) {
                    ((SelectionModel)singleSelectionModel).clearSelection();
                } else {
                    int n2 = this.getItems().indexOf(singleSelectionModel.getSelectedItem());
                    singleSelectionModel.setSelectedIndex(n2);
                }
            }
            if (singleSelectionModel != null) {
                Object t2 = singleSelectionModel.getSelectedItem();
                while (listChangeListener$Change.next()) {
                    if (t2 == null || !listChangeListener$Change.getRemoved().contains(t2)) continue;
                    ((SelectionModel)singleSelectionModel).clearSelection();
                    break;
                }
            }
        };
        this.converter = new SimpleObjectProperty<Object>(this, "converter", null);
        ChoiceBox choiceBox2 = this;
        this.value = new ChoiceBox$4(choiceBox2, choiceBox2, "value");
        this.onAction = new ChoiceBox$5(this);
        this.onShowing = new ChoiceBox$6(this);
        this.onShown = new ChoiceBox$7(this);
        this.onHiding = new ChoiceBox$8(this);
        this.onHidden = new ChoiceBox$9(this);
        this.getStyleClass().setAll((String[])new String[]{"choice-box"});
        this.setAccessibleRole(AccessibleRole.COMBO_BOX);
        this.setItems(observableList);
        this.setSelectionModel(new ChoiceBox$ChoiceBoxSelectionModel(this));
        this.valueProperty().addListener((singleSelectionModel, object, object2) -> {
            if (this.getItems() == null) {
                return;
            }
            singleSelectionModel = this.getSelectionModel();
            if (singleSelectionModel == null) {
                return;
            }
            int n2 = this.getItems().indexOf(object2);
            if (n2 >= 0) {
                ((SelectionModel)((Object)singleSelectionModel)).select(n2);
            }
        });
    }

    public final void setSelectionModel(SingleSelectionModel<T> singleSelectionModel) {
        this.selectionModel.set(singleSelectionModel);
    }

    public final SingleSelectionModel<T> getSelectionModel() {
        return (SingleSelectionModel)this.selectionModel.get();
    }

    public final ObjectProperty<SingleSelectionModel<T>> selectionModelProperty() {
        return this.selectionModel;
    }

    public final boolean isShowing() {
        return this.showing.get();
    }

    public final ReadOnlyBooleanProperty showingProperty() {
        return this.showing.getReadOnlyProperty();
    }

    private void setShowing(boolean bl2) {
        Event.fireEvent(this, bl2 ? new Event(ON_SHOWING) : new Event(ON_HIDING));
        this.showing.set(bl2);
        Event.fireEvent(this, bl2 ? new Event(ON_SHOWN) : new Event(ON_HIDDEN));
    }

    public final void setItems(ObservableList<T> observableList) {
        this.items.set(observableList);
    }

    public final ObservableList<T> getItems() {
        return (ObservableList)this.items.get();
    }

    public final ObjectProperty<ObservableList<T>> itemsProperty() {
        return this.items;
    }

    public ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<T> stringConverter) {
        this.converterProperty().set(stringConverter);
    }

    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }

    public ObjectProperty<T> valueProperty() {
        return this.value;
    }

    public final void setValue(T t2) {
        this.valueProperty().set(t2);
    }

    public final T getValue() {
        return this.valueProperty().get();
    }

    public final ObjectProperty<EventHandler<ActionEvent>> onActionProperty() {
        return this.onAction;
    }

    public final void setOnAction(EventHandler<ActionEvent> eventHandler) {
        this.onActionProperty().set(eventHandler);
    }

    public final EventHandler<ActionEvent> getOnAction() {
        return (EventHandler)this.onActionProperty().get();
    }

    public final ObjectProperty<EventHandler<Event>> onShowingProperty() {
        return this.onShowing;
    }

    public final void setOnShowing(EventHandler<Event> eventHandler) {
        this.onShowingProperty().set(eventHandler);
    }

    public final EventHandler<Event> getOnShowing() {
        return (EventHandler)this.onShowingProperty().get();
    }

    public final ObjectProperty<EventHandler<Event>> onShownProperty() {
        return this.onShown;
    }

    public final void setOnShown(EventHandler<Event> eventHandler) {
        this.onShownProperty().set(eventHandler);
    }

    public final EventHandler<Event> getOnShown() {
        return (EventHandler)this.onShownProperty().get();
    }

    public final ObjectProperty<EventHandler<Event>> onHidingProperty() {
        return this.onHiding;
    }

    public final void setOnHiding(EventHandler<Event> eventHandler) {
        this.onHidingProperty().set(eventHandler);
    }

    public final EventHandler<Event> getOnHiding() {
        return (EventHandler)this.onHidingProperty().get();
    }

    public final ObjectProperty<EventHandler<Event>> onHiddenProperty() {
        return this.onHidden;
    }

    public final void setOnHidden(EventHandler<Event> eventHandler) {
        this.onHiddenProperty().set(eventHandler);
    }

    public final EventHandler<Event> getOnHidden() {
        return (EventHandler)this.onHiddenProperty().get();
    }

    public void show() {
        if (!this.isDisabled()) {
            this.setShowing(true);
        }
    }

    public void hide() {
        this.setShowing(false);
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new ChoiceBoxSkin(this);
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute object, Object ... objectArray) {
        switch (ChoiceBox$10.$SwitchMap$javafx$scene$AccessibleAttribute[((Enum)object).ordinal()]) {
            case 1: {
                String string = this.getAccessibleText();
                if (string != null && !string.isEmpty()) {
                    return string;
                }
                if ((object = super.queryAccessibleAttribute((AccessibleAttribute)((Object)object), objectArray)) != null) {
                    return object;
                }
                object = this.getConverter();
                if (object == null) {
                    if (this.getValue() != null) {
                        return this.getValue().toString();
                    }
                    return "";
                }
                return ((StringConverter)object).toString(this.getValue());
            }
            case 2: {
                return this.isShowing();
            }
        }
        return super.queryAccessibleAttribute((AccessibleAttribute)((Object)object), objectArray);
    }

    @Override
    public void executeAccessibleAction(AccessibleAction accessibleAction, Object ... objectArray) {
        switch (accessibleAction) {
            case COLLAPSE: {
                this.hide();
                return;
            }
            case EXPAND: {
                this.show();
                return;
            }
        }
        super.executeAccessibleAction(accessibleAction, new Object[0]);
    }

    static /* synthetic */ void access$000(ChoiceBox choiceBox, EventType eventType, EventHandler eventHandler) {
        choiceBox.setEventHandler(eventType, eventHandler);
    }

    static /* synthetic */ void access$100(ChoiceBox choiceBox, EventType eventType, EventHandler eventHandler) {
        choiceBox.setEventHandler(eventType, eventHandler);
    }

    static /* synthetic */ void access$200(ChoiceBox choiceBox, EventType eventType, EventHandler eventHandler) {
        choiceBox.setEventHandler(eventType, eventHandler);
    }

    static /* synthetic */ void access$300(ChoiceBox choiceBox, EventType eventType, EventHandler eventHandler) {
        choiceBox.setEventHandler(eventType, eventHandler);
    }

    static /* synthetic */ void access$400(ChoiceBox choiceBox, EventType eventType, EventHandler eventHandler) {
        choiceBox.setEventHandler(eventType, eventHandler);
    }
}

