/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ComboBox$ComboBoxSelectionModel$1;
import javafx.scene.control.ComboBox$ComboBoxSelectionModel$2;
import javafx.scene.control.SingleSelectionModel;

class ComboBox$ComboBoxSelectionModel<T>
extends SingleSelectionModel<T> {
    private final ComboBox<T> comboBox;
    private boolean atomic = false;
    private final ListChangeListener<T> itemsContentObserver = new ComboBox$ComboBoxSelectionModel$2(this);
    private final InvalidationListener itemsObserver;
    private WeakListChangeListener<T> weakItemsContentObserver = new WeakListChangeListener<T>(this.itemsContentObserver);

    private void doAtomic(Runnable runnable) {
        this.atomic = true;
        runnable.run();
        this.atomic = false;
    }

    public ComboBox$ComboBoxSelectionModel(ComboBox<T> comboBox) {
        if (comboBox == null) {
            throw new NullPointerException("ComboBox can not be null");
        }
        this.comboBox = comboBox;
        this.comboBox.previousItemCount = this.getItemCount();
        this.selectedIndexProperty().addListener(observable -> {
            if (this.atomic) {
                return;
            }
            ComboBox$ComboBoxSelectionModel comboBox$ComboBoxSelectionModel = this;
            comboBox$ComboBoxSelectionModel.setSelectedItem(comboBox$ComboBoxSelectionModel.getModelItem(this.getSelectedIndex()));
        });
        this.itemsObserver = new ComboBox$ComboBoxSelectionModel$1(this);
        this.comboBox.itemsProperty().addListener(new WeakInvalidationListener(this.itemsObserver));
        if (this.comboBox.getItems() != null) {
            this.comboBox.getItems().addListener(this.weakItemsContentObserver);
        }
    }

    private void updateItemsObserver(ObservableList<T> observableList, ObservableList<T> observableList2) {
        Object t2;
        if (observableList != null) {
            observableList.removeListener(this.weakItemsContentObserver);
        }
        if (observableList2 != null) {
            observableList2.addListener(this.weakItemsContentObserver);
        }
        int n2 = -1;
        if (observableList2 != null && (t2 = this.comboBox.getValue()) != null) {
            n2 = observableList2.indexOf(t2);
        }
        this.setSelectedIndex(n2);
    }

    @Override
    protected T getModelItem(int n2) {
        ObservableList<T> observableList = this.comboBox.getItems();
        if (observableList == null) {
            return null;
        }
        if (n2 < 0 || n2 >= observableList.size()) {
            return null;
        }
        return (T)observableList.get(n2);
    }

    @Override
    protected int getItemCount() {
        ObservableList<T> observableList = this.comboBox.getItems();
        if (observableList == null) {
            return 0;
        }
        return observableList.size();
    }
}

