/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.FakeFocusTextField;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.ComboBox$1;
import javafx.scene.control.ComboBox$2;
import javafx.scene.control.ComboBox$3;
import javafx.scene.control.ComboBox$4;
import javafx.scene.control.ComboBox$ComboBoxSelectionModel;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Skin;
import javafx.scene.control.TextField;
import javafx.scene.control.skin.ComboBoxListViewSkin;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class ComboBox<T>
extends ComboBoxBase<T> {
    private ObjectProperty<ObservableList<T>> items = new SimpleObjectProperty<ObservableList<T>>(this, "items");
    private ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty<StringConverter<StringConverter<T>>>(this, "converter", ComboBox.defaultStringConverter());
    private ObjectProperty<Callback<ListView<T>, ListCell<T>>> cellFactory = new SimpleObjectProperty<Callback<ListView<T>, ListCell<T>>>(this, "cellFactory");
    private ObjectProperty<ListCell<T>> buttonCell = new SimpleObjectProperty<ListCell<T>>(this, "buttonCell");
    private ObjectProperty<SingleSelectionModel<T>> selectionModel;
    private IntegerProperty visibleRowCount;
    private TextField textField;
    private ReadOnlyObjectWrapper<TextField> editor;
    private ObjectProperty<Node> placeholder;
    private ChangeListener<T> selectedItemListener;
    private static final String DEFAULT_STYLE_CLASS = "combo-box";
    private boolean wasSetAllCalled;
    private int previousItemCount;

    private static <T> StringConverter<T> defaultStringConverter() {
        return new ComboBox$1();
    }

    public ComboBox() {
        this(FXCollections.observableArrayList());
    }

    public ComboBox(ObservableList<T> observableList) {
        ComboBox comboBox = this;
        this.selectionModel = new ComboBox$2(comboBox, comboBox, "selectionModel");
        this.visibleRowCount = new SimpleIntegerProperty(this, "visibleRowCount", 10);
        this.selectedItemListener = new ComboBox$3(this);
        this.wasSetAllCalled = false;
        this.previousItemCount = -1;
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
        this.setAccessibleRole(AccessibleRole.COMBO_BOX);
        this.setItems(observableList);
        this.setSelectionModel(new ComboBox$ComboBoxSelectionModel(this));
        this.valueProperty().addListener((singleSelectionModel, object, object2) -> {
            if (this.getItems() == null) {
                return;
            }
            singleSelectionModel = this.getSelectionModel();
            if (singleSelectionModel == null) {
                return;
            }
            int n2 = this.getItems().indexOf(object2);
            if (n2 == -1) {
                object2 = () -> {
                    singleSelectionModel.setSelectedIndex(-1);
                    singleSelectionModel.setSelectedItem(object2);
                };
                if (singleSelectionModel instanceof ComboBox$ComboBoxSelectionModel) {
                    ((ComboBox$ComboBoxSelectionModel)((Object)singleSelectionModel)).doAtomic((Runnable)object2);
                    return;
                }
                object2.run();
                return;
            }
            object2 = singleSelectionModel.getSelectedItem();
            if (object2 != null) {
                if (object2.equals(this.getValue())) return;
            }
            ((SelectionModel)((Object)singleSelectionModel)).clearAndSelect(n2);
        });
        this.editableProperty().addListener(object -> {
            if (!this.isEditable() && this.getItems() != null && !this.getItems().contains(this.getValue()) && (object = this.getSelectionModel()) != null) {
                ((SelectionModel)((Object)object)).clearSelection();
            }
        });
        this.focusedProperty().addListener(observable -> {
            if (!this.isFocused()) {
                this.commitValue();
            }
        });
    }

    public final void setItems(ObservableList<T> observableList) {
        this.itemsProperty().set(observableList);
    }

    public final ObservableList<T> getItems() {
        return (ObservableList)this.items.get();
    }

    public ObjectProperty<ObservableList<T>> itemsProperty() {
        return this.items;
    }

    public ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<T> stringConverter) {
        this.converterProperty().set(stringConverter);
    }

    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }

    public final void setCellFactory(Callback<ListView<T>, ListCell<T>> callback) {
        this.cellFactoryProperty().set(callback);
    }

    public final Callback<ListView<T>, ListCell<T>> getCellFactory() {
        return (Callback)this.cellFactoryProperty().get();
    }

    public ObjectProperty<Callback<ListView<T>, ListCell<T>>> cellFactoryProperty() {
        return this.cellFactory;
    }

    public ObjectProperty<ListCell<T>> buttonCellProperty() {
        return this.buttonCell;
    }

    public final void setButtonCell(ListCell<T> listCell) {
        this.buttonCellProperty().set(listCell);
    }

    public final ListCell<T> getButtonCell() {
        return (ListCell)this.buttonCellProperty().get();
    }

    public final void setSelectionModel(SingleSelectionModel<T> singleSelectionModel) {
        this.selectionModel.set(singleSelectionModel);
    }

    public final SingleSelectionModel<T> getSelectionModel() {
        return (SingleSelectionModel)this.selectionModel.get();
    }

    public final ObjectProperty<SingleSelectionModel<T>> selectionModelProperty() {
        return this.selectionModel;
    }

    public final void setVisibleRowCount(int n2) {
        this.visibleRowCount.set(n2);
    }

    public final int getVisibleRowCount() {
        return this.visibleRowCount.get();
    }

    public final IntegerProperty visibleRowCountProperty() {
        return this.visibleRowCount;
    }

    public final TextField getEditor() {
        return (TextField)this.editorProperty().get();
    }

    public final ReadOnlyObjectProperty<TextField> editorProperty() {
        if (this.editor == null) {
            this.editor = new ReadOnlyObjectWrapper(this, "editor");
            this.textField = new FakeFocusTextField();
            this.editor.set(this.textField);
        }
        return this.editor.getReadOnlyProperty();
    }

    public final ObjectProperty<Node> placeholderProperty() {
        if (this.placeholder == null) {
            this.placeholder = new SimpleObjectProperty<Node>(this, "placeholder");
        }
        return this.placeholder;
    }

    public final void setPlaceholder(Node node) {
        this.placeholderProperty().set(node);
    }

    public final Node getPlaceholder() {
        if (this.placeholder == null) {
            return null;
        }
        return (Node)this.placeholder.get();
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new ComboBoxListViewSkin(this);
    }

    public final void commitValue() {
        if (!this.isEditable()) {
            return;
        }
        String string = this.getEditor().getText();
        StringConverter<T> stringConverter = this.getConverter();
        if (stringConverter != null) {
            string = stringConverter.fromString(string);
            this.setValue(string);
        }
    }

    public final void cancelEdit() {
        if (!this.isEditable()) {
            return;
        }
        Object object = this.getValue();
        StringConverter stringConverter = this.getConverter();
        if (stringConverter != null) {
            object = stringConverter.toString(object);
            this.getEditor().setText((String)object);
        }
    }

    private void updateValue(T t2) {
        if (!this.valueProperty().isBound()) {
            this.setValue(t2);
        }
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute object, Object ... objectArray) {
        switch (ComboBox$4.$SwitchMap$javafx$scene$AccessibleAttribute[((Enum)object).ordinal()]) {
            case 1: {
                String string = this.getAccessibleText();
                if (string != null && !string.isEmpty()) {
                    return string;
                }
                if ((object = super.queryAccessibleAttribute((AccessibleAttribute)((Object)object), objectArray)) != null) {
                    return object;
                }
                object = this.getConverter();
                if (object == null) {
                    if (this.getValue() != null) {
                        return this.getValue().toString();
                    }
                    return "";
                }
                return ((StringConverter)object).toString(this.getValue());
            }
        }
        return super.queryAccessibleAttribute((AccessibleAttribute)((Object)object), objectArray);
    }
}

