/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.beans.IDProperty;
import com.sun.javafx.util.Utils;
import java.util.Collection;
import javafx.beans.property.ObjectProperty;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu$1;
import javafx.scene.control.ContextMenu$2;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.scene.control.skin.ContextMenuSkin;
import javafx.stage.Window;

@IDProperty(value="id")
public class ContextMenu
extends PopupControl {
    private boolean showRelativeToWindow = false;
    private ObjectProperty<EventHandler<ActionEvent>> onAction = new ContextMenu$1(this);
    private final ObservableList<MenuItem> items = new ContextMenu$2(this);
    private static final String DEFAULT_STYLE_CLASS = "context-menu";

    public ContextMenu() {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAutoHide(true);
        this.setConsumeAutoHidingEvents(false);
    }

    public ContextMenu(MenuItem ... menuItemArray) {
        this();
        this.items.addAll((MenuItem[])menuItemArray);
    }

    public final void setOnAction(EventHandler<ActionEvent> eventHandler) {
        this.onActionProperty().set(eventHandler);
    }

    public final EventHandler<ActionEvent> getOnAction() {
        return (EventHandler)this.onActionProperty().get();
    }

    public final ObjectProperty<EventHandler<ActionEvent>> onActionProperty() {
        return this.onAction;
    }

    public final ObservableList<MenuItem> getItems() {
        return this.items;
    }

    public void show(Node node, Side object, double d2, double d3) {
        HPos hPos;
        if (node == null) {
            return;
        }
        if (this.getItems().size() == 0) {
            return;
        }
        this.getScene().setNodeOrientation(node.getEffectiveNodeOrientation());
        if (this.getScene().getStylesheets().isEmpty()) {
            this.getScene().getStylesheets().setAll((Collection<String>)node.getScene().getStylesheets());
        }
        HPos hPos2 = object == Side.LEFT ? HPos.LEFT : (hPos = object == Side.RIGHT ? HPos.RIGHT : HPos.CENTER);
        object = object == Side.TOP ? VPos.TOP : (object == Side.BOTTOM ? VPos.BOTTOM : VPos.CENTER);
        object = Utils.pointRelativeTo(node, this.prefWidth(-1.0), this.prefHeight(-1.0), hPos, (VPos)((Object)object), d2, d3, true);
        this.doShow(node, ((Point2D)object).getX(), ((Point2D)object).getY());
    }

    @Override
    public void show(Node node, double d2, double d3) {
        if (node == null) {
            return;
        }
        if (this.getItems().size() == 0) {
            return;
        }
        this.getScene().setNodeOrientation(node.getEffectiveNodeOrientation());
        this.doShow(node, d2, d3);
    }

    @Override
    public void hide() {
        if (!this.isShowing()) {
            return;
        }
        Event.fireEvent(this, new Event(Menu.ON_HIDING));
        super.hide();
        Event.fireEvent(this, new Event(Menu.ON_HIDDEN));
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new ContextMenuSkin(this);
    }

    final boolean isShowRelativeToWindow() {
        return this.showRelativeToWindow;
    }

    final void setShowRelativeToWindow(boolean bl2) {
        this.showRelativeToWindow = bl2;
    }

    private void doShow(Node eventTarget, double d2, double d3) {
        Event.fireEvent(this, new Event(Menu.ON_SHOWING));
        if (this.isShowRelativeToWindow()) {
            eventTarget = eventTarget == null ? null : ((Node)eventTarget).getScene();
            if ((eventTarget = eventTarget == null ? null : ((Scene)eventTarget).getWindow()) == null) {
                return;
            }
            super.show((Window)eventTarget, d2, d3);
        } else {
            super.show((Node)eventTarget, d2, d3);
        }
        Event.fireEvent(this, new Event(Menu.ON_SHOWN));
    }

    static /* synthetic */ void access$000(ContextMenu contextMenu, EventType eventType, EventHandler eventHandler) {
        contextMenu.setEventHandler(eventType, eventHandler);
    }
}

