/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.scene.control.ControlHelper;
import com.sun.javafx.scene.control.Logging;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javafx.application.Application;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.CssParser$ParseError;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.event.EventHandler;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control$1;
import javafx.scene.control.Control$2;
import javafx.scene.control.Control$3;
import javafx.scene.control.Control$4;
import javafx.scene.control.Control$5;
import javafx.scene.control.Control$6;
import javafx.scene.control.Control$StyleableProperties;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Skinnable;
import javafx.scene.control.Tooltip;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.layout.Region;
import javafx.stage.PopupWindow;

public abstract class Control
extends Region
implements Skinnable {
    private List<CssMetaData<? extends Styleable, ?>> styleableProperties;
    private SkinBase<?> skinBase;
    private static final EventHandler<ContextMenuEvent> contextMenuHandler;
    private ObjectProperty<Skin<?>> skin = new Control$2(this);
    private ObjectProperty<Tooltip> tooltip;
    private ObjectProperty<ContextMenu> contextMenu;
    private String currentSkinClassName;
    private StringProperty skinClassName;
    private boolean skinCreationLocked;

    private static Class<?> loadClass(String string, Object object) throws ClassNotFoundException {
        try {
            return Class.forName(string, false, Control.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (Thread.currentThread().getContextClassLoader() != null) {
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    return Class.forName(string, false, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException2) {}
            }
            if (object != null) {
                for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                    try {
                        object = clazz.getClassLoader();
                        return Class.forName(string, false, (ClassLoader)object);
                    }
                    catch (ClassNotFoundException classNotFoundException3) {
                        continue;
                    }
                }
            }
            throw classNotFoundException;
        }
    }

    @Override
    public final ObjectProperty<Skin<?>> skinProperty() {
        return this.skin;
    }

    @Override
    public final void setSkin(Skin<?> skin) {
        this.skinProperty().set(skin);
    }

    @Override
    public final Skin<?> getSkin() {
        return (Skin)this.skinProperty().getValue();
    }

    public final ObjectProperty<Tooltip> tooltipProperty() {
        if (this.tooltip == null) {
            this.tooltip = new Control$3(this);
        }
        return this.tooltip;
    }

    public final void setTooltip(Tooltip tooltip) {
        this.tooltipProperty().setValue(tooltip);
    }

    public final Tooltip getTooltip() {
        if (this.tooltip == null) {
            return null;
        }
        return (Tooltip)this.tooltip.getValue();
    }

    public final ObjectProperty<ContextMenu> contextMenuProperty() {
        return this.contextMenu;
    }

    public final void setContextMenu(ContextMenu contextMenu) {
        this.contextMenu.setValue(contextMenu);
    }

    public final ContextMenu getContextMenu() {
        if (this.contextMenu == null) {
            return null;
        }
        return (ContextMenu)this.contextMenu.getValue();
    }

    protected Control() {
        Control control = this;
        this.contextMenu = new Control$4(control, control, "contextMenu");
        ControlHelper.initHelper(this);
        this.currentSkinClassName = null;
        this.skinCreationLocked = false;
        StyleableProperty styleableProperty = (StyleableProperty)((Object)this.focusTraversableProperty());
        styleableProperty.applyStyle(null, Boolean.TRUE);
        this.addEventHandler(ContextMenuEvent.CONTEXT_MENU_REQUESTED, contextMenuHandler);
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    protected double computeMinWidth(double d2) {
        if (this.skinBase != null) {
            return this.skinBase.computeMinWidth(d2, this.snappedTopInset(), this.snappedRightInset(), this.snappedBottomInset(), this.snappedLeftInset());
        }
        Node node = this.getSkinNode();
        if (node == null) {
            return 0.0;
        }
        return node.minWidth(d2);
    }

    @Override
    protected double computeMinHeight(double d2) {
        if (this.skinBase != null) {
            return this.skinBase.computeMinHeight(d2, this.snappedTopInset(), this.snappedRightInset(), this.snappedBottomInset(), this.snappedLeftInset());
        }
        Node node = this.getSkinNode();
        if (node == null) {
            return 0.0;
        }
        return node.minHeight(d2);
    }

    @Override
    protected double computeMaxWidth(double d2) {
        if (this.skinBase != null) {
            return this.skinBase.computeMaxWidth(d2, this.snappedTopInset(), this.snappedRightInset(), this.snappedBottomInset(), this.snappedLeftInset());
        }
        Node node = this.getSkinNode();
        if (node == null) {
            return 0.0;
        }
        return node.maxWidth(d2);
    }

    @Override
    protected double computeMaxHeight(double d2) {
        if (this.skinBase != null) {
            return this.skinBase.computeMaxHeight(d2, this.snappedTopInset(), this.snappedRightInset(), this.snappedBottomInset(), this.snappedLeftInset());
        }
        Node node = this.getSkinNode();
        if (node == null) {
            return 0.0;
        }
        return node.maxHeight(d2);
    }

    @Override
    protected double computePrefWidth(double d2) {
        if (this.skinBase != null) {
            return this.skinBase.computePrefWidth(d2, this.snappedTopInset(), this.snappedRightInset(), this.snappedBottomInset(), this.snappedLeftInset());
        }
        Node node = this.getSkinNode();
        if (node == null) {
            return 0.0;
        }
        return node.prefWidth(d2);
    }

    @Override
    protected double computePrefHeight(double d2) {
        if (this.skinBase != null) {
            return this.skinBase.computePrefHeight(d2, this.snappedTopInset(), this.snappedRightInset(), this.snappedBottomInset(), this.snappedLeftInset());
        }
        Node node = this.getSkinNode();
        if (node == null) {
            return 0.0;
        }
        return node.prefHeight(d2);
    }

    @Override
    public double getBaselineOffset() {
        if (this.skinBase != null) {
            return this.skinBase.computeBaselineOffset(this.snappedTopInset(), this.snappedRightInset(), this.snappedBottomInset(), this.snappedLeftInset());
        }
        Node node = this.getSkinNode();
        if (node == null) {
            return 0.0;
        }
        return node.getBaselineOffset();
    }

    @Override
    protected void layoutChildren() {
        if (this.skinBase != null) {
            double d2 = this.snappedLeftInset();
            double d3 = this.snappedTopInset();
            Control control = this;
            double d4 = control.snapSizeX(control.getWidth()) - d2 - this.snappedRightInset();
            Control control2 = this;
            double d5 = control2.snapSizeY(control2.getHeight()) - d3 - this.snappedBottomInset();
            this.skinBase.layoutChildren(d2, d3, d4, d5);
            return;
        }
        Node node = this.getSkinNode();
        if (node != null) {
            node.resizeRelocate(0.0, 0.0, this.getWidth(), this.getHeight());
        }
    }

    protected Skin<?> createDefaultSkin() {
        return null;
    }

    ObservableList<Node> getControlChildren() {
        return this.getChildren();
    }

    private Node getSkinNode() {
        assert (this.skinBase == null);
        Skin<?> skin = this.getSkin();
        if (skin == null) {
            return null;
        }
        return skin.getNode();
    }

    StringProperty skinClassNameProperty() {
        if (this.skinClassName == null) {
            this.skinClassName = new Control$5(this);
        }
        return this.skinClassName;
    }

    static void loadSkinClass(Skinnable skinnable, String string) {
        if (string == null || string.isEmpty()) {
            String string2 = "Empty -fx-skin property specified for control " + String.valueOf(skinnable);
            ObservableList<CssParser$ParseError> observableList = StyleManager.getErrors();
            if (observableList != null) {
                CssParser$ParseError cssParser$ParseError = new CssParser$ParseError(string2);
                observableList.add(cssParser$ParseError);
            }
            Logging.getControlsLogger().severe(string2);
            return;
        }
        try {
            Class<?> clazz = Control.loadClass(string, skinnable);
            if (!Skin.class.isAssignableFrom(clazz)) {
                String string3 = "'" + string + "' is not a valid Skin class for control " + String.valueOf(skinnable);
                ObservableList<CssParser$ParseError> observableList = StyleManager.getErrors();
                if (observableList != null) {
                    CssParser$ParseError cssParser$ParseError = new CssParser$ParseError(string3);
                    observableList.add(cssParser$ParseError);
                }
                Logging.getControlsLogger().severe(string3);
                return;
            }
            Constructor<?>[] constructorArray = clazz.getConstructors();
            Constructor<?> constructor = null;
            Object object = constructorArray;
            int n2 = constructorArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Constructor<?> constructor2 = object[i2];
                Class<?>[] classArray = constructor2.getParameterTypes();
                if (classArray.length != 1 || !Skinnable.class.isAssignableFrom(classArray[0])) continue;
                constructor = constructor2;
                break;
            }
            if (constructor == null) {
                object = "No valid constructor defined in '" + string + "' for control " + String.valueOf(skinnable) + ".\r\nYou must provide a constructor that accepts a single Skinnable (e.g. Control or PopupControl) parameter in " + string + ".";
                ObservableList<CssParser$ParseError> observableList = StyleManager.getErrors();
                if (observableList != null) {
                    CssParser$ParseError cssParser$ParseError = new CssParser$ParseError((String)object);
                    observableList.add(cssParser$ParseError);
                }
            } else {
                object = (Skin)constructor.newInstance(skinnable);
                skinnable.skinProperty().set((Skin<?>)object);
                return;
            }
            Logging.getControlsLogger().severe((String)object);
        }
        catch (InvocationTargetException invocationTargetException) {
            String string4 = "Failed to load skin '" + string + "' for control " + String.valueOf(skinnable);
            ObservableList<CssParser$ParseError> observableList = StyleManager.getErrors();
            if (observableList != null) {
                CssParser$ParseError cssParser$ParseError = new CssParser$ParseError(string4 + " :" + invocationTargetException.getLocalizedMessage());
                observableList.add(cssParser$ParseError);
            }
            Logging.getControlsLogger().severe(string4, invocationTargetException.getCause());
            return;
        }
        catch (Exception exception) {
            String string5 = "Failed to load skin '" + string + "' for control " + String.valueOf(skinnable);
            ObservableList<CssParser$ParseError> observableList = StyleManager.getErrors();
            if (observableList != null) {
                CssParser$ParseError cssParser$ParseError = new CssParser$ParseError(string5 + " :" + exception.getLocalizedMessage());
                observableList.add(cssParser$ParseError);
            }
            Logging.getControlsLogger().severe(string5, exception);
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return Control$StyleableProperties.STYLEABLES;
    }

    @Override
    public final List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        if (this.styleableProperties == null) {
            CssMetaData<Styleable, ?> cssMetaData;
            int n2;
            int n3;
            HashMap hashMap = new HashMap();
            List<CssMetaData<Styleable, ?>> list = this.getControlCssMetaData();
            int n4 = n3 = list != null ? list.size() : 0;
            for (n2 = 0; n2 < n3; ++n2) {
                cssMetaData = list.get(n2);
                if (cssMetaData == null) continue;
                hashMap.put(cssMetaData.getProperty(), cssMetaData);
            }
            list = this.skinBase != null ? this.skinBase.getCssMetaData() : null;
            int n5 = n3 = list != null ? list.size() : 0;
            for (n2 = 0; n2 < n3; ++n2) {
                cssMetaData = list.get(n2);
                if (cssMetaData == null) continue;
                hashMap.put(cssMetaData.getProperty(), cssMetaData);
            }
            this.styleableProperties = new ArrayList();
            this.styleableProperties.addAll(hashMap.values());
        }
        return this.styleableProperties;
    }

    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return Control.getClassCssMetaData();
    }

    private void doProcessCSS() {
        ControlHelper.superProcessCSS(this);
        if (this.getSkin() == null) {
            if (this.skinCreationLocked) {
                return;
            }
            try {
                this.skinCreationLocked = true;
                Object object = this.createDefaultSkin();
                if (object != null) {
                    this.skinProperty().set((Skin<?>)object);
                    ControlHelper.superProcessCSS(this);
                } else {
                    object = "The -fx-skin property has not been defined in CSS for " + String.valueOf(this) + " and createDefaultSkin() returned null.";
                    ObservableList<CssParser$ParseError> observableList = StyleManager.getErrors();
                    if (observableList != null) {
                        CssParser$ParseError cssParser$ParseError = new CssParser$ParseError((String)object);
                        observableList.add(cssParser$ParseError);
                    }
                    Logging.getControlsLogger().severe((String)object);
                }
                return;
            }
            finally {
                this.skinCreationLocked = false;
            }
        }
    }

    @Override
    protected Boolean getInitialFocusTraversable() {
        return Boolean.TRUE;
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute object, Object ... objectArray) {
        Object object2;
        switch (Control$6.$SwitchMap$javafx$scene$AccessibleAttribute[((Enum)object).ordinal()]) {
            case 1: {
                String string = this.getAccessibleHelp();
                if (string != null && !string.isEmpty()) {
                    return string;
                }
                object = this.getTooltip();
                if (object == null) {
                    return "";
                }
                return ((Tooltip)object).getText();
            }
        }
        if (this.skinBase != null && (object2 = this.skinBase.queryAccessibleAttribute((AccessibleAttribute)((Object)object), objectArray)) != null) {
            return object2;
        }
        return super.queryAccessibleAttribute((AccessibleAttribute)((Object)object), objectArray);
    }

    @Override
    public void executeAccessibleAction(AccessibleAction accessibleAction, Object ... objectArray) {
        if (this.skinBase != null) {
            this.skinBase.executeAccessibleAction(accessibleAction, objectArray);
        }
        super.executeAccessibleAction(accessibleAction, objectArray);
    }

    static /* synthetic */ ObservableList access$000(Control control) {
        return control.getChildren();
    }

    static /* synthetic */ ObservableList access$100(Control control) {
        return control.getChildren();
    }

    static {
        ControlHelper.setControlAccessor(new Control$1());
        if (Application.getUserAgentStylesheet() == null) {
            PlatformImpl.setDefaultPlatformUserAgentStylesheet();
        }
        contextMenuHandler = contextMenuEvent -> {
            if (contextMenuEvent.isConsumed()) {
                return;
            }
            Object object = contextMenuEvent.getSource();
            if (object instanceof Control && ((Control)(object = (Control)object)).getContextMenu() != null) {
                ((PopupWindow)((Control)object).getContextMenu()).show((Node)object, contextMenuEvent.getScreenX(), contextMenuEvent.getScreenY());
                contextMenuEvent.consume();
            }
        };
    }
}

