/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.FakeFocusTextField;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.chrono.Chronology;
import java.time.chrono.IsoChronology;
import java.time.format.FormatStyle;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.DateCell;
import javafx.scene.control.DatePicker$1;
import javafx.scene.control.DatePicker$2;
import javafx.scene.control.DatePicker$StyleableProperties;
import javafx.scene.control.Skin;
import javafx.scene.control.TextField;
import javafx.scene.control.skin.DatePickerSkin;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javafx.util.converter.LocalDateStringConverter;

public class DatePicker
extends ComboBoxBase<LocalDate> {
    private LocalDate lastValidDate = null;
    private Chronology lastValidChronology = IsoChronology.INSTANCE;
    private ObjectProperty<Callback<DatePicker, DateCell>> dayCellFactory;
    private ObjectProperty<Chronology> chronology = new SimpleObjectProperty<Object>(this, "chronology", null);
    private BooleanProperty showWeekNumbers;
    private ObjectProperty<StringConverter<LocalDate>> converter = new SimpleObjectProperty<Object>(this, "converter", null);
    private StringConverter<LocalDate> defaultConverter = new LocalDateStringConverter(FormatStyle.SHORT, null, this.getChronology());
    private ReadOnlyObjectWrapper<TextField> editor;
    private static final String DEFAULT_STYLE_CLASS = "date-picker";

    public DatePicker() {
        this(null);
    }

    public DatePicker(LocalDate localDate) {
        this.valueProperty().addListener(object -> {
            object = (LocalDate)this.getValue();
            Chronology chronology = this.getChronology();
            if (this.validateDate(chronology, (LocalDate)((Object)object))) {
                this.lastValidDate = object;
                return;
            }
            System.err.println("Restoring value to " + (this.lastValidDate == null ? "null" : this.getConverter().toString(this.lastValidDate)));
            DatePicker datePicker = this;
            datePicker.setValue(datePicker.lastValidDate);
        });
        this.chronologyProperty().addListener(object -> {
            object = (LocalDate)this.getValue();
            Chronology chronology = this.getChronology();
            if (this.validateDate(chronology, (LocalDate)((Object)object))) {
                this.lastValidChronology = chronology;
                this.defaultConverter = new LocalDateStringConverter(FormatStyle.SHORT, null, chronology);
                return;
            }
            System.err.println("Restoring value to " + String.valueOf(this.lastValidChronology));
            DatePicker datePicker = this;
            datePicker.setChronology(datePicker.lastValidChronology);
        });
        this.setValue(localDate);
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
        this.setAccessibleRole(AccessibleRole.DATE_PICKER);
        this.setEditable(true);
        this.focusedProperty().addListener(observable -> {
            if (!this.isFocused()) {
                this.commitValue();
            }
        });
    }

    private boolean validateDate(Chronology chronology, LocalDate localDate) {
        try {
            if (localDate != null) {
                chronology.date(localDate);
            }
            return true;
        }
        catch (DateTimeException dateTimeException) {
            System.err.println(dateTimeException);
            return false;
        }
    }

    public final void setDayCellFactory(Callback<DatePicker, DateCell> callback) {
        this.dayCellFactoryProperty().set(callback);
    }

    public final Callback<DatePicker, DateCell> getDayCellFactory() {
        if (this.dayCellFactory != null) {
            return (Callback)this.dayCellFactory.get();
        }
        return null;
    }

    public final ObjectProperty<Callback<DatePicker, DateCell>> dayCellFactoryProperty() {
        if (this.dayCellFactory == null) {
            this.dayCellFactory = new SimpleObjectProperty<Callback<DatePicker, DateCell>>(this, "dayCellFactory");
        }
        return this.dayCellFactory;
    }

    public final ObjectProperty<Chronology> chronologyProperty() {
        return this.chronology;
    }

    public final Chronology getChronology() {
        Chronology chronology = (Chronology)this.chronology.get();
        if (chronology == null) {
            try {
                chronology = Chronology.ofLocale(Locale.getDefault(Locale.Category.FORMAT));
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
            if (chronology == null) {
                chronology = IsoChronology.INSTANCE;
            }
        }
        return chronology;
    }

    public final void setChronology(Chronology chronology) {
        this.chronology.setValue(chronology);
    }

    public final BooleanProperty showWeekNumbersProperty() {
        if (this.showWeekNumbers == null) {
            String string = Locale.getDefault(Locale.Category.FORMAT).getCountry();
            boolean bl2 = !string.isEmpty() && ControlResources.getNonTranslatableString("DatePicker.showWeekNumbers").contains(string);
            this.showWeekNumbers = new DatePicker$1(this, bl2);
        }
        return this.showWeekNumbers;
    }

    public final void setShowWeekNumbers(boolean bl2) {
        this.showWeekNumbersProperty().setValue(bl2);
    }

    public final boolean isShowWeekNumbers() {
        return this.showWeekNumbersProperty().getValue();
    }

    public final ObjectProperty<StringConverter<LocalDate>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<LocalDate> stringConverter) {
        this.converterProperty().set(stringConverter);
    }

    public final StringConverter<LocalDate> getConverter() {
        StringConverter stringConverter = (StringConverter)this.converterProperty().get();
        if (stringConverter != null) {
            return stringConverter;
        }
        return this.defaultConverter;
    }

    public final TextField getEditor() {
        return (TextField)this.editorProperty().get();
    }

    public final ReadOnlyObjectProperty<TextField> editorProperty() {
        if (this.editor == null) {
            this.editor = new ReadOnlyObjectWrapper(this, "editor");
            this.editor.set(new FakeFocusTextField());
        }
        return this.editor.getReadOnlyProperty();
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new DatePickerSkin(this);
    }

    public final void commitValue() {
        if (!this.isEditable()) {
            return;
        }
        Object object = this.getEditor().getText();
        StringConverter<LocalDate> stringConverter = this.getConverter();
        if (stringConverter != null) {
            object = stringConverter.fromString((String)object);
            this.setValue(object);
        }
    }

    public final void cancelEdit() {
        if (!this.isEditable()) {
            return;
        }
        Object object = (LocalDate)this.getValue();
        StringConverter<LocalDate> stringConverter = this.getConverter();
        if (stringConverter != null) {
            object = stringConverter.toString((LocalDate)object);
            this.getEditor().setText((String)object);
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return DatePicker$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return DatePicker.getClassCssMetaData();
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute object, Object ... object2) {
        switch (DatePicker$2.$SwitchMap$javafx$scene$AccessibleAttribute[((Enum)object).ordinal()]) {
            case 1: {
                return this.getValue();
            }
            case 2: {
                object = this.getAccessibleText();
                if (object != null && !((String)object).isEmpty()) {
                    return object;
                }
                object = (LocalDate)this.getValue();
                object2 = this.getConverter();
                if (object != null && object2 != null) {
                    return ((StringConverter)object2).toString(object);
                }
                return "";
            }
        }
        return super.queryAccessibleAttribute((AccessibleAttribute)((Object)object), (Object[])object2);
    }
}

