/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.FXDialog;
import javafx.scene.control.HeavyweightDialog$1;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

class HeavyweightDialog
extends FXDialog {
    final Stage stage = new HeavyweightDialog$1(this);
    private Scene scene;
    private final Parent DUMMY_ROOT = new Region();
    private final Dialog<?> dialog;
    private DialogPane dialogPane;
    private double prefX = Double.NaN;
    private double prefY = Double.NaN;

    HeavyweightDialog(Dialog<?> dialog) {
        this.dialog = dialog;
        this.stage.setResizable(false);
        this.stage.setOnCloseRequest(windowEvent -> {
            if (this.requestPermissionToClose(dialog)) {
                dialog.close();
                return;
            }
            windowEvent.consume();
        });
        this.stage.addEventHandler(KeyEvent.KEY_PRESSED, keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ESCAPE && !keyEvent.isConsumed() && this.requestPermissionToClose(dialog)) {
                dialog.close();
                keyEvent.consume();
            }
        });
    }

    @Override
    void initStyle(StageStyle stageStyle) {
        this.stage.initStyle(stageStyle);
    }

    @Override
    StageStyle getStyle() {
        return this.stage.getStyle();
    }

    @Override
    public void initOwner(Window window) {
        HeavyweightDialog heavyweightDialog = this;
        heavyweightDialog.updateStageBindings(heavyweightDialog.stage.getOwner(), window);
        this.stage.initOwner(window);
    }

    @Override
    public Window getOwner() {
        return this.stage.getOwner();
    }

    @Override
    public void initModality(Modality modality) {
        this.stage.initModality(modality == null ? Modality.APPLICATION_MODAL : modality);
    }

    @Override
    public Modality getModality() {
        return this.stage.getModality();
    }

    @Override
    public void setDialogPane(DialogPane dialogPane) {
        this.dialogPane = dialogPane;
        if (this.scene == null) {
            this.scene = new Scene(dialogPane);
            this.stage.setScene(this.scene);
        } else {
            this.scene.setRoot(dialogPane);
        }
        dialogPane.autosize();
        this.stage.sizeToScene();
    }

    @Override
    public void show() {
        this.scene.setRoot(this.dialogPane);
        this.stage.centerOnScreen();
        this.stage.show();
    }

    @Override
    public void showAndWait() {
        this.scene.setRoot(this.dialogPane);
        this.stage.centerOnScreen();
        this.stage.showAndWait();
    }

    @Override
    public void close() {
        if (this.stage.isShowing()) {
            this.stage.hide();
        }
        if (this.scene != null) {
            this.scene.setRoot(this.DUMMY_ROOT);
        }
    }

    @Override
    public ReadOnlyBooleanProperty showingProperty() {
        return this.stage.showingProperty();
    }

    @Override
    public Window getWindow() {
        return this.stage;
    }

    @Override
    public Node getRoot() {
        return this.stage.getScene().getRoot();
    }

    @Override
    public double getX() {
        return this.stage.getX();
    }

    @Override
    public void setX(double d2) {
        this.stage.setX(d2);
    }

    @Override
    public ReadOnlyDoubleProperty xProperty() {
        return this.stage.xProperty();
    }

    @Override
    public double getY() {
        return this.stage.getY();
    }

    @Override
    public void setY(double d2) {
        this.stage.setY(d2);
    }

    @Override
    public ReadOnlyDoubleProperty yProperty() {
        return this.stage.yProperty();
    }

    @Override
    ReadOnlyDoubleProperty heightProperty() {
        return this.stage.heightProperty();
    }

    @Override
    void setHeight(double d2) {
        this.stage.setHeight(d2);
    }

    @Override
    double getSceneHeight() {
        if (this.scene == null) {
            return 0.0;
        }
        return this.scene.getHeight();
    }

    @Override
    ReadOnlyDoubleProperty widthProperty() {
        return this.stage.widthProperty();
    }

    @Override
    void setWidth(double d2) {
        this.stage.setWidth(d2);
    }

    @Override
    BooleanProperty resizableProperty() {
        return this.stage.resizableProperty();
    }

    @Override
    StringProperty titleProperty() {
        return this.stage.titleProperty();
    }

    @Override
    ReadOnlyBooleanProperty focusedProperty() {
        return this.stage.focusedProperty();
    }

    @Override
    public void sizeToScene() {
        this.stage.sizeToScene();
    }

    private void positionStage() {
        double d2 = this.getX();
        double d3 = this.getY();
        if (!Double.isNaN(d2) && !Double.isNaN(d3) && Double.compare(d2, this.prefX) != 0 && Double.compare(d3, this.prefY) != 0) {
            this.setX(d2);
            this.setY(d3);
            return;
        }
        this.dialogPane.applyCss();
        this.dialogPane.layout();
        Window window = this.getOwner();
        Scene scene = window.getScene();
        double d4 = scene.getY();
        double d5 = ((Node)this.dialogPane).prefWidth(-1.0);
        double d6 = ((Node)this.dialogPane).prefHeight(d5);
        d2 = window.getX() + scene.getWidth() / 2.0 - d5 / 2.0;
        double d7 = window.getY() + d4 / 2.0 + scene.getHeight() / 2.0 - d6 / 2.0;
        this.prefX = d2;
        this.prefY = d7;
        this.setX(d2);
        this.setY(d7);
    }

    private void updateStageBindings(Window eventTarget, Window window) {
        Scene scene = this.stage.getScene();
        if (eventTarget != null && eventTarget instanceof Stage) {
            eventTarget = (Stage)eventTarget;
            Bindings.unbindContent(this.stage.getIcons(), ((Stage)eventTarget).getIcons());
            this.stage.renderScaleXProperty().unbind();
            this.stage.renderScaleYProperty().unbind();
            eventTarget = ((Window)eventTarget).getScene();
            if (this.scene != null && scene != null) {
                Bindings.unbindContent(scene.getStylesheets(), ((Scene)eventTarget).getStylesheets());
            }
        }
        if (window instanceof Stage) {
            eventTarget = (Stage)window;
            Bindings.bindContent(this.stage.getIcons(), ((Stage)eventTarget).getIcons());
            this.stage.renderScaleXProperty().bind(((Window)eventTarget).renderScaleXProperty());
            this.stage.renderScaleYProperty().bind(((Window)eventTarget).renderScaleYProperty());
            eventTarget = ((Window)eventTarget).getScene();
            if (this.scene != null && scene != null) {
                Bindings.bindContent(scene.getStylesheets(), ((Scene)eventTarget).getStylesheets());
            }
        }
    }
}

