/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.NamedArg;

public final class IndexRange {
    private int start;
    private int end;
    public static final String VALUE_DELIMITER = ",";

    public IndexRange(@NamedArg(value="start") int n2, @NamedArg(value="end") int n3) {
        if (n3 < n2) {
            throw new IllegalArgumentException();
        }
        this.start = n2;
        this.end = n3;
    }

    public IndexRange(@NamedArg(value="range") IndexRange indexRange) {
        this.start = indexRange.start;
        this.end = indexRange.end;
    }

    public final int getStart() {
        return this.start;
    }

    public final int getEnd() {
        return this.end;
    }

    public final int getLength() {
        return this.end - this.start;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof IndexRange) {
            object = (IndexRange)object;
            return this.start == ((IndexRange)object).start && this.end == ((IndexRange)object).end;
        }
        return false;
    }

    public final int hashCode() {
        return 31 * this.start + this.end;
    }

    public final String toString() {
        return this.start + ", " + this.end;
    }

    public static IndexRange normalize(int n2, int n3) {
        return new IndexRange(Math.min(n2, n3), Math.max(n2, n3));
    }

    public static IndexRange valueOf(String stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException();
        }
        if ((stringArray = stringArray.split(VALUE_DELIMITER)).length != 2) {
            throw new IllegalArgumentException();
        }
        int n2 = Integer.parseInt(stringArray[0].trim());
        int n3 = Integer.parseInt(stringArray[1].trim());
        return IndexRange.normalize(n2, n3);
    }
}

