/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.css.PseudoClass;
import javafx.scene.control.Cell;
import javafx.scene.control.IndexedCell$1;

public class IndexedCell<T>
extends Cell<T> {
    private int oldIndex = -1;
    private ReadOnlyIntegerWrapper index;
    private static final String DEFAULT_STYLE_CLASS = "indexed-cell";
    private static final PseudoClass PSEUDO_CLASS_ODD = PseudoClass.getPseudoClass("odd");
    private static final PseudoClass PSEUDO_CLASS_EVEN = PseudoClass.getPseudoClass("even");

    public IndexedCell() {
        IndexedCell indexedCell = this;
        this.index = new IndexedCell$1(indexedCell, indexedCell, "index", -1);
        this.getStyleClass().addAll((String[])new String[]{DEFAULT_STYLE_CLASS});
    }

    public final int getIndex() {
        return this.index.get();
    }

    public final ReadOnlyIntegerProperty indexProperty() {
        return this.index.getReadOnlyProperty();
    }

    public void updateIndex(int n2) {
        this.oldIndex = this.index.get();
        if (this.oldIndex == n2) {
            IndexedCell indexedCell = this;
            indexedCell.indexChanged(indexedCell.oldIndex, n2);
            return;
        }
        this.index.set(n2);
    }

    void indexChanged(int n2, int n3) {
    }
}

