/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.css.StyleableStringProperty;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.Labeled$1;
import javafx.scene.control.Labeled$10;
import javafx.scene.control.Labeled$11;
import javafx.scene.control.Labeled$12;
import javafx.scene.control.Labeled$13;
import javafx.scene.control.Labeled$14;
import javafx.scene.control.Labeled$2;
import javafx.scene.control.Labeled$3;
import javafx.scene.control.Labeled$4;
import javafx.scene.control.Labeled$5;
import javafx.scene.control.Labeled$6;
import javafx.scene.control.Labeled$7;
import javafx.scene.control.Labeled$8;
import javafx.scene.control.Labeled$9;
import javafx.scene.control.Labeled$StyleableProperties;
import javafx.scene.control.OverrunStyle;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;

@DefaultProperty(value="text")
public abstract class Labeled
extends Control {
    private static final String DEFAULT_ELLIPSIS_STRING = "...";
    private StringProperty text;
    private ObjectProperty<Pos> alignment;
    private ObjectProperty<TextAlignment> textAlignment;
    private ObjectProperty<OverrunStyle> textOverrun;
    private StringProperty ellipsisString;
    private BooleanProperty wrapText;
    private ObjectProperty<Font> font;
    private ObjectProperty<Node> graphic;
    private StyleableStringProperty imageUrl = null;
    private BooleanProperty underline;
    private DoubleProperty lineSpacing;
    private ObjectProperty<ContentDisplay> contentDisplay;
    private ObjectProperty<Insets> labelPadding;
    private DoubleProperty graphicTextGap;
    private ObjectProperty<Paint> textFill;
    private BooleanProperty mnemonicParsing;

    public Labeled() {
    }

    public Labeled(String string) {
        this.setText(string);
    }

    public Labeled(String string, Node node) {
        this.setText(string);
        ((StyleableProperty)((Object)this.graphicProperty())).applyStyle(null, node);
    }

    public final StringProperty textProperty() {
        if (this.text == null) {
            this.text = new SimpleStringProperty(this, "text", "");
        }
        return this.text;
    }

    public final void setText(String string) {
        this.textProperty().setValue(string);
    }

    public final String getText() {
        if (this.text == null) {
            return "";
        }
        return this.text.getValue();
    }

    public final ObjectProperty<Pos> alignmentProperty() {
        if (this.alignment == null) {
            this.alignment = new Labeled$1(this, Pos.CENTER_LEFT);
        }
        return this.alignment;
    }

    public final void setAlignment(Pos pos) {
        this.alignmentProperty().set(pos);
    }

    public final Pos getAlignment() {
        if (this.alignment == null) {
            return Pos.CENTER_LEFT;
        }
        return (Pos)((Object)this.alignment.get());
    }

    public final ObjectProperty<TextAlignment> textAlignmentProperty() {
        if (this.textAlignment == null) {
            this.textAlignment = new Labeled$2(this, TextAlignment.LEFT);
        }
        return this.textAlignment;
    }

    public final void setTextAlignment(TextAlignment textAlignment) {
        this.textAlignmentProperty().setValue(textAlignment);
    }

    public final TextAlignment getTextAlignment() {
        if (this.textAlignment == null) {
            return TextAlignment.LEFT;
        }
        return (TextAlignment)((Object)this.textAlignment.getValue());
    }

    public final ObjectProperty<OverrunStyle> textOverrunProperty() {
        if (this.textOverrun == null) {
            this.textOverrun = new Labeled$3(this, OverrunStyle.ELLIPSIS);
        }
        return this.textOverrun;
    }

    public final void setTextOverrun(OverrunStyle overrunStyle) {
        this.textOverrunProperty().setValue(overrunStyle);
    }

    public final OverrunStyle getTextOverrun() {
        if (this.textOverrun == null) {
            return OverrunStyle.ELLIPSIS;
        }
        return (OverrunStyle)((Object)this.textOverrun.getValue());
    }

    public final StringProperty ellipsisStringProperty() {
        if (this.ellipsisString == null) {
            this.ellipsisString = new Labeled$4(this, DEFAULT_ELLIPSIS_STRING);
        }
        return this.ellipsisString;
    }

    public final void setEllipsisString(String string) {
        this.ellipsisStringProperty().set(string == null ? "" : string);
    }

    public final String getEllipsisString() {
        if (this.ellipsisString == null) {
            return DEFAULT_ELLIPSIS_STRING;
        }
        return (String)this.ellipsisString.get();
    }

    public final BooleanProperty wrapTextProperty() {
        if (this.wrapText == null) {
            this.wrapText = new Labeled$5(this);
        }
        return this.wrapText;
    }

    public final void setWrapText(boolean bl2) {
        this.wrapTextProperty().setValue(bl2);
    }

    public final boolean isWrapText() {
        if (this.wrapText == null) {
            return false;
        }
        return this.wrapText.getValue();
    }

    @Override
    public Orientation getContentBias() {
        if (this.isWrapText()) {
            return Orientation.HORIZONTAL;
        }
        return null;
    }

    public final ObjectProperty<Font> fontProperty() {
        if (this.font == null) {
            this.font = new Labeled$6(this, Font.getDefault());
        }
        return this.font;
    }

    public final void setFont(Font font) {
        this.fontProperty().setValue(font);
    }

    public final Font getFont() {
        if (this.font == null) {
            return Font.getDefault();
        }
        return (Font)this.font.getValue();
    }

    public final ObjectProperty<Node> graphicProperty() {
        if (this.graphic == null) {
            this.graphic = new Labeled$7(this);
        }
        return this.graphic;
    }

    public final void setGraphic(Node node) {
        this.graphicProperty().setValue(node);
    }

    public final Node getGraphic() {
        if (this.graphic == null) {
            return null;
        }
        return (Node)this.graphic.getValue();
    }

    private StyleableStringProperty imageUrlProperty() {
        if (this.imageUrl == null) {
            this.imageUrl = new Labeled$8(this);
        }
        return this.imageUrl;
    }

    public final BooleanProperty underlineProperty() {
        if (this.underline == null) {
            this.underline = new Labeled$9(this, false);
        }
        return this.underline;
    }

    public final void setUnderline(boolean bl2) {
        this.underlineProperty().setValue(bl2);
    }

    public final boolean isUnderline() {
        if (this.underline == null) {
            return false;
        }
        return this.underline.getValue();
    }

    public final DoubleProperty lineSpacingProperty() {
        if (this.lineSpacing == null) {
            this.lineSpacing = new Labeled$10(this, 0.0);
        }
        return this.lineSpacing;
    }

    public final void setLineSpacing(double d2) {
        this.lineSpacingProperty().setValue(d2);
    }

    public final double getLineSpacing() {
        if (this.lineSpacing == null) {
            return 0.0;
        }
        return this.lineSpacing.getValue();
    }

    public final ObjectProperty<ContentDisplay> contentDisplayProperty() {
        if (this.contentDisplay == null) {
            this.contentDisplay = new Labeled$11(this, ContentDisplay.LEFT);
        }
        return this.contentDisplay;
    }

    public final void setContentDisplay(ContentDisplay contentDisplay) {
        this.contentDisplayProperty().setValue(contentDisplay);
    }

    public final ContentDisplay getContentDisplay() {
        if (this.contentDisplay == null) {
            return ContentDisplay.LEFT;
        }
        return (ContentDisplay)((Object)this.contentDisplay.getValue());
    }

    public final ReadOnlyObjectProperty<Insets> labelPaddingProperty() {
        return this.labelPaddingPropertyImpl();
    }

    private ObjectProperty<Insets> labelPaddingPropertyImpl() {
        if (this.labelPadding == null) {
            this.labelPadding = new Labeled$12(this, Insets.EMPTY);
        }
        return this.labelPadding;
    }

    private void setLabelPadding(Insets insets) {
        this.labelPaddingPropertyImpl().set(insets);
    }

    public final Insets getLabelPadding() {
        if (this.labelPadding == null) {
            return Insets.EMPTY;
        }
        return (Insets)this.labelPadding.get();
    }

    public final DoubleProperty graphicTextGapProperty() {
        if (this.graphicTextGap == null) {
            this.graphicTextGap = new Labeled$13(this, 4.0);
        }
        return this.graphicTextGap;
    }

    public final void setGraphicTextGap(double d2) {
        this.graphicTextGapProperty().setValue(d2);
    }

    public final double getGraphicTextGap() {
        if (this.graphicTextGap == null) {
            return 4.0;
        }
        return this.graphicTextGap.getValue();
    }

    public final void setTextFill(Paint paint) {
        this.textFillProperty().set(paint);
    }

    public final Paint getTextFill() {
        if (this.textFill == null) {
            return Color.BLACK;
        }
        return (Paint)this.textFill.get();
    }

    public final ObjectProperty<Paint> textFillProperty() {
        if (this.textFill == null) {
            this.textFill = new Labeled$14(this, Color.BLACK);
        }
        return this.textFill;
    }

    public final void setMnemonicParsing(boolean bl2) {
        this.mnemonicParsingProperty().set(bl2);
    }

    public final boolean isMnemonicParsing() {
        if (this.mnemonicParsing == null) {
            return false;
        }
        return this.mnemonicParsing.get();
    }

    public final BooleanProperty mnemonicParsingProperty() {
        if (this.mnemonicParsing == null) {
            this.mnemonicParsing = new SimpleBooleanProperty(this, "mnemonicParsing");
        }
        return this.mnemonicParsing;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString()).append("'").append(this.getText()).append("'");
        return stringBuilder.toString();
    }

    protected Pos getInitialAlignment() {
        return Pos.CENTER_LEFT;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return Labeled$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return Labeled.getClassCssMetaData();
    }
}

