/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.scene.AccessibleAttribute;
import javafx.scene.control.FocusModel;
import javafx.scene.control.ListView;
import javafx.scene.control.ListView$ListViewFocusModel$1;

class ListView$ListViewFocusModel<T>
extends FocusModel<T> {
    private final ListView<T> listView;
    private int itemCount = 0;
    private final InvalidationListener itemsObserver;
    private final ListChangeListener<T> itemsContentListener = listChangeListener$Change -> {
        this.updateItemCount();
        while (listChangeListener$Change.next()) {
            int n2 = listChangeListener$Change.getFrom();
            if (listChangeListener$Change.wasReplaced() || listChangeListener$Change.getAddedSize() == this.getItemCount()) {
                this.updateDefaultFocus();
                return;
            }
            if (this.getFocusedIndex() == -1 || n2 > this.getFocusedIndex()) {
                return;
            }
            listChangeListener$Change.reset();
            n2 = 0;
            boolean bl2 = false;
            int n3 = 0;
            int n4 = 0;
            while (listChangeListener$Change.next()) {
                n2 |= listChangeListener$Change.wasAdded();
                bl2 |= listChangeListener$Change.wasRemoved();
                n3 += listChangeListener$Change.getAddedSize();
                n4 += listChangeListener$Change.getRemovedSize();
            }
            if (n2 != 0 && !bl2) {
                ListView$ListViewFocusModel listView$ListViewFocusModel = this;
                listView$ListViewFocusModel.focus(Math.min(listView$ListViewFocusModel.getItemCount() - 1, this.getFocusedIndex() + n3));
                continue;
            }
            if (n2 != 0 || !bl2) continue;
            this.focus(Math.max(0, this.getFocusedIndex() - n4));
        }
    };
    private WeakListChangeListener<T> weakItemsContentListener = new WeakListChangeListener<T>(this.itemsContentListener);

    public ListView$ListViewFocusModel(ListView<T> listView) {
        if (listView == null) {
            throw new IllegalArgumentException("ListView can not be null");
        }
        this.listView = listView;
        this.itemsObserver = new ListView$ListViewFocusModel$1(this, listView);
        this.listView.itemsProperty().addListener(new WeakInvalidationListener(this.itemsObserver));
        if (listView.getItems() != null) {
            this.listView.getItems().addListener(this.weakItemsContentListener);
        }
        this.updateItemCount();
        this.updateDefaultFocus();
        this.focusedIndexProperty().addListener(observable -> listView.notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUS_ITEM));
    }

    private void updateItemsObserver(ObservableList<T> observableList, ObservableList<T> observableList2) {
        if (observableList != null) {
            observableList.removeListener(this.weakItemsContentListener);
        }
        if (observableList2 != null) {
            observableList2.addListener(this.weakItemsContentListener);
        }
        this.updateItemCount();
        this.updateDefaultFocus();
    }

    @Override
    protected int getItemCount() {
        return this.itemCount;
    }

    @Override
    protected T getModelItem(int n2) {
        if (this.isEmpty()) {
            return null;
        }
        if (n2 < 0 || n2 >= this.itemCount) {
            return null;
        }
        return (T)this.listView.getItems().get(n2);
    }

    private boolean isEmpty() {
        return this.itemCount == -1;
    }

    private void updateItemCount() {
        int n2;
        if (this.listView == null) {
            v0 = this;
            n2 = -1;
        } else {
            ObservableList<T> observableList = this.listView.getItems();
            v0 = this;
            n2 = observableList == null ? -1 : observableList.size();
        }
        v0.itemCount = n2;
    }

    private void updateDefaultFocus() {
        int n2 = -1;
        if (this.listView.getItems() != null) {
            Object t2 = this.getFocusedItem();
            if (t2 != null) {
                n2 = this.listView.getItems().indexOf(t2);
            }
            if (n2 == -1) {
                n2 = this.listView.getItems().size() > 0 ? 0 : -1;
            }
        }
        this.focus(n2);
    }
}

