/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.MapChangeListener$Change;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Orientation;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ControlUtils;
import javafx.scene.control.FocusModel;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView$1;
import javafx.scene.control.ListView$2;
import javafx.scene.control.ListView$3;
import javafx.scene.control.ListView$4;
import javafx.scene.control.ListView$5;
import javafx.scene.control.ListView$6;
import javafx.scene.control.ListView$7;
import javafx.scene.control.ListView$EditEvent;
import javafx.scene.control.ListView$ListViewBitSetSelectionModel;
import javafx.scene.control.ListView$ListViewFocusModel;
import javafx.scene.control.ListView$StyleableProperties;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.ScrollToEvent;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Skin;
import javafx.scene.control.skin.ListViewSkin;
import javafx.util.Callback;

@DefaultProperty(value="items")
public class ListView<T>
extends Control {
    private static final EventType<?> EDIT_ANY_EVENT = new EventType<Event>(Event.ANY, "LIST_VIEW_EDIT");
    private static final EventType<?> EDIT_START_EVENT = new EventType(ListView.editAnyEvent(), "EDIT_START");
    private static final EventType<?> EDIT_CANCEL_EVENT = new EventType(ListView.editAnyEvent(), "EDIT_CANCEL");
    private static final EventType<?> EDIT_COMMIT_EVENT = new EventType(ListView.editAnyEvent(), "EDIT_COMMIT");
    private boolean selectFirstRowByDefault = true;
    private EventHandler<ListView$EditEvent<T>> DEFAULT_EDIT_COMMIT_HANDLER = listView$EditEvent -> {
        int n2 = listView$EditEvent.getIndex();
        ObservableList<T> observableList = this.getItems();
        if (n2 < 0 || n2 >= observableList.size()) {
            return;
        }
        observableList.set(n2, listView$EditEvent.getNewValue());
    };
    private ObjectProperty<ObservableList<T>> items;
    private ObjectProperty<Node> placeholder;
    private ObjectProperty<MultipleSelectionModel<T>> selectionModel = new SimpleObjectProperty<MultipleSelectionModel<T>>(this, "selectionModel");
    private ObjectProperty<FocusModel<T>> focusModel;
    private ObjectProperty<Orientation> orientation;
    private ObjectProperty<Callback<ListView<T>, ListCell<T>>> cellFactory;
    private DoubleProperty fixedCellSize;
    private BooleanProperty editable;
    private ReadOnlyIntegerWrapper editingIndex;
    private ObjectProperty<EventHandler<ListView$EditEvent<T>>> onEditStart;
    private ObjectProperty<EventHandler<ListView$EditEvent<T>>> onEditCommit;
    private ObjectProperty<EventHandler<ListView$EditEvent<T>>> onEditCancel;
    private ObjectProperty<EventHandler<ScrollToEvent<Integer>>> onScrollTo;
    private static final String DEFAULT_STYLE_CLASS = "list-view";
    private static final PseudoClass PSEUDO_CLASS_VERTICAL = PseudoClass.getPseudoClass("vertical");
    private static final PseudoClass PSEUDO_CLASS_HORIZONTAL = PseudoClass.getPseudoClass("horizontal");

    public static <T> EventType<ListView$EditEvent<T>> editAnyEvent() {
        return EDIT_ANY_EVENT;
    }

    public static <T> EventType<ListView$EditEvent<T>> editStartEvent() {
        return EDIT_START_EVENT;
    }

    public static <T> EventType<ListView$EditEvent<T>> editCancelEvent() {
        return EDIT_CANCEL_EVENT;
    }

    public static <T> EventType<ListView$EditEvent<T>> editCommitEvent() {
        return EDIT_COMMIT_EVENT;
    }

    public ListView() {
        this(FXCollections.observableArrayList());
    }

    public ListView(ObservableList<T> observableList) {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.LIST_VIEW);
        this.setItems(observableList);
        this.setSelectionModel(new ListView$ListViewBitSetSelectionModel(this));
        this.setFocusModel(new ListView$ListViewFocusModel(this));
        ListView listView = this;
        listView.setOnEditCommit(listView.DEFAULT_EDIT_COMMIT_HANDLER);
        this.getProperties().addListener(object -> {
            if (((MapChangeListener$Change)object).wasAdded() && "selectFirstRowByDefault".equals(((MapChangeListener$Change)object).getKey())) {
                if ((object = (Boolean)((MapChangeListener$Change)object).getValueAdded()) == null) {
                    return;
                }
                this.selectFirstRowByDefault = (Boolean)((Object)object);
            }
        });
        this.pseudoClassStateChanged(PSEUDO_CLASS_VERTICAL, true);
    }

    public final void setItems(ObservableList<T> observableList) {
        this.itemsProperty().set(observableList);
    }

    public final ObservableList<T> getItems() {
        if (this.items == null) {
            return null;
        }
        return (ObservableList)this.items.get();
    }

    public final ObjectProperty<ObservableList<T>> itemsProperty() {
        if (this.items == null) {
            this.items = new SimpleObjectProperty<ObservableList<T>>(this, "items");
        }
        return this.items;
    }

    public final ObjectProperty<Node> placeholderProperty() {
        if (this.placeholder == null) {
            this.placeholder = new SimpleObjectProperty<Node>(this, "placeholder");
        }
        return this.placeholder;
    }

    public final void setPlaceholder(Node node) {
        this.placeholderProperty().set(node);
    }

    public final Node getPlaceholder() {
        if (this.placeholder == null) {
            return null;
        }
        return (Node)this.placeholder.get();
    }

    public final void setSelectionModel(MultipleSelectionModel<T> multipleSelectionModel) {
        this.selectionModelProperty().set(multipleSelectionModel);
    }

    public final MultipleSelectionModel<T> getSelectionModel() {
        if (this.selectionModel == null) {
            return null;
        }
        return (MultipleSelectionModel)this.selectionModel.get();
    }

    public final ObjectProperty<MultipleSelectionModel<T>> selectionModelProperty() {
        return this.selectionModel;
    }

    public final void setFocusModel(FocusModel<T> focusModel) {
        this.focusModelProperty().set(focusModel);
    }

    public final FocusModel<T> getFocusModel() {
        if (this.focusModel == null) {
            return null;
        }
        return (FocusModel)this.focusModel.get();
    }

    public final ObjectProperty<FocusModel<T>> focusModelProperty() {
        if (this.focusModel == null) {
            this.focusModel = new SimpleObjectProperty<FocusModel<T>>(this, "focusModel");
        }
        return this.focusModel;
    }

    public final void setOrientation(Orientation orientation) {
        this.orientationProperty().set(orientation);
    }

    public final Orientation getOrientation() {
        if (this.orientation == null) {
            return Orientation.VERTICAL;
        }
        return (Orientation)((Object)this.orientation.get());
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        if (this.orientation == null) {
            this.orientation = new ListView$1(this, Orientation.VERTICAL);
        }
        return this.orientation;
    }

    public final void setCellFactory(Callback<ListView<T>, ListCell<T>> callback) {
        this.cellFactoryProperty().set(callback);
    }

    public final Callback<ListView<T>, ListCell<T>> getCellFactory() {
        if (this.cellFactory == null) {
            return null;
        }
        return (Callback)this.cellFactory.get();
    }

    public final ObjectProperty<Callback<ListView<T>, ListCell<T>>> cellFactoryProperty() {
        if (this.cellFactory == null) {
            this.cellFactory = new SimpleObjectProperty<Callback<ListView<T>, ListCell<T>>>(this, "cellFactory");
        }
        return this.cellFactory;
    }

    public final void setFixedCellSize(double d2) {
        this.fixedCellSizeProperty().set(d2);
    }

    public final double getFixedCellSize() {
        if (this.fixedCellSize == null) {
            return -1.0;
        }
        return this.fixedCellSize.get();
    }

    public final DoubleProperty fixedCellSizeProperty() {
        if (this.fixedCellSize == null) {
            this.fixedCellSize = new ListView$2(this, -1.0);
        }
        return this.fixedCellSize;
    }

    public final void setEditable(boolean bl2) {
        this.editableProperty().set(bl2);
    }

    public final boolean isEditable() {
        if (this.editable == null) {
            return false;
        }
        return this.editable.get();
    }

    public final BooleanProperty editableProperty() {
        if (this.editable == null) {
            this.editable = new SimpleBooleanProperty(this, "editable", false);
        }
        return this.editable;
    }

    private void setEditingIndex(int n2) {
        this.editingIndexPropertyImpl().set(n2);
    }

    public final int getEditingIndex() {
        if (this.editingIndex == null) {
            return -1;
        }
        return this.editingIndex.get();
    }

    public final ReadOnlyIntegerProperty editingIndexProperty() {
        return this.editingIndexPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyIntegerWrapper editingIndexPropertyImpl() {
        if (this.editingIndex == null) {
            this.editingIndex = new ReadOnlyIntegerWrapper(this, "editingIndex", -1);
        }
        return this.editingIndex;
    }

    public final void setOnEditStart(EventHandler<ListView$EditEvent<T>> eventHandler) {
        this.onEditStartProperty().set(eventHandler);
    }

    public final EventHandler<ListView$EditEvent<T>> getOnEditStart() {
        if (this.onEditStart == null) {
            return null;
        }
        return (EventHandler)this.onEditStart.get();
    }

    public final ObjectProperty<EventHandler<ListView$EditEvent<T>>> onEditStartProperty() {
        if (this.onEditStart == null) {
            this.onEditStart = new ListView$3(this);
        }
        return this.onEditStart;
    }

    public final void setOnEditCommit(EventHandler<ListView$EditEvent<T>> eventHandler) {
        this.onEditCommitProperty().set(eventHandler);
    }

    public final EventHandler<ListView$EditEvent<T>> getOnEditCommit() {
        if (this.onEditCommit == null) {
            return null;
        }
        return (EventHandler)this.onEditCommit.get();
    }

    public final ObjectProperty<EventHandler<ListView$EditEvent<T>>> onEditCommitProperty() {
        if (this.onEditCommit == null) {
            this.onEditCommit = new ListView$4(this);
        }
        return this.onEditCommit;
    }

    public final void setOnEditCancel(EventHandler<ListView$EditEvent<T>> eventHandler) {
        this.onEditCancelProperty().set(eventHandler);
    }

    public final EventHandler<ListView$EditEvent<T>> getOnEditCancel() {
        if (this.onEditCancel == null) {
            return null;
        }
        return (EventHandler)this.onEditCancel.get();
    }

    public final ObjectProperty<EventHandler<ListView$EditEvent<T>>> onEditCancelProperty() {
        if (this.onEditCancel == null) {
            this.onEditCancel = new ListView$5(this);
        }
        return this.onEditCancel;
    }

    public void edit(int n2) {
        if (!this.isEditable()) {
            return;
        }
        this.setEditingIndex(n2);
    }

    public void scrollTo(int n2) {
        ControlUtils.scrollToIndex(this, n2);
    }

    public void scrollTo(T t2) {
        int n2;
        if (this.getItems() != null && (n2 = this.getItems().indexOf(t2)) >= 0) {
            ControlUtils.scrollToIndex(this, n2);
        }
    }

    public void setOnScrollTo(EventHandler<ScrollToEvent<Integer>> eventHandler) {
        this.onScrollToProperty().set(eventHandler);
    }

    public EventHandler<ScrollToEvent<Integer>> getOnScrollTo() {
        if (this.onScrollTo != null) {
            return (EventHandler)this.onScrollTo.get();
        }
        return null;
    }

    public ObjectProperty<EventHandler<ScrollToEvent<Integer>>> onScrollToProperty() {
        if (this.onScrollTo == null) {
            this.onScrollTo = new ListView$6(this);
        }
        return this.onScrollTo;
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new ListViewSkin(this);
    }

    public void refresh() {
        this.getProperties().put("recreateKey", Boolean.TRUE);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return ListView$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return ListView.getClassCssMetaData();
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute object, Object ... objectArray) {
        switch (ListView$7.$SwitchMap$javafx$scene$AccessibleAttribute[((Enum)object).ordinal()]) {
            case 1: {
                object = this.getSelectionModel();
                return object != null && ((MultipleSelectionModel)object).getSelectionMode() == SelectionMode.MULTIPLE;
            }
        }
        return super.queryAccessibleAttribute((AccessibleAttribute)((Object)object), objectArray);
    }

    static /* synthetic */ void access$000(ListView listView, EventType eventType, EventHandler eventHandler) {
        listView.setEventHandler(eventType, eventHandler);
    }

    static /* synthetic */ void access$100(ListView listView, EventType eventType, EventHandler eventHandler) {
        listView.setEventHandler(eventType, eventHandler);
    }

    static /* synthetic */ void access$200(ListView listView, EventType eventType, EventHandler eventHandler) {
        listView.setEventHandler(eventType, eventHandler);
    }

    static /* synthetic */ void access$300(ListView listView, EventType eventType, EventHandler eventHandler) {
        listView.setEventHandler(eventType, eventHandler);
    }
}

