/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.scene.AccessibleRole;
import javafx.scene.control.Control;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar$1;
import javafx.scene.control.MenuBar$StyleableProperties;
import javafx.scene.control.Skin;
import javafx.scene.control.skin.MenuBarSkin;

@DefaultProperty(value="menus")
public class MenuBar
extends Control {
    private ObservableList<Menu> menus = FXCollections.observableArrayList();
    private String BIND_MSG = "cannot uni-directionally bind to the system menu bar - use bindBidrectional instead";
    private BooleanProperty useSystemMenuBar;
    private static final String DEFAULT_STYLE_CLASS = "menu-bar";

    public MenuBar() {
        this(null);
    }

    public MenuBar(Menu ... menuArray) {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.MENU_BAR);
        if (menuArray != null) {
            this.getMenus().addAll((Menu[])menuArray);
        }
        ((StyleableProperty)((Object)this.focusTraversableProperty())).applyStyle(null, Boolean.FALSE);
    }

    public final BooleanProperty useSystemMenuBarProperty() {
        if (this.useSystemMenuBar == null) {
            this.useSystemMenuBar = new MenuBar$1(this);
        }
        return this.useSystemMenuBar;
    }

    public final void setUseSystemMenuBar(boolean bl2) {
        this.useSystemMenuBarProperty().setValue(bl2);
    }

    public final boolean isUseSystemMenuBar() {
        if (this.useSystemMenuBar == null) {
            return false;
        }
        return this.useSystemMenuBar.getValue();
    }

    public final ObservableList<Menu> getMenus() {
        return this.menus;
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new MenuBarSkin(this);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return MenuBar$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return MenuBar.getClassCssMetaData();
    }

    @Override
    protected Boolean getInitialFocusTraversable() {
        return Boolean.FALSE;
    }
}

