/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.stage.PopupWindowHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.application.Application;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.converter.StringConverter;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.PopupControl$1;
import javafx.scene.control.PopupControl$2;
import javafx.scene.control.PopupControl$3;
import javafx.scene.control.PopupControl$4;
import javafx.scene.control.PopupControl$5;
import javafx.scene.control.PopupControl$6;
import javafx.scene.control.PopupControl$7;
import javafx.scene.control.PopupControl$8;
import javafx.scene.control.PopupControl$9;
import javafx.scene.control.PopupControl$CSSBridge;
import javafx.scene.control.Skin;
import javafx.scene.control.Skinnable;
import javafx.stage.PopupWindow;
import javafx.stage.PopupWindow$AnchorLocation;
import javafx.stage.Window;

public class PopupControl
extends PopupWindow
implements Styleable,
Skinnable {
    public static final double USE_PREF_SIZE = Double.NEGATIVE_INFINITY;
    public static final double USE_COMPUTED_SIZE = -1.0;
    protected PopupControl$CSSBridge bridge;
    private final ObjectProperty<Skin<?>> skin = new PopupControl$1(this);
    private String currentSkinClassName = null;
    private StringProperty skinClassName = null;
    private DoubleProperty minWidth;
    private DoubleProperty minHeight;
    private DoubleProperty prefWidth;
    private DoubleProperty prefHeight;
    private DoubleProperty maxWidth;
    private DoubleProperty maxHeight;
    private double prefWidthCache = -1.0;
    private double prefHeightCache = -1.0;
    private double minWidthCache = -1.0;
    private double minHeightCache = -1.0;
    private double maxWidthCache = -1.0;
    private double maxHeightCache = -1.0;
    private boolean skinSizeComputed = false;
    private static final CssMetaData<PopupControl$CSSBridge, String> SKIN;
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public PopupControl() {
        this.bridge = new PopupControl$CSSBridge(this);
        this.setAnchorLocation(PopupWindow$AnchorLocation.CONTENT_TOP_LEFT);
        PopupWindowHelper.getContent(this).add(this.bridge);
    }

    public final StringProperty idProperty() {
        return this.bridge.idProperty();
    }

    public final void setId(String string) {
        this.idProperty().set(string);
    }

    @Override
    public final String getId() {
        return (String)this.idProperty().get();
    }

    @Override
    public final ObservableList<String> getStyleClass() {
        return this.bridge.getStyleClass();
    }

    public final void setStyle(String string) {
        this.styleProperty().set(string);
    }

    @Override
    public final String getStyle() {
        return (String)this.styleProperty().get();
    }

    public final StringProperty styleProperty() {
        return this.bridge.styleProperty();
    }

    @Override
    public final ObjectProperty<Skin<?>> skinProperty() {
        return this.skin;
    }

    @Override
    public final void setSkin(Skin<?> skin) {
        this.skinProperty().setValue(skin);
    }

    @Override
    public final Skin<?> getSkin() {
        return (Skin)this.skinProperty().getValue();
    }

    private StringProperty skinClassNameProperty() {
        if (this.skinClassName == null) {
            this.skinClassName = new PopupControl$2(this);
        }
        return this.skinClassName;
    }

    private Node getSkinNode() {
        if (this.getSkin() == null) {
            return null;
        }
        return this.getSkin().getNode();
    }

    public final void setMinWidth(double d2) {
        this.minWidthProperty().set(d2);
    }

    public final double getMinWidth() {
        if (this.minWidth == null) {
            return -1.0;
        }
        return this.minWidth.get();
    }

    public final DoubleProperty minWidthProperty() {
        if (this.minWidth == null) {
            this.minWidth = new PopupControl$3(this, -1.0);
        }
        return this.minWidth;
    }

    public final void setMinHeight(double d2) {
        this.minHeightProperty().set(d2);
    }

    public final double getMinHeight() {
        if (this.minHeight == null) {
            return -1.0;
        }
        return this.minHeight.get();
    }

    public final DoubleProperty minHeightProperty() {
        if (this.minHeight == null) {
            this.minHeight = new PopupControl$4(this, -1.0);
        }
        return this.minHeight;
    }

    public void setMinSize(double d2, double d3) {
        this.setMinWidth(d2);
        this.setMinHeight(d3);
    }

    public final void setPrefWidth(double d2) {
        this.prefWidthProperty().set(d2);
    }

    public final double getPrefWidth() {
        if (this.prefWidth == null) {
            return -1.0;
        }
        return this.prefWidth.get();
    }

    public final DoubleProperty prefWidthProperty() {
        if (this.prefWidth == null) {
            this.prefWidth = new PopupControl$5(this, -1.0);
        }
        return this.prefWidth;
    }

    public final void setPrefHeight(double d2) {
        this.prefHeightProperty().set(d2);
    }

    public final double getPrefHeight() {
        if (this.prefHeight == null) {
            return -1.0;
        }
        return this.prefHeight.get();
    }

    public final DoubleProperty prefHeightProperty() {
        if (this.prefHeight == null) {
            this.prefHeight = new PopupControl$6(this, -1.0);
        }
        return this.prefHeight;
    }

    public void setPrefSize(double d2, double d3) {
        this.setPrefWidth(d2);
        this.setPrefHeight(d3);
    }

    public final void setMaxWidth(double d2) {
        this.maxWidthProperty().set(d2);
    }

    public final double getMaxWidth() {
        if (this.maxWidth == null) {
            return -1.0;
        }
        return this.maxWidth.get();
    }

    public final DoubleProperty maxWidthProperty() {
        if (this.maxWidth == null) {
            this.maxWidth = new PopupControl$7(this, -1.0);
        }
        return this.maxWidth;
    }

    public final void setMaxHeight(double d2) {
        this.maxHeightProperty().set(d2);
    }

    public final double getMaxHeight() {
        if (this.maxHeight == null) {
            return -1.0;
        }
        return this.maxHeight.get();
    }

    public final DoubleProperty maxHeightProperty() {
        if (this.maxHeight == null) {
            this.maxHeight = new PopupControl$8(this, -1.0);
        }
        return this.maxHeight;
    }

    public void setMaxSize(double d2, double d3) {
        this.setMaxWidth(d2);
        this.setMaxHeight(d3);
    }

    public final double minWidth(double d2) {
        double d3 = this.getMinWidth();
        if (d3 == -1.0) {
            if (this.minWidthCache == -1.0) {
                this.minWidthCache = this.recalculateMinWidth(d2);
            }
            return this.minWidthCache;
        }
        if (d3 == Double.NEGATIVE_INFINITY) {
            return this.prefWidth(d2);
        }
        return d3;
    }

    public final double minHeight(double d2) {
        double d3 = this.getMinHeight();
        if (d3 == -1.0) {
            if (this.minHeightCache == -1.0) {
                this.minHeightCache = this.recalculateMinHeight(d2);
            }
            return this.minHeightCache;
        }
        if (d3 == Double.NEGATIVE_INFINITY) {
            return this.prefHeight(d2);
        }
        return d3;
    }

    public final double prefWidth(double d2) {
        double d3;
        do {
            if ((d3 = this.getPrefWidth()) != -1.0) continue;
            if (this.prefWidthCache == -1.0) {
                this.prefWidthCache = this.recalculatePrefWidth(d2);
            }
            return this.prefWidthCache;
        } while (d3 == Double.NEGATIVE_INFINITY);
        return d3;
    }

    public final double prefHeight(double d2) {
        double d3;
        do {
            if ((d3 = this.getPrefHeight()) != -1.0) continue;
            if (this.prefHeightCache == -1.0) {
                this.prefHeightCache = this.recalculatePrefHeight(d2);
            }
            return this.prefHeightCache;
        } while (d3 == Double.NEGATIVE_INFINITY);
        return d3;
    }

    public final double maxWidth(double d2) {
        double d3 = this.getMaxWidth();
        if (d3 == -1.0) {
            if (this.maxWidthCache == -1.0) {
                this.maxWidthCache = this.recalculateMaxWidth(d2);
            }
            return this.maxWidthCache;
        }
        if (d3 == Double.NEGATIVE_INFINITY) {
            return this.prefWidth(d2);
        }
        return d3;
    }

    public final double maxHeight(double d2) {
        double d3 = this.getMaxHeight();
        if (d3 == -1.0) {
            if (this.maxHeightCache == -1.0) {
                this.maxHeightCache = this.recalculateMaxHeight(d2);
            }
            return this.maxHeightCache;
        }
        if (d3 == Double.NEGATIVE_INFINITY) {
            return this.prefHeight(d2);
        }
        return d3;
    }

    private double recalculateMinWidth(double d2) {
        this.recomputeSkinSize();
        if (this.getSkinNode() == null) {
            return 0.0;
        }
        return this.getSkinNode().minWidth(d2);
    }

    private double recalculateMinHeight(double d2) {
        this.recomputeSkinSize();
        if (this.getSkinNode() == null) {
            return 0.0;
        }
        return this.getSkinNode().minHeight(d2);
    }

    private double recalculateMaxWidth(double d2) {
        this.recomputeSkinSize();
        if (this.getSkinNode() == null) {
            return 0.0;
        }
        return this.getSkinNode().maxWidth(d2);
    }

    private double recalculateMaxHeight(double d2) {
        this.recomputeSkinSize();
        if (this.getSkinNode() == null) {
            return 0.0;
        }
        return this.getSkinNode().maxHeight(d2);
    }

    private double recalculatePrefWidth(double d2) {
        this.recomputeSkinSize();
        if (this.getSkinNode() == null) {
            return 0.0;
        }
        return this.getSkinNode().prefWidth(d2);
    }

    private double recalculatePrefHeight(double d2) {
        this.recomputeSkinSize();
        if (this.getSkinNode() == null) {
            return 0.0;
        }
        return this.getSkinNode().prefHeight(d2);
    }

    private void recomputeSkinSize() {
        if (!this.skinSizeComputed) {
            this.bridge.applyCss();
            this.skinSizeComputed = true;
        }
    }

    protected Skin<?> createDefaultSkin() {
        return null;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return PopupControl.getClassCssMetaData();
    }

    public final void pseudoClassStateChanged(PseudoClass pseudoClass, boolean bl2) {
        this.bridge.pseudoClassStateChanged(pseudoClass, bl2);
    }

    @Override
    public String getTypeSelector() {
        return "PopupControl";
    }

    @Override
    public Styleable getStyleableParent() {
        EventTarget eventTarget = this.getOwnerNode();
        if (eventTarget != null) {
            return eventTarget;
        }
        eventTarget = this.getOwnerWindow();
        if (eventTarget != null && (eventTarget = ((Window)eventTarget).getScene()) != null) {
            return ((Scene)eventTarget).getRoot();
        }
        return this.bridge.getParent();
    }

    @Override
    public final ObservableSet<PseudoClass> getPseudoClassStates() {
        return FXCollections.emptyObservableSet();
    }

    @Override
    public Node getStyleableNode() {
        return this.bridge;
    }

    static {
        if (Application.getUserAgentStylesheet() == null) {
            PlatformImpl.setDefaultPlatformUserAgentStylesheet();
        }
        SKIN = new PopupControl$9("-fx-skin", StringConverter.getInstance());
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, SKIN);
        STYLEABLES = Collections.unmodifiableList(arrayList);
    }
}

