/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollPane$1;
import javafx.scene.control.ScrollPane$2;
import javafx.scene.control.ScrollPane$3;
import javafx.scene.control.ScrollPane$4;
import javafx.scene.control.ScrollPane$5;
import javafx.scene.control.ScrollPane$ScrollBarPolicy;
import javafx.scene.control.ScrollPane$StyleableProperties;
import javafx.scene.control.Skin;
import javafx.scene.control.skin.ScrollPaneSkin;

@DefaultProperty(value="content")
public class ScrollPane
extends Control {
    private ObjectProperty<ScrollPane$ScrollBarPolicy> hbarPolicy;
    private ObjectProperty<ScrollPane$ScrollBarPolicy> vbarPolicy;
    private ObjectProperty<Node> content;
    private DoubleProperty hvalue;
    private DoubleProperty vvalue;
    private DoubleProperty hmin;
    private DoubleProperty vmin;
    private DoubleProperty hmax;
    private DoubleProperty vmax;
    private BooleanProperty fitToWidth;
    private BooleanProperty fitToHeight;
    private BooleanProperty pannable;
    private DoubleProperty prefViewportWidth;
    private DoubleProperty prefViewportHeight;
    private DoubleProperty minViewportWidth;
    private DoubleProperty minViewportHeight;
    private ObjectProperty<Bounds> viewportBounds;
    private static final String DEFAULT_STYLE_CLASS = "scroll-pane";
    private static final PseudoClass PANNABLE_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("pannable");
    private static final PseudoClass FIT_TO_WIDTH_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("fitToWidth");
    private static final PseudoClass FIT_TO_HEIGHT_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("fitToHeight");

    public ScrollPane() {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.SCROLL_PANE);
        ((StyleableProperty)((Object)this.focusTraversableProperty())).applyStyle(null, Boolean.FALSE);
    }

    public ScrollPane(Node node) {
        this();
        this.setContent(node);
    }

    public final void setHbarPolicy(ScrollPane$ScrollBarPolicy scrollPane$ScrollBarPolicy) {
        this.hbarPolicyProperty().set(scrollPane$ScrollBarPolicy);
    }

    public final ScrollPane$ScrollBarPolicy getHbarPolicy() {
        if (this.hbarPolicy == null) {
            return ScrollPane$ScrollBarPolicy.AS_NEEDED;
        }
        return (ScrollPane$ScrollBarPolicy)((Object)this.hbarPolicy.get());
    }

    public final ObjectProperty<ScrollPane$ScrollBarPolicy> hbarPolicyProperty() {
        if (this.hbarPolicy == null) {
            this.hbarPolicy = new ScrollPane$1(this, ScrollPane$ScrollBarPolicy.AS_NEEDED);
        }
        return this.hbarPolicy;
    }

    public final void setVbarPolicy(ScrollPane$ScrollBarPolicy scrollPane$ScrollBarPolicy) {
        this.vbarPolicyProperty().set(scrollPane$ScrollBarPolicy);
    }

    public final ScrollPane$ScrollBarPolicy getVbarPolicy() {
        if (this.vbarPolicy == null) {
            return ScrollPane$ScrollBarPolicy.AS_NEEDED;
        }
        return (ScrollPane$ScrollBarPolicy)((Object)this.vbarPolicy.get());
    }

    public final ObjectProperty<ScrollPane$ScrollBarPolicy> vbarPolicyProperty() {
        if (this.vbarPolicy == null) {
            this.vbarPolicy = new ScrollPane$2(this, ScrollPane$ScrollBarPolicy.AS_NEEDED);
        }
        return this.vbarPolicy;
    }

    public final void setContent(Node node) {
        this.contentProperty().set(node);
    }

    public final Node getContent() {
        if (this.content == null) {
            return null;
        }
        return (Node)this.content.get();
    }

    public final ObjectProperty<Node> contentProperty() {
        if (this.content == null) {
            this.content = new SimpleObjectProperty<Node>(this, "content");
        }
        return this.content;
    }

    public final void setHvalue(double d2) {
        this.hvalueProperty().set(d2);
    }

    public final double getHvalue() {
        if (this.hvalue == null) {
            return 0.0;
        }
        return this.hvalue.get();
    }

    public final DoubleProperty hvalueProperty() {
        if (this.hvalue == null) {
            this.hvalue = new SimpleDoubleProperty(this, "hvalue");
        }
        return this.hvalue;
    }

    public final void setVvalue(double d2) {
        this.vvalueProperty().set(d2);
    }

    public final double getVvalue() {
        if (this.vvalue == null) {
            return 0.0;
        }
        return this.vvalue.get();
    }

    public final DoubleProperty vvalueProperty() {
        if (this.vvalue == null) {
            this.vvalue = new SimpleDoubleProperty(this, "vvalue");
        }
        return this.vvalue;
    }

    public final void setHmin(double d2) {
        this.hminProperty().set(d2);
    }

    public final double getHmin() {
        if (this.hmin == null) {
            return 0.0;
        }
        return this.hmin.get();
    }

    public final DoubleProperty hminProperty() {
        if (this.hmin == null) {
            this.hmin = new SimpleDoubleProperty(this, "hmin", 0.0);
        }
        return this.hmin;
    }

    public final void setVmin(double d2) {
        this.vminProperty().set(d2);
    }

    public final double getVmin() {
        if (this.vmin == null) {
            return 0.0;
        }
        return this.vmin.get();
    }

    public final DoubleProperty vminProperty() {
        if (this.vmin == null) {
            this.vmin = new SimpleDoubleProperty(this, "vmin", 0.0);
        }
        return this.vmin;
    }

    public final void setHmax(double d2) {
        this.hmaxProperty().set(d2);
    }

    public final double getHmax() {
        if (this.hmax == null) {
            return 1.0;
        }
        return this.hmax.get();
    }

    public final DoubleProperty hmaxProperty() {
        if (this.hmax == null) {
            this.hmax = new SimpleDoubleProperty(this, "hmax", 1.0);
        }
        return this.hmax;
    }

    public final void setVmax(double d2) {
        this.vmaxProperty().set(d2);
    }

    public final double getVmax() {
        if (this.vmax == null) {
            return 1.0;
        }
        return this.vmax.get();
    }

    public final DoubleProperty vmaxProperty() {
        if (this.vmax == null) {
            this.vmax = new SimpleDoubleProperty(this, "vmax", 1.0);
        }
        return this.vmax;
    }

    public final void setFitToWidth(boolean bl2) {
        this.fitToWidthProperty().set(bl2);
    }

    public final boolean isFitToWidth() {
        if (this.fitToWidth == null) {
            return false;
        }
        return this.fitToWidth.get();
    }

    public final BooleanProperty fitToWidthProperty() {
        if (this.fitToWidth == null) {
            this.fitToWidth = new ScrollPane$3(this, false);
        }
        return this.fitToWidth;
    }

    public final void setFitToHeight(boolean bl2) {
        this.fitToHeightProperty().set(bl2);
    }

    public final boolean isFitToHeight() {
        if (this.fitToHeight == null) {
            return false;
        }
        return this.fitToHeight.get();
    }

    public final BooleanProperty fitToHeightProperty() {
        if (this.fitToHeight == null) {
            this.fitToHeight = new ScrollPane$4(this, false);
        }
        return this.fitToHeight;
    }

    public final void setPannable(boolean bl2) {
        this.pannableProperty().set(bl2);
    }

    public final boolean isPannable() {
        if (this.pannable == null) {
            return false;
        }
        return this.pannable.get();
    }

    public final BooleanProperty pannableProperty() {
        if (this.pannable == null) {
            this.pannable = new ScrollPane$5(this, false);
        }
        return this.pannable;
    }

    public final void setPrefViewportWidth(double d2) {
        this.prefViewportWidthProperty().set(d2);
    }

    public final double getPrefViewportWidth() {
        if (this.prefViewportWidth == null) {
            return 0.0;
        }
        return this.prefViewportWidth.get();
    }

    public final DoubleProperty prefViewportWidthProperty() {
        if (this.prefViewportWidth == null) {
            this.prefViewportWidth = new SimpleDoubleProperty(this, "prefViewportWidth");
        }
        return this.prefViewportWidth;
    }

    public final void setPrefViewportHeight(double d2) {
        this.prefViewportHeightProperty().set(d2);
    }

    public final double getPrefViewportHeight() {
        if (this.prefViewportHeight == null) {
            return 0.0;
        }
        return this.prefViewportHeight.get();
    }

    public final DoubleProperty prefViewportHeightProperty() {
        if (this.prefViewportHeight == null) {
            this.prefViewportHeight = new SimpleDoubleProperty(this, "prefViewportHeight");
        }
        return this.prefViewportHeight;
    }

    public final void setMinViewportWidth(double d2) {
        this.minViewportWidthProperty().set(d2);
    }

    public final double getMinViewportWidth() {
        if (this.minViewportWidth == null) {
            return 0.0;
        }
        return this.minViewportWidth.get();
    }

    public final DoubleProperty minViewportWidthProperty() {
        if (this.minViewportWidth == null) {
            this.minViewportWidth = new SimpleDoubleProperty(this, "minViewportWidth");
        }
        return this.minViewportWidth;
    }

    public final void setMinViewportHeight(double d2) {
        this.minViewportHeightProperty().set(d2);
    }

    public final double getMinViewportHeight() {
        if (this.minViewportHeight == null) {
            return 0.0;
        }
        return this.minViewportHeight.get();
    }

    public final DoubleProperty minViewportHeightProperty() {
        if (this.minViewportHeight == null) {
            this.minViewportHeight = new SimpleDoubleProperty(this, "minViewportHeight");
        }
        return this.minViewportHeight;
    }

    public final void setViewportBounds(Bounds bounds) {
        this.viewportBoundsProperty().set(bounds);
    }

    public final Bounds getViewportBounds() {
        if (this.viewportBounds == null) {
            return new BoundingBox(0.0, 0.0, 0.0, 0.0);
        }
        return (Bounds)this.viewportBounds.get();
    }

    public final ObjectProperty<Bounds> viewportBoundsProperty() {
        if (this.viewportBounds == null) {
            this.viewportBounds = new SimpleObjectProperty<BoundingBox>(this, "viewportBounds", new BoundingBox(0.0, 0.0, 0.0, 0.0));
        }
        return this.viewportBounds;
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new ScrollPaneSkin(this);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return ScrollPane$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return ScrollPane.getClassCssMetaData();
    }

    @Override
    protected Boolean getInitialFocusTraversable() {
        return Boolean.FALSE;
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case CONTENTS: {
                return this.getContent();
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }
}

