/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.geometry.VPos;
import javafx.scene.control.Control;
import javafx.scene.control.Separator$1;
import javafx.scene.control.Separator$2;
import javafx.scene.control.Separator$3;
import javafx.scene.control.Separator$StyleableProperties;
import javafx.scene.control.Skin;
import javafx.scene.control.skin.SeparatorSkin;

public class Separator
extends Control {
    private ObjectProperty<Orientation> orientation = new Separator$1(this, Orientation.HORIZONTAL);
    private ObjectProperty<HPos> halignment;
    private ObjectProperty<VPos> valignment;
    private static final String DEFAULT_STYLE_CLASS = "separator";
    private static final PseudoClass VERTICAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("vertical");
    private static final PseudoClass HORIZONTAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("horizontal");

    public Separator() {
        this(Orientation.HORIZONTAL);
    }

    public Separator(Orientation orientation) {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        ((StyleableProperty)((Object)this.focusTraversableProperty())).applyStyle(null, Boolean.FALSE);
        this.pseudoClassStateChanged(HORIZONTAL_PSEUDOCLASS_STATE, orientation != Orientation.VERTICAL);
        this.pseudoClassStateChanged(VERTICAL_PSEUDOCLASS_STATE, orientation == Orientation.VERTICAL);
        ((StyleableProperty)((Object)this.orientationProperty())).applyStyle(null, orientation != null ? orientation : Orientation.HORIZONTAL);
    }

    public final void setOrientation(Orientation orientation) {
        this.orientation.set(orientation);
    }

    public final Orientation getOrientation() {
        return (Orientation)((Object)this.orientation.get());
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        return this.orientation;
    }

    public final void setHalignment(HPos hPos) {
        this.halignmentProperty().set(hPos);
    }

    public final HPos getHalignment() {
        if (this.halignment == null) {
            return HPos.CENTER;
        }
        return (HPos)((Object)this.halignment.get());
    }

    public final ObjectProperty<HPos> halignmentProperty() {
        if (this.halignment == null) {
            this.halignment = new Separator$2(this, HPos.CENTER);
        }
        return this.halignment;
    }

    public final void setValignment(VPos vPos) {
        this.valignmentProperty().set(vPos);
    }

    public final VPos getValignment() {
        if (this.valignment == null) {
            return VPos.CENTER;
        }
        return (VPos)((Object)this.valignment.get());
    }

    public final ObjectProperty<VPos> valignmentProperty() {
        if (this.valignment == null) {
            this.valignment = new Separator$3(this, VPos.CENTER);
        }
        return this.valignment;
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new SeparatorSkin(this);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return Separator$StyleableProperties.STYLEABLES;
    }

    @Override
    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return Separator.getClassCssMetaData();
    }

    @Override
    protected Boolean getInitialFocusTraversable() {
        return Boolean.FALSE;
    }
}

