/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.time.Duration;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import javafx.beans.NamedArg;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.SpinnerValueFactory$LocalTimeSpinnerValueFactory$1;
import javafx.scene.control.SpinnerValueFactory$LocalTimeSpinnerValueFactory$2;
import javafx.scene.control.SpinnerValueFactory$LocalTimeSpinnerValueFactory$3;

class SpinnerValueFactory$LocalTimeSpinnerValueFactory
extends SpinnerValueFactory<LocalTime> {
    private ObjectProperty<LocalTime> min;
    private ObjectProperty<LocalTime> max;
    private ObjectProperty<TemporalUnit> temporalUnit;
    private LongProperty amountToStepBy;

    public SpinnerValueFactory$LocalTimeSpinnerValueFactory() {
        this(LocalTime.now());
    }

    public SpinnerValueFactory$LocalTimeSpinnerValueFactory(@NamedArg(value="initialValue") LocalTime localTime) {
        this(LocalTime.MIN, LocalTime.MAX, localTime);
    }

    public SpinnerValueFactory$LocalTimeSpinnerValueFactory(@NamedArg(value="min") LocalTime localTime, @NamedArg(value="min") LocalTime localTime2, @NamedArg(value="initialValue") LocalTime localTime3) {
        this(localTime, localTime2, localTime3, 1L, ChronoUnit.HOURS);
    }

    public SpinnerValueFactory$LocalTimeSpinnerValueFactory(@NamedArg(value="min") LocalTime localTime3, @NamedArg(value="min") LocalTime localTime4, @NamedArg(value="initialValue") LocalTime localTime5, @NamedArg(value="amountToStepBy") long l2, @NamedArg(value="temporalUnit") TemporalUnit temporalUnit) {
        SpinnerValueFactory$LocalTimeSpinnerValueFactory spinnerValueFactory$LocalTimeSpinnerValueFactory = this;
        this.min = new SpinnerValueFactory$LocalTimeSpinnerValueFactory$2(spinnerValueFactory$LocalTimeSpinnerValueFactory, spinnerValueFactory$LocalTimeSpinnerValueFactory, "min");
        SpinnerValueFactory$LocalTimeSpinnerValueFactory spinnerValueFactory$LocalTimeSpinnerValueFactory2 = this;
        this.max = new SpinnerValueFactory$LocalTimeSpinnerValueFactory$3(spinnerValueFactory$LocalTimeSpinnerValueFactory2, spinnerValueFactory$LocalTimeSpinnerValueFactory2, "max");
        this.temporalUnit = new SimpleObjectProperty<TemporalUnit>(this, "temporalUnit");
        this.amountToStepBy = new SimpleLongProperty(this, "amountToStepBy");
        this.setMin(localTime3);
        this.setMax(localTime4);
        this.setAmountToStepBy(l2);
        this.setTemporalUnit(temporalUnit);
        this.setConverter(new SpinnerValueFactory$LocalTimeSpinnerValueFactory$1(this));
        this.valueProperty().addListener((observableValue, localTime, localTime2) -> {
            if (localTime2 == null) {
                return;
            }
            if (this.getMin() != null && localTime2.isBefore(this.getMin())) {
                SpinnerValueFactory$LocalTimeSpinnerValueFactory spinnerValueFactory$LocalTimeSpinnerValueFactory = this;
                spinnerValueFactory$LocalTimeSpinnerValueFactory.setValue(spinnerValueFactory$LocalTimeSpinnerValueFactory.getMin());
                return;
            }
            if (this.getMax() != null && localTime2.isAfter(this.getMax())) {
                SpinnerValueFactory$LocalTimeSpinnerValueFactory spinnerValueFactory$LocalTimeSpinnerValueFactory = this;
                spinnerValueFactory$LocalTimeSpinnerValueFactory.setValue(spinnerValueFactory$LocalTimeSpinnerValueFactory.getMax());
            }
        });
        this.setValue(localTime5 != null ? localTime5 : LocalTime.now());
    }

    public final void setMin(LocalTime localTime) {
        this.min.set(localTime);
    }

    public final LocalTime getMin() {
        return (LocalTime)this.min.get();
    }

    public final ObjectProperty<LocalTime> minProperty() {
        return this.min;
    }

    public final void setMax(LocalTime localTime) {
        this.max.set(localTime);
    }

    public final LocalTime getMax() {
        return (LocalTime)this.max.get();
    }

    public final ObjectProperty<LocalTime> maxProperty() {
        return this.max;
    }

    public final void setTemporalUnit(TemporalUnit temporalUnit) {
        this.temporalUnit.set(temporalUnit);
    }

    public final TemporalUnit getTemporalUnit() {
        return (TemporalUnit)this.temporalUnit.get();
    }

    public final ObjectProperty<TemporalUnit> temporalUnitProperty() {
        return this.temporalUnit;
    }

    public final void setAmountToStepBy(long l2) {
        this.amountToStepBy.set(l2);
    }

    public final long getAmountToStepBy() {
        return this.amountToStepBy.get();
    }

    public final LongProperty amountToStepByProperty() {
        return this.amountToStepBy;
    }

    @Override
    public void decrement(int n2) {
        LocalTime localTime = (LocalTime)this.getValue();
        LocalTime localTime2 = this.getMin();
        Duration duration = Duration.of(this.getAmountToStepBy() * (long)n2, this.getTemporalUnit());
        long l2 = duration.toMinutes() * 60L;
        long l3 = localTime.toSecondOfDay();
        if (!this.isWrapAround() && l2 > l3) {
            this.setValue(localTime2 == null ? LocalTime.MIN : localTime2);
            return;
        }
        this.setValue(localTime.minus(duration));
    }

    @Override
    public void increment(int n2) {
        LocalTime localTime = (LocalTime)this.getValue();
        LocalTime localTime2 = this.getMax();
        Duration duration = Duration.of(this.getAmountToStepBy() * (long)n2, this.getTemporalUnit());
        long l2 = duration.toMinutes() * 60L;
        long l3 = localTime.toSecondOfDay();
        if (!this.isWrapAround() && l2 > (long)LocalTime.MAX.toSecondOfDay() - l3) {
            this.setValue(localTime2 == null ? LocalTime.MAX : localTime2);
            return;
        }
        this.setValue(localTime.plus(duration));
    }
}

