/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.util.List;
import java.util.WeakHashMap;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SplitPane$1;
import javafx.scene.control.SplitPane$2;
import javafx.scene.control.SplitPane$Divider;
import javafx.scene.control.SplitPane$StyleableProperties;
import javafx.scene.control.skin.SplitPaneSkin;

@DefaultProperty(value="items")
public class SplitPane
extends Control {
    private static final String RESIZABLE_WITH_PARENT = "resizable-with-parent";
    private ObjectProperty<Orientation> orientation;
    private final ObservableList<Node> items = FXCollections.observableArrayList();
    private final ObservableList<SplitPane$Divider> dividers = FXCollections.observableArrayList();
    private final ObservableList<SplitPane$Divider> unmodifiableDividers = FXCollections.unmodifiableObservableList(this.dividers);
    private final WeakHashMap<Integer, Double> dividerCache = new WeakHashMap();
    private static final String DEFAULT_STYLE_CLASS = "split-pane";
    private static final PseudoClass VERTICAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("vertical");
    private static final PseudoClass HORIZONTAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("horizontal");

    public static void setResizableWithParent(Node node, Boolean bl2) {
        if (bl2 == null) {
            node.getProperties().remove(RESIZABLE_WITH_PARENT);
            return;
        }
        node.getProperties().put(RESIZABLE_WITH_PARENT, bl2);
    }

    public static Boolean isResizableWithParent(Node node) {
        if (node.hasProperties() && (node = node.getProperties().get(RESIZABLE_WITH_PARENT)) != null) {
            return (Boolean)((Object)node);
        }
        return Boolean.TRUE;
    }

    public SplitPane() {
        this(null);
    }

    public SplitPane(Node ... nodeArray) {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        ((StyleableProperty)((Object)this.focusTraversableProperty())).applyStyle(null, Boolean.FALSE);
        this.getItems().addListener(new SplitPane$1(this));
        if (nodeArray != null) {
            this.getItems().addAll((Node[])nodeArray);
        }
        this.pseudoClassStateChanged(HORIZONTAL_PSEUDOCLASS_STATE, true);
    }

    public final void setOrientation(Orientation orientation) {
        this.orientationProperty().set(orientation);
    }

    public final Orientation getOrientation() {
        if (this.orientation == null) {
            return Orientation.HORIZONTAL;
        }
        return (Orientation)((Object)this.orientation.get());
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        if (this.orientation == null) {
            this.orientation = new SplitPane$2(this, Orientation.HORIZONTAL);
        }
        return this.orientation;
    }

    public ObservableList<Node> getItems() {
        return this.items;
    }

    public ObservableList<SplitPane$Divider> getDividers() {
        return this.unmodifiableDividers;
    }

    public void setDividerPosition(int n2, double d2) {
        if (this.getDividers().size() <= n2) {
            this.dividerCache.put(n2, d2);
            return;
        }
        if (n2 >= 0) {
            ((SplitPane$Divider)this.getDividers().get(n2)).setPosition(d2);
        }
    }

    public void setDividerPositions(double ... dArray) {
        if (this.dividers.isEmpty()) {
            for (int i2 = 0; i2 < dArray.length; ++i2) {
                this.dividerCache.put(i2, dArray[i2]);
            }
            return;
        }
        for (int i3 = 0; i3 < dArray.length && i3 < this.dividers.size(); ++i3) {
            ((SplitPane$Divider)this.dividers.get(i3)).setPosition(dArray[i3]);
        }
    }

    public double[] getDividerPositions() {
        double[] dArray = new double[this.dividers.size()];
        for (int i2 = 0; i2 < this.dividers.size(); ++i2) {
            dArray[i2] = ((SplitPane$Divider)this.dividers.get(i2)).getPosition();
        }
        return dArray;
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new SplitPaneSkin(this);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return SplitPane$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return SplitPane.getClassCssMetaData();
    }

    @Override
    protected Boolean getInitialFocusTraversable() {
        return Boolean.FALSE;
    }
}

