/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.beans.IDProperty;
import com.sun.javafx.event.EventHandlerManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Tab$1;
import javafx.scene.control.Tab$2;
import javafx.scene.control.Tab$3;
import javafx.scene.control.Tab$4;
import javafx.scene.control.Tab$5;
import javafx.scene.control.Tab$6;
import javafx.scene.control.Tab$7;
import javafx.scene.control.Tab$8;
import javafx.scene.control.Tab$9;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;

@DefaultProperty(value="content")
@IDProperty(value="id")
public class Tab
implements Styleable,
EventTarget {
    private StringProperty id;
    private StringProperty style;
    private ReadOnlyBooleanWrapper selected;
    private ReadOnlyObjectWrapper<TabPane> tabPane;
    private final InvalidationListener parentDisabledChangedListener = observable -> this.updateDisabled();
    private StringProperty text;
    private ObjectProperty<Node> graphic;
    private ObjectProperty<Node> content;
    private ObjectProperty<ContextMenu> contextMenu;
    private BooleanProperty closable;
    public static final EventType<Event> SELECTION_CHANGED_EVENT = new EventType<Event>(Event.ANY, "SELECTION_CHANGED_EVENT");
    private ObjectProperty<EventHandler<Event>> onSelectionChanged;
    public static final EventType<Event> CLOSED_EVENT = new EventType<Event>(Event.ANY, "TAB_CLOSED");
    private ObjectProperty<EventHandler<Event>> onClosed;
    private ObjectProperty<Tooltip> tooltip;
    private final ObservableList<String> styleClass = FXCollections.observableArrayList();
    private BooleanProperty disable;
    private ReadOnlyBooleanWrapper disabled;
    public static final EventType<Event> TAB_CLOSE_REQUEST_EVENT = new EventType<Event>(Event.ANY, "TAB_CLOSE_REQUEST_EVENT");
    private ObjectProperty<EventHandler<Event>> onCloseRequest;
    private static final Object USER_DATA_KEY = new Object();
    private ObservableMap<Object, Object> properties;
    private final EventHandlerManager eventHandlerManager = new EventHandlerManager(this);
    private static final String DEFAULT_STYLE_CLASS = "tab";

    public Tab() {
        this(null);
    }

    public Tab(String string) {
        this(string, null);
    }

    public Tab(String string, Node node) {
        this.setText(string);
        this.setContent(node);
        this.styleClass.addAll((String[])new String[]{DEFAULT_STYLE_CLASS});
    }

    public final void setId(String string) {
        this.idProperty().set(string);
    }

    @Override
    public final String getId() {
        if (this.id == null) {
            return null;
        }
        return (String)this.id.get();
    }

    public final StringProperty idProperty() {
        if (this.id == null) {
            this.id = new SimpleStringProperty(this, "id");
        }
        return this.id;
    }

    public final void setStyle(String string) {
        this.styleProperty().set(string);
    }

    @Override
    public final String getStyle() {
        if (this.style == null) {
            return null;
        }
        return (String)this.style.get();
    }

    public final StringProperty styleProperty() {
        if (this.style == null) {
            this.style = new SimpleStringProperty(this, "style");
        }
        return this.style;
    }

    final void setSelected(boolean bl2) {
        this.selectedPropertyImpl().set(bl2);
    }

    public final boolean isSelected() {
        if (this.selected == null) {
            return false;
        }
        return this.selected.get();
    }

    public final ReadOnlyBooleanProperty selectedProperty() {
        return this.selectedPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper selectedPropertyImpl() {
        if (this.selected == null) {
            this.selected = new Tab$1(this);
        }
        return this.selected;
    }

    final void setTabPane(TabPane tabPane) {
        this.tabPanePropertyImpl().set(tabPane);
    }

    public final TabPane getTabPane() {
        if (this.tabPane == null) {
            return null;
        }
        return (TabPane)this.tabPane.get();
    }

    public final ReadOnlyObjectProperty<TabPane> tabPaneProperty() {
        return this.tabPanePropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<TabPane> tabPanePropertyImpl() {
        if (this.tabPane == null) {
            Tab tab = this;
            this.tabPane = new Tab$2(tab, tab, "tabPane");
        }
        return this.tabPane;
    }

    public final void setText(String string) {
        this.textProperty().set(string);
    }

    public final String getText() {
        if (this.text == null) {
            return null;
        }
        return (String)this.text.get();
    }

    public final StringProperty textProperty() {
        if (this.text == null) {
            this.text = new SimpleStringProperty(this, "text");
        }
        return this.text;
    }

    public final void setGraphic(Node node) {
        this.graphicProperty().set(node);
    }

    public final Node getGraphic() {
        if (this.graphic == null) {
            return null;
        }
        return (Node)this.graphic.get();
    }

    public final ObjectProperty<Node> graphicProperty() {
        if (this.graphic == null) {
            this.graphic = new SimpleObjectProperty<Node>(this, "graphic");
        }
        return this.graphic;
    }

    public final void setContent(Node node) {
        this.contentProperty().set(node);
    }

    public final Node getContent() {
        if (this.content == null) {
            return null;
        }
        return (Node)this.content.get();
    }

    public final ObjectProperty<Node> contentProperty() {
        if (this.content == null) {
            Tab tab = this;
            this.content = new Tab$3(tab, tab, "content");
        }
        return this.content;
    }

    public final void setContextMenu(ContextMenu contextMenu) {
        this.contextMenuProperty().set(contextMenu);
    }

    public final ContextMenu getContextMenu() {
        if (this.contextMenu == null) {
            return null;
        }
        return (ContextMenu)this.contextMenu.get();
    }

    public final ObjectProperty<ContextMenu> contextMenuProperty() {
        if (this.contextMenu == null) {
            Tab tab = this;
            this.contextMenu = new Tab$4(tab, tab, "contextMenu");
        }
        return this.contextMenu;
    }

    public final void setClosable(boolean bl2) {
        this.closableProperty().set(bl2);
    }

    public final boolean isClosable() {
        if (this.closable == null) {
            return true;
        }
        return this.closable.get();
    }

    public final BooleanProperty closableProperty() {
        if (this.closable == null) {
            this.closable = new SimpleBooleanProperty(this, "closable", true);
        }
        return this.closable;
    }

    public final void setOnSelectionChanged(EventHandler<Event> eventHandler) {
        this.onSelectionChangedProperty().set(eventHandler);
    }

    public final EventHandler<Event> getOnSelectionChanged() {
        if (this.onSelectionChanged == null) {
            return null;
        }
        return (EventHandler)this.onSelectionChanged.get();
    }

    public final ObjectProperty<EventHandler<Event>> onSelectionChangedProperty() {
        if (this.onSelectionChanged == null) {
            this.onSelectionChanged = new Tab$5(this);
        }
        return this.onSelectionChanged;
    }

    public final void setOnClosed(EventHandler<Event> eventHandler) {
        this.onClosedProperty().set(eventHandler);
    }

    public final EventHandler<Event> getOnClosed() {
        if (this.onClosed == null) {
            return null;
        }
        return (EventHandler)this.onClosed.get();
    }

    public final ObjectProperty<EventHandler<Event>> onClosedProperty() {
        if (this.onClosed == null) {
            this.onClosed = new Tab$6(this);
        }
        return this.onClosed;
    }

    public final void setTooltip(Tooltip tooltip) {
        this.tooltipProperty().setValue(tooltip);
    }

    public final Tooltip getTooltip() {
        if (this.tooltip == null) {
            return null;
        }
        return (Tooltip)this.tooltip.getValue();
    }

    public final ObjectProperty<Tooltip> tooltipProperty() {
        if (this.tooltip == null) {
            this.tooltip = new SimpleObjectProperty<Tooltip>(this, "tooltip");
        }
        return this.tooltip;
    }

    public final void setDisable(boolean bl2) {
        this.disableProperty().set(bl2);
    }

    public final boolean isDisable() {
        if (this.disable == null) {
            return false;
        }
        return this.disable.get();
    }

    public final BooleanProperty disableProperty() {
        if (this.disable == null) {
            this.disable = new Tab$7(this, false);
        }
        return this.disable;
    }

    private final void setDisabled(boolean bl2) {
        this.disabledPropertyImpl().set(bl2);
    }

    public final boolean isDisabled() {
        if (this.disabled == null) {
            return false;
        }
        return this.disabled.get();
    }

    public final ReadOnlyBooleanProperty disabledProperty() {
        return this.disabledPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper disabledPropertyImpl() {
        if (this.disabled == null) {
            this.disabled = new Tab$8(this);
        }
        return this.disabled;
    }

    private void updateDisabled() {
        boolean bl2 = this.isDisable() || this.getTabPane() != null && this.getTabPane().isDisabled();
        this.setDisabled(bl2);
        Node node = this.getContent();
        if (node != null) {
            node.setDisable(bl2);
        }
    }

    public final ObjectProperty<EventHandler<Event>> onCloseRequestProperty() {
        if (this.onCloseRequest == null) {
            this.onCloseRequest = new Tab$9(this);
        }
        return this.onCloseRequest;
    }

    public EventHandler<Event> getOnCloseRequest() {
        if (this.onCloseRequest == null) {
            return null;
        }
        return (EventHandler)this.onCloseRequest.get();
    }

    public void setOnCloseRequest(EventHandler<Event> eventHandler) {
        this.onCloseRequestProperty().set(eventHandler);
    }

    public final ObservableMap<Object, Object> getProperties() {
        if (this.properties == null) {
            this.properties = FXCollections.observableMap(new HashMap());
        }
        return this.properties;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public void setUserData(Object object) {
        this.getProperties().put(USER_DATA_KEY, object);
    }

    public Object getUserData() {
        return this.getProperties().get(USER_DATA_KEY);
    }

    @Override
    public ObservableList<String> getStyleClass() {
        return this.styleClass;
    }

    @Override
    public EventDispatchChain buildEventDispatchChain(EventDispatchChain eventDispatchChain) {
        return eventDispatchChain.prepend(this.eventHandlerManager);
    }

    @Override
    public final <E extends Event> void addEventHandler(EventType<E> eventType, EventHandler<? super E> eventHandler) {
        this.eventHandlerManager.addEventHandler(eventType, eventHandler);
    }

    @Override
    public final <E extends Event> void removeEventHandler(EventType<E> eventType, EventHandler<? super E> eventHandler) {
        this.eventHandlerManager.removeEventHandler(eventType, eventHandler);
    }

    @Override
    public final <E extends Event> void addEventFilter(EventType<E> eventType, EventHandler<? super E> eventHandler) {
        this.eventHandlerManager.addEventFilter(eventType, eventHandler);
    }

    @Override
    public final <E extends Event> void removeEventFilter(EventType<E> eventType, EventHandler<? super E> eventHandler) {
        this.eventHandlerManager.removeEventFilter(eventType, eventHandler);
    }

    <E extends Event> void setEventHandler(EventType<E> eventType, EventHandler<E> eventHandler) {
        this.eventHandlerManager.setEventHandler(eventType, eventHandler);
    }

    Node lookup(String string) {
        if (string == null) {
            return null;
        }
        Node node = null;
        if (this.getContent() != null) {
            node = this.getContent().lookup(string);
        }
        if (node == null && this.getGraphic() != null) {
            node = this.getGraphic().lookup(string);
        }
        return node;
    }

    List<Node> lookupAll(String string) {
        Set<Node> set;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (this.getContent() != null && !(set = this.getContent().lookupAll(string)).isEmpty()) {
            arrayList.addAll(set);
        }
        if (this.getGraphic() != null && !(set = this.getGraphic().lookupAll(string)).isEmpty()) {
            arrayList.addAll(set);
        }
        return arrayList;
    }

    @Override
    public String getTypeSelector() {
        return "Tab";
    }

    @Override
    public Styleable getStyleableParent() {
        return this.getTabPane();
    }

    @Override
    public final ObservableSet<PseudoClass> getPseudoClassStates() {
        return FXCollections.emptyObservableSet();
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return Tab.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return Collections.emptyList();
    }
}

