/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.scene.AccessibleAttribute;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;

class TabPane$TabPaneSelectionModel
extends SingleSelectionModel<Tab> {
    private final TabPane tabPane;
    private ListChangeListener<Tab> itemsContentObserver;

    public TabPane$TabPaneSelectionModel(TabPane tabPane) {
        if (tabPane == null) {
            throw new NullPointerException("TabPane can not be null");
        }
        this.tabPane = tabPane;
        this.itemsContentObserver = listChangeListener$Change -> {
            while (listChangeListener$Change.next()) {
                for (Tab tab : listChangeListener$Change.getRemoved()) {
                    if (tab == null || this.tabPane.getTabs().contains(tab) || !tab.isSelected()) continue;
                    tab.setSelected(false);
                    int n2 = listChangeListener$Change.getFrom();
                    this.findNearestAvailableTab(n2, true);
                }
                if (!listChangeListener$Change.wasAdded() && !listChangeListener$Change.wasRemoved() || this.getSelectedIndex() == this.tabPane.getTabs().indexOf(this.getSelectedItem())) continue;
                TabPane$TabPaneSelectionModel tabPane$TabPaneSelectionModel = this;
                ((SelectionModel)tabPane$TabPaneSelectionModel).clearAndSelect(tabPane$TabPaneSelectionModel.tabPane.getTabs().indexOf(this.getSelectedItem()));
            }
            if (this.getSelectedIndex() == -1 && this.getSelectedItem() == null && this.tabPane.getTabs().size() > 0) {
                this.findNearestAvailableTab(0, true);
                return;
            }
            if (this.tabPane.getTabs().isEmpty()) {
                ((SelectionModel)this).clearSelection();
            }
        };
        if (this.tabPane.getTabs() != null) {
            this.tabPane.getTabs().addListener(new WeakListChangeListener<Tab>(this.itemsContentObserver));
        }
    }

    @Override
    public void select(int n2) {
        if (n2 < 0 || this.getItemCount() > 0 && n2 >= this.getItemCount() || n2 == this.getSelectedIndex() && this.getModelItem(n2).isSelected()) {
            return;
        }
        if (this.getSelectedIndex() >= 0 && this.getSelectedIndex() < this.tabPane.getTabs().size()) {
            ((Tab)this.tabPane.getTabs().get(this.getSelectedIndex())).setSelected(false);
        }
        this.setSelectedIndex(n2);
        Tab tab = this.getModelItem(n2);
        if (tab != null) {
            this.setSelectedItem(tab);
        }
        if (this.getSelectedIndex() >= 0 && this.getSelectedIndex() < this.tabPane.getTabs().size()) {
            ((Tab)this.tabPane.getTabs().get(this.getSelectedIndex())).setSelected(true);
        }
        this.tabPane.notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUS_ITEM);
    }

    @Override
    public void select(Tab tab) {
        int n2 = this.getItemCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Tab tab2 = this.getModelItem(i2);
            if (tab2 == null || !tab2.equals(tab)) continue;
            ((SelectionModel)this).select(i2);
            return;
        }
    }

    @Override
    protected Tab getModelItem(int n2) {
        ObservableList<Tab> observableList = this.tabPane.getTabs();
        if (observableList == null) {
            return null;
        }
        if (n2 < 0 || n2 >= observableList.size()) {
            return null;
        }
        return (Tab)observableList.get(n2);
    }

    @Override
    protected int getItemCount() {
        ObservableList<Tab> observableList = this.tabPane.getTabs();
        if (observableList == null) {
            return 0;
        }
        return observableList.size();
    }

    private Tab findNearestAvailableTab(int n2, boolean bl2) {
        int n3 = this.getItemCount();
        int n4 = 1;
        Tab tab = null;
        while (true) {
            Tab tab2;
            Tab tab3;
            int n5;
            if ((n5 = n2 - n4) >= 0 && (tab3 = this.getModelItem(n5)) != null && !tab3.isDisable()) {
                tab = tab3;
                break;
            }
            int n6 = n2 + n4 - 1;
            if (n6 < n3 && (tab2 = this.getModelItem(n6)) != null && !tab2.isDisable()) {
                tab = tab2;
                break;
            }
            if (n5 < 0 && n6 >= n3) break;
            ++n4;
        }
        if (bl2 && tab != null) {
            this.select(tab);
        }
        return tab;
    }
}

