/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.collections.UnmodifiableListSet;
import com.sun.javafx.scene.control.TabObservableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.geometry.Side;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Skin;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane$1;
import javafx.scene.control.TabPane$2;
import javafx.scene.control.TabPane$3;
import javafx.scene.control.TabPane$4;
import javafx.scene.control.TabPane$5;
import javafx.scene.control.TabPane$StyleableProperties;
import javafx.scene.control.TabPane$TabClosingPolicy;
import javafx.scene.control.TabPane$TabDragPolicy;
import javafx.scene.control.TabPane$TabPaneSelectionModel;
import javafx.scene.control.skin.TabPaneSkin;

@DefaultProperty(value="tabs")
public class TabPane
extends Control {
    private static final double DEFAULT_TAB_MIN_WIDTH = 0.0;
    private static final double DEFAULT_TAB_MAX_WIDTH = Double.MAX_VALUE;
    private static final double DEFAULT_TAB_MIN_HEIGHT = 0.0;
    private static final double DEFAULT_TAB_MAX_HEIGHT = Double.MAX_VALUE;
    public static final String STYLE_CLASS_FLOATING = "floating";
    private ObservableList<Tab> tabs = new TabObservableList<Tab>(new ArrayList());
    private ObjectProperty<SingleSelectionModel<Tab>> selectionModel = new SimpleObjectProperty<SingleSelectionModel<Tab>>(this, "selectionModel");
    private ObjectProperty<Side> side;
    private ObjectProperty<TabPane$TabClosingPolicy> tabClosingPolicy;
    private BooleanProperty rotateGraphic;
    private DoubleProperty tabMinWidth;
    private DoubleProperty tabMaxWidth;
    private DoubleProperty tabMinHeight;
    private DoubleProperty tabMaxHeight;
    private static final PseudoClass TOP_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("top");
    private static final PseudoClass BOTTOM_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("bottom");
    private static final PseudoClass LEFT_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("left");
    private static final PseudoClass RIGHT_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("right");
    private ObjectProperty<TabPane$TabDragPolicy> tabDragPolicy;

    public TabPane() {
        this(null);
    }

    public TabPane(Tab ... object) {
        this.getStyleClass().setAll((String[])new String[]{"tab-pane"});
        this.setAccessibleRole(AccessibleRole.TAB_PANE);
        this.setSelectionModel(new TabPane$TabPaneSelectionModel(this));
        this.tabs.addListener(listChangeListener$Change -> {
            while (listChangeListener$Change.next()) {
                for (Tab tab : listChangeListener$Change.getRemoved()) {
                    if (tab == null || this.getTabs().contains(tab)) continue;
                    tab.setTabPane(null);
                }
                for (Tab tab : listChangeListener$Change.getAddedSubList()) {
                    if (tab == null) continue;
                    tab.setTabPane(this);
                }
            }
        });
        if (object != null) {
            this.getTabs().addAll((Tab[])object);
        }
        this.pseudoClassStateChanged(TOP_PSEUDOCLASS_STATE, (object = this.getSide()) == Side.TOP);
        this.pseudoClassStateChanged(RIGHT_PSEUDOCLASS_STATE, object == Side.RIGHT);
        this.pseudoClassStateChanged(BOTTOM_PSEUDOCLASS_STATE, object == Side.BOTTOM);
        this.pseudoClassStateChanged(LEFT_PSEUDOCLASS_STATE, object == Side.LEFT);
    }

    public final ObservableList<Tab> getTabs() {
        return this.tabs;
    }

    public final void setSelectionModel(SingleSelectionModel<Tab> singleSelectionModel) {
        this.selectionModel.set(singleSelectionModel);
    }

    public final SingleSelectionModel<Tab> getSelectionModel() {
        return (SingleSelectionModel)this.selectionModel.get();
    }

    public final ObjectProperty<SingleSelectionModel<Tab>> selectionModelProperty() {
        return this.selectionModel;
    }

    public final void setSide(Side side) {
        this.sideProperty().set(side);
    }

    public final Side getSide() {
        if (this.side == null) {
            return Side.TOP;
        }
        return (Side)((Object)this.side.get());
    }

    public final ObjectProperty<Side> sideProperty() {
        if (this.side == null) {
            this.side = new TabPane$1(this, Side.TOP);
        }
        return this.side;
    }

    public final void setTabClosingPolicy(TabPane$TabClosingPolicy tabPane$TabClosingPolicy) {
        this.tabClosingPolicyProperty().set(tabPane$TabClosingPolicy);
    }

    public final TabPane$TabClosingPolicy getTabClosingPolicy() {
        if (this.tabClosingPolicy == null) {
            return TabPane$TabClosingPolicy.SELECTED_TAB;
        }
        return (TabPane$TabClosingPolicy)((Object)this.tabClosingPolicy.get());
    }

    public final ObjectProperty<TabPane$TabClosingPolicy> tabClosingPolicyProperty() {
        if (this.tabClosingPolicy == null) {
            this.tabClosingPolicy = new SimpleObjectProperty<TabPane$TabClosingPolicy>(this, "tabClosingPolicy", TabPane$TabClosingPolicy.SELECTED_TAB);
        }
        return this.tabClosingPolicy;
    }

    public final void setRotateGraphic(boolean bl2) {
        this.rotateGraphicProperty().set(bl2);
    }

    public final boolean isRotateGraphic() {
        if (this.rotateGraphic == null) {
            return false;
        }
        return this.rotateGraphic.get();
    }

    public final BooleanProperty rotateGraphicProperty() {
        if (this.rotateGraphic == null) {
            this.rotateGraphic = new SimpleBooleanProperty(this, "rotateGraphic", false);
        }
        return this.rotateGraphic;
    }

    public final void setTabMinWidth(double d2) {
        this.tabMinWidthProperty().setValue(d2);
    }

    public final double getTabMinWidth() {
        if (this.tabMinWidth == null) {
            return 0.0;
        }
        return this.tabMinWidth.getValue();
    }

    public final DoubleProperty tabMinWidthProperty() {
        if (this.tabMinWidth == null) {
            this.tabMinWidth = new TabPane$2(this, 0.0);
        }
        return this.tabMinWidth;
    }

    public final void setTabMaxWidth(double d2) {
        this.tabMaxWidthProperty().setValue(d2);
    }

    public final double getTabMaxWidth() {
        if (this.tabMaxWidth == null) {
            return Double.MAX_VALUE;
        }
        return this.tabMaxWidth.getValue();
    }

    public final DoubleProperty tabMaxWidthProperty() {
        if (this.tabMaxWidth == null) {
            this.tabMaxWidth = new TabPane$3(this, Double.MAX_VALUE);
        }
        return this.tabMaxWidth;
    }

    public final void setTabMinHeight(double d2) {
        this.tabMinHeightProperty().setValue(d2);
    }

    public final double getTabMinHeight() {
        if (this.tabMinHeight == null) {
            return 0.0;
        }
        return this.tabMinHeight.getValue();
    }

    public final DoubleProperty tabMinHeightProperty() {
        if (this.tabMinHeight == null) {
            this.tabMinHeight = new TabPane$4(this, 0.0);
        }
        return this.tabMinHeight;
    }

    public final void setTabMaxHeight(double d2) {
        this.tabMaxHeightProperty().setValue(d2);
    }

    public final double getTabMaxHeight() {
        if (this.tabMaxHeight == null) {
            return Double.MAX_VALUE;
        }
        return this.tabMaxHeight.getValue();
    }

    public final DoubleProperty tabMaxHeightProperty() {
        if (this.tabMaxHeight == null) {
            this.tabMaxHeight = new TabPane$5(this, Double.MAX_VALUE);
        }
        return this.tabMaxHeight;
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new TabPaneSkin(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Node lookup(String string) {
        void var2_3;
        Node eventTarget2 = super.lookup(string);
        if (eventTarget2 == null) {
            Tab tab;
            Node node;
            Iterator iterator = this.tabs.iterator();
            while (iterator.hasNext() && (node = (tab = (Tab)iterator.next()).lookup(string)) == null) {
            }
        }
        return var2_3;
    }

    @Override
    public Set<Node> lookupAll(String string) {
        if (string == null) {
            return null;
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.addAll(super.lookupAll(string));
        for (Tab tab : this.tabs) {
            arrayList.addAll(tab.lookupAll(string));
        }
        return new UnmodifiableListSet<Node>(arrayList);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return TabPane$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return TabPane.getClassCssMetaData();
    }

    public final ObjectProperty<TabPane$TabDragPolicy> tabDragPolicyProperty() {
        if (this.tabDragPolicy == null) {
            this.tabDragPolicy = new SimpleObjectProperty<TabPane$TabDragPolicy>(this, "tabDragPolicy", TabPane$TabDragPolicy.FIXED);
        }
        return this.tabDragPolicy;
    }

    public final void setTabDragPolicy(TabPane$TabDragPolicy tabPane$TabDragPolicy) {
        this.tabDragPolicyProperty().set(tabPane$TabDragPolicy);
    }

    public final TabPane$TabDragPolicy getTabDragPolicy() {
        return (TabPane$TabDragPolicy)((Object)this.tabDragPolicyProperty().get());
    }
}

