/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.lang.ref.WeakReference;
import java.util.Collection;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.WeakListChangeListener;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.control.Cell;
import javafx.scene.control.ControlUtils;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.Skin;
import javafx.scene.control.TableCell$1;
import javafx.scene.control.TableCell$2;
import javafx.scene.control.TableCell$3;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumn$CellEditEvent;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.control.TableView;
import javafx.scene.control.TableView$TableViewFocusModel;
import javafx.scene.control.TableView$TableViewSelectionModel;
import javafx.scene.control.skin.TableCellSkin;

public class TableCell<S, T>
extends IndexedCell<T> {
    boolean lockItemOnEdit = false;
    private boolean itemDirty = false;
    private ListChangeListener<TablePosition> selectedListener = listChangeListener$Change -> {
        while (listChangeListener$Change.next()) {
            if (!listChangeListener$Change.wasAdded() && !listChangeListener$Change.wasRemoved()) continue;
            this.updateSelection();
        }
    };
    private final InvalidationListener focusedListener = observable -> this.updateFocus();
    private final InvalidationListener tableRowUpdateObserver = observable -> {
        this.itemDirty = true;
        this.requestLayout();
    };
    private final InvalidationListener editingListener = observable -> this.updateEditing();
    private ListChangeListener<TableColumn<S, ?>> visibleLeafColumnsListener = listChangeListener$Change -> this.updateColumnIndex();
    private ListChangeListener<String> columnStyleClassListener = listChangeListener$Change -> {
        while (listChangeListener$Change.next()) {
            if (listChangeListener$Change.wasRemoved()) {
                this.getStyleClass().removeAll(listChangeListener$Change.getRemoved());
            }
            if (!listChangeListener$Change.wasAdded()) continue;
            this.getStyleClass().addAll(listChangeListener$Change.getAddedSubList());
        }
    };
    private final InvalidationListener columnStyleListener = observable -> {
        if (this.getTableColumn() != null) {
            TableCell tableCell = this;
            tableCell.possiblySetStyle(tableCell.getTableColumn().getStyle());
        }
    };
    private final InvalidationListener columnIdListener = observable -> {
        if (this.getTableColumn() != null) {
            TableCell tableCell = this;
            tableCell.possiblySetId(tableCell.getTableColumn().getId());
        }
    };
    private final WeakListChangeListener<TablePosition> weakSelectedListener = new WeakListChangeListener<TablePosition>(this.selectedListener);
    private final WeakInvalidationListener weakFocusedListener = new WeakInvalidationListener(this.focusedListener);
    private final WeakInvalidationListener weaktableRowUpdateObserver = new WeakInvalidationListener(this.tableRowUpdateObserver);
    private final WeakInvalidationListener weakEditingListener = new WeakInvalidationListener(this.editingListener);
    private final WeakInvalidationListener weakColumnStyleListener = new WeakInvalidationListener(this.columnStyleListener);
    private final WeakInvalidationListener weakColumnIdListener = new WeakInvalidationListener(this.columnIdListener);
    private final WeakListChangeListener<TableColumn<S, ?>> weakVisibleLeafColumnsListener = new WeakListChangeListener(this.visibleLeafColumnsListener);
    private final WeakListChangeListener<String> weakColumnStyleClassListener = new WeakListChangeListener<String>(this.columnStyleClassListener);
    private ReadOnlyObjectWrapper<TableColumn<S, T>> tableColumn = new TableCell$1(this);
    private ReadOnlyObjectWrapper<TableView<S>> tableView;
    private ReadOnlyObjectWrapper<TableRow<S>> tableRow = new ReadOnlyObjectWrapper(this, "tableRow");
    private TablePosition<S, T> editingCellAtStartEdit;
    private boolean isLastVisibleColumn = false;
    private int columnIndex = -1;
    private boolean updateEditingIndex = true;
    private ObservableValue<T> currentObservableValue = null;
    private boolean isFirstRun = true;
    private WeakReference<S> oldRowItemRef;
    private static final String DEFAULT_STYLE_CLASS = "table-cell";
    private static final PseudoClass PSEUDO_CLASS_LAST_VISIBLE = PseudoClass.getPseudoClass("last-visible");

    public TableCell() {
        this.getStyleClass().addAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.TABLE_CELL);
        this.updateColumnIndex();
    }

    public final ReadOnlyObjectProperty<TableColumn<S, T>> tableColumnProperty() {
        return this.tableColumn.getReadOnlyProperty();
    }

    private void setTableColumn(TableColumn<S, T> tableColumn) {
        this.tableColumn.set(tableColumn);
    }

    public final TableColumn<S, T> getTableColumn() {
        return (TableColumn)this.tableColumn.get();
    }

    private void setTableView(TableView<S> tableView) {
        this.tableViewPropertyImpl().set(tableView);
    }

    public final TableView<S> getTableView() {
        if (this.tableView == null) {
            return null;
        }
        return (TableView)this.tableView.get();
    }

    public final ReadOnlyObjectProperty<TableView<S>> tableViewProperty() {
        return this.tableViewPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<TableView<S>> tableViewPropertyImpl() {
        if (this.tableView == null) {
            this.tableView = new TableCell$2(this);
        }
        return this.tableView;
    }

    private void setTableRow(TableRow<S> tableRow) {
        this.tableRow.set(tableRow);
    }

    public final TableRow<S> getTableRow() {
        return (TableRow)this.tableRow.get();
    }

    public final ReadOnlyObjectProperty<TableRow<S>> tableRowProperty() {
        return this.tableRow;
    }

    TablePosition<S, T> getEditingCellAtStartEdit() {
        return this.editingCellAtStartEdit;
    }

    @Override
    public void startEdit() {
        if (this.isEditing()) {
            return;
        }
        TableView<S> tableView = this.getTableView();
        TableColumn<S, T> tableColumn = this.getTableColumn();
        Object object = this.getTableRow();
        if (!this.isEditable() || tableView != null && !tableView.isEditable() || tableColumn != null && !tableColumn.isEditable() || object != null && !((Cell)object).isEditable()) {
            return;
        }
        if (!this.lockItemOnEdit) {
            this.updateItem(-1);
        }
        super.startEdit();
        if (!this.isEditing()) {
            return;
        }
        this.editingCellAtStartEdit = new TablePosition<S, T>(tableView, this.getIndex(), tableColumn);
        if (tableColumn != null) {
            object = new TableColumn$CellEditEvent<S, Object>(tableView, this.editingCellAtStartEdit, TableColumn.editStartEvent(), null);
            Event.fireEvent(tableColumn, (Event)object);
        }
        if (tableView != null) {
            tableView.edit(this.editingCellAtStartEdit.getRow(), (TableColumn<S, ?>)this.editingCellAtStartEdit.getTableColumn());
        }
    }

    @Override
    public void commitEdit(T t2) {
        if (!this.isEditing()) {
            return;
        }
        super.commitEdit(t2);
        TableView tableView = this.getTableView();
        if (this.getTableColumn() != null) {
            TableColumn$CellEditEvent<S, T> tableColumn$CellEditEvent = new TableColumn$CellEditEvent<S, T>(tableView, this.editingCellAtStartEdit, TableColumn.editCommitEvent(), t2);
            Event.fireEvent(this.getTableColumn(), tableColumn$CellEditEvent);
        }
        this.updateItem(t2, false);
        if (tableView != null) {
            tableView.edit(-1, null);
            ControlUtils.requestFocusOnControlOnlyIfCurrentFocusOwnerIsChild(tableView);
        }
    }

    @Override
    public void cancelEdit() {
        if (!this.isEditing()) {
            return;
        }
        super.cancelEdit();
        Object object = this.getTableView();
        if (object != null) {
            if (this.updateEditingIndex) {
                ((TableView)object).edit(-1, null);
            }
            ControlUtils.requestFocusOnControlOnlyIfCurrentFocusOwnerIsChild(object);
        }
        if (this.getTableColumn() != null) {
            object = new TableColumn$CellEditEvent<S, Object>(object, this.editingCellAtStartEdit, TableColumn.editCancelEvent(), null);
            Event.fireEvent(this.getTableColumn(), (Event)object);
        }
    }

    @Override
    public void updateSelected(boolean bl2) {
        if (this.getTableRow() == null || this.getTableRow().isEmpty()) {
            return;
        }
        this.setSelected(bl2);
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new TableCellSkin(this);
    }

    private void cleanUpTableViewListeners(TableView<S> tableView) {
        if (tableView != null) {
            TableView$TableViewSelectionModel<S> tableView$TableViewSelectionModel = tableView.getSelectionModel();
            if (tableView$TableViewSelectionModel != null) {
                tableView$TableViewSelectionModel.getSelectedCells().removeListener(this.weakSelectedListener);
            }
            if ((tableView$TableViewSelectionModel = tableView.getFocusModel()) != null) {
                ((TableView$TableViewFocusModel)((Object)tableView$TableViewSelectionModel)).focusedCellProperty().removeListener(this.weakFocusedListener);
            }
            tableView.editingCellProperty().removeListener(this.weakEditingListener);
            tableView.getVisibleLeafColumns().removeListener(this.weakVisibleLeafColumnsListener);
        }
    }

    @Override
    void indexChanged(int n2, int n3) {
        super.indexChanged(n2, n3);
        this.updateItem(n2);
        this.updateSelection();
        this.updateFocus();
        this.updateEditing();
    }

    private void updateColumnIndex() {
        TableView<S> tableView = this.getTableView();
        TableColumn<S, T> tableColumn = this.getTableColumn();
        this.columnIndex = tableView == null || tableColumn == null ? -1 : tableView.getVisibleLeafIndex(tableColumn);
        this.isLastVisibleColumn = this.getTableColumn() != null && this.columnIndex != -1 && this.columnIndex == this.getTableView().getVisibleLeafColumns().size() - 1;
        this.pseudoClassStateChanged(PSEUDO_CLASS_LAST_VISIBLE, this.isLastVisibleColumn);
    }

    private void updateSelection() {
        if (this.isEmpty()) {
            return;
        }
        boolean bl2 = this.isSelected();
        if (!this.isInCellSelectionMode()) {
            if (bl2) {
                ((Cell)this).updateSelected(false);
            }
            return;
        }
        Object object = this.getTableView();
        if (this.getIndex() == -1 || object == null) {
            return;
        }
        if ((object = ((TableView)object).getSelectionModel()) == null) {
            ((Cell)this).updateSelected(false);
            return;
        }
        boolean bl3 = ((TableSelectionModel)object).isSelected(this.getIndex(), this.getTableColumn());
        if (bl2 == bl3) {
            return;
        }
        ((Cell)this).updateSelected(bl3);
    }

    private void updateFocus() {
        boolean bl2 = this.isFocused();
        if (!this.isInCellSelectionMode()) {
            if (bl2) {
                this.setFocused(false);
            }
            return;
        }
        Object object = this.getTableView();
        TableRow<S> tableRow = this.getTableRow();
        int n2 = this.getIndex();
        if (n2 == -1 || object == null || tableRow == null) {
            return;
        }
        if ((object = ((TableView)object).getFocusModel()) == null) {
            this.setFocused(false);
            return;
        }
        this.setFocused(((TableView$TableViewFocusModel)object).isFocused(n2, this.getTableColumn()));
    }

    private void updateEditing() {
        if (this.getIndex() == -1 || this.getTableView() == null) {
            if (this.isEditing()) {
                this.doCancelEdit();
            }
            return;
        }
        TablePosition<S, ?> tablePosition = this.getTableView().getEditingCell();
        boolean bl2 = this.match(tablePosition);
        if (bl2 && !this.isEditing()) {
            ((Cell)this).startEdit();
            return;
        }
        if (!bl2 && this.isEditing()) {
            this.doCancelEdit();
        }
    }

    private void doCancelEdit() {
        try {
            this.updateEditingIndex = false;
            ((Cell)this).cancelEdit();
            return;
        }
        finally {
            this.updateEditingIndex = true;
        }
    }

    private boolean match(TablePosition<S, ?> tablePosition) {
        return tablePosition != null && tablePosition.getRow() == this.getIndex() && tablePosition.getTableColumn() == this.getTableColumn();
    }

    private boolean isInCellSelectionMode() {
        TableView<S> tableView = this.getTableView();
        if (tableView == null) {
            return false;
        }
        return (tableView = tableView.getSelectionModel()) != null && ((TableSelectionModel)((Object)tableView)).isCellSelectionEnabled();
    }

    private void updateItem(int n2) {
        Object object;
        Object t2;
        Object object2;
        if (this.currentObservableValue != null) {
            this.currentObservableValue.removeListener(this.weaktableRowUpdateObserver);
        }
        object2 = (object2 = this.getTableView()) == null ? FXCollections.emptyObservableList() : ((TableView)object2).getItems();
        TableColumn<int, T> tableColumn = this.getTableColumn();
        int n3 = object2 == null ? -1 : object2.size();
        int n4 = this.getIndex();
        boolean bl2 = this.isEmpty();
        Object t3 = this.getItem();
        TableRow<S> tableRow = this.getTableRow();
        tableRow = tableRow == null ? null : tableRow.getItem();
        if ((n3 = n4 >= n3 ? 1 : 0) != 0 || n4 < 0 || this.columnIndex < 0 || !this.isVisible() || tableColumn == null || !tableColumn.isVisible()) {
            if (!bl2 && t3 != null || this.isFirstRun || n3 != 0) {
                this.updateItem(null, true);
                this.isFirstRun = false;
            }
            return;
        }
        this.currentObservableValue = ((TableColumnBase)tableColumn).getCellObservableValue(n4);
        Object t4 = t2 = this.currentObservableValue == null ? null : (Object)this.currentObservableValue.getValue();
        if (n2 != n4 || this.isItemChanged(t3, t2) || (object = this.oldRowItemRef != null ? (Object)this.oldRowItemRef.get() : null) == null || !object.equals(tableRow)) {
            this.updateItem(t2, false);
        }
        this.oldRowItemRef = new WeakReference<TableRow<S>>(tableRow);
        if (this.currentObservableValue == null) {
            return;
        }
        this.currentObservableValue.addListener(this.weaktableRowUpdateObserver);
    }

    @Override
    protected void layoutChildren() {
        if (this.itemDirty) {
            this.updateItem(-1);
            this.itemDirty = false;
        }
        super.layoutChildren();
    }

    public final void updateTableView(TableView tableView) {
        this.setTableView(tableView);
    }

    public final void updateTableRow(TableRow tableRow) {
        this.setTableRow(tableRow);
    }

    public final void updateTableColumn(TableColumn tableColumn) {
        TableColumn<S, T> tableColumn2 = this.getTableColumn();
        if (tableColumn2 != null) {
            tableColumn2.getStyleClass().removeListener(this.weakColumnStyleClassListener);
            this.getStyleClass().removeAll((Collection<?>)tableColumn2.getStyleClass());
            tableColumn2.idProperty().removeListener(this.weakColumnIdListener);
            tableColumn2.styleProperty().removeListener(this.weakColumnStyleListener);
            String string = this.getId();
            String string2 = this.getStyle();
            if (string != null && string.equals(tableColumn2.getId())) {
                this.setId(null);
            }
            if (string2 != null && string2.equals(tableColumn2.getStyle())) {
                this.setStyle("");
            }
        }
        this.setTableColumn(tableColumn);
        if (tableColumn != null) {
            this.getStyleClass().addAll((Collection<String>)tableColumn.getStyleClass());
            tableColumn.getStyleClass().addListener(this.weakColumnStyleClassListener);
            tableColumn.idProperty().addListener(this.weakColumnIdListener);
            tableColumn.styleProperty().addListener(this.weakColumnStyleListener);
            this.possiblySetId(tableColumn.getId());
            this.possiblySetStyle(tableColumn.getStyle());
        }
    }

    private void possiblySetId(String string) {
        if (this.getId() == null || this.getId().isEmpty()) {
            this.setId(string);
        }
    }

    private void possiblySetStyle(String string) {
        if (this.getStyle() == null || this.getStyle().isEmpty()) {
            this.setStyle(string);
        }
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case ROW_INDEX: {
                return this.getIndex();
            }
            case COLUMN_INDEX: {
                return this.columnIndex;
            }
            case SELECTED: {
                if (this.isInCellSelectionMode()) {
                    return this.isSelected();
                }
                if (this.getTableRow() == null) {
                    return null;
                }
                return this.getTableRow().isSelected();
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }

    @Override
    public void executeAccessibleAction(AccessibleAction object, Object ... objectArray) {
        switch (TableCell$3.$SwitchMap$javafx$scene$AccessibleAction[((Enum)object).ordinal()]) {
            case 1: {
                object = this.getTableView();
                if (object == null) break;
                if ((object = ((TableView)object).getFocusModel()) != null) {
                    ((TableView$TableViewFocusModel)object).focus(this.getIndex(), this.getTableColumn());
                }
                return;
            }
            default: {
                super.executeAccessibleAction((AccessibleAction)((Object)object), objectArray);
            }
        }
    }
}

