/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;

public class TableColumn$CellEditEvent<S, T>
extends Event {
    private static final long serialVersionUID = -609964441682677579L;
    public static final EventType<?> ANY = TableColumn.EDIT_ANY_EVENT;
    private final T newValue;
    private final transient TablePosition<S, T> pos;

    public TableColumn$CellEditEvent(TableView<S> tableView, TablePosition<S, T> tablePosition, EventType<TableColumn$CellEditEvent<S, T>> eventType, T t2) {
        super(tableView, Event.NULL_SOURCE_TARGET, eventType);
        this.pos = tablePosition;
        this.newValue = t2;
    }

    public TableView<S> getTableView() {
        if (this.pos != null) {
            return this.pos.getTableView();
        }
        return null;
    }

    public TableColumn<S, T> getTableColumn() {
        if (this.pos != null) {
            return this.pos.getTableColumn();
        }
        return null;
    }

    public TablePosition<S, T> getTablePosition() {
        return this.pos;
    }

    public T getNewValue() {
        return this.newValue;
    }

    public T getOldValue() {
        S s2 = this.getRowValue();
        if (s2 == null || this.pos.getTableColumn() == null) {
            return null;
        }
        return this.pos.getTableColumn().getCellData(s2);
    }

    public S getRowValue() {
        ObservableList<S> observableList = this.getTableView() != null ? this.getTableView().getItems() : null;
        if (observableList == null) {
            return null;
        }
        int n2 = this.pos != null ? this.pos.getRow() : -1;
        if (n2 < 0 || n2 >= observableList.size()) {
            return null;
        }
        return (S)observableList.get(n2);
    }
}

