/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn$1;
import javafx.scene.control.TableColumn$2;
import javafx.scene.control.TableColumn$3;
import javafx.scene.control.TableColumn$4;
import javafx.scene.control.TableColumn$5;
import javafx.scene.control.TableColumn$CellDataFeatures;
import javafx.scene.control.TableColumn$CellEditEvent;
import javafx.scene.control.TableColumn$SortType;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableView;
import javafx.scene.control.skin.NestedTableColumnHeader;
import javafx.scene.control.skin.TableColumnHeader;
import javafx.scene.control.skin.TableHeaderRow;
import javafx.scene.control.skin.TableViewSkin;
import javafx.util.Callback;

public class TableColumn<S, T>
extends TableColumnBase<S, T>
implements EventTarget {
    private static final EventType<?> EDIT_ANY_EVENT = new EventType<Event>(Event.ANY, "TABLE_COLUMN_EDIT");
    private static final EventType<?> EDIT_START_EVENT = new EventType(TableColumn.editAnyEvent(), "EDIT_START");
    private static final EventType<?> EDIT_CANCEL_EVENT = new EventType(TableColumn.editAnyEvent(), "EDIT_CANCEL");
    private static final EventType<?> EDIT_COMMIT_EVENT = new EventType(TableColumn.editAnyEvent(), "EDIT_COMMIT");
    public static final Callback<TableColumn<?, ?>, TableCell<?, ?>> DEFAULT_CELL_FACTORY = new TableColumn$1();
    private EventHandler<TableColumn$CellEditEvent<S, T>> DEFAULT_EDIT_COMMIT_HANDLER = tableColumn$CellEditEvent -> {
        int n2 = tableColumn$CellEditEvent.getTablePosition() != null ? tableColumn$CellEditEvent.getTablePosition().getRow() : -1;
        ObservableList observableList = tableColumn$CellEditEvent.getTableView() != null ? tableColumn$CellEditEvent.getTableView().getItems() : null;
        if (observableList == null || n2 < 0 || n2 >= observableList.size()) {
            return;
        }
        Object object = observableList.get(n2);
        if ((object = ((TableColumnBase)this).getCellObservableValue(object)) instanceof WritableValue) {
            ((WritableValue)object).setValue(tableColumn$CellEditEvent.getNewValue());
        }
    };
    private ListChangeListener<TableColumn<S, ?>> columnsListener = listChangeListener$Change -> {
        while (listChangeListener$Change.next()) {
            for (TableColumn tableColumn : listChangeListener$Change.getRemoved()) {
                if (((TableColumnBase)this).getColumns().contains(tableColumn)) continue;
                tableColumn.setTableView(null);
                tableColumn.setParentColumn(null);
            }
            for (TableColumn tableColumn : listChangeListener$Change.getAddedSubList()) {
                tableColumn.setTableView(this.getTableView());
            }
            this.updateColumnWidths();
        }
    };
    private WeakListChangeListener<TableColumn<S, ?>> weakColumnsListener = new WeakListChangeListener(this.columnsListener);
    private final ObservableList<TableColumn<S, ?>> columns = FXCollections.observableArrayList();
    private ReadOnlyObjectWrapper<TableView<S>> tableView = new ReadOnlyObjectWrapper(this, "tableView");
    private ObjectProperty<Callback<TableColumn$CellDataFeatures<S, T>, ObservableValue<T>>> cellValueFactory;
    private final ObjectProperty<Callback<TableColumn<S, T>, TableCell<S, T>>> cellFactory;
    private ObjectProperty<TableColumn$SortType> sortType;
    private ObjectProperty<EventHandler<TableColumn$CellEditEvent<S, T>>> onEditStart;
    private ObjectProperty<EventHandler<TableColumn$CellEditEvent<S, T>>> onEditCommit;
    private ObjectProperty<EventHandler<TableColumn$CellEditEvent<S, T>>> onEditCancel;
    private static final String DEFAULT_STYLE_CLASS = "table-column";

    public static <S, T> EventType<TableColumn$CellEditEvent<S, T>> editAnyEvent() {
        return EDIT_ANY_EVENT;
    }

    public static <S, T> EventType<TableColumn$CellEditEvent<S, T>> editStartEvent() {
        return EDIT_START_EVENT;
    }

    public static <S, T> EventType<TableColumn$CellEditEvent<S, T>> editCancelEvent() {
        return EDIT_CANCEL_EVENT;
    }

    public static <S, T> EventType<TableColumn$CellEditEvent<S, T>> editCommitEvent() {
        return EDIT_COMMIT_EVENT;
    }

    public TableColumn() {
        TableColumn tableColumn = this;
        this.cellFactory = new TableColumn$2(tableColumn, tableColumn, "cellFactory", DEFAULT_CELL_FACTORY);
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
        TableColumn tableColumn2 = this;
        tableColumn2.setOnEditCommit(tableColumn2.DEFAULT_EDIT_COMMIT_HANDLER);
        ((TableColumnBase)this).getColumns().addListener(this.weakColumnsListener);
        this.tableViewProperty().addListener(object -> {
            for (TableColumn tableColumn : ((TableColumnBase)this).getColumns()) {
                tableColumn.setTableView(this.getTableView());
            }
        });
    }

    public TableColumn(String string) {
        this();
        this.setText(string);
    }

    public final ReadOnlyObjectProperty<TableView<S>> tableViewProperty() {
        return this.tableView.getReadOnlyProperty();
    }

    final void setTableView(TableView<S> tableView) {
        this.tableView.set(tableView);
    }

    public final TableView<S> getTableView() {
        return (TableView)this.tableView.get();
    }

    public final void setCellValueFactory(Callback<TableColumn$CellDataFeatures<S, T>, ObservableValue<T>> callback) {
        this.cellValueFactoryProperty().set(callback);
    }

    public final Callback<TableColumn$CellDataFeatures<S, T>, ObservableValue<T>> getCellValueFactory() {
        if (this.cellValueFactory == null) {
            return null;
        }
        return (Callback)this.cellValueFactory.get();
    }

    public final ObjectProperty<Callback<TableColumn$CellDataFeatures<S, T>, ObservableValue<T>>> cellValueFactoryProperty() {
        if (this.cellValueFactory == null) {
            this.cellValueFactory = new SimpleObjectProperty<Callback<TableColumn$CellDataFeatures<S, T>, ObservableValue<T>>>(this, "cellValueFactory");
        }
        return this.cellValueFactory;
    }

    public final void setCellFactory(Callback<TableColumn<S, T>, TableCell<S, T>> callback) {
        this.cellFactory.set(callback);
    }

    public final Callback<TableColumn<S, T>, TableCell<S, T>> getCellFactory() {
        return (Callback)this.cellFactory.get();
    }

    public final ObjectProperty<Callback<TableColumn<S, T>, TableCell<S, T>>> cellFactoryProperty() {
        return this.cellFactory;
    }

    public final ObjectProperty<TableColumn$SortType> sortTypeProperty() {
        if (this.sortType == null) {
            this.sortType = new SimpleObjectProperty<TableColumn$SortType>(this, "sortType", TableColumn$SortType.ASCENDING);
        }
        return this.sortType;
    }

    public final void setSortType(TableColumn$SortType tableColumn$SortType) {
        this.sortTypeProperty().set(tableColumn$SortType);
    }

    public final TableColumn$SortType getSortType() {
        if (this.sortType == null) {
            return TableColumn$SortType.ASCENDING;
        }
        return (TableColumn$SortType)((Object)this.sortType.get());
    }

    public final void setOnEditStart(EventHandler<TableColumn$CellEditEvent<S, T>> eventHandler) {
        this.onEditStartProperty().set(eventHandler);
    }

    public final EventHandler<TableColumn$CellEditEvent<S, T>> getOnEditStart() {
        if (this.onEditStart == null) {
            return null;
        }
        return (EventHandler)this.onEditStart.get();
    }

    public final ObjectProperty<EventHandler<TableColumn$CellEditEvent<S, T>>> onEditStartProperty() {
        if (this.onEditStart == null) {
            TableColumn tableColumn = this;
            this.onEditStart = new TableColumn$3(tableColumn, tableColumn, "onEditStart");
        }
        return this.onEditStart;
    }

    public final void setOnEditCommit(EventHandler<TableColumn$CellEditEvent<S, T>> eventHandler) {
        this.onEditCommitProperty().set(eventHandler);
    }

    public final EventHandler<TableColumn$CellEditEvent<S, T>> getOnEditCommit() {
        if (this.onEditCommit == null) {
            return null;
        }
        return (EventHandler)this.onEditCommit.get();
    }

    public final ObjectProperty<EventHandler<TableColumn$CellEditEvent<S, T>>> onEditCommitProperty() {
        if (this.onEditCommit == null) {
            TableColumn tableColumn = this;
            this.onEditCommit = new TableColumn$4(tableColumn, tableColumn, "onEditCommit");
        }
        return this.onEditCommit;
    }

    public final void setOnEditCancel(EventHandler<TableColumn$CellEditEvent<S, T>> eventHandler) {
        this.onEditCancelProperty().set(eventHandler);
    }

    public final EventHandler<TableColumn$CellEditEvent<S, T>> getOnEditCancel() {
        if (this.onEditCancel == null) {
            return null;
        }
        return (EventHandler)this.onEditCancel.get();
    }

    public final ObjectProperty<EventHandler<TableColumn$CellEditEvent<S, T>>> onEditCancelProperty() {
        if (this.onEditCancel == null) {
            TableColumn tableColumn = this;
            this.onEditCancel = new TableColumn$5(tableColumn, tableColumn, "onEditCancel");
        }
        return this.onEditCancel;
    }

    @Override
    public final ObservableList<TableColumn<S, ?>> getColumns() {
        return this.columns;
    }

    @Override
    public final ObservableValue<T> getCellObservableValue(int n2) {
        if (n2 < 0) {
            return null;
        }
        TableView<S> tableView = this.getTableView();
        if (tableView == null || tableView.getItems() == null) {
            return null;
        }
        if (n2 >= (tableView = tableView.getItems()).size()) {
            return null;
        }
        Object e2 = tableView.get(n2);
        return ((TableColumnBase)this).getCellObservableValue(e2);
    }

    @Override
    public final ObservableValue<T> getCellObservableValue(S object) {
        Callback<TableColumn$CellDataFeatures<S, T>, ObservableValue<T>> callback = this.getCellValueFactory();
        if (callback == null) {
            return null;
        }
        TableView<S> tableView = this.getTableView();
        if (tableView == null) {
            return null;
        }
        object = new TableColumn$CellDataFeatures(tableView, this, object);
        return callback.call((TableColumn$CellDataFeatures<S, T>)object);
    }

    @Override
    public String getTypeSelector() {
        return "TableColumn";
    }

    @Override
    public Styleable getStyleableParent() {
        return this.getTableView();
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return TableColumn.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Node getStyleableNode() {
        void var2_3;
        if (!(this.getTableView().getSkin() instanceof TableViewSkin)) {
            return null;
        }
        Object object = (TableViewSkin)this.getTableView().getSkin();
        Object node2 = null;
        for (Node node : ((SkinBase)object).getChildren()) {
            if (!(node instanceof TableHeaderRow)) continue;
            TableHeaderRow tableHeaderRow = (TableHeaderRow)node;
        }
        object = null;
        for (Node node : var2_3.getChildren()) {
            if (!(node instanceof NestedTableColumnHeader)) continue;
            object = (NestedTableColumnHeader)node;
        }
        return this.scan((TableColumnHeader)object);
    }

    private TableColumnHeader scan(TableColumnHeader tableColumnHeader) {
        if (this.equals(tableColumnHeader.getTableColumn())) {
            return tableColumnHeader;
        }
        if (tableColumnHeader instanceof NestedTableColumnHeader) {
            tableColumnHeader = (NestedTableColumnHeader)tableColumnHeader;
            for (int i2 = 0; i2 < ((NestedTableColumnHeader)tableColumnHeader).getColumnHeaders().size(); ++i2) {
                TableColumnHeader tableColumnHeader2 = this.scan((TableColumnHeader)((NestedTableColumnHeader)tableColumnHeader).getColumnHeaders().get(i2));
                if (tableColumnHeader2 == null) continue;
                return tableColumnHeader2;
            }
        }
        return null;
    }
}

