/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.beans.IDProperty;
import com.sun.javafx.event.EventHandlerManager;
import com.sun.javafx.scene.control.TableColumnBaseHelper;
import com.sun.javafx.scene.control.skin.Utils;
import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.TableColumnBase$1;
import javafx.scene.control.TableColumnBase$2;
import javafx.scene.control.TableColumnBase$3;
import javafx.scene.control.TableColumnBase$4;
import javafx.scene.control.TableColumnBase$5;
import javafx.scene.control.TableColumnBase$6;

@IDProperty(value="id")
public abstract class TableColumnBase<S, T>
implements Styleable,
EventTarget {
    static final double DEFAULT_WIDTH = 80.0;
    static final double DEFAULT_MIN_WIDTH = 10.0;
    static final double DEFAULT_MAX_WIDTH = 5000.0;
    public static final Comparator DEFAULT_COMPARATOR;
    final EventHandlerManager eventHandlerManager = new EventHandlerManager(this);
    private StringProperty text = new SimpleStringProperty(this, "text", "");
    private BooleanProperty visible;
    private ReadOnlyObjectWrapper<TableColumnBase<S, ?>> parentColumn;
    private ObjectProperty<ContextMenu> contextMenu;
    private StringProperty id;
    private StringProperty style;
    private final ObservableList<String> styleClass;
    private ObjectProperty<Node> graphic;
    private ObjectProperty<Node> sortNode;
    private ReadOnlyDoubleWrapper width;
    private DoubleProperty minWidth;
    private final DoubleProperty prefWidth;
    private DoubleProperty maxWidth;
    private BooleanProperty resizable;
    private BooleanProperty sortable;
    private BooleanProperty reorderable;
    private ObjectProperty<Comparator<T>> comparator;
    private BooleanProperty editable;
    private static final Object USER_DATA_KEY;
    private ObservableMap<Object, Object> properties;

    protected TableColumnBase() {
        this("");
    }

    protected TableColumnBase(String string) {
        TableColumnBase tableColumnBase = this;
        this.visible = new TableColumnBase$2(tableColumnBase, tableColumnBase, "visible", true);
        this.styleClass = FXCollections.observableArrayList();
        this.sortNode = new SimpleObjectProperty<Node>(this, "sortNode");
        this.width = new ReadOnlyDoubleWrapper(this, "width", 80.0);
        TableColumnBase tableColumnBase2 = this;
        this.prefWidth = new TableColumnBase$5(tableColumnBase2, tableColumnBase2, "prefWidth", 80.0);
        TableColumnBase tableColumnBase3 = this;
        this.maxWidth = new TableColumnBase$6(tableColumnBase3, tableColumnBase3, "maxWidth", 5000.0);
        this.setText(string);
    }

    public final StringProperty textProperty() {
        return this.text;
    }

    public final void setText(String string) {
        this.text.set(string);
    }

    public final String getText() {
        return (String)this.text.get();
    }

    public final void setVisible(boolean bl2) {
        this.visibleProperty().set(bl2);
    }

    public final boolean isVisible() {
        return this.visible.get();
    }

    public final BooleanProperty visibleProperty() {
        return this.visible;
    }

    void setParentColumn(TableColumnBase<S, ?> tableColumnBase) {
        this.parentColumnPropertyImpl().set(tableColumnBase);
    }

    public final TableColumnBase<S, ?> getParentColumn() {
        if (this.parentColumn == null) {
            return null;
        }
        return (TableColumnBase)this.parentColumn.get();
    }

    public final ReadOnlyObjectProperty<TableColumnBase<S, ?>> parentColumnProperty() {
        return this.parentColumnPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<TableColumnBase<S, ?>> parentColumnPropertyImpl() {
        if (this.parentColumn == null) {
            this.parentColumn = new ReadOnlyObjectWrapper(this, "parentColumn");
        }
        return this.parentColumn;
    }

    public final void setContextMenu(ContextMenu contextMenu) {
        this.contextMenuProperty().set(contextMenu);
    }

    public final ContextMenu getContextMenu() {
        if (this.contextMenu == null) {
            return null;
        }
        return (ContextMenu)this.contextMenu.get();
    }

    public final ObjectProperty<ContextMenu> contextMenuProperty() {
        if (this.contextMenu == null) {
            TableColumnBase tableColumnBase = this;
            this.contextMenu = new TableColumnBase$3(tableColumnBase, tableColumnBase, "contextMenu");
        }
        return this.contextMenu;
    }

    public final void setId(String string) {
        this.idProperty().set(string);
    }

    @Override
    public final String getId() {
        if (this.id == null) {
            return null;
        }
        return (String)this.id.get();
    }

    public final StringProperty idProperty() {
        if (this.id == null) {
            this.id = new SimpleStringProperty(this, "id");
        }
        return this.id;
    }

    public final void setStyle(String string) {
        this.styleProperty().set(string);
    }

    @Override
    public final String getStyle() {
        if (this.style == null) {
            return "";
        }
        return (String)this.style.get();
    }

    public final StringProperty styleProperty() {
        if (this.style == null) {
            this.style = new SimpleStringProperty(this, "style");
        }
        return this.style;
    }

    @Override
    public ObservableList<String> getStyleClass() {
        return this.styleClass;
    }

    public final void setGraphic(Node node) {
        this.graphicProperty().set(node);
    }

    public final Node getGraphic() {
        if (this.graphic == null) {
            return null;
        }
        return (Node)this.graphic.get();
    }

    public final ObjectProperty<Node> graphicProperty() {
        if (this.graphic == null) {
            this.graphic = new SimpleObjectProperty<Node>(this, "graphic");
        }
        return this.graphic;
    }

    public final void setSortNode(Node node) {
        this.sortNodeProperty().set(node);
    }

    public final Node getSortNode() {
        return (Node)this.sortNode.get();
    }

    public final ObjectProperty<Node> sortNodeProperty() {
        return this.sortNode;
    }

    public final ReadOnlyDoubleProperty widthProperty() {
        return this.width.getReadOnlyProperty();
    }

    public final double getWidth() {
        return this.width.get();
    }

    void setWidth(double d2) {
        this.width.set(d2);
    }

    public final void setMinWidth(double d2) {
        this.minWidthProperty().set(d2);
    }

    public final double getMinWidth() {
        if (this.minWidth == null) {
            return 10.0;
        }
        return this.minWidth.get();
    }

    public final DoubleProperty minWidthProperty() {
        if (this.minWidth == null) {
            TableColumnBase tableColumnBase = this;
            this.minWidth = new TableColumnBase$4(tableColumnBase, tableColumnBase, "minWidth", 10.0);
        }
        return this.minWidth;
    }

    public final DoubleProperty prefWidthProperty() {
        return this.prefWidth;
    }

    public final void setPrefWidth(double d2) {
        this.prefWidthProperty().set(d2);
    }

    public final double getPrefWidth() {
        return this.prefWidth.get();
    }

    public final DoubleProperty maxWidthProperty() {
        return this.maxWidth;
    }

    public final void setMaxWidth(double d2) {
        this.maxWidthProperty().set(d2);
    }

    public final double getMaxWidth() {
        return this.maxWidth.get();
    }

    public final BooleanProperty resizableProperty() {
        if (this.resizable == null) {
            this.resizable = new SimpleBooleanProperty(this, "resizable", true);
        }
        return this.resizable;
    }

    public final void setResizable(boolean bl2) {
        this.resizableProperty().set(bl2);
    }

    public final boolean isResizable() {
        if (this.resizable == null) {
            return true;
        }
        return this.resizable.get();
    }

    public final BooleanProperty sortableProperty() {
        if (this.sortable == null) {
            this.sortable = new SimpleBooleanProperty(this, "sortable", true);
        }
        return this.sortable;
    }

    public final void setSortable(boolean bl2) {
        this.sortableProperty().set(bl2);
    }

    public final boolean isSortable() {
        if (this.sortable == null) {
            return true;
        }
        return this.sortable.get();
    }

    public final BooleanProperty reorderableProperty() {
        if (this.reorderable == null) {
            this.reorderable = new SimpleBooleanProperty(this, "reorderable", true);
        }
        return this.reorderable;
    }

    public final void setReorderable(boolean bl2) {
        this.reorderableProperty().set(bl2);
    }

    public final boolean isReorderable() {
        if (this.reorderable == null) {
            return true;
        }
        return this.reorderable.get();
    }

    public final ObjectProperty<Comparator<T>> comparatorProperty() {
        if (this.comparator == null) {
            this.comparator = new SimpleObjectProperty<Comparator>(this, "comparator", DEFAULT_COMPARATOR);
        }
        return this.comparator;
    }

    public final void setComparator(Comparator<T> comparator) {
        this.comparatorProperty().set(comparator);
    }

    public final Comparator<T> getComparator() {
        if (this.comparator == null) {
            return DEFAULT_COMPARATOR;
        }
        return (Comparator)this.comparator.get();
    }

    public final void setEditable(boolean bl2) {
        this.editableProperty().set(bl2);
    }

    public final boolean isEditable() {
        if (this.editable == null) {
            return true;
        }
        return this.editable.get();
    }

    public final BooleanProperty editableProperty() {
        if (this.editable == null) {
            this.editable = new SimpleBooleanProperty(this, "editable", true);
        }
        return this.editable;
    }

    public final ObservableMap<Object, Object> getProperties() {
        if (this.properties == null) {
            this.properties = FXCollections.observableMap(new HashMap());
        }
        return this.properties;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public void setUserData(Object object) {
        this.getProperties().put(USER_DATA_KEY, object);
    }

    public Object getUserData() {
        return this.getProperties().get(USER_DATA_KEY);
    }

    public abstract ObservableList<? extends TableColumnBase<S, ?>> getColumns();

    public final T getCellData(int n2) {
        ObservableValue<T> observableValue = this.getCellObservableValue((S)n2);
        if (observableValue == null) {
            return null;
        }
        return observableValue.getValue();
    }

    public final T getCellData(S object) {
        if ((object = this.getCellObservableValue(object)) == null) {
            return null;
        }
        return object.getValue();
    }

    public abstract ObservableValue<T> getCellObservableValue(int var1);

    public abstract ObservableValue<T> getCellObservableValue(S var1);

    @Override
    public EventDispatchChain buildEventDispatchChain(EventDispatchChain eventDispatchChain) {
        return eventDispatchChain.prepend(this.eventHandlerManager);
    }

    @Override
    public <E extends Event> void addEventHandler(EventType<E> eventType, EventHandler<? super E> eventHandler) {
        this.eventHandlerManager.addEventHandler(eventType, eventHandler);
    }

    @Override
    public <E extends Event> void removeEventHandler(EventType<E> eventType, EventHandler<? super E> eventHandler) {
        this.eventHandlerManager.removeEventHandler(eventType, eventHandler);
    }

    @Override
    public <E extends Event> void addEventFilter(EventType<E> eventType, EventHandler<? super E> eventHandler) {
        this.eventHandlerManager.addEventFilter(eventType, eventHandler);
    }

    @Override
    public <E extends Event> void removeEventFilter(EventType<E> eventType, EventHandler<? super E> eventHandler) {
        this.eventHandlerManager.removeEventFilter(eventType, eventHandler);
    }

    void doSetWidth(double d2) {
        this.setWidth(Utils.boundedSize(d2, this.getMinWidth(), this.getMaxWidth()));
    }

    void updateColumnWidths() {
        if (!this.getColumns().isEmpty()) {
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            for (TableColumnBase tableColumnBase : this.getColumns()) {
                tableColumnBase.setParentColumn(this);
                d2 += tableColumnBase.getMinWidth();
                d3 += tableColumnBase.getPrefWidth();
                d4 += tableColumnBase.getMaxWidth();
            }
            this.setMinWidth(d2);
            this.setPrefWidth(d3);
            this.setMaxWidth(d4);
        }
    }

    @Override
    public final ObservableSet<PseudoClass> getPseudoClassStates() {
        return FXCollections.emptyObservableSet();
    }

    static {
        TableColumnBaseHelper.setTableColumnBaseAccessor(new TableColumnBase$1());
        DEFAULT_COMPARATOR = (object, object2) -> {
            if (object == null && object2 == null) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (object instanceof Comparable && (object.getClass() == object2.getClass() || object.getClass().isAssignableFrom(object2.getClass()))) {
                if (object instanceof String) {
                    return Collator.getInstance().compare(object, object2);
                }
                return ((Comparable)object).compareTo(object2);
            }
            return Collator.getInstance().compare(object.toString(), object2.toString());
        };
        USER_DATA_KEY = new Object();
    }
}

