/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.ListChangeListener;
import javafx.collections.WeakListChangeListener;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.control.FocusModel;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.Skin;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableRow$1;
import javafx.scene.control.TableView;
import javafx.scene.control.TableView$TableViewSelectionModel;
import javafx.scene.control.skin.TableRowSkin;

public class TableRow<T>
extends IndexedCell<T> {
    private ListChangeListener<Integer> selectedListener = listChangeListener$Change -> this.updateSelection();
    private final InvalidationListener focusedListener = observable -> this.updateFocus();
    private final InvalidationListener editingListener = observable -> this.updateEditing();
    private final WeakListChangeListener<Integer> weakSelectedListener = new WeakListChangeListener<Integer>(this.selectedListener);
    private final WeakInvalidationListener weakFocusedListener = new WeakInvalidationListener(this.focusedListener);
    private final WeakInvalidationListener weakEditingListener = new WeakInvalidationListener(this.editingListener);
    private ReadOnlyObjectWrapper<TableView<T>> tableView;
    private boolean isFirstRun = true;
    private static final String DEFAULT_STYLE_CLASS = "table-row-cell";

    public TableRow() {
        this.getStyleClass().addAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.TABLE_ROW);
    }

    private void setTableView(TableView<T> tableView) {
        this.tableViewPropertyImpl().set(tableView);
    }

    public final TableView<T> getTableView() {
        if (this.tableView == null) {
            return null;
        }
        return (TableView)this.tableView.get();
    }

    public final ReadOnlyObjectProperty<TableView<T>> tableViewProperty() {
        return this.tableViewPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<TableView<T>> tableViewPropertyImpl() {
        if (this.tableView == null) {
            this.tableView = new TableRow$1(this);
        }
        return this.tableView;
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new TableRowSkin(this);
    }

    @Override
    void indexChanged(int n2, int n3) {
        super.indexChanged(n2, n3);
        this.updateItem(n2);
        this.updateSelection();
        this.updateFocus();
    }

    private void updateItem(int n2) {
        TableView<T> tableView = this.getTableView();
        if (tableView == null || tableView.getItems() == null) {
            return;
        }
        int n3 = (tableView = tableView.getItems()) == null ? -1 : tableView.size();
        int n4 = this.getIndex();
        n3 = n4 >= 0 && n4 < n3 ? 1 : 0;
        Object t2 = this.getItem();
        boolean bl2 = this.isEmpty();
        if (n3 != 0) {
            tableView = tableView.get(n4);
            if (n2 != n4 || this.isItemChanged(t2, tableView)) {
                this.updateItem(tableView, false);
                return;
            }
        } else if (!bl2 && t2 != null || this.isFirstRun) {
            this.updateItem(null, true);
            this.isFirstRun = false;
        }
    }

    private void updateSelection() {
        if (this.getIndex() == -1) {
            return;
        }
        TableView<T> tableView = this.getTableView();
        boolean bl2 = tableView != null && tableView.getSelectionModel() != null && !tableView.getSelectionModel().isCellSelectionEnabled() && ((SelectionModel)tableView.getSelectionModel()).isSelected(this.getIndex());
        this.updateSelected(bl2);
    }

    private void updateFocus() {
        if (this.getIndex() == -1) {
            return;
        }
        TableView<T> tableView = this.getTableView();
        if (tableView == null) {
            return;
        }
        TableView$TableViewSelectionModel<T> tableView$TableViewSelectionModel = tableView.getSelectionModel();
        tableView = tableView.getFocusModel();
        if (tableView$TableViewSelectionModel == null || tableView == null) {
            return;
        }
        boolean bl2 = !tableView$TableViewSelectionModel.isCellSelectionEnabled() && ((FocusModel)((Object)tableView)).isFocused(this.getIndex());
        this.setFocused(bl2);
    }

    private void updateEditing() {
        boolean bl2;
        if (this.getIndex() == -1) {
            return;
        }
        TableView<T> tableView = this.getTableView();
        if (tableView == null) {
            return;
        }
        TableView$TableViewSelectionModel<T> tableView$TableViewSelectionModel = tableView.getSelectionModel();
        if (tableView$TableViewSelectionModel == null || tableView$TableViewSelectionModel.isCellSelectionEnabled()) {
            return;
        }
        if ((tableView = tableView.getEditingCell()) != null && ((TablePosition)((Object)tableView)).getTableColumn() != null) {
            return;
        }
        boolean bl3 = bl2 = tableView != null && ((TablePositionBase)((Object)tableView)).getRow() == this.getIndex();
        if (!this.isEditing() && bl2) {
            this.startEdit();
            return;
        }
        if (this.isEditing() && !bl2) {
            this.cancelEdit();
        }
    }

    public final void updateTableView(TableView<T> tableView) {
        this.setTableView(tableView);
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case INDEX: {
                return this.getIndex();
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }
}

