/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ListChangeListener$Change;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumn$SortType;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableUtil$SortEventType;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableColumn$SortType;

class TableUtil {
    private static final double EPSILON = 1.0E-7;

    private TableUtil() {
    }

    static void removeTableColumnListener(List<? extends TableColumnBase> object, InvalidationListener invalidationListener, InvalidationListener invalidationListener2, InvalidationListener invalidationListener3, InvalidationListener invalidationListener4) {
        if (object == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            TableColumnBase tableColumnBase = (TableColumnBase)object.next();
            tableColumnBase.visibleProperty().removeListener(invalidationListener);
            tableColumnBase.sortableProperty().removeListener(invalidationListener2);
            tableColumnBase.comparatorProperty().removeListener(invalidationListener4);
            if (tableColumnBase instanceof TableColumn) {
                ((TableColumn)tableColumnBase).sortTypeProperty().removeListener(invalidationListener3);
            } else if (tableColumnBase instanceof TreeTableColumn) {
                ((TreeTableColumn)tableColumnBase).sortTypeProperty().removeListener(invalidationListener3);
            }
            TableUtil.removeTableColumnListener(tableColumnBase.getColumns(), invalidationListener, invalidationListener2, invalidationListener3, invalidationListener4);
        }
    }

    static void addTableColumnListener(List<? extends TableColumnBase> object, InvalidationListener invalidationListener, InvalidationListener invalidationListener2, InvalidationListener invalidationListener3, InvalidationListener invalidationListener4) {
        if (object == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            TableColumnBase tableColumnBase = (TableColumnBase)object.next();
            tableColumnBase.visibleProperty().addListener(invalidationListener);
            tableColumnBase.sortableProperty().addListener(invalidationListener2);
            tableColumnBase.comparatorProperty().addListener(invalidationListener4);
            if (tableColumnBase instanceof TableColumn) {
                ((TableColumn)tableColumnBase).sortTypeProperty().addListener(invalidationListener3);
            } else if (tableColumnBase instanceof TreeTableColumn) {
                ((TreeTableColumn)tableColumnBase).sortTypeProperty().addListener(invalidationListener3);
            }
            TableUtil.addTableColumnListener(tableColumnBase.getColumns(), invalidationListener, invalidationListener2, invalidationListener3, invalidationListener4);
        }
    }

    static void removeColumnsListener(List<? extends TableColumnBase> object, ListChangeListener listChangeListener) {
        if (object == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            TableColumnBase tableColumnBase = (TableColumnBase)object.next();
            tableColumnBase.getColumns().removeListener(listChangeListener);
            TableUtil.removeColumnsListener(tableColumnBase.getColumns(), listChangeListener);
        }
    }

    static void addColumnsListener(List<? extends TableColumnBase> object, ListChangeListener listChangeListener) {
        if (object == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            TableColumnBase tableColumnBase = (TableColumnBase)object.next();
            tableColumnBase.getColumns().addListener(listChangeListener);
            TableUtil.addColumnsListener(tableColumnBase.getColumns(), listChangeListener);
        }
    }

    static void handleSortFailure(ObservableList<? extends TableColumnBase> observableList, TableUtil$SortEventType object, Object ... object2) {
        if (object == TableUtil$SortEventType.COLUMN_SORT_TYPE_CHANGE) {
            object = (TableColumnBase)object2[0];
            TableUtil.revertSortType((TableColumnBase)object);
            return;
        }
        if (object == TableUtil$SortEventType.SORT_ORDER_CHANGE) {
            object = (ListChangeListener$Change)object2[0];
            object2 = new ArrayList();
            ArrayList arrayList = new ArrayList();
            while (((ListChangeListener$Change)object).next()) {
                if (((ListChangeListener$Change)object).wasAdded()) {
                    object2.addAll(((ListChangeListener$Change)object).getAddedSubList());
                }
                if (!((ListChangeListener$Change)object).wasRemoved()) continue;
                arrayList.addAll(((ListChangeListener$Change)object).getRemoved());
            }
            observableList.removeAll((Collection<?>)object2);
            observableList.addAll(arrayList);
            return;
        }
        if (object != TableUtil$SortEventType.COLUMN_SORTABLE_CHANGE) {
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void revertSortType(TableColumnBase tableColumnBase) {
        if (tableColumnBase instanceof TableColumn) {
            TableColumn$SortType tableColumn$SortType = ((TableColumn)(tableColumnBase = (TableColumn)tableColumnBase)).getSortType();
            if (tableColumn$SortType == TableColumn$SortType.ASCENDING) {
                ((TableColumn)tableColumnBase).setSortType(null);
                return;
            }
            if (tableColumn$SortType == TableColumn$SortType.DESCENDING) {
                ((TableColumn)tableColumnBase).setSortType(TableColumn$SortType.ASCENDING);
                return;
            }
            if (tableColumn$SortType != null) return;
            ((TableColumn)tableColumnBase).setSortType(TableColumn$SortType.DESCENDING);
            return;
        }
        if (!(tableColumnBase instanceof TreeTableColumn)) return;
        TreeTableColumn$SortType treeTableColumn$SortType = ((TreeTableColumn)(tableColumnBase = (TreeTableColumn)tableColumnBase)).getSortType();
        if (treeTableColumn$SortType == TreeTableColumn$SortType.ASCENDING) {
            ((TreeTableColumn)tableColumnBase).setSortType(null);
            return;
        }
        if (treeTableColumn$SortType == TreeTableColumn$SortType.DESCENDING) {
            ((TreeTableColumn)tableColumnBase).setSortType(TreeTableColumn$SortType.ASCENDING);
            return;
        }
        if (treeTableColumn$SortType != null) return;
        ((TreeTableColumn)tableColumnBase).setSortType(TreeTableColumn$SortType.DESCENDING);
    }

    static double resize(TableColumnBase tableColumnBase, double d2) {
        double d3;
        if (d2 == 0.0) {
            return 0.0;
        }
        if (!tableColumnBase.isResizable()) {
            return d2;
        }
        boolean bl2 = d2 < 0.0;
        List<TableColumnBase<?, ?>> list = TableUtil.getResizableChildren(tableColumnBase, bl2);
        if (list.size() > 0) {
            return TableUtil.resizeColumns(list, d2);
        }
        double d4 = tableColumnBase.getWidth() + d2;
        if (d3 > tableColumnBase.getMaxWidth()) {
            TableColumnBase tableColumnBase2 = tableColumnBase;
            tableColumnBase2.doSetWidth(tableColumnBase2.getMaxWidth());
            return d4 - tableColumnBase.getMaxWidth();
        }
        if (d4 < tableColumnBase.getMinWidth()) {
            TableColumnBase tableColumnBase3 = tableColumnBase;
            tableColumnBase3.doSetWidth(tableColumnBase3.getMinWidth());
            return d4 - tableColumnBase.getMinWidth();
        }
        tableColumnBase.doSetWidth(d4);
        return 0.0;
    }

    private static List<TableColumnBase<?, ?>> getResizableChildren(TableColumnBase<?, ?> object, boolean bl2) {
        if (object == null || ((TableColumnBase)((Object)object)).getColumns().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList arrayList = new ArrayList();
        for (TableColumnBase tableColumnBase : ((TableColumnBase)((Object)object)).getColumns()) {
            if (!tableColumnBase.isVisible() || !tableColumnBase.isResizable()) continue;
            if (bl2 && tableColumnBase.getWidth() > tableColumnBase.getMinWidth()) {
                arrayList.add(tableColumnBase);
                continue;
            }
            if (bl2 || !(tableColumnBase.getWidth() < tableColumnBase.getMaxWidth())) continue;
            arrayList.add(tableColumnBase);
        }
        return arrayList;
    }

    private static double resizeColumns(List<? extends TableColumnBase<?, ?>> object, double d2) {
        int n2 = object.size();
        double d3 = d2 / (double)n2;
        double d4 = d2;
        int n3 = 0;
        boolean bl2 = true;
        object = object.iterator();
        while (object.hasNext()) {
            TableColumnBase tableColumnBase = (TableColumnBase)object.next();
            ++n3;
            double d5 = TableUtil.resize(tableColumnBase, d3);
            d4 = d4 - d3 + d5;
            if (d5 == 0.0) continue;
            bl2 = false;
            d3 = d4 / (double)(n2 - n3);
        }
        if (bl2) {
            return 0.0;
        }
        return d4;
    }
}

