/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.collections.MappingChange;
import com.sun.javafx.collections.NonIterableChange$GenericAddRemoveChange;
import com.sun.javafx.collections.NonIterableChange$SimpleAddChange;
import com.sun.javafx.scene.control.ReadOnlyUnbackedObservableList;
import com.sun.javafx.scene.control.SelectedCellsMap;
import com.sun.javafx.scene.control.behavior.TableCellBehavior;
import com.sun.javafx.scene.control.behavior.TableCellBehaviorBase;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntPredicate;
import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ListChangeListener$Change;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.scene.control.ControlUtils;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.control.TableView;
import javafx.scene.control.TableView$TableViewArrayListSelectionModel$1;
import javafx.scene.control.TableView$TableViewArrayListSelectionModel$2;
import javafx.scene.control.TableView$TableViewArrayListSelectionModel$3;
import javafx.scene.control.TableView$TableViewArrayListSelectionModel$4;
import javafx.scene.control.TableView$TableViewArrayListSelectionModel$5;
import javafx.scene.control.TableView$TableViewSelectionModel;

class TableView$TableViewArrayListSelectionModel<S>
extends TableView$TableViewSelectionModel<S> {
    private int itemCount = 0;
    private final TableView<S> tableView;
    final InvalidationListener itemsPropertyListener;
    final ListChangeListener<S> itemsContentListener = listChangeListener$Change -> {
        this.updateItemCount();
        List list = this.getTableModel();
        boolean bl2 = true;
        while (listChangeListener$Change.next()) {
            Object s2;
            if (listChangeListener$Change.wasReplaced() || listChangeListener$Change.getAddedSize() == this.getItemCount()) {
                this.selectedItemChange = listChangeListener$Change;
                this.updateDefaultSelection();
                this.selectedItemChange = null;
                return;
            }
            Object t2 = this.getSelectedItem();
            int n2 = this.getSelectedIndex();
            if (list == null || list.isEmpty()) {
                ((SelectionModel)this).clearSelection();
                continue;
            }
            if (this.getSelectedIndex() == -1 && this.getSelectedItem() != null) {
                n2 = list.indexOf(this.getSelectedItem());
                if (n2 == -1) continue;
                this.setSelectedIndex(n2);
                bl2 = false;
                continue;
            }
            if (!listChangeListener$Change.wasRemoved() || listChangeListener$Change.getRemovedSize() != 1 || listChangeListener$Change.wasAdded() || t2 == null || !t2.equals(listChangeListener$Change.getRemoved().get(0)) || this.getSelectedIndex() >= this.getItemCount() || t2.equals(s2 = this.getModelItem(n2 = n2 == 0 ? 0 : n2 - 1))) continue;
            ((SelectionModel)this).clearAndSelect(n2);
        }
        if (bl2) {
            this.updateSelection(listChangeListener$Change);
        }
    };
    final WeakListChangeListener<S> weakItemsContentListener = new WeakListChangeListener<S>(this.itemsContentListener);
    private final SelectedCellsMap<TablePosition<S, ?>> selectedCellsMap;
    private final ReadOnlyUnbackedObservableList<TablePosition<S, ?>> selectedCellsSeq;
    private int previousModelSize = 0;

    public TableView$TableViewArrayListSelectionModel(TableView<S> tableView) {
        super(tableView);
        this.tableView = tableView;
        this.itemsPropertyListener = new TableView$TableViewArrayListSelectionModel$1(this, tableView);
        this.tableView.itemsProperty().addListener(this.itemsPropertyListener);
        TableView$TableViewArrayListSelectionModel tableView$TableViewArrayListSelectionModel = this;
        this.selectedCellsMap = new TableView$TableViewArrayListSelectionModel$2(tableView$TableViewArrayListSelectionModel, listChangeListener$Change -> this.fireCustomSelectedCellsListChangeEvent(listChangeListener$Change));
        this.selectedCellsSeq = new TableView$TableViewArrayListSelectionModel$3(this);
        ObservableList observableList = this.getTableView().getItems();
        if (observableList != null) {
            observableList.addListener(this.weakItemsContentListener);
        }
        this.updateItemCount();
        this.updateDefaultSelection();
        this.cellSelectionEnabledProperty().addListener(observable -> {
            this.updateDefaultSelection();
            TableCellBehaviorBase.setAnchor(tableView, this.getFocusedCell(), true);
        });
    }

    private void dispose() {
        this.tableView.itemsProperty().removeListener(this.itemsPropertyListener);
        ObservableList observableList = this.getTableView().getItems();
        if (observableList != null) {
            observableList.removeListener(this.weakItemsContentListener);
        }
    }

    @Override
    public ObservableList<TablePosition> getSelectedCells() {
        return this.selectedCellsSeq;
    }

    private void updateSelection(ListChangeListener$Change<? extends S> listChangeListener$Change) {
        Object object;
        listChangeListener$Change.reset();
        int n2 = 0;
        int n3 = -1;
        while (listChangeListener$Change.next()) {
            int n4;
            int n5;
            if (listChangeListener$Change.wasReplaced()) {
                if (listChangeListener$Change.getList().isEmpty()) {
                    ((SelectionModel)this).clearSelection();
                    continue;
                }
                n5 = this.getSelectedIndex();
                if (this.previousModelSize != listChangeListener$Change.getRemovedSize() && n5 < this.getItemCount() && n5 >= 0) {
                    this.startAtomic();
                    ((SelectionModel)this).clearSelection(n5);
                    this.stopAtomic();
                    ((SelectionModel)this).select(n5);
                    continue;
                }
                ((SelectionModel)this).clearSelection();
                continue;
            }
            if (listChangeListener$Change.wasAdded() || listChangeListener$Change.wasRemoved()) {
                n3 = listChangeListener$Change.getFrom();
                n2 += listChangeListener$Change.wasAdded() ? listChangeListener$Change.getAddedSize() : -listChangeListener$Change.getRemovedSize();
                continue;
            }
            if (!listChangeListener$Change.wasPermutated()) continue;
            this.startAtomic();
            n5 = this.getSelectedIndex();
            int n6 = listChangeListener$Change.getTo() - listChangeListener$Change.getFrom();
            object = new HashMap<Integer, Integer>(n6);
            for (int i2 = listChangeListener$Change.getFrom(); i2 < listChangeListener$Change.getTo(); ++i2) {
                ((HashMap)object).put(i2, listChangeListener$Change.getPermutation(i2));
            }
            ArrayList<TablePosition> arrayList = new ArrayList<TablePosition>(((TableView$TableViewSelectionModel)this).getSelectedCells());
            ArrayList arrayList2 = new ArrayList(arrayList.size());
            boolean bl2 = false;
            for (n4 = 0; n4 < arrayList.size(); ++n4) {
                TablePosition tablePosition = (TablePosition)arrayList.get(n4);
                int n7 = tablePosition.getRow();
                if (!((HashMap)object).containsKey(n7)) continue;
                int n8 = (Integer)((HashMap)object).get(n7);
                bl2 = bl2 || n8 != n7;
                arrayList2.add(new TablePosition(tablePosition.getTableView(), n8, tablePosition.getTableColumn()));
            }
            if (bl2) {
                this.quietClearSelection();
                this.stopAtomic();
                this.selectedCellsMap.setAll(arrayList2);
                if (n5 < 0 || n5 >= this.itemCount) continue;
                n4 = listChangeListener$Change.getPermutation(n5);
                this.setSelectedIndex(n4);
                this.focus(n4);
                continue;
            }
            this.stopAtomic();
        }
        TablePosition tablePosition = TableCellBehavior.getAnchor(this.tableView, null);
        if (n2 != 0 && n3 >= 0 && tablePosition != null && tablePosition.getRow() >= n3 && (listChangeListener$Change.wasRemoved() || listChangeListener$Change.wasAdded()) && ((TableView$TableViewSelectionModel)this).isSelected(tablePosition.getRow(), tablePosition.getTableColumn())) {
            object = new TablePosition(this.tableView, tablePosition.getRow() + n2, tablePosition.getTableColumn());
            TableCellBehavior.setAnchor(this.tableView, object, false);
        }
        this.shiftSelection(n3, n2, new TableView$TableViewArrayListSelectionModel$4(this));
        this.previousModelSize = this.getItemCount();
    }

    @Override
    public void clearAndSelect(int n2) {
        ((TableView$TableViewSelectionModel)this).clearAndSelect(n2, null);
    }

    @Override
    public void clearAndSelect(int n2, TableColumn<S, ?> object2) {
        ListChangeListener$Change<TablePosition> listChangeListener$Change;
        if (n2 < 0 || n2 >= this.getItemCount()) {
            return;
        }
        TablePosition tablePosition = new TablePosition(this.getTableView(), n2, object2);
        boolean bl2 = this.isCellSelectionEnabled();
        TableCellBehavior.setAnchor(this.tableView, tablePosition, false);
        ArrayList arrayList = new ArrayList(this.selectedCellsMap.getSelectedCells());
        boolean bl3 = ((TableView$TableViewSelectionModel)this).isSelected(n2, object2);
        if (bl3 && arrayList.size() == 1) {
            listChangeListener$Change = (TablePosition)((TableView$TableViewSelectionModel)this).getSelectedCells().get(0);
            if (this.getSelectedItem() == this.getModelItem(n2) && ((TablePositionBase)((Object)listChangeListener$Change)).getRow() == n2 && ((TablePosition)((Object)listChangeListener$Change)).getTableColumn() == object2) {
                return;
            }
        }
        this.startAtomic();
        ((SelectionModel)this).clearSelection();
        ((TableView$TableViewSelectionModel)this).select(n2, object2);
        this.stopAtomic();
        if (bl2) {
            arrayList.remove(tablePosition);
        } else {
            for (TablePosition tablePosition2 : arrayList) {
                if (tablePosition2.getRow() != n2) continue;
                arrayList.remove(tablePosition2);
                break;
            }
        }
        if (bl3) {
            listChangeListener$Change = ControlUtils.buildClearAndSelectChange(this.selectedCellsSeq, arrayList, tablePosition, Comparator.comparing(TablePositionBase::getRow));
        } else {
            int n3 = bl2 ? 0 : Math.max(0, this.selectedCellsSeq.indexOf(tablePosition));
            n2 = bl2 ? ((TableView$TableViewSelectionModel)this).getSelectedCells().size() : 1;
            int n4 = n3;
            listChangeListener$Change = new NonIterableChange$GenericAddRemoveChange(n4, n4 + n2, arrayList, this.selectedCellsSeq);
        }
        this.fireCustomSelectedCellsListChangeEvent(listChangeListener$Change);
    }

    @Override
    public void select(int n2) {
        ((TableView$TableViewSelectionModel)this).select(n2, null);
    }

    @Override
    public void select(int n2, TableColumn<S, ?> object) {
        if (n2 < 0 || n2 >= this.getItemCount()) {
            return;
        }
        if (this.isCellSelectionEnabled() && object == null) {
            object = this.getTableView().getVisibleLeafColumns();
            for (int i2 = 0; i2 < object.size(); ++i2) {
                ((TableView$TableViewSelectionModel)this).select(n2, (TableColumn)object.get(i2));
            }
            return;
        }
        if (TableCellBehavior.hasDefaultAnchor(this.tableView)) {
            TableCellBehavior.removeAnchor(this.tableView);
        }
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
        }
        this.selectedCellsMap.add(new TablePosition(this.getTableView(), n2, object));
        this.updateSelectedIndex(n2);
        this.focus(n2, object);
    }

    @Override
    public void select(S s2) {
        if (s2 == null && this.getSelectionMode() == SelectionMode.SINGLE) {
            ((SelectionModel)this).clearSelection();
            return;
        }
        for (int i2 = 0; i2 < this.getItemCount(); ++i2) {
            Object s3 = this.getModelItem(i2);
            if (s3 == null || !s3.equals(s2)) continue;
            if (((SelectionModel)this).isSelected(i2)) {
                return;
            }
            if (this.getSelectionMode() == SelectionMode.SINGLE) {
                this.quietClearSelection();
            }
            ((SelectionModel)this).select(i2);
            return;
        }
        this.setSelectedIndex(-1);
        this.setSelectedItem(s2);
    }

    @Override
    public void selectIndices(int n2, int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            ((SelectionModel)this).select(n2);
            return;
        }
        int n3 = this.getItemCount();
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
            for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
                int n4 = nArray[i2];
                if (n4 < 0 || n4 >= n3) continue;
                ((SelectionModel)this).select(n4);
                break;
            }
            if (this.selectedCellsMap.isEmpty() && n2 > 0 && n2 < n3) {
                ((SelectionModel)this).select(n2);
                return;
            }
        } else {
            int n5;
            int n6 = -1;
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            if (n2 >= 0 && n2 < n3) {
                if (this.isCellSelectionEnabled()) {
                    ObservableList observableList = this.getTableView().getVisibleLeafColumns();
                    for (n5 = 0; n5 < observableList.size(); ++n5) {
                        if (this.selectedCellsMap.isSelected(n2, n5)) continue;
                        linkedHashSet.add(new TablePosition(this.getTableView(), n2, (TableColumn)observableList.get(n5)));
                    }
                } else {
                    boolean bl2 = this.selectedCellsMap.isSelected(n2, -1);
                    if (!bl2) {
                        linkedHashSet.add(new TablePosition(this.getTableView(), n2, null));
                    }
                }
                n6 = n2;
            }
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                n5 = nArray[i3];
                if (n5 < 0 || n5 >= n3) continue;
                n6 = n5;
                if (this.isCellSelectionEnabled()) {
                    ObservableList observableList = this.getTableView().getVisibleLeafColumns();
                    for (int i4 = 0; i4 < observableList.size(); ++i4) {
                        if (this.selectedCellsMap.isSelected(n5, i4)) continue;
                        linkedHashSet.add(new TablePosition(this.getTableView(), n5, (TableColumn)observableList.get(i4)));
                        n6 = n5;
                    }
                    continue;
                }
                if (this.selectedCellsMap.isSelected(n5, -1)) continue;
                linkedHashSet.add(new TablePosition(this.getTableView(), n5, null));
            }
            this.selectedCellsMap.addAll(linkedHashSet);
            if (n6 != -1) {
                ((SelectionModel)this).select(n6);
            }
        }
    }

    @Override
    public void selectAll() {
        int n2;
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            return;
        }
        if (this.isCellSelectionEnabled()) {
            ArrayList arrayList = new ArrayList();
            TablePosition tablePosition = null;
            for (int i2 = 0; i2 < this.getTableView().getVisibleLeafColumns().size(); ++i2) {
                TableColumn tableColumn = (TableColumn)this.getTableView().getVisibleLeafColumns().get(i2);
                for (int i3 = 0; i3 < this.getItemCount(); ++i3) {
                    tablePosition = new TablePosition(this.getTableView(), i3, tableColumn);
                    arrayList.add(tablePosition);
                }
            }
            this.selectedCellsMap.setAll(arrayList);
            if (tablePosition != null) {
                ((TableView$TableViewSelectionModel)this).select(tablePosition.getRow(), tablePosition.getTableColumn());
                this.focus(tablePosition.getRow(), tablePosition.getTableColumn());
            }
            return;
        }
        ArrayList arrayList = new ArrayList();
        for (n2 = 0; n2 < this.getItemCount(); ++n2) {
            arrayList.add(new TablePosition(this.getTableView(), n2, null));
        }
        this.selectedCellsMap.setAll(arrayList);
        n2 = this.getFocusedIndex();
        if (n2 == -1) {
            int n3 = this.getItemCount();
            if (n3 > 0) {
                ((SelectionModel)this).select(n3 - 1);
                ArrayList arrayList2 = arrayList;
                this.focus((TablePosition)arrayList2.get(arrayList2.size() - 1));
            }
            return;
        }
        ((SelectionModel)this).select(n2);
        this.focus(n2);
    }

    @Override
    public void selectRange(int n2, TableColumnBase<S, ?> tableColumnBase, int n3, TableColumnBase<S, ?> tableColumnBase2) {
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
            ((TableSelectionModel)this).select(n3, tableColumnBase2);
            return;
        }
        this.startAtomic();
        int n4 = this.getItemCount();
        boolean bl2 = this.isCellSelectionEnabled();
        int n5 = this.tableView.getVisibleLeafIndex((TableColumn)tableColumnBase);
        int n6 = this.tableView.getVisibleLeafIndex((TableColumn)tableColumnBase2);
        int n7 = Math.min(n5, n6);
        n5 = Math.max(n5, n6);
        n6 = Math.min(n2, n3);
        int n8 = Math.max(n2, n3);
        ArrayList arrayList = new ArrayList();
        while (n6 <= n8) {
            if (n6 >= 0 && n6 < n4) {
                if (!bl2) {
                    arrayList.add(new TablePosition(this.tableView, n6, (TableColumn)tableColumnBase));
                } else {
                    for (int i2 = n7; i2 <= n5; ++i2) {
                        TableColumn<S, ?> tableColumn = this.tableView.getVisibleLeafColumn(i2);
                        if (tableColumn == null && bl2) continue;
                        arrayList.add(new TablePosition(this.tableView, n6, tableColumn));
                    }
                }
            }
            ++n6;
        }
        arrayList.removeAll(((TableView$TableViewSelectionModel)this).getSelectedCells());
        this.selectedCellsMap.addAll(arrayList);
        this.stopAtomic();
        this.updateSelectedIndex(n3);
        this.focus(n3, (TableColumn)tableColumnBase2);
        TableColumn tableColumn = (TableColumn)tableColumnBase;
        TableColumn tableColumn2 = bl2 ? (TableColumn)tableColumnBase2 : tableColumn;
        int n9 = this.selectedCellsMap.indexOf(new TablePosition(this.tableView, n2, tableColumn));
        n2 = this.selectedCellsMap.indexOf(new TablePosition(this.tableView, n3, tableColumn2));
        if (n9 >= 0 && n2 >= 0) {
            int n10 = Math.min(n9, n2);
            n2 = Math.max(n9, n2);
            NonIterableChange$SimpleAddChange nonIterableChange$SimpleAddChange = new NonIterableChange$SimpleAddChange(n10, n2 + 1, this.selectedCellsSeq);
            this.fireCustomSelectedCellsListChangeEvent(nonIterableChange$SimpleAddChange);
        }
    }

    @Override
    public void clearSelection(int n2) {
        ((TableView$TableViewSelectionModel)this).clearSelection(n2, null);
    }

    @Override
    public void clearSelection(int n2, TableColumn<S, ?> tableColumn) {
        this.clearSelection(new TablePosition(this.getTableView(), n2, tableColumn));
    }

    private void clearSelection(TablePosition<S, ?> tablePosition) {
        boolean bl2 = this.isCellSelectionEnabled();
        int n2 = tablePosition.getRow();
        boolean bl3 = tablePosition.getTableColumn() == null;
        ArrayList arrayList = new ArrayList();
        for (TablePosition tablePosition2 : ((TableView$TableViewSelectionModel)this).getSelectedCells()) {
            if (!bl2) {
                if (tablePosition2.getRow() != n2) continue;
                arrayList.add(tablePosition2);
                break;
            }
            if (bl3 && tablePosition2.getRow() == n2) {
                arrayList.add(tablePosition2);
                continue;
            }
            if (!tablePosition2.equals(tablePosition)) continue;
            arrayList.add(tablePosition);
            break;
        }
        arrayList.stream().forEach(this.selectedCellsMap::remove);
        if (((SelectionModel)this).isEmpty() && !this.isAtomic()) {
            this.updateSelectedIndex(-1);
            this.selectedCellsMap.clear();
        }
    }

    @Override
    public void clearSelection() {
        Object object = new ArrayList<TablePosition>(((TableView$TableViewSelectionModel)this).getSelectedCells());
        this.quietClearSelection();
        if (!this.isAtomic()) {
            this.updateSelectedIndex(-1);
            this.focus(-1);
            if (!object.isEmpty()) {
                object = new TableView$TableViewArrayListSelectionModel$5(this, 0, 0, this.selectedCellsSeq, (List)object);
                this.fireCustomSelectedCellsListChangeEvent((ListChangeListener$Change<? extends TablePosition<S, ?>>)object);
            }
        }
    }

    private void quietClearSelection() {
        this.startAtomic();
        this.selectedCellsMap.clear();
        this.stopAtomic();
    }

    @Override
    public boolean isSelected(int n2, TableColumn<S, ?> tableColumn) {
        int n3 = this.isCellSelectionEnabled();
        if (n3 != 0 && tableColumn == null) {
            int n4 = this.tableView.getVisibleLeafColumns().size();
            for (n3 = 0; n3 < n4; ++n3) {
                if (this.selectedCellsMap.isSelected(n2, n3)) continue;
                return false;
            }
            return true;
        }
        int n5 = n3 == 0 || tableColumn == null ? -1 : this.tableView.getVisibleLeafIndex(tableColumn);
        return this.selectedCellsMap.isSelected(n2, n5);
    }

    @Override
    public boolean isEmpty() {
        return this.selectedCellsMap.isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void selectPrevious() {
        if (this.isCellSelectionEnabled()) {
            TablePosition tablePosition = this.getFocusedCell();
            if (((TablePositionBase)tablePosition).getColumn() - 1 >= 0) {
                ((TableView$TableViewSelectionModel)this).select(tablePosition.getRow(), this.getTableColumn((TableColumn<S, ?>)tablePosition.getTableColumn(), -1));
                return;
            }
            if (tablePosition.getRow() >= this.getItemCount() - 1) return;
            TableView$TableViewArrayListSelectionModel tableView$TableViewArrayListSelectionModel = this;
            ((TableView$TableViewSelectionModel)this).select(tablePosition.getRow() - 1, tableView$TableViewArrayListSelectionModel.getTableColumn(tableView$TableViewArrayListSelectionModel.getTableView().getVisibleLeafColumns().size() - 1));
            return;
        }
        int n2 = this.getFocusedIndex();
        if (n2 == -1) {
            TableView$TableViewArrayListSelectionModel tableView$TableViewArrayListSelectionModel = this;
            ((SelectionModel)tableView$TableViewArrayListSelectionModel).select(tableView$TableViewArrayListSelectionModel.getItemCount() - 1);
            return;
        }
        if (n2 <= 0) return;
        ((SelectionModel)this).select(n2 - 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void selectNext() {
        if (this.isCellSelectionEnabled()) {
            TablePosition tablePosition = this.getFocusedCell();
            if (((TablePositionBase)tablePosition).getColumn() + 1 < this.getTableView().getVisibleLeafColumns().size()) {
                ((TableView$TableViewSelectionModel)this).select(tablePosition.getRow(), this.getTableColumn((TableColumn<S, ?>)tablePosition.getTableColumn(), 1));
                return;
            }
            if (tablePosition.getRow() >= this.getItemCount() - 1) return;
            ((TableView$TableViewSelectionModel)this).select(tablePosition.getRow() + 1, this.getTableColumn(0));
            return;
        }
        int n2 = this.getFocusedIndex();
        if (n2 == -1) {
            ((SelectionModel)this).select(0);
            return;
        }
        if (n2 >= this.getItemCount() - 1) return;
        ((SelectionModel)this).select(n2 + 1);
    }

    @Override
    public void selectAboveCell() {
        TablePosition tablePosition = this.getFocusedCell();
        if (tablePosition.getRow() == -1) {
            TableView$TableViewArrayListSelectionModel tableView$TableViewArrayListSelectionModel = this;
            ((SelectionModel)tableView$TableViewArrayListSelectionModel).select(tableView$TableViewArrayListSelectionModel.getItemCount() - 1);
            return;
        }
        if (tablePosition.getRow() > 0) {
            ((TableView$TableViewSelectionModel)this).select(tablePosition.getRow() - 1, tablePosition.getTableColumn());
        }
    }

    @Override
    public void selectBelowCell() {
        TablePosition tablePosition = this.getFocusedCell();
        if (tablePosition.getRow() == -1) {
            ((SelectionModel)this).select(0);
            return;
        }
        if (tablePosition.getRow() < this.getItemCount() - 1) {
            ((TableView$TableViewSelectionModel)this).select(tablePosition.getRow() + 1, tablePosition.getTableColumn());
        }
    }

    @Override
    public void selectFirst() {
        TablePosition tablePosition = this.getFocusedCell();
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
        }
        if (this.getItemCount() > 0) {
            if (this.isCellSelectionEnabled()) {
                ((TableView$TableViewSelectionModel)this).select(0, tablePosition.getTableColumn());
                return;
            }
            ((SelectionModel)this).select(0);
        }
    }

    @Override
    public void selectLast() {
        int n2;
        TablePosition tablePosition = this.getFocusedCell();
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
        }
        if ((n2 = this.getItemCount()) > 0 && this.getSelectedIndex() < n2 - 1) {
            if (this.isCellSelectionEnabled()) {
                ((TableView$TableViewSelectionModel)this).select(n2 - 1, tablePosition.getTableColumn());
                return;
            }
            ((SelectionModel)this).select(n2 - 1);
        }
    }

    @Override
    public void selectLeftCell() {
        if (!this.isCellSelectionEnabled()) {
            return;
        }
        TablePosition tablePosition = this.getFocusedCell();
        if (((TablePositionBase)tablePosition).getColumn() - 1 >= 0) {
            ((TableView$TableViewSelectionModel)this).select(tablePosition.getRow(), this.getTableColumn((TableColumn<S, ?>)tablePosition.getTableColumn(), -1));
        }
    }

    @Override
    public void selectRightCell() {
        if (!this.isCellSelectionEnabled()) {
            return;
        }
        TablePosition tablePosition = this.getFocusedCell();
        if (((TablePositionBase)tablePosition).getColumn() + 1 < this.getTableView().getVisibleLeafColumns().size()) {
            ((TableView$TableViewSelectionModel)this).select(tablePosition.getRow(), this.getTableColumn((TableColumn<S, ?>)tablePosition.getTableColumn(), 1));
        }
    }

    private void updateItemsObserver(ObservableList<S> observableList, ObservableList<S> observableList2) {
        if (observableList != null) {
            observableList.removeListener(this.weakItemsContentListener);
        }
        if (observableList2 != null) {
            observableList2.addListener(this.weakItemsContentListener);
        }
        this.updateItemCount();
        this.updateDefaultSelection();
    }

    private void updateDefaultSelection() {
        Object t2;
        int n2 = -1;
        if (this.tableView.getItems() != null && (t2 = this.getSelectedItem()) != null) {
            n2 = this.tableView.getItems().indexOf(t2);
        }
        ((SelectionModel)this).clearSelection();
        ((TableView$TableViewSelectionModel)this).select(n2, this.isCellSelectionEnabled() ? this.getTableColumn(0) : null);
    }

    private TableColumn<S, ?> getTableColumn(int n2) {
        return this.getTableView().getVisibleLeafColumn(n2);
    }

    private TableColumn<S, ?> getTableColumn(TableColumn<S, ?> tableColumn, int n2) {
        int n3 = this.getTableView().getVisibleLeafIndex(tableColumn);
        return this.getTableView().getVisibleLeafColumn(n3 += n2);
    }

    private void updateSelectedIndex(int n2) {
        this.setSelectedIndex(n2);
        TableView$TableViewArrayListSelectionModel tableView$TableViewArrayListSelectionModel = this;
        tableView$TableViewArrayListSelectionModel.setSelectedItem(tableView$TableViewArrayListSelectionModel.getModelItem(n2));
    }

    @Override
    protected int getItemCount() {
        return this.itemCount;
    }

    private void updateItemCount() {
        int n2;
        if (this.tableView == null) {
            v0 = this;
            n2 = -1;
        } else {
            List list = this.getTableModel();
            v0 = this;
            n2 = list == null ? -1 : list.size();
        }
        v0.itemCount = n2;
    }

    private void fireCustomSelectedCellsListChangeEvent(ListChangeListener$Change<? extends TablePosition<S, ?>> listChangeListener$Change) {
        IntPredicate intPredicate = n2 -> !this.isCellSelectionEnabled() || ((TableView$TableViewSelectionModel)this).getSelectedCells().stream().noneMatch(tablePosition -> tablePosition.getRow() == n2);
        TableView$TableViewArrayListSelectionModel tableView$TableViewArrayListSelectionModel = this;
        ControlUtils.updateSelectedIndices(tableView$TableViewArrayListSelectionModel, tableView$TableViewArrayListSelectionModel.isCellSelectionEnabled(), listChangeListener$Change, intPredicate);
        if (this.isAtomic()) {
            return;
        }
        this.selectedCellsSeq.callObservers(new MappingChange(listChangeListener$Change, Function.identity(), this.selectedCellsSeq));
    }
}

