/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.AccessibleAttribute;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.control.TableView;

public abstract class TableView$TableViewSelectionModel<S>
extends TableSelectionModel<S> {
    private final TableView<S> tableView;
    boolean blockFocusCall = false;

    public TableView$TableViewSelectionModel(TableView<S> tableView) {
        if (tableView == null) {
            throw new NullPointerException("TableView can not be null");
        }
        this.tableView = tableView;
    }

    public abstract ObservableList<TablePosition> getSelectedCells();

    @Override
    public boolean isSelected(int n2, TableColumnBase<S, ?> tableColumnBase) {
        return this.isSelected(n2, (TableColumn)tableColumnBase);
    }

    @Override
    public abstract boolean isSelected(int var1, TableColumn<S, ?> var2);

    @Override
    public void select(int n2, TableColumnBase<S, ?> tableColumnBase) {
        this.select(n2, (TableColumn)tableColumnBase);
    }

    @Override
    public abstract void select(int var1, TableColumn<S, ?> var2);

    @Override
    public void clearAndSelect(int n2, TableColumnBase<S, ?> tableColumnBase) {
        this.clearAndSelect(n2, (TableColumn)tableColumnBase);
    }

    @Override
    public abstract void clearAndSelect(int var1, TableColumn<S, ?> var2);

    @Override
    public void clearSelection(int n2, TableColumnBase<S, ?> tableColumnBase) {
        this.clearSelection(n2, (TableColumn)tableColumnBase);
    }

    @Override
    public abstract void clearSelection(int var1, TableColumn<S, ?> var2);

    @Override
    public void selectRange(int n2, TableColumnBase<S, ?> tableColumnBase, int n3, TableColumnBase<S, ?> tableColumnBase2) {
        int n4 = this.tableView.getVisibleLeafIndex((TableColumn)tableColumnBase);
        int n5 = this.tableView.getVisibleLeafIndex((TableColumn)tableColumnBase2);
        while (n2 <= n3) {
            for (int i2 = n4; i2 <= n5; ++i2) {
                this.select(n2, this.tableView.getVisibleLeafColumn(i2));
            }
            ++n2;
        }
    }

    public TableView<S> getTableView() {
        return this.tableView;
    }

    protected List<S> getTableModel() {
        return this.tableView.getItems();
    }

    @Override
    protected S getModelItem(int n2) {
        if (n2 < 0 || n2 >= this.getItemCount()) {
            return null;
        }
        return (S)this.tableView.getItems().get(n2);
    }

    @Override
    protected int getItemCount() {
        return this.getTableModel().size();
    }

    @Override
    public void focus(int n2) {
        this.focus(n2, null);
    }

    @Override
    public int getFocusedIndex() {
        return this.getFocusedCell().getRow();
    }

    void focus(int n2, TableColumn<S, ?> tableColumn) {
        this.focus(new TablePosition(this.getTableView(), n2, tableColumn));
        this.getTableView().notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUS_ITEM);
    }

    void focus(TablePosition<S, ?> tablePosition) {
        if (this.blockFocusCall) {
            return;
        }
        if (this.getTableView().getFocusModel() == null) {
            return;
        }
        this.getTableView().getFocusModel().focus(tablePosition.getRow(), (TableColumn<S, ?>)tablePosition.getTableColumn());
    }

    TablePosition<S, ?> getFocusedCell() {
        if (this.getTableView().getFocusModel() == null) {
            return new TablePosition(this.getTableView(), -1, null);
        }
        return this.getTableView().getFocusModel().getFocusedCell();
    }
}

