/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.scene.AccessibleRole;
import javafx.scene.control.Skin;
import javafx.scene.control.TextArea$1;
import javafx.scene.control.TextArea$2;
import javafx.scene.control.TextArea$3;
import javafx.scene.control.TextArea$StyleableProperties;
import javafx.scene.control.TextArea$TextAreaContent;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.skin.TextAreaSkin;

public class TextArea
extends TextInputControl {
    public static final int DEFAULT_PREF_COLUMN_COUNT = 40;
    public static final int DEFAULT_PREF_ROW_COUNT = 10;
    private static final int DEFAULT_PARAGRAPH_CAPACITY = 32;
    private BooleanProperty wrapText = new TextArea$1(this, false);
    private IntegerProperty prefColumnCount = new TextArea$2(this, 40);
    private IntegerProperty prefRowCount = new TextArea$3(this, 10);
    private DoubleProperty scrollTop = new SimpleDoubleProperty(this, "scrollTop", 0.0);
    private DoubleProperty scrollLeft = new SimpleDoubleProperty(this, "scrollLeft", 0.0);

    public TextArea() {
        this("");
    }

    public TextArea(String string) {
        super(new TextArea$TextAreaContent());
        this.getStyleClass().add("text-area");
        this.setAccessibleRole(AccessibleRole.TEXT_AREA);
        this.setText(string);
    }

    @Override
    final void textUpdated() {
        this.setScrollTop(0.0);
        this.setScrollLeft(0.0);
    }

    public ObservableList<CharSequence> getParagraphs() {
        return ((TextArea$TextAreaContent)this.getContent()).paragraphList;
    }

    public final BooleanProperty wrapTextProperty() {
        return this.wrapText;
    }

    public final boolean isWrapText() {
        return this.wrapText.getValue();
    }

    public final void setWrapText(boolean bl2) {
        this.wrapText.setValue(bl2);
    }

    public final IntegerProperty prefColumnCountProperty() {
        return this.prefColumnCount;
    }

    public final int getPrefColumnCount() {
        return this.prefColumnCount.getValue();
    }

    public final void setPrefColumnCount(int n2) {
        this.prefColumnCount.setValue(n2);
    }

    public final IntegerProperty prefRowCountProperty() {
        return this.prefRowCount;
    }

    public final int getPrefRowCount() {
        return this.prefRowCount.getValue();
    }

    public final void setPrefRowCount(int n2) {
        this.prefRowCount.setValue(n2);
    }

    public final DoubleProperty scrollTopProperty() {
        return this.scrollTop;
    }

    public final double getScrollTop() {
        return this.scrollTop.getValue();
    }

    public final void setScrollTop(double d2) {
        this.scrollTop.setValue(d2);
    }

    public final DoubleProperty scrollLeftProperty() {
        return this.scrollLeft;
    }

    public final double getScrollLeft() {
        return this.scrollLeft.getValue();
    }

    public final void setScrollLeft(double d2) {
        this.scrollLeft.setValue(d2);
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new TextAreaSkin(this);
    }

    @Override
    String filterInput(String string) {
        return TextInputControl.filterInput(string, false, false);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return TextArea$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return TextArea.getClassCssMetaData();
    }
}

