/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.util.List;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Pos;
import javafx.scene.AccessibleRole;
import javafx.scene.control.Skin;
import javafx.scene.control.TextField$1;
import javafx.scene.control.TextField$2;
import javafx.scene.control.TextField$3;
import javafx.scene.control.TextField$StyleableProperties;
import javafx.scene.control.TextField$TextFieldContent;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.skin.TextFieldSkin;

public class TextField
extends TextInputControl {
    public static final int DEFAULT_PREF_COLUMN_COUNT = 12;
    private IntegerProperty prefColumnCount = new TextField$1(this, 12);
    private ObjectProperty<EventHandler<ActionEvent>> onAction = new TextField$2(this);
    private ObjectProperty<Pos> alignment;

    public TextField() {
        this("");
    }

    public TextField(String string) {
        super(new TextField$TextFieldContent());
        this.getStyleClass().add("text-field");
        this.setAccessibleRole(AccessibleRole.TEXT_FIELD);
        this.setText(string);
    }

    public CharSequence getCharacters() {
        return ((TextField$TextFieldContent)this.getContent()).characters;
    }

    public final IntegerProperty prefColumnCountProperty() {
        return this.prefColumnCount;
    }

    public final int getPrefColumnCount() {
        return this.prefColumnCount.getValue();
    }

    public final void setPrefColumnCount(int n2) {
        this.prefColumnCount.setValue(n2);
    }

    public final ObjectProperty<EventHandler<ActionEvent>> onActionProperty() {
        return this.onAction;
    }

    public final EventHandler<ActionEvent> getOnAction() {
        return (EventHandler)this.onActionProperty().get();
    }

    public final void setOnAction(EventHandler<ActionEvent> eventHandler) {
        this.onActionProperty().set(eventHandler);
    }

    public final ObjectProperty<Pos> alignmentProperty() {
        if (this.alignment == null) {
            this.alignment = new TextField$3(this, Pos.CENTER_LEFT);
        }
        return this.alignment;
    }

    public final void setAlignment(Pos pos) {
        this.alignmentProperty().set(pos);
    }

    public final Pos getAlignment() {
        if (this.alignment == null) {
            return Pos.CENTER_LEFT;
        }
        return (Pos)((Object)this.alignment.get());
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new TextFieldSkin(this);
    }

    @Override
    String filterInput(String string) {
        return TextInputControl.filterInput(string, true, true);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return TextField$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return TextField.getClassCssMetaData();
    }

    static /* synthetic */ void access$000(TextField textField, EventType eventType, EventHandler eventHandler) {
        textField.setEventHandler(eventType, eventHandler);
    }
}

