/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.FormatterAccessor;
import javafx.scene.control.Control;
import javafx.scene.control.IndexRange;

public final class TextFormatter$Change
implements Cloneable {
    private final FormatterAccessor accessor;
    private Control control;
    int start;
    int end;
    String text;
    int anchor;
    int caret;

    TextFormatter$Change(Control control, FormatterAccessor formatterAccessor, int n2, int n3) {
        int n4 = n3;
        this(control, formatterAccessor, n4, n4, "", n2, n3);
    }

    TextFormatter$Change(Control control, FormatterAccessor formatterAccessor, int n2, int n3, String string) {
        this(control, formatterAccessor, n2, n3, string, n2 + string.length(), n2 + string.length());
    }

    TextFormatter$Change(Control control, FormatterAccessor formatterAccessor, int n2, int n3, String string, int n4, int n5) {
        this.control = control;
        this.accessor = formatterAccessor;
        this.start = n2;
        this.end = n3;
        this.text = string;
        this.anchor = n4;
        this.caret = n5;
    }

    public final Control getControl() {
        return this.control;
    }

    public final int getRangeStart() {
        return this.start;
    }

    public final int getRangeEnd() {
        return this.end;
    }

    public final void setRange(int n2, int n3) {
        int n4 = this.accessor.getTextLength();
        if (n2 < 0 || n2 > n4 || n3 < 0 || n3 > n4) {
            throw new IndexOutOfBoundsException();
        }
        this.start = n2;
        this.end = n3;
    }

    public final int getCaretPosition() {
        return this.caret;
    }

    public final int getAnchor() {
        return this.anchor;
    }

    public final int getControlCaretPosition() {
        return this.accessor.getCaret();
    }

    public final int getControlAnchor() {
        return this.accessor.getAnchor();
    }

    public final void selectRange(int n2, int n3) {
        if (n2 < 0 || n2 > this.accessor.getTextLength() - (this.end - this.start) + this.text.length() || n3 < 0 || n3 > this.accessor.getTextLength() - (this.end - this.start) + this.text.length()) {
            throw new IndexOutOfBoundsException();
        }
        this.anchor = n2;
        this.caret = n3;
    }

    public final IndexRange getSelection() {
        return IndexRange.normalize(this.anchor, this.caret);
    }

    public final void setAnchor(int n2) {
        if (n2 < 0 || n2 > this.accessor.getTextLength() - (this.end - this.start) + this.text.length()) {
            throw new IndexOutOfBoundsException();
        }
        this.anchor = n2;
    }

    public final void setCaretPosition(int n2) {
        if (n2 < 0 || n2 > this.accessor.getTextLength() - (this.end - this.start) + this.text.length()) {
            throw new IndexOutOfBoundsException();
        }
        this.caret = n2;
    }

    public final String getText() {
        return this.text;
    }

    public final void setText(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.text = string;
    }

    public final String getControlText() {
        return this.accessor.getText(0, this.accessor.getTextLength());
    }

    public final String getControlNewText() {
        return this.accessor.getText(0, this.start) + this.text + this.accessor.getText(this.end, this.accessor.getTextLength());
    }

    public final boolean isAdded() {
        return !this.text.isEmpty();
    }

    public final boolean isDeleted() {
        return this.start != this.end;
    }

    public final boolean isReplaced() {
        return this.isAdded() && this.isDeleted();
    }

    public final boolean isContentChange() {
        return this.isAdded() || this.isDeleted();
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("TextInputControl.Change [");
        if (this.isReplaced()) {
            stringBuilder.append(" replaced \"").append(this.accessor.getText(this.start, this.end)).append("\" with \"").append(this.text).append("\" at (").append(this.start).append(", ").append(this.end).append(")");
        } else if (this.isDeleted()) {
            stringBuilder.append(" deleted \"").append(this.accessor.getText(this.start, this.end)).append("\" at (").append(this.start).append(", ").append(this.end).append(")");
        } else if (this.isAdded()) {
            stringBuilder.append(" added \"").append(this.text).append("\" at ").append(this.start);
        }
        if (this.isAdded() || this.isDeleted()) {
            stringBuilder.append("; ");
        } else {
            stringBuilder.append(" ");
        }
        stringBuilder.append("new selection (anchor, caret): [").append(this.anchor).append(", ").append(this.caret).append("]");
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }

    public final TextFormatter$Change clone() {
        try {
            return (TextFormatter$Change)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }
}

