/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javafx.beans.NamedArg;
import javafx.beans.property.ObjectProperty;
import javafx.scene.control.TextFormatter$1;
import javafx.scene.control.TextFormatter$2;
import javafx.scene.control.TextFormatter$Change;
import javafx.util.StringConverter;

public class TextFormatter<V> {
    private final StringConverter<V> valueConverter;
    private final UnaryOperator<TextFormatter$Change> filter;
    private Consumer<TextFormatter<?>> textUpdater;
    public static final StringConverter<String> IDENTITY_STRING_CONVERTER = new TextFormatter$1();
    private final ObjectProperty<V> value = new TextFormatter$2(this);

    public TextFormatter(@NamedArg(value="filter") UnaryOperator<TextFormatter$Change> unaryOperator) {
        this(null, null, unaryOperator);
    }

    public TextFormatter(@NamedArg(value="valueConverter") StringConverter<V> stringConverter, @NamedArg(value="defaultValue") V v2, @NamedArg(value="filter") UnaryOperator<TextFormatter$Change> unaryOperator) {
        this.filter = unaryOperator;
        this.valueConverter = stringConverter;
        this.setValue(v2);
    }

    public TextFormatter(@NamedArg(value="valueConverter") StringConverter<V> stringConverter, @NamedArg(value="defaultValue") V v2) {
        this(stringConverter, v2, null);
    }

    public TextFormatter(@NamedArg(value="valueConverter") StringConverter<V> stringConverter) {
        this(stringConverter, null, null);
    }

    public final StringConverter<V> getValueConverter() {
        return this.valueConverter;
    }

    public final UnaryOperator<TextFormatter$Change> getFilter() {
        return this.filter;
    }

    public final ObjectProperty<V> valueProperty() {
        return this.value;
    }

    public final void setValue(V v2) {
        if (this.valueConverter == null && v2 != null) {
            throw new IllegalStateException("Value changes are not supported when valueConverter is not set");
        }
        this.value.set(v2);
    }

    public final V getValue() {
        return (V)this.value.get();
    }

    private void updateText() {
        if (this.textUpdater != null) {
            this.textUpdater.accept(this);
        }
    }

    void bindToControl(Consumer<TextFormatter<?>> consumer) {
        if (this.textUpdater != null) {
            throw new IllegalStateException("Formatter is already used in other control");
        }
        this.textUpdater = consumer;
    }

    void unbindFromControl() {
        this.textUpdater = null;
    }

    void updateValue(String string) {
        if (this.valueConverter != null && !this.value.isBound()) {
            try {
                string = this.valueConverter.fromString(string);
                this.setValue(string);
                return;
            }
            catch (Exception exception) {
                this.updateText();
            }
        }
    }
}

