/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.FormatterAccessor;
import com.sun.javafx.util.Utils;
import java.text.BreakIterator;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.control.Control;
import javafx.scene.control.IndexRange;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TextFormatter$Change;
import javafx.scene.control.TextInputControl$1;
import javafx.scene.control.TextInputControl$2;
import javafx.scene.control.TextInputControl$3;
import javafx.scene.control.TextInputControl$4;
import javafx.scene.control.TextInputControl$5;
import javafx.scene.control.TextInputControl$6;
import javafx.scene.control.TextInputControl$Content;
import javafx.scene.control.TextInputControl$StyleableProperties;
import javafx.scene.control.TextInputControl$TextInputControlFromatterAccessor;
import javafx.scene.control.TextInputControl$TextProperty;
import javafx.scene.control.TextInputControl$UndoRedoChange;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.text.Font;
import javafx.util.StringConverter;

@DefaultProperty(value="text")
public abstract class TextInputControl
extends Control {
    private boolean blockSelectedTextUpdate;
    private ObjectProperty<Font> font;
    private StringProperty promptText;
    private final ObjectProperty<TextFormatter<?>> textFormatter;
    private final TextInputControl$Content content;
    private TextInputControl$TextProperty text;
    private ReadOnlyIntegerWrapper length;
    private BooleanProperty editable;
    private ReadOnlyObjectWrapper<IndexRange> selection;
    private ReadOnlyStringWrapper selectedText;
    private ReadOnlyIntegerWrapper anchor;
    private ReadOnlyIntegerWrapper caretPosition;
    private TextInputControl$UndoRedoChange undoChangeHead;
    private TextInputControl$UndoRedoChange undoChange;
    private boolean createNewUndoRecord;
    private final ReadOnlyBooleanWrapper undoable;
    private final ReadOnlyBooleanWrapper redoable;
    private BreakIterator charIterator;
    private BreakIterator wordIterator;
    private FormatterAccessor accessor;
    private static final PseudoClass PSEUDO_CLASS_READONLY = PseudoClass.getPseudoClass("readonly");

    protected TextInputControl(TextInputControl$Content textInputControl$Content) {
        TextInputControl textInputControl = this;
        this.promptText = new TextInputControl$3(textInputControl, textInputControl, "promptText", "");
        this.textFormatter = new TextInputControl$4(this);
        this.text = new TextInputControl$TextProperty(this);
        this.length = new ReadOnlyIntegerWrapper(this, "length");
        TextInputControl textInputControl2 = this;
        this.editable = new TextInputControl$5(textInputControl2, textInputControl2, "editable", true);
        this.selection = new ReadOnlyObjectWrapper<IndexRange>(this, "selection", new IndexRange(0, 0));
        this.selectedText = new ReadOnlyStringWrapper(this, "selectedText");
        this.anchor = new ReadOnlyIntegerWrapper(this, "anchor", 0);
        this.caretPosition = new ReadOnlyIntegerWrapper(this, "caretPosition", 0);
        this.undoChange = this.undoChangeHead = new TextInputControl$UndoRedoChange();
        this.createNewUndoRecord = false;
        this.undoable = new ReadOnlyBooleanWrapper(this, "undoable", false);
        this.redoable = new ReadOnlyBooleanWrapper(this, "redoable", false);
        this.content = textInputControl$Content;
        textInputControl$Content.addListener(observable -> {
            if (textInputControl$Content.length() > 0) {
                this.text.textIsNull = false;
            }
            this.text.controlContentHasChanged();
        });
        this.length.bind(new TextInputControl$1(this));
        this.selection.addListener((observableValue, indexRange, indexRange2) -> this.updateSelectedText());
        this.text.addListener((ChangeListener<? super String>)((ChangeListener<String>)(observableValue, string, string2) -> this.updateSelectedText()));
        this.focusedProperty().addListener((observableValue, bl2, bl3) -> {
            if (bl3.booleanValue()) {
                if (this.getTextFormatter() != null) {
                    TextInputControl textInputControl = this;
                    textInputControl.updateText(textInputControl.getTextFormatter());
                    return;
                }
            } else {
                this.commitValue();
            }
        });
        this.getStyleClass().add("text-input");
    }

    private void updateSelectedText() {
        if (!this.blockSelectedTextUpdate) {
            int n2;
            String string = this.text.get();
            IndexRange indexRange = (IndexRange)this.selection.get();
            if (string == null || indexRange == null) {
                this.selectedText.set("");
                return;
            }
            int n3 = indexRange.getStart();
            int n4 = indexRange.getEnd();
            if (n4 > n3 + (n2 = string.length())) {
                n4 = n2;
            }
            if (n3 > n2 - 1) {
                n4 = 0;
                n3 = 0;
            }
            this.selectedText.set(string.substring(n3, n4));
        }
    }

    public final ObjectProperty<Font> fontProperty() {
        if (this.font == null) {
            this.font = new TextInputControl$2(this, Font.getDefault());
        }
        return this.font;
    }

    public final void setFont(Font font) {
        this.fontProperty().setValue(font);
    }

    public final Font getFont() {
        if (this.font == null) {
            return Font.getDefault();
        }
        return (Font)this.font.getValue();
    }

    public final StringProperty promptTextProperty() {
        return this.promptText;
    }

    public final String getPromptText() {
        return (String)this.promptText.get();
    }

    public final void setPromptText(String string) {
        this.promptText.set(string);
    }

    public final ObjectProperty<TextFormatter<?>> textFormatterProperty() {
        return this.textFormatter;
    }

    public final TextFormatter<?> getTextFormatter() {
        return (TextFormatter)this.textFormatter.get();
    }

    public final void setTextFormatter(TextFormatter<?> textFormatter) {
        this.textFormatter.set(textFormatter);
    }

    protected final TextInputControl$Content getContent() {
        return this.content;
    }

    public final String getText() {
        return this.text.get();
    }

    public final void setText(String string) {
        this.text.set(string);
    }

    public final StringProperty textProperty() {
        return this.text;
    }

    public final int getLength() {
        return this.length.get();
    }

    public final ReadOnlyIntegerProperty lengthProperty() {
        return this.length.getReadOnlyProperty();
    }

    public final boolean isEditable() {
        return this.editable.getValue();
    }

    public final void setEditable(boolean bl2) {
        this.editable.setValue(bl2);
    }

    public final BooleanProperty editableProperty() {
        return this.editable;
    }

    public final IndexRange getSelection() {
        return (IndexRange)this.selection.getValue();
    }

    public final ReadOnlyObjectProperty<IndexRange> selectionProperty() {
        return this.selection.getReadOnlyProperty();
    }

    public final String getSelectedText() {
        return this.selectedText.get();
    }

    public final ReadOnlyStringProperty selectedTextProperty() {
        return this.selectedText.getReadOnlyProperty();
    }

    public final int getAnchor() {
        return this.anchor.get();
    }

    public final ReadOnlyIntegerProperty anchorProperty() {
        return this.anchor.getReadOnlyProperty();
    }

    public final int getCaretPosition() {
        return this.caretPosition.get();
    }

    public final ReadOnlyIntegerProperty caretPositionProperty() {
        return this.caretPosition.getReadOnlyProperty();
    }

    public final boolean isUndoable() {
        return this.undoable.get();
    }

    public final ReadOnlyBooleanProperty undoableProperty() {
        return this.undoable.getReadOnlyProperty();
    }

    public final boolean isRedoable() {
        return this.redoable.get();
    }

    public final ReadOnlyBooleanProperty redoableProperty() {
        return this.redoable.getReadOnlyProperty();
    }

    public String getText(int n2, int n3) {
        if (n2 > n3) {
            throw new IllegalArgumentException("The start must be <= the end");
        }
        if (n2 < 0 || n3 > this.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        return this.getContent().get(n2, n3);
    }

    public void appendText(String string) {
        TextInputControl textInputControl = this;
        textInputControl.insertText(textInputControl.getLength(), string);
    }

    public void insertText(int n2, String string) {
        int n3 = n2;
        this.replaceText(n3, n3, string);
    }

    public void deleteText(IndexRange indexRange) {
        this.replaceText(indexRange, "");
    }

    public void deleteText(int n2, int n3) {
        this.replaceText(n2, n3, "");
    }

    public void replaceText(IndexRange indexRange, String string) {
        int n2 = indexRange.getStart();
        int n3 = n2 + indexRange.getLength();
        this.replaceText(n2, n3, string);
    }

    public void replaceText(int n2, int n3, String string) {
        if (n2 > n3) {
            throw new IllegalArgumentException();
        }
        if (string == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 > this.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.text.isBound()) {
            TextFormatter$Change textFormatter$Change;
            int n4 = this.getLength();
            TextFormatter<?> textFormatter = this.getTextFormatter();
            if (textFormatter != null && textFormatter.getFilter() != null) {
                TextInputControl textInputControl = this;
                textFormatter$Change = new TextFormatter$Change(textInputControl, textInputControl.getFormatterAccessor(), n2, n3, string);
                textFormatter$Change = (TextFormatter$Change)textFormatter.getFilter().apply(textFormatter$Change);
                if (textFormatter$Change == null) {
                    return;
                }
            } else {
                TextInputControl textInputControl = this;
                textFormatter$Change = new TextFormatter$Change(textInputControl, textInputControl.getFormatterAccessor(), n2, n3, this.filterInput(string));
            }
            this.updateContent(textFormatter$Change, n4 == 0);
        }
    }

    private void updateContent(TextFormatter$Change textFormatter$Change, boolean bl2) {
        boolean bl3 = this.getSelection().getLength() > 0;
        String string = this.getText(textFormatter$Change.start, textFormatter$Change.end);
        int n2 = this.replaceText(textFormatter$Change.start, textFormatter$Change.end, textFormatter$Change.text, textFormatter$Change.getAnchor(), textFormatter$Change.getCaretPosition());
        String string2 = this.getText(textFormatter$Change.start, textFormatter$Change.start + textFormatter$Change.text.length() - n2);
        if (string2.equals(string)) {
            return;
        }
        int n3 = this.undoChange == this.undoChangeHead ? -1 : this.undoChange.start + this.undoChange.newText.length();
        boolean bl4 = false;
        if (string2.equals(" ")) {
            if (!TextInputControl$UndoRedoChange.isSpaceCharSequence()) {
                bl4 = true;
                TextInputControl$UndoRedoChange.setSpaceCharSequence(true);
            }
        } else {
            TextInputControl$UndoRedoChange.setSpaceCharSequence(false);
        }
        if (this.createNewUndoRecord || bl3 || n3 == -1 || bl2 || bl4 || TextInputControl$UndoRedoChange.hasChangeDurationElapsed() || n3 != textFormatter$Change.start && n3 != textFormatter$Change.end || textFormatter$Change.end - textFormatter$Change.start > 0) {
            this.undoChange = this.undoChange.add(textFormatter$Change.start, string, string2);
        } else if (textFormatter$Change.start != textFormatter$Change.end && textFormatter$Change.text.isEmpty()) {
            if (this.undoChange.newText.length() > 0) {
                this.undoChange.newText = this.undoChange.newText.substring(0, textFormatter$Change.start - this.undoChange.start);
                if (this.undoChange.newText.isEmpty()) {
                    this.undoChange = this.undoChange.discard();
                }
            } else if (textFormatter$Change.start == n3) {
                this.undoChange.oldText = this.undoChange.oldText + string;
            } else {
                this.undoChange.oldText = string + this.undoChange.oldText;
                --this.undoChange.start;
            }
        } else {
            this.undoChange.newText = this.undoChange.newText + string2;
        }
        this.updateUndoRedoState();
    }

    public void cut() {
        this.copy();
        IndexRange indexRange = this.getSelection();
        this.deleteText(indexRange.getStart(), indexRange.getEnd());
    }

    public void copy() {
        String string = this.getSelectedText();
        if (string.length() > 0) {
            ClipboardContent clipboardContent = new ClipboardContent();
            clipboardContent.putString(string);
            Clipboard.getSystemClipboard().setContent(clipboardContent);
        }
    }

    public void paste() {
        Object object = Clipboard.getSystemClipboard();
        if (((Clipboard)object).hasString() && (object = ((Clipboard)object).getString()) != null) {
            this.createNewUndoRecord = true;
            try {
                this.replaceSelection((String)object);
                return;
            }
            finally {
                this.createNewUndoRecord = false;
            }
        }
    }

    public void selectBackward() {
        if (this.getCaretPosition() > 0 && this.getLength() > 0) {
            if (this.charIterator == null) {
                this.charIterator = BreakIterator.getCharacterInstance();
            }
            this.charIterator.setText(this.getText());
            TextInputControl textInputControl = this;
            textInputControl.selectRange(textInputControl.getAnchor(), this.charIterator.preceding(this.getCaretPosition()));
        }
    }

    public void selectForward() {
        int n2 = this.getLength();
        if (n2 > 0 && this.getCaretPosition() < n2) {
            if (this.charIterator == null) {
                this.charIterator = BreakIterator.getCharacterInstance();
            }
            this.charIterator.setText(this.getText());
            TextInputControl textInputControl = this;
            textInputControl.selectRange(textInputControl.getAnchor(), this.charIterator.following(this.getCaretPosition()));
        }
    }

    public void previousWord() {
        this.previousWord(false);
    }

    public void nextWord() {
        this.nextWord(false);
    }

    public void endOfNextWord() {
        this.endOfNextWord(false);
    }

    public void selectPreviousWord() {
        this.previousWord(true);
    }

    public void selectNextWord() {
        this.nextWord(true);
    }

    public void selectEndOfNextWord() {
        this.endOfNextWord(true);
    }

    private void previousWord(boolean bl2) {
        int n2 = this.getLength();
        String string = this.getText();
        if (n2 <= 0) {
            return;
        }
        if (this.wordIterator == null) {
            this.wordIterator = BreakIterator.getWordInstance();
        }
        this.wordIterator.setText(string);
        int n3 = this.wordIterator.preceding(Utils.clamp(0, this.getCaretPosition(), n2));
        while (n3 != -1 && !Character.isLetterOrDigit(string.charAt(Utils.clamp(0, n3, n2 - 1)))) {
            n3 = this.wordIterator.preceding(Utils.clamp(0, n3, n2));
        }
        this.selectRange(bl2 ? this.getAnchor() : n3, n3);
    }

    private void nextWord(boolean bl2) {
        int n2 = this.getLength();
        String string = this.getText();
        if (n2 <= 0) {
            return;
        }
        if (this.wordIterator == null) {
            this.wordIterator = BreakIterator.getWordInstance();
        }
        this.wordIterator.setText(string);
        int n3 = this.wordIterator.following(Utils.clamp(0, this.getCaretPosition(), n2 - 1));
        int n4 = this.wordIterator.next();
        while (n4 != -1) {
            while (n3 <= n4) {
                char c2 = string.charAt(Utils.clamp(0, n3, n2 - 1));
                if (c2 != ' ' && c2 != '\t') {
                    if (bl2) {
                        TextInputControl textInputControl = this;
                        textInputControl.selectRange(textInputControl.getAnchor(), n3);
                        return;
                    }
                    int n5 = n3;
                    this.selectRange(n5, n5);
                    return;
                }
                ++n3;
            }
            n3 = n4;
            n4 = this.wordIterator.next();
        }
        if (bl2) {
            TextInputControl textInputControl = this;
            textInputControl.selectRange(textInputControl.getAnchor(), n2);
            return;
        }
        this.end();
    }

    private void endOfNextWord(boolean bl2) {
        int n2 = this.getLength();
        String string = this.getText();
        if (n2 <= 0) {
            return;
        }
        if (this.wordIterator == null) {
            this.wordIterator = BreakIterator.getWordInstance();
        }
        this.wordIterator.setText(string);
        int n3 = this.wordIterator.following(Utils.clamp(0, this.getCaretPosition(), n2));
        int n4 = this.wordIterator.next();
        while (n4 != -1) {
            while (n3 <= n4) {
                if (!Character.isLetterOrDigit(string.charAt(Utils.clamp(0, n3, n2 - 1)))) {
                    if (bl2) {
                        TextInputControl textInputControl = this;
                        textInputControl.selectRange(textInputControl.getAnchor(), n3);
                        return;
                    }
                    int n5 = n3;
                    this.selectRange(n5, n5);
                    return;
                }
                ++n3;
            }
            n3 = n4;
            n4 = this.wordIterator.next();
        }
        if (bl2) {
            TextInputControl textInputControl = this;
            textInputControl.selectRange(textInputControl.getAnchor(), n2);
            return;
        }
        this.end();
    }

    public void selectAll() {
        this.selectRange(0, this.getLength());
    }

    public void home() {
        this.selectRange(0, 0);
    }

    public void end() {
        int n2 = this.getLength();
        if (n2 > 0) {
            int n3 = n2;
            this.selectRange(n3, n3);
        }
    }

    public void selectHome() {
        TextInputControl textInputControl = this;
        textInputControl.selectRange(textInputControl.getAnchor(), 0);
    }

    public void selectEnd() {
        int n2 = this.getLength();
        if (n2 > 0) {
            TextInputControl textInputControl = this;
            textInputControl.selectRange(textInputControl.getAnchor(), n2);
        }
    }

    public boolean deletePreviousChar() {
        int n2 = 1;
        if (this.isEditable() && !this.isDisabled()) {
            int n3;
            String string = this.getText();
            int n4 = this.getCaretPosition();
            if (n4 != (n3 = this.getAnchor())) {
                this.replaceSelection("");
                n2 = 0;
            } else if (n4 > 0) {
                n2 = Character.offsetByCodePoints(string, n4, -1);
                this.deleteText(n2, n4);
                n2 = 0;
            }
        }
        return n2 == 0;
    }

    public boolean deleteNextChar() {
        int n2 = 1;
        if (this.isEditable() && !this.isDisabled()) {
            int n3;
            int n4 = this.getLength();
            String string = this.getText();
            int n5 = this.getCaretPosition();
            if (n5 != (n3 = this.getAnchor())) {
                this.replaceSelection("");
                n2 = 0;
            } else if (n4 > 0 && n5 < n4) {
                if (this.charIterator == null) {
                    this.charIterator = BreakIterator.getCharacterInstance();
                }
                this.charIterator.setText(string);
                n2 = this.charIterator.following(n5);
                this.deleteText(n5, n2);
                n2 = 0;
            }
        }
        return n2 == 0;
    }

    public void forward() {
        int n2;
        int n3 = this.getLength();
        int n4 = this.getCaretPosition();
        if (n4 != (n2 = this.getAnchor())) {
            int n5 = n3 = Math.max(n4, n2);
            this.selectRange(n5, n5);
        } else if (n4 < n3 && n3 > 0) {
            if (this.charIterator == null) {
                this.charIterator = BreakIterator.getCharacterInstance();
            }
            this.charIterator.setText(this.getText());
            int n6 = n3 = this.charIterator.following(n4);
            this.selectRange(n6, n6);
        }
        this.deselect();
    }

    public void backward() {
        int n2;
        int n3 = this.getLength();
        int n4 = this.getCaretPosition();
        if (n4 != (n2 = this.getAnchor())) {
            int n5 = n3 = Math.min(n4, n2);
            this.selectRange(n5, n5);
        } else if (n4 > 0 && n3 > 0) {
            if (this.charIterator == null) {
                this.charIterator = BreakIterator.getCharacterInstance();
            }
            this.charIterator.setText(this.getText());
            int n6 = n3 = this.charIterator.preceding(n4);
            this.selectRange(n6, n6);
        }
        this.deselect();
    }

    public void positionCaret(int n2) {
        int n3 = n2 = Utils.clamp(0, n2, this.getLength());
        this.selectRange(n3, n3);
    }

    public void selectPositionCaret(int n2) {
        TextInputControl textInputControl = this;
        textInputControl.selectRange(textInputControl.getAnchor(), Utils.clamp(0, n2, this.getLength()));
    }

    public void selectRange(int n2, int n3) {
        n3 = Utils.clamp(0, n3, this.getLength());
        n2 = Utils.clamp(0, n2, this.getLength());
        TextInputControl textInputControl = this;
        TextFormatter$Change textFormatter$Change = new TextFormatter$Change(textInputControl, textInputControl.getFormatterAccessor(), n2, n3);
        TextFormatter<?> textFormatter = this.getTextFormatter();
        if (textFormatter != null && textFormatter.getFilter() != null && (textFormatter$Change = (TextFormatter$Change)textFormatter.getFilter().apply(textFormatter$Change)) == null) {
            return;
        }
        this.updateContent(textFormatter$Change, false);
    }

    private void doSelectRange(int n2, int n3) {
        this.caretPosition.set(Utils.clamp(0, n3, this.getLength()));
        this.anchor.set(Utils.clamp(0, n2, this.getLength()));
        this.selection.set(IndexRange.normalize(this.getAnchor(), this.getCaretPosition()));
        this.notifyAccessibleAttributeChanged(AccessibleAttribute.SELECTION_START);
    }

    public void extendSelection(int n2) {
        n2 = Utils.clamp(0, n2, this.getLength());
        int n3 = this.getCaretPosition();
        int n4 = this.getAnchor();
        int n5 = Math.min(n3, n4);
        n3 = Math.max(n3, n4);
        if (n2 < n5) {
            this.selectRange(n3, n2);
            return;
        }
        this.selectRange(n5, n2);
    }

    public void clear() {
        this.deselect();
        if (!this.text.isBound()) {
            this.setText("");
        }
    }

    public void deselect() {
        TextInputControl textInputControl = this;
        textInputControl.selectRange(textInputControl.getCaretPosition(), this.getCaretPosition());
    }

    public void replaceSelection(String string) {
        TextInputControl textInputControl = this;
        textInputControl.replaceText(textInputControl.getSelection(), string);
    }

    public final void undo() {
        if (this.isUndoable()) {
            int n2 = this.undoChange.start;
            String string = this.undoChange.newText;
            String string2 = this.undoChange.oldText;
            this.blockSelectedTextUpdate = true;
            try {
                if (string != null) {
                    int n3 = n2;
                    this.getContent().delete(n3, n3 + string.length(), string2.isEmpty());
                }
                if (string2 != null) {
                    this.getContent().insert(n2, string2, true);
                    int n4 = n2;
                    this.doSelectRange(n4, n4 + string2.length());
                } else {
                    int n5 = n2;
                    this.doSelectRange(n5, n5 + string.length());
                }
                this.undoChange = this.undoChange.prev;
            }
            finally {
                this.blockSelectedTextUpdate = false;
                this.updateSelectedText();
            }
        }
        this.updateUndoRedoState();
    }

    public final void redo() {
        if (this.isRedoable()) {
            this.undoChange = this.undoChange.next;
            int n2 = this.undoChange.start;
            String string = this.undoChange.newText;
            String string2 = this.undoChange.oldText;
            this.blockSelectedTextUpdate = true;
            try {
                if (string2 != null) {
                    int n3 = n2;
                    this.getContent().delete(n3, n3 + string2.length(), string.isEmpty());
                }
                if (string != null) {
                    this.getContent().insert(n2, string, true);
                    this.doSelectRange(n2 + string.length(), n2 + string.length());
                } else {
                    int n4 = n2;
                    this.doSelectRange(n4, n4);
                }
            }
            finally {
                this.blockSelectedTextUpdate = false;
                this.updateSelectedText();
            }
        }
        this.updateUndoRedoState();
    }

    void textUpdated() {
    }

    private void resetUndoRedoState() {
        this.undoChange = this.undoChangeHead;
        this.undoChange.next = null;
        this.updateUndoRedoState();
    }

    private void updateUndoRedoState() {
        this.undoable.set(this.undoChange != this.undoChangeHead);
        this.redoable.set(this.undoChange.next != null);
    }

    private boolean filterAndSet(String object) {
        TextFormatter<?> textFormatter = this.getTextFormatter();
        int n2 = this.content.length();
        if (textFormatter != null && textFormatter.getFilter() != null && !this.text.isBound()) {
            TextInputControl textInputControl = this;
            object = new TextFormatter$Change(textInputControl, textInputControl.getFormatterAccessor(), 0, n2, (String)object, 0, 0);
            object = (TextFormatter$Change)textFormatter.getFilter().apply((TextFormatter$Change)object);
            if (object == null) {
                return false;
            }
            this.replaceText(((TextFormatter$Change)object).start, ((TextFormatter$Change)object).end, ((TextFormatter$Change)object).text, ((TextFormatter$Change)object).getAnchor(), ((TextFormatter$Change)object).getCaretPosition());
        } else {
            this.replaceText(0, n2, (String)object, 0, 0);
        }
        return true;
    }

    private int replaceText(int n2, int n3, String string, int n4, int n5) {
        this.blockSelectedTextUpdate = true;
        try {
            int n6 = this.getLength();
            int n7 = 0;
            if (n3 != n2) {
                this.getContent().delete(n2, n3, string.isEmpty());
                n6 -= n3 - n2;
            }
            if (string != null) {
                this.getContent().insert(n2, string, true);
                n7 = string.length() - (this.getLength() - n6);
                n4 -= n7;
                n5 -= n7;
            }
            this.doSelectRange(n4, n5);
            n2 = n7;
            return n2;
        }
        finally {
            this.blockSelectedTextUpdate = false;
            this.updateSelectedText();
        }
    }

    private <T> void updateText(TextFormatter<T> object) {
        T t2 = ((TextFormatter)object).getValue();
        if ((object = ((TextFormatter)object).getValueConverter()) != null) {
            if ((object = ((StringConverter)object).toString(t2)) == null) {
                object = "";
            }
            Object object2 = object;
            this.replaceText(0, this.getLength(), (String)object2, ((String)object2).length(), ((String)object).length());
        }
    }

    public final void commitValue() {
        if (this.getTextFormatter() != null) {
            this.getTextFormatter().updateValue(this.getText());
        }
    }

    public final void cancelEdit() {
        if (this.getTextFormatter() != null) {
            TextInputControl textInputControl = this;
            textInputControl.updateText(textInputControl.getTextFormatter());
        }
    }

    private FormatterAccessor getFormatterAccessor() {
        if (this.accessor == null) {
            this.accessor = new TextInputControl$TextInputControlFromatterAccessor(this);
        }
        return this.accessor;
    }

    String filterInput(String string) {
        return string;
    }

    static String filterInput(String string, boolean bl2, boolean bl3) {
        if (TextInputControl.containsInvalidCharacters(string, bl2, bl3)) {
            StringBuilder stringBuilder = new StringBuilder(string.length());
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if (TextInputControl.isInvalidCharacter(c2, bl2, bl3)) continue;
                stringBuilder.append(c2);
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    static boolean containsInvalidCharacters(String string, boolean bl2, boolean bl3) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (!TextInputControl.isInvalidCharacter(c2, bl2, bl3)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInvalidCharacter(char c2, boolean bl2, boolean bl3) {
        if (c2 == '\u007f') {
            return true;
        }
        if (c2 == '\n') {
            return bl2;
        }
        if (c2 == '\t') {
            return bl3;
        }
        return c2 < ' ';
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return TextInputControl$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return TextInputControl.getClassCssMetaData();
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute object, Object ... objectArray) {
        switch (TextInputControl$6.$SwitchMap$javafx$scene$AccessibleAttribute[((Enum)object).ordinal()]) {
            case 1: {
                object = this.getAccessibleText();
                if (object != null && !((String)object).isEmpty()) {
                    return object;
                }
                object = this.getText();
                if (object == null || ((String)object).isEmpty()) {
                    object = this.getPromptText();
                }
                return object;
            }
            case 2: {
                return this.isEditable();
            }
            case 3: {
                return this.getSelection().getStart();
            }
            case 4: {
                return this.getSelection().getEnd();
            }
            case 5: {
                return this.getCaretPosition();
            }
            case 6: {
                return this.getFont();
            }
        }
        return super.queryAccessibleAttribute((AccessibleAttribute)((Object)object), objectArray);
    }

    @Override
    public void executeAccessibleAction(AccessibleAction object, Object ... object2) {
        switch (TextInputControl$6.$SwitchMap$javafx$scene$AccessibleAction[((Enum)object).ordinal()]) {
            case 1: {
                object = (String)object2[0];
                if (object == null) break;
                this.setText((String)object);
                return;
            }
            case 2: {
                object = (Integer)object2[0];
                object2 = (Integer)object2[1];
                if (object == null || object2 == null) break;
                this.selectRange((Integer)object, (Integer)object2);
                return;
            }
            default: {
                super.executeAccessibleAction((AccessibleAction)((Object)object), (Object[])object2);
            }
        }
    }
}

