/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.geometry.Orientation;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.Labeled;
import javafx.scene.control.Skin;
import javafx.scene.control.TitledPane$1;
import javafx.scene.control.TitledPane$2;
import javafx.scene.control.TitledPane$3;
import javafx.scene.control.TitledPane$4;
import javafx.scene.control.TitledPane$StyleableProperties;
import javafx.scene.control.skin.TitledPaneSkin;

@DefaultProperty(value="content")
public class TitledPane
extends Labeled {
    private ObjectProperty<Node> content;
    private BooleanProperty expanded = new TitledPane$1(this, true);
    private BooleanProperty animated = new TitledPane$2(this, true);
    private BooleanProperty collapsible = new TitledPane$3(this, true);
    private static final String DEFAULT_STYLE_CLASS = "titled-pane";
    private static final PseudoClass PSEUDO_CLASS_EXPANDED = PseudoClass.getPseudoClass("expanded");
    private static final PseudoClass PSEUDO_CLASS_COLLAPSED = PseudoClass.getPseudoClass("collapsed");

    public TitledPane() {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.TITLED_PANE);
        this.pseudoClassStateChanged(PSEUDO_CLASS_EXPANDED, true);
    }

    public TitledPane(String string, Node node) {
        this();
        this.setText(string);
        this.setContent(node);
    }

    public final void setContent(Node node) {
        this.contentProperty().set(node);
    }

    public final Node getContent() {
        if (this.content == null) {
            return null;
        }
        return (Node)this.content.get();
    }

    public final ObjectProperty<Node> contentProperty() {
        if (this.content == null) {
            this.content = new SimpleObjectProperty<Node>(this, "content");
        }
        return this.content;
    }

    public final void setExpanded(boolean bl2) {
        this.expandedProperty().set(bl2);
    }

    public final boolean isExpanded() {
        return this.expanded.get();
    }

    public final BooleanProperty expandedProperty() {
        return this.expanded;
    }

    public final void setAnimated(boolean bl2) {
        this.animatedProperty().set(bl2);
    }

    public final boolean isAnimated() {
        return this.animated.get();
    }

    public final BooleanProperty animatedProperty() {
        return this.animated;
    }

    public final void setCollapsible(boolean bl2) {
        this.collapsibleProperty().set(bl2);
    }

    public final boolean isCollapsible() {
        return this.collapsible.get();
    }

    public final BooleanProperty collapsibleProperty() {
        return this.collapsible;
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new TitledPaneSkin(this);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return TitledPane$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return TitledPane.getClassCssMetaData();
    }

    @Override
    public Orientation getContentBias() {
        Node node = this.getContent();
        if (node == null) {
            return super.getContentBias();
        }
        return node.getContentBias();
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute object, Object ... objectArray) {
        switch (TitledPane$4.$SwitchMap$javafx$scene$AccessibleAttribute[((Enum)object).ordinal()]) {
            case 1: {
                object = this.getAccessibleText();
                if (object != null && !((String)object).isEmpty()) {
                    return object;
                }
                return this.getText();
            }
            case 2: {
                return this.isExpanded();
            }
        }
        return super.queryAccessibleAttribute((AccessibleAttribute)((Object)object), objectArray);
    }

    @Override
    public void executeAccessibleAction(AccessibleAction accessibleAction, Object ... objectArray) {
        switch (accessibleAction) {
            case EXPAND: {
                this.setExpanded(true);
                return;
            }
            case COLLAPSE: {
                this.setExpanded(false);
                return;
            }
        }
        super.executeAccessibleAction(accessibleAction, new Object[0]);
    }
}

