/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.css.PseudoClass;
import javafx.css.StyleableProperty;
import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Skin;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton$1;
import javafx.scene.control.ToggleButton$2;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.skin.ToggleButtonSkin;

public class ToggleButton
extends ButtonBase
implements Toggle {
    private BooleanProperty selected;
    private ObjectProperty<ToggleGroup> toggleGroup;
    private static final String DEFAULT_STYLE_CLASS = "toggle-button";
    private static final PseudoClass PSEUDO_CLASS_SELECTED = PseudoClass.getPseudoClass("selected");

    public ToggleButton() {
        this.initialize();
    }

    public ToggleButton(String string) {
        this.setText(string);
        this.initialize();
    }

    public ToggleButton(String string, Node node) {
        this.setText(string);
        this.setGraphic(node);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.TOGGLE_BUTTON);
        ((StyleableProperty)((Object)this.alignmentProperty())).applyStyle(null, Pos.CENTER);
        this.setMnemonicParsing(true);
    }

    @Override
    public final void setSelected(boolean bl2) {
        this.selectedProperty().set(bl2);
    }

    @Override
    public final boolean isSelected() {
        if (this.selected == null) {
            return false;
        }
        return this.selected.get();
    }

    @Override
    public final BooleanProperty selectedProperty() {
        if (this.selected == null) {
            this.selected = new ToggleButton$1(this);
        }
        return this.selected;
    }

    @Override
    public final void setToggleGroup(ToggleGroup toggleGroup) {
        this.toggleGroupProperty().set(toggleGroup);
    }

    @Override
    public final ToggleGroup getToggleGroup() {
        if (this.toggleGroup == null) {
            return null;
        }
        return (ToggleGroup)this.toggleGroup.get();
    }

    @Override
    public final ObjectProperty<ToggleGroup> toggleGroupProperty() {
        if (this.toggleGroup == null) {
            this.toggleGroup = new ToggleButton$2(this);
        }
        return this.toggleGroup;
    }

    @Override
    public void fire() {
        if (!this.isDisabled()) {
            ToggleButton toggleButton = this;
            toggleButton.setSelected(!toggleButton.isSelected());
            this.fireEvent(new ActionEvent());
        }
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new ToggleButtonSkin(this);
    }

    @Override
    protected Pos getInitialAlignment() {
        return Pos.CENTER;
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case SELECTED: {
                return this.isSelected();
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }
}

