/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.WeakListChangeListener;
import javafx.css.PseudoClass;
import javafx.event.EventTarget;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.ControlUtils;
import javafx.scene.control.FocusModel;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.Skin;
import javafx.scene.control.TreeCell$1;
import javafx.scene.control.TreeCell$2;
import javafx.scene.control.TreeCell$3;
import javafx.scene.control.TreeCell$4;
import javafx.scene.control.TreeCell$5;
import javafx.scene.control.TreeCell$6;
import javafx.scene.control.TreeCell$7;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.TreeView$EditEvent;
import javafx.scene.control.skin.TreeCellSkin;

public class TreeCell<T>
extends IndexedCell<T> {
    private final ListChangeListener<Integer> selectedListener = listChangeListener$Change -> this.updateSelection();
    private final ChangeListener<MultipleSelectionModel<TreeItem<T>>> selectionModelPropertyListener = new TreeCell$1(this);
    private final InvalidationListener focusedListener = observable -> this.updateFocus();
    private final ChangeListener<FocusModel<TreeItem<T>>> focusModelPropertyListener = new TreeCell$2(this);
    private final InvalidationListener editingListener = observable -> this.updateEditing();
    private final InvalidationListener leafListener = new TreeCell$3(this);
    private boolean oldIsExpanded;
    private final InvalidationListener treeItemExpandedInvalidationListener = new TreeCell$4(this);
    private final InvalidationListener rootPropertyListener = observable -> this.updateItem(-1);
    private final WeakListChangeListener<Integer> weakSelectedListener = new WeakListChangeListener<Integer>(this.selectedListener);
    private final WeakChangeListener<MultipleSelectionModel<TreeItem<T>>> weakSelectionModelPropertyListener = new WeakChangeListener<MultipleSelectionModel<TreeItem<MultipleSelectionModel<TreeItem<T>>>>>(this.selectionModelPropertyListener);
    private final WeakInvalidationListener weakFocusedListener = new WeakInvalidationListener(this.focusedListener);
    private final WeakChangeListener<FocusModel<TreeItem<T>>> weakFocusModelPropertyListener = new WeakChangeListener<FocusModel<TreeItem<FocusModel<TreeItem<T>>>>>(this.focusModelPropertyListener);
    private final WeakInvalidationListener weakEditingListener = new WeakInvalidationListener(this.editingListener);
    private final WeakInvalidationListener weakLeafListener = new WeakInvalidationListener(this.leafListener);
    private final WeakInvalidationListener weakTreeItemExpandedInvalidationListener = new WeakInvalidationListener(this.treeItemExpandedInvalidationListener);
    private final WeakInvalidationListener weakRootPropertyListener = new WeakInvalidationListener(this.rootPropertyListener);
    private ReadOnlyObjectWrapper<TreeItem<T>> treeItem;
    private ObjectProperty<Node> disclosureNode;
    private ReadOnlyObjectWrapper<TreeView<T>> treeView;
    private TreeItem<T> treeItemAtStartEdit;
    private boolean isFirstRun;
    private boolean updateEditingIndex;
    private static final String DEFAULT_STYLE_CLASS = "tree-cell";
    private static final PseudoClass EXPANDED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("expanded");
    private static final PseudoClass COLLAPSED_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("collapsed");

    public TreeCell() {
        TreeCell treeCell = this;
        this.treeItem = new TreeCell$5(treeCell, treeCell, "treeItem");
        this.disclosureNode = new SimpleObjectProperty<Node>(this, "disclosureNode");
        this.treeView = new TreeCell$6(this);
        this.isFirstRun = true;
        this.updateEditingIndex = true;
        this.getStyleClass().addAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.TREE_ITEM);
    }

    private void setTreeItem(TreeItem<T> treeItem) {
        this.treeItem.set(treeItem);
    }

    public final TreeItem<T> getTreeItem() {
        return (TreeItem)this.treeItem.get();
    }

    public final ReadOnlyObjectProperty<TreeItem<T>> treeItemProperty() {
        return this.treeItem.getReadOnlyProperty();
    }

    public final void setDisclosureNode(Node node) {
        this.disclosureNodeProperty().set(node);
    }

    public final Node getDisclosureNode() {
        return (Node)this.disclosureNode.get();
    }

    public final ObjectProperty<Node> disclosureNodeProperty() {
        return this.disclosureNode;
    }

    private void setTreeView(TreeView<T> treeView) {
        this.treeView.set(treeView);
    }

    public final TreeView<T> getTreeView() {
        return (TreeView)this.treeView.get();
    }

    public final ReadOnlyObjectProperty<TreeView<T>> treeViewProperty() {
        return this.treeView.getReadOnlyProperty();
    }

    @Override
    public void startEdit() {
        if (this.isEditing()) {
            return;
        }
        TreeView<T> treeView = this.getTreeView();
        if (!this.isEditable() || treeView != null && !treeView.isEditable()) {
            return;
        }
        this.updateItem(-1);
        super.startEdit();
        if (!this.isEditing()) {
            return;
        }
        this.treeItemAtStartEdit = this.getTreeItem();
        if (treeView != null) {
            treeView.fireEvent(new TreeView$EditEvent<Object>((TreeView<Object>)treeView, TreeView.editStartEvent(), (TreeItem<Object>)this.treeItemAtStartEdit, this.getItem(), null));
            treeView.edit(this.treeItemAtStartEdit);
            treeView.requestFocus();
        }
    }

    @Override
    public void commitEdit(T t2) {
        if (!this.isEditing()) {
            return;
        }
        super.commitEdit(t2);
        TreeItem<T> treeItem = this.getTreeItem();
        TreeView treeView = this.getTreeView();
        if (treeView != null) {
            treeView.fireEvent(new TreeView$EditEvent<T>(treeView, TreeView.editCommitEvent(), treeItem, this.getItem(), t2));
        }
        this.updateItem(t2, false);
        if (treeView != null) {
            treeView.edit(null);
            ControlUtils.requestFocusOnControlOnlyIfCurrentFocusOwnerIsChild(treeView);
        }
        this.treeItemAtStartEdit = null;
    }

    @Override
    public void cancelEdit() {
        if (!this.isEditing()) {
            return;
        }
        TreeView treeView = this.getTreeView();
        super.cancelEdit();
        if (treeView != null) {
            Object t2;
            TreeItem<T> treeItem = this.treeItemAtStartEdit;
            Object t3 = t2 = treeItem != null ? (Object)treeItem.getValue() : null;
            if (this.updateEditingIndex) {
                treeView.edit(null);
            }
            ControlUtils.requestFocusOnControlOnlyIfCurrentFocusOwnerIsChild(treeView);
            treeView.fireEvent(new TreeView$EditEvent<Object>(treeView, TreeView.editCancelEvent(), (TreeItem<Object>)treeItem, t2, null));
        }
        this.treeItemAtStartEdit = null;
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new TreeCellSkin(this);
    }

    @Override
    void indexChanged(int n2, int n3) {
        super.indexChanged(n2, n3);
        if (!this.isEditing() || n3 != n2) {
            this.updateItem(n2);
            this.updateSelection();
            this.updateFocus();
            this.updateEditing();
        }
    }

    private void updateItem(int n2) {
        EventTarget eventTarget = this.getTreeView();
        if (eventTarget == null) {
            return;
        }
        int n3 = this.getIndex();
        boolean bl2 = n3 >= 0 && n3 < ((TreeView)eventTarget).getExpandedItemCount();
        boolean bl3 = this.isEmpty();
        TreeItem<T> treeItem = this.getTreeItem();
        if (bl2) {
            Object t2;
            Object t3 = (eventTarget = ((TreeView)eventTarget).getTreeItem(n3)) == null ? null : (Object)((TreeItem)eventTarget).getValue();
            Object t4 = t2 = treeItem == null ? null : (Object)treeItem.getValue();
            if (n2 != n3 || this.isItemChanged(t2, t3)) {
                this.updateTreeItem((TreeItem<T>)eventTarget);
                this.updateItem(t3, false);
                return;
            }
        } else if (!bl3 && treeItem != null || this.isFirstRun) {
            this.updateTreeItem(null);
            this.updateItem(null, true);
            this.isFirstRun = false;
        }
    }

    private void updateSelection() {
        if (this.isEmpty()) {
            return;
        }
        if (this.getIndex() == -1 || this.getTreeView() == null) {
            return;
        }
        MultipleSelectionModel<TreeItem<T>> multipleSelectionModel = this.getTreeView().getSelectionModel();
        if (multipleSelectionModel == null) {
            this.updateSelected(false);
            return;
        }
        boolean bl2 = multipleSelectionModel.isSelected(this.getIndex());
        if (this.isSelected() == bl2) {
            return;
        }
        this.updateSelected(bl2);
    }

    private void updateFocus() {
        if (this.getIndex() == -1 || this.getTreeView() == null) {
            return;
        }
        FocusModel<TreeItem<T>> focusModel = this.getTreeView().getFocusModel();
        if (focusModel == null) {
            this.setFocused(false);
            return;
        }
        this.setFocused(focusModel.isFocused(this.getIndex()));
    }

    private void updateEditing() {
        int n2 = this.getIndex();
        TreeView<T> treeView = this.getTreeView();
        TreeItem<T> treeItem = this.getTreeItem();
        TreeItem<T> treeItem2 = treeView == null ? null : treeView.getEditingItem();
        boolean bl2 = this.isEditing();
        if (n2 == -1 || treeView == null || treeItem == null) {
            if (bl2) {
                this.doCancelEditing();
            }
            return;
        }
        boolean bl3 = treeItem.equals(treeItem2);
        n2 = bl3 ? 1 : 0;
        if (bl3 && !bl2) {
            ((Cell)this).startEdit();
            return;
        }
        if (n2 == 0 && bl2) {
            this.doCancelEditing();
        }
    }

    private void doCancelEditing() {
        try {
            this.updateEditingIndex = false;
            ((Cell)this).cancelEdit();
            return;
        }
        finally {
            this.updateEditingIndex = true;
        }
    }

    public final void updateTreeView(TreeView<T> treeView) {
        this.setTreeView(treeView);
    }

    public final void updateTreeItem(TreeItem<T> treeItem) {
        TreeItem<T> treeItem2 = this.getTreeItem();
        if (treeItem2 != null) {
            treeItem2.leafProperty().removeListener(this.weakLeafListener);
        }
        this.setTreeItem(treeItem);
        if (treeItem != null) {
            treeItem.leafProperty().addListener(this.weakLeafListener);
        }
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute object, Object ... objectArray) {
        TreeItem<T> treeItem = this.getTreeItem();
        TreeView<T> treeView = this.getTreeView();
        switch (object) {
            case TREE_ITEM_PARENT: {
                if (treeView == null) {
                    return null;
                }
                if (treeItem == null) {
                    return null;
                }
                object = treeItem.getParent();
                if (object == null) {
                    return null;
                }
                int n2 = treeView.getRow((TreeItem<T>)object);
                return ((Node)treeView).queryAccessibleAttribute(AccessibleAttribute.ROW_AT_INDEX, n2);
            }
            case TREE_ITEM_COUNT: {
                if (treeItem == null) {
                    return 0;
                }
                if (!treeItem.isExpanded()) {
                    return 0;
                }
                return treeItem.getChildren().size();
            }
            case TREE_ITEM_AT_INDEX: {
                if (treeItem == null) {
                    return null;
                }
                if (!treeItem.isExpanded()) {
                    return null;
                }
                int n3 = (Integer)objectArray[0];
                if (n3 >= treeItem.getChildren().size()) {
                    return null;
                }
                TreeItem treeItem2 = (TreeItem)treeItem.getChildren().get(n3);
                if (treeItem2 == null) {
                    return null;
                }
                int n4 = treeView.getRow(treeItem2);
                return ((Node)treeView).queryAccessibleAttribute(AccessibleAttribute.ROW_AT_INDEX, n4);
            }
            case LEAF: {
                return treeItem == null ? true : treeItem.isLeaf();
            }
            case EXPANDED: {
                return treeItem == null ? false : treeItem.isExpanded();
            }
            case INDEX: {
                return this.getIndex();
            }
            case SELECTED: {
                return this.isSelected();
            }
            case DISCLOSURE_LEVEL: {
                return treeView == null ? 0 : treeView.getTreeItemLevel(treeItem);
            }
        }
        return super.queryAccessibleAttribute((AccessibleAttribute)((Object)object), objectArray);
    }

    @Override
    public void executeAccessibleAction(AccessibleAction object, Object ... objectArray) {
        switch (TreeCell$7.$SwitchMap$javafx$scene$AccessibleAction[((Enum)object).ordinal()]) {
            case 1: {
                object = this.getTreeItem();
                if (object == null) break;
                ((TreeItem)object).setExpanded(true);
                return;
            }
            case 2: {
                object = this.getTreeItem();
                if (object == null) break;
                ((TreeItem)object).setExpanded(false);
                return;
            }
            case 3: {
                object = this.getTreeView();
                if (object == null) break;
                if ((object = ((TreeView)object).getFocusModel()) != null) {
                    ((FocusModel)object).focus(this.getIndex());
                }
                return;
            }
            default: {
                super.executeAccessibleAction((AccessibleAction)((Object)object), new Object[0]);
            }
        }
    }
}

