/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.collections.MappingChange;
import com.sun.javafx.collections.NonIterableChange$GenericAddRemoveChange;
import com.sun.javafx.collections.NonIterableChange$SimpleAddChange;
import com.sun.javafx.scene.control.ReadOnlyUnbackedObservableList;
import com.sun.javafx.scene.control.SelectedCellsMap;
import com.sun.javafx.scene.control.behavior.TableCellBehavior;
import com.sun.javafx.scene.control.behavior.TableCellBehaviorBase;
import com.sun.javafx.scene.control.behavior.TreeTableCellBehavior;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntPredicate;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener$Change;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.scene.AccessibleAttribute;
import javafx.scene.control.ControlUtils;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeItem$TreeModificationEvent;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTablePosition;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.TreeTableView$TreeTableViewArrayListSelectionModel$1;
import javafx.scene.control.TreeTableView$TreeTableViewArrayListSelectionModel$2;
import javafx.scene.control.TreeTableView$TreeTableViewArrayListSelectionModel$3;
import javafx.scene.control.TreeTableView$TreeTableViewArrayListSelectionModel$4;
import javafx.scene.control.TreeTableView$TreeTableViewSelectionModel;

class TreeTableView$TreeTableViewArrayListSelectionModel<S>
extends TreeTableView$TreeTableViewSelectionModel<S> {
    private TreeTableView<S> treeTableView = null;
    private ChangeListener<TreeItem<S>> rootPropertyListener = (observableValue, treeItem, treeItem2) -> {
        this.updateDefaultSelection();
        this.updateTreeEventListener((TreeItem<S>)treeItem, (TreeItem<S>)treeItem2);
    };
    private InvalidationListener showRootPropertyListener = observable -> this.shiftSelection(0, this.treeTableView.isShowRoot() ? 1 : -1, null);
    private EventHandler<TreeItem$TreeModificationEvent<S>> treeItemListener = new TreeTableView$TreeTableViewArrayListSelectionModel$3(this);
    private WeakChangeListener<TreeItem<S>> weakRootPropertyListener = new WeakChangeListener<TreeItem<S>>(this.rootPropertyListener);
    private WeakEventHandler<TreeItem$TreeModificationEvent<S>> weakTreeItemListener;
    private final SelectedCellsMap<TreeTablePosition<S, ?>> selectedCellsMap;
    private final ReadOnlyUnbackedObservableList<TreeTablePosition<S, ?>> selectedCellsSeq;

    public TreeTableView$TreeTableViewArrayListSelectionModel(TreeTableView<S> treeTableView) {
        super(treeTableView);
        this.treeTableView = treeTableView;
        this.treeTableView.rootProperty().addListener(this.weakRootPropertyListener);
        this.treeTableView.showRootProperty().addListener(this.showRootPropertyListener);
        this.updateTreeEventListener(null, treeTableView.getRoot());
        TreeTableView$TreeTableViewArrayListSelectionModel treeTableView$TreeTableViewArrayListSelectionModel = this;
        this.selectedCellsMap = new TreeTableView$TreeTableViewArrayListSelectionModel$1(treeTableView$TreeTableViewArrayListSelectionModel, listChangeListener$Change -> this.fireCustomSelectedCellsListChangeEvent(listChangeListener$Change));
        this.selectedCellsSeq = new TreeTableView$TreeTableViewArrayListSelectionModel$2(this);
        this.updateDefaultSelection();
        this.cellSelectionEnabledProperty().addListener(observable -> {
            this.updateDefaultSelection();
            TableCellBehaviorBase.setAnchor(treeTableView, this.getFocusedCell(), true);
        });
    }

    private void dispose() {
        this.treeTableView.rootProperty().removeListener(this.weakRootPropertyListener);
        this.treeTableView.showRootProperty().removeListener(this.showRootPropertyListener);
        TreeItem<S> treeItem = this.treeTableView.getRoot();
        if (treeItem != null) {
            treeItem.removeEventHandler(TreeItem.expandedItemCountChangeEvent(), this.weakTreeItemListener);
        }
    }

    private void updateTreeEventListener(TreeItem<S> treeItem, TreeItem<S> treeItem2) {
        if (treeItem != null && this.weakTreeItemListener != null) {
            treeItem.removeEventHandler(TreeItem.expandedItemCountChangeEvent(), this.weakTreeItemListener);
        }
        if (treeItem2 != null) {
            this.weakTreeItemListener = new WeakEventHandler<TreeItem$TreeModificationEvent<S>>(this.treeItemListener);
            treeItem2.addEventHandler(TreeItem.expandedItemCountChangeEvent(), this.weakTreeItemListener);
        }
    }

    @Override
    public ObservableList<TreeTablePosition<S, ?>> getSelectedCells() {
        return this.selectedCellsSeq;
    }

    @Override
    public void clearAndSelect(int n2) {
        ((TableSelectionModel)this).clearAndSelect(n2, null);
    }

    @Override
    public void clearAndSelect(int n2, TableColumnBase<TreeItem<S>, ?> object2) {
        ListChangeListener$Change<TreeTablePosition> listChangeListener$Change;
        if (n2 < 0 || n2 >= this.getItemCount()) {
            return;
        }
        TreeTablePosition treeTablePosition = new TreeTablePosition(this.getTreeTableView(), n2, (TreeTableColumn)object2);
        boolean bl2 = this.isCellSelectionEnabled();
        TreeTableCellBehavior.setAnchor(this.treeTableView, treeTablePosition, false);
        ArrayList arrayList = new ArrayList(this.selectedCellsMap.getSelectedCells());
        boolean bl3 = ((TableSelectionModel)this).isSelected(n2, object2);
        if (bl3 && arrayList.size() == 1) {
            listChangeListener$Change = (TreeTablePosition)((TreeTableView$TreeTableViewSelectionModel)this).getSelectedCells().get(0);
            if (this.getSelectedItem() == this.getModelItem(n2) && ((TablePositionBase)((Object)listChangeListener$Change)).getRow() == n2 && ((TreeTablePosition)((Object)listChangeListener$Change)).getTableColumn() == object2) {
                return;
            }
        }
        this.startAtomic();
        ((SelectionModel)this).clearSelection();
        ((TableSelectionModel)this).select(n2, object2);
        this.stopAtomic();
        if (bl2) {
            arrayList.remove(treeTablePosition);
        } else {
            for (TreeTablePosition treeTablePosition2 : arrayList) {
                if (treeTablePosition2.getRow() != n2) continue;
                arrayList.remove(treeTablePosition2);
                break;
            }
        }
        if (bl3) {
            listChangeListener$Change = ControlUtils.buildClearAndSelectChange(this.selectedCellsSeq, arrayList, treeTablePosition, Comparator.comparing(TablePositionBase::getRow));
        } else {
            int n3 = bl2 ? 0 : Math.max(0, this.selectedCellsSeq.indexOf(treeTablePosition));
            n2 = bl2 ? ((TreeTableView$TreeTableViewSelectionModel)this).getSelectedCells().size() : 1;
            int n4 = n3;
            listChangeListener$Change = new NonIterableChange$GenericAddRemoveChange(n4, n4 + n2, arrayList, this.selectedCellsSeq);
        }
        this.fireCustomSelectedCellsListChangeEvent(listChangeListener$Change);
    }

    @Override
    public void select(int n2) {
        ((TableSelectionModel)this).select(n2, null);
    }

    @Override
    public void select(int n2, TableColumnBase<TreeItem<S>, ?> object) {
        if (n2 < 0 || n2 >= this.getRowCount()) {
            return;
        }
        if (this.isCellSelectionEnabled() && object == null) {
            object = this.getTreeTableView().getVisibleLeafColumns();
            for (int i2 = 0; i2 < object.size(); ++i2) {
                ((TableSelectionModel)this).select(n2, (TableColumnBase)object.get(i2));
            }
            return;
        }
        if (TableCellBehavior.hasDefaultAnchor(this.treeTableView)) {
            TableCellBehavior.removeAnchor(this.treeTableView);
        }
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
        }
        this.selectedCellsMap.add(new TreeTablePosition(this.getTreeTableView(), n2, (TreeTableColumn)object));
        this.updateSelectedIndex(n2);
        this.focus(n2, (TreeTableColumn)object);
    }

    @Override
    public void select(TreeItem<S> treeItem) {
        if (treeItem == null && this.getSelectionMode() == SelectionMode.SINGLE) {
            ((SelectionModel)this).clearSelection();
            return;
        }
        int n2 = this.treeTableView.getRow(treeItem);
        if (n2 >= 0) {
            if (((SelectionModel)this).isSelected(n2)) {
                return;
            }
            if (this.getSelectionMode() == SelectionMode.SINGLE) {
                this.quietClearSelection();
            }
            ((SelectionModel)this).select(n2);
            return;
        }
        this.setSelectedIndex(-1);
        this.setSelectedItem(treeItem);
    }

    @Override
    public void selectIndices(int n2, int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            ((SelectionModel)this).select(n2);
            return;
        }
        int n3 = this.getRowCount();
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
            for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
                int n4 = nArray[i2];
                if (n4 < 0 || n4 >= n3) continue;
                ((SelectionModel)this).select(n4);
                break;
            }
            if (this.selectedCellsMap.isEmpty() && n2 > 0 && n2 < n3) {
                ((SelectionModel)this).select(n2);
                return;
            }
        } else {
            int n5;
            int n6 = -1;
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            if (n2 >= 0 && n2 < n3) {
                if (this.isCellSelectionEnabled()) {
                    ObservableList observableList = this.getTreeTableView().getVisibleLeafColumns();
                    for (n5 = 0; n5 < observableList.size(); ++n5) {
                        if (this.selectedCellsMap.isSelected(n2, n5)) continue;
                        linkedHashSet.add(new TreeTablePosition(this.getTreeTableView(), n2, (TreeTableColumn)observableList.get(n5)));
                    }
                } else {
                    boolean bl2 = this.selectedCellsMap.isSelected(n2, -1);
                    if (!bl2) {
                        linkedHashSet.add(new TreeTablePosition(this.getTreeTableView(), n2, null));
                    }
                }
                n6 = n2;
            }
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                n5 = nArray[i3];
                if (n5 < 0 || n5 >= n3) continue;
                n6 = n5;
                if (this.isCellSelectionEnabled()) {
                    ObservableList observableList = this.getTreeTableView().getVisibleLeafColumns();
                    for (int i4 = 0; i4 < observableList.size(); ++i4) {
                        if (this.selectedCellsMap.isSelected(n5, i4)) continue;
                        linkedHashSet.add(new TreeTablePosition(this.getTreeTableView(), n5, (TreeTableColumn)observableList.get(i4)));
                        n6 = n5;
                    }
                    continue;
                }
                if (this.selectedCellsMap.isSelected(n5, -1)) continue;
                linkedHashSet.add(new TreeTablePosition(this.getTreeTableView(), n5, null));
            }
            this.selectedCellsMap.addAll(linkedHashSet);
            if (n6 != -1) {
                ((SelectionModel)this).select(n6);
            }
        }
    }

    @Override
    public void selectAll() {
        int n2;
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            return;
        }
        if (this.isCellSelectionEnabled()) {
            ArrayList arrayList = new ArrayList();
            TreeTablePosition treeTablePosition = null;
            for (int i2 = 0; i2 < this.getTreeTableView().getVisibleLeafColumns().size(); ++i2) {
                TreeTableColumn treeTableColumn = (TreeTableColumn)this.getTreeTableView().getVisibleLeafColumns().get(i2);
                for (int i3 = 0; i3 < this.getRowCount(); ++i3) {
                    treeTablePosition = new TreeTablePosition(this.getTreeTableView(), i3, treeTableColumn);
                    arrayList.add(treeTablePosition);
                }
            }
            this.selectedCellsMap.setAll(arrayList);
            if (treeTablePosition != null) {
                ((TableSelectionModel)this).select(treeTablePosition.getRow(), treeTablePosition.getTableColumn());
                this.focus(treeTablePosition.getRow(), (TreeTableColumn<S, ?>)treeTablePosition.getTableColumn());
            }
            return;
        }
        ArrayList arrayList = new ArrayList();
        for (n2 = 0; n2 < this.getRowCount(); ++n2) {
            arrayList.add(new TreeTablePosition(this.getTreeTableView(), n2, null));
        }
        this.selectedCellsMap.setAll(arrayList);
        n2 = ((TreeTableView$TreeTableViewSelectionModel)this).getFocusedIndex();
        if (n2 == -1) {
            int n3 = this.getItemCount();
            if (n3 > 0) {
                ((SelectionModel)this).select(n3 - 1);
                ArrayList arrayList2 = arrayList;
                this.focus((TreeTablePosition)arrayList2.get(arrayList2.size() - 1));
            }
            return;
        }
        ((SelectionModel)this).select(n2);
        ((TreeTableView$TreeTableViewSelectionModel)this).focus(n2);
    }

    @Override
    public void selectRange(int n2, TableColumnBase<TreeItem<S>, ?> tableColumnBase, int n3, TableColumnBase<TreeItem<S>, ?> tableColumnBase2) {
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
            ((TableSelectionModel)this).select(n3, tableColumnBase2);
            return;
        }
        this.startAtomic();
        int n4 = this.getItemCount();
        boolean bl2 = this.isCellSelectionEnabled();
        int n5 = this.treeTableView.getVisibleLeafIndex((TreeTableColumn)tableColumnBase);
        int n6 = this.treeTableView.getVisibleLeafIndex((TreeTableColumn)tableColumnBase2);
        int n7 = Math.min(n5, n6);
        n5 = Math.max(n5, n6);
        n6 = Math.min(n2, n3);
        int n8 = Math.max(n2, n3);
        ArrayList arrayList = new ArrayList();
        while (n6 <= n8) {
            if (n6 >= 0 && n6 < n4) {
                if (!bl2) {
                    arrayList.add(new TreeTablePosition(this.treeTableView, n6, (TreeTableColumn)tableColumnBase));
                } else {
                    for (int i2 = n7; i2 <= n5; ++i2) {
                        TreeTableColumn<S, ?> treeTableColumn = this.treeTableView.getVisibleLeafColumn(i2);
                        if (treeTableColumn == null && bl2) continue;
                        arrayList.add(new TreeTablePosition(this.treeTableView, n6, treeTableColumn));
                    }
                }
            }
            ++n6;
        }
        arrayList.removeAll(((TreeTableView$TreeTableViewSelectionModel)this).getSelectedCells());
        this.selectedCellsMap.addAll(arrayList);
        this.stopAtomic();
        this.updateSelectedIndex(n3);
        this.focus(n3, (TreeTableColumn)tableColumnBase2);
        TreeTableColumn treeTableColumn = (TreeTableColumn)tableColumnBase;
        TreeTableColumn treeTableColumn2 = bl2 ? (TreeTableColumn)tableColumnBase2 : treeTableColumn;
        int n9 = this.selectedCellsMap.indexOf(new TreeTablePosition(this.treeTableView, n2, treeTableColumn));
        n2 = this.selectedCellsMap.indexOf(new TreeTablePosition(this.treeTableView, n3, treeTableColumn2));
        if (n9 >= 0 && n2 >= 0) {
            int n10 = Math.min(n9, n2);
            n2 = Math.max(n9, n2);
            NonIterableChange$SimpleAddChange nonIterableChange$SimpleAddChange = new NonIterableChange$SimpleAddChange(n10, n2 + 1, this.selectedCellsSeq);
            this.fireCustomSelectedCellsListChangeEvent(nonIterableChange$SimpleAddChange);
        }
    }

    @Override
    public void clearSelection(int n2) {
        ((TableSelectionModel)this).clearSelection(n2, null);
    }

    @Override
    public void clearSelection(int n2, TableColumnBase<TreeItem<S>, ?> tableColumnBase) {
        this.clearSelection(new TreeTablePosition(this.getTreeTableView(), n2, (TreeTableColumn)tableColumnBase));
    }

    private void clearSelection(TreeTablePosition<S, ?> treeTablePosition) {
        boolean bl2 = this.isCellSelectionEnabled();
        int n2 = treeTablePosition.getRow();
        boolean bl3 = treeTablePosition.getTableColumn() == null;
        ArrayList arrayList = new ArrayList();
        for (TreeTablePosition treeTablePosition2 : ((TreeTableView$TreeTableViewSelectionModel)this).getSelectedCells()) {
            if (!bl2) {
                if (treeTablePosition2.getRow() != n2) continue;
                arrayList.add(treeTablePosition2);
                break;
            }
            if (bl3 && treeTablePosition2.getRow() == n2) {
                arrayList.add(treeTablePosition2);
                continue;
            }
            if (!treeTablePosition2.equals(treeTablePosition)) continue;
            arrayList.add(treeTablePosition);
            break;
        }
        arrayList.stream().forEach(this.selectedCellsMap::remove);
        if (((SelectionModel)this).isEmpty() && !this.isAtomic()) {
            this.updateSelectedIndex(-1);
            this.selectedCellsMap.clear();
        }
    }

    @Override
    public void clearSelection() {
        Object object = new ArrayList(((TreeTableView$TreeTableViewSelectionModel)this).getSelectedCells());
        this.quietClearSelection();
        if (!this.isAtomic()) {
            this.updateSelectedIndex(-1);
            ((TreeTableView$TreeTableViewSelectionModel)this).focus(-1);
            if (!object.isEmpty()) {
                object = new TreeTableView$TreeTableViewArrayListSelectionModel$4(this, 0, 0, this.selectedCellsSeq, (List)object);
                this.fireCustomSelectedCellsListChangeEvent((ListChangeListener$Change<? extends TreeTablePosition<S, ?>>)object);
            }
        }
    }

    private void quietClearSelection() {
        this.startAtomic();
        this.selectedCellsMap.clear();
        this.stopAtomic();
    }

    @Override
    public boolean isSelected(int n2, TableColumnBase<TreeItem<S>, ?> tableColumnBase) {
        int n3 = this.isCellSelectionEnabled();
        if (n3 != 0 && tableColumnBase == null) {
            int n4 = this.treeTableView.getVisibleLeafColumns().size();
            for (n3 = 0; n3 < n4; ++n3) {
                if (this.selectedCellsMap.isSelected(n2, n3)) continue;
                return false;
            }
            return true;
        }
        int n5 = n3 == 0 || tableColumnBase == null ? -1 : this.treeTableView.getVisibleLeafIndex((TreeTableColumn)tableColumnBase);
        return this.selectedCellsMap.isSelected(n2, n5);
    }

    @Override
    public boolean isEmpty() {
        return this.selectedCellsMap.isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void selectPrevious() {
        if (this.isCellSelectionEnabled()) {
            TreeTablePosition<S, ?> treeTablePosition = this.getFocusedCell();
            if (((TablePositionBase)treeTablePosition).getColumn() - 1 >= 0) {
                ((TableSelectionModel)this).select(treeTablePosition.getRow(), this.getTableColumn((TreeTableColumn<S, ?>)treeTablePosition.getTableColumn(), -1));
                return;
            }
            if (treeTablePosition.getRow() >= this.getRowCount() - 1) return;
            TreeTableView$TreeTableViewArrayListSelectionModel treeTableView$TreeTableViewArrayListSelectionModel = this;
            ((TableSelectionModel)this).select(treeTablePosition.getRow() - 1, treeTableView$TreeTableViewArrayListSelectionModel.getTableColumn(treeTableView$TreeTableViewArrayListSelectionModel.getTreeTableView().getVisibleLeafColumns().size() - 1));
            return;
        }
        int n2 = ((TreeTableView$TreeTableViewSelectionModel)this).getFocusedIndex();
        if (n2 == -1) {
            TreeTableView$TreeTableViewArrayListSelectionModel treeTableView$TreeTableViewArrayListSelectionModel = this;
            ((SelectionModel)treeTableView$TreeTableViewArrayListSelectionModel).select(treeTableView$TreeTableViewArrayListSelectionModel.getRowCount() - 1);
            return;
        }
        if (n2 <= 0) return;
        ((SelectionModel)this).select(n2 - 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void selectNext() {
        if (this.isCellSelectionEnabled()) {
            TreeTablePosition<S, ?> treeTablePosition = this.getFocusedCell();
            if (((TablePositionBase)treeTablePosition).getColumn() + 1 < this.getTreeTableView().getVisibleLeafColumns().size()) {
                ((TableSelectionModel)this).select(treeTablePosition.getRow(), this.getTableColumn((TreeTableColumn<S, ?>)treeTablePosition.getTableColumn(), 1));
                return;
            }
            if (treeTablePosition.getRow() >= this.getRowCount() - 1) return;
            ((TableSelectionModel)this).select(treeTablePosition.getRow() + 1, this.getTableColumn(0));
            return;
        }
        int n2 = ((TreeTableView$TreeTableViewSelectionModel)this).getFocusedIndex();
        if (n2 == -1) {
            ((SelectionModel)this).select(0);
            return;
        }
        if (n2 >= this.getRowCount() - 1) return;
        ((SelectionModel)this).select(n2 + 1);
    }

    @Override
    public void selectAboveCell() {
        TreeTablePosition<S, ?> treeTablePosition = this.getFocusedCell();
        if (treeTablePosition.getRow() == -1) {
            TreeTableView$TreeTableViewArrayListSelectionModel treeTableView$TreeTableViewArrayListSelectionModel = this;
            ((SelectionModel)treeTableView$TreeTableViewArrayListSelectionModel).select(treeTableView$TreeTableViewArrayListSelectionModel.getRowCount() - 1);
            return;
        }
        if (treeTablePosition.getRow() > 0) {
            ((TableSelectionModel)this).select(treeTablePosition.getRow() - 1, treeTablePosition.getTableColumn());
        }
    }

    @Override
    public void selectBelowCell() {
        TreeTablePosition<S, ?> treeTablePosition = this.getFocusedCell();
        if (treeTablePosition.getRow() == -1) {
            ((SelectionModel)this).select(0);
            return;
        }
        if (treeTablePosition.getRow() < this.getRowCount() - 1) {
            ((TableSelectionModel)this).select(treeTablePosition.getRow() + 1, treeTablePosition.getTableColumn());
        }
    }

    @Override
    public void selectFirst() {
        TreeTablePosition<S, ?> treeTablePosition = this.getFocusedCell();
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
        }
        if (this.getRowCount() > 0) {
            if (this.isCellSelectionEnabled()) {
                ((TableSelectionModel)this).select(0, treeTablePosition.getTableColumn());
                return;
            }
            ((SelectionModel)this).select(0);
        }
    }

    @Override
    public void selectLast() {
        int n2;
        TreeTablePosition<S, ?> treeTablePosition = this.getFocusedCell();
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
        }
        if ((n2 = this.getRowCount()) > 0 && this.getSelectedIndex() < n2 - 1) {
            if (this.isCellSelectionEnabled()) {
                ((TableSelectionModel)this).select(n2 - 1, treeTablePosition.getTableColumn());
                return;
            }
            ((SelectionModel)this).select(n2 - 1);
        }
    }

    @Override
    public void selectLeftCell() {
        if (!this.isCellSelectionEnabled()) {
            return;
        }
        TreeTablePosition<S, ?> treeTablePosition = this.getFocusedCell();
        if (((TablePositionBase)treeTablePosition).getColumn() - 1 >= 0) {
            ((TableSelectionModel)this).select(treeTablePosition.getRow(), this.getTableColumn((TreeTableColumn<S, ?>)treeTablePosition.getTableColumn(), -1));
        }
    }

    @Override
    public void selectRightCell() {
        if (!this.isCellSelectionEnabled()) {
            return;
        }
        TreeTablePosition<S, ?> treeTablePosition = this.getFocusedCell();
        if (((TablePositionBase)treeTablePosition).getColumn() + 1 < this.getTreeTableView().getVisibleLeafColumns().size()) {
            ((TableSelectionModel)this).select(treeTablePosition.getRow(), this.getTableColumn((TreeTableColumn<S, ?>)treeTablePosition.getTableColumn(), 1));
        }
    }

    private void updateDefaultSelection() {
        int n2 = -1;
        TreeItem treeItem = (TreeItem)this.getSelectedItem();
        if (treeItem != null) {
            n2 = this.treeTableView.getRow(treeItem);
        }
        int n3 = n2 != -1 ? n2 : (this.treeTableView.getExpandedItemCount() > 0 ? 0 : -1);
        ((SelectionModel)this).clearSelection();
        ((TableSelectionModel)this).select(n2, this.isCellSelectionEnabled() ? this.getTableColumn(0) : null);
        this.focus(n3, this.isCellSelectionEnabled() ? this.getTableColumn(0) : null);
    }

    private TreeTableColumn<S, ?> getTableColumn(int n2) {
        return this.getTreeTableView().getVisibleLeafColumn(n2);
    }

    private TreeTableColumn<S, ?> getTableColumn(TreeTableColumn<S, ?> treeTableColumn, int n2) {
        int n3 = this.getTreeTableView().getVisibleLeafIndex(treeTableColumn);
        return this.getTreeTableView().getVisibleLeafColumn(n3 += n2);
    }

    private void updateSelectedIndex(int n2) {
        this.setSelectedIndex(n2);
        TreeTableView$TreeTableViewArrayListSelectionModel treeTableView$TreeTableViewArrayListSelectionModel = this;
        treeTableView$TreeTableViewArrayListSelectionModel.setSelectedItem(treeTableView$TreeTableViewArrayListSelectionModel.getModelItem(n2));
    }

    @Override
    public void focus(int n2) {
        this.focus(n2, null);
    }

    private void focus(int n2, TreeTableColumn<S, ?> treeTableColumn) {
        this.focus(new TreeTablePosition(this.getTreeTableView(), n2, treeTableColumn));
    }

    private void focus(TreeTablePosition<S, ?> treeTablePosition) {
        if (this.getTreeTableView().getFocusModel() == null) {
            return;
        }
        this.getTreeTableView().getFocusModel().focus(treeTablePosition.getRow(), treeTablePosition.getTableColumn());
        this.getTreeTableView().notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUS_ITEM);
    }

    @Override
    public int getFocusedIndex() {
        return this.getFocusedCell().getRow();
    }

    private TreeTablePosition<S, ?> getFocusedCell() {
        if (this.treeTableView.getFocusModel() == null) {
            return new TreeTablePosition(this.treeTableView, -1, null);
        }
        return this.treeTableView.getFocusModel().getFocusedCell();
    }

    private int getRowCount() {
        return this.treeTableView.getExpandedItemCount();
    }

    private void fireCustomSelectedCellsListChangeEvent(ListChangeListener$Change<? extends TreeTablePosition<S, ?>> listChangeListener$Change) {
        IntPredicate intPredicate = n2 -> !this.isCellSelectionEnabled() || ((TreeTableView$TreeTableViewSelectionModel)this).getSelectedCells().stream().noneMatch(treeTablePosition -> treeTablePosition.getRow() == n2);
        TreeTableView$TreeTableViewArrayListSelectionModel treeTableView$TreeTableViewArrayListSelectionModel = this;
        ControlUtils.updateSelectedIndices(treeTableView$TreeTableViewArrayListSelectionModel, treeTableView$TreeTableViewArrayListSelectionModel.isCellSelectionEnabled(), listChangeListener$Change, intPredicate);
        if (this.isAtomic()) {
            return;
        }
        this.selectedCellsSeq.callObservers(new MappingChange(listChangeListener$Change, Function.identity(), this.selectedCellsSeq));
    }
}

