/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.scene.AccessibleAttribute;
import javafx.scene.control.FocusModel;
import javafx.scene.control.TableFocusModel;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeItem$TreeModificationEvent;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTablePosition;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.TreeTableView$TreeTableViewFocusModel$1;
import javafx.scene.control.TreeTableView$TreeTableViewFocusModel$2;

public class TreeTableView$TreeTableViewFocusModel<S>
extends TableFocusModel<TreeItem<S>, TreeTableColumn<S, ?>> {
    private final TreeTableView<S> treeTableView;
    private final TreeTablePosition<S, ?> EMPTY_CELL;
    private final ChangeListener<TreeItem<S>> rootPropertyListener = (observableValue, treeItem, treeItem2) -> this.updateTreeEventListener((TreeItem<S>)treeItem, (TreeItem<S>)treeItem2);
    private final WeakChangeListener<TreeItem<S>> weakRootPropertyListener = new WeakChangeListener<TreeItem<S>>(this.rootPropertyListener);
    private final InvalidationListener showRootListener;
    private EventHandler<TreeItem$TreeModificationEvent<S>> treeItemListener = new TreeTableView$TreeTableViewFocusModel$1(this);
    private WeakEventHandler<TreeItem$TreeModificationEvent<S>> weakTreeItemListener;
    private ReadOnlyObjectWrapper<TreeTablePosition<S, ?>> focusedCell;

    public TreeTableView$TreeTableViewFocusModel(TreeTableView<S> treeTableView) {
        if (treeTableView == null) {
            throw new NullPointerException("TableView can not be null");
        }
        this.treeTableView = treeTableView;
        this.EMPTY_CELL = new TreeTablePosition(treeTableView, -1, null);
        this.treeTableView.rootProperty().addListener(this.weakRootPropertyListener);
        this.updateTreeEventListener(null, treeTableView.getRoot());
        int n2 = this.getItemCount() > 0 ? 0 : -1;
        TreeTablePosition treeTablePosition = new TreeTablePosition(treeTableView, n2, null);
        this.setFocusedCell(treeTablePosition);
        this.showRootListener = observable -> {
            if (this.isFocused(0)) {
                ((FocusModel)this).focus(-1);
                ((FocusModel)this).focus(0);
            }
        };
        treeTableView.showRootProperty().addListener(new WeakInvalidationListener(this.showRootListener));
        this.focusedCellProperty().addListener(observable -> treeTableView.notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUS_ITEM));
    }

    private void updateTreeEventListener(TreeItem<S> treeItem, TreeItem<S> treeItem2) {
        if (treeItem != null && this.weakTreeItemListener != null) {
            treeItem.removeEventHandler(TreeItem.expandedItemCountChangeEvent(), this.weakTreeItemListener);
        }
        if (treeItem2 != null) {
            this.weakTreeItemListener = new WeakEventHandler<TreeItem$TreeModificationEvent<S>>(this.treeItemListener);
            treeItem2.addEventHandler(TreeItem.expandedItemCountChangeEvent(), this.weakTreeItemListener);
        }
    }

    @Override
    protected int getItemCount() {
        return this.treeTableView.getExpandedItemCount();
    }

    @Override
    protected TreeItem<S> getModelItem(int n2) {
        if (n2 < 0 || n2 >= this.getItemCount()) {
            return null;
        }
        return this.treeTableView.getTreeItem(n2);
    }

    public final ReadOnlyObjectProperty<TreeTablePosition<S, ?>> focusedCellProperty() {
        return this.focusedCellPropertyImpl().getReadOnlyProperty();
    }

    private void setFocusedCell(TreeTablePosition<S, ?> treeTablePosition) {
        this.focusedCellPropertyImpl().set(treeTablePosition);
    }

    public final TreeTablePosition<S, ?> getFocusedCell() {
        if (this.focusedCell == null) {
            return this.EMPTY_CELL;
        }
        return (TreeTablePosition)this.focusedCell.get();
    }

    private ReadOnlyObjectWrapper<TreeTablePosition<S, ?>> focusedCellPropertyImpl() {
        if (this.focusedCell == null) {
            TreeTableView$TreeTableViewFocusModel treeTableView$TreeTableViewFocusModel = this;
            this.focusedCell = new TreeTableView$TreeTableViewFocusModel$2(treeTableView$TreeTableViewFocusModel, treeTableView$TreeTableViewFocusModel.EMPTY_CELL);
        }
        return this.focusedCell;
    }

    @Override
    public void focus(int n2, TreeTableColumn<S, ?> object) {
        if (n2 < 0 || n2 >= this.getItemCount()) {
            TreeTableView$TreeTableViewFocusModel treeTableView$TreeTableViewFocusModel = this;
            treeTableView$TreeTableViewFocusModel.setFocusedCell(treeTableView$TreeTableViewFocusModel.EMPTY_CELL);
            return;
        }
        TreeTablePosition<S, ?> treeTablePosition = this.getFocusedCell();
        object = new TreeTablePosition(this.treeTableView, n2, object);
        this.setFocusedCell((TreeTablePosition<S, ?>)object);
        if (((TablePositionBase)object).equals(treeTablePosition)) {
            this.setFocusedIndex(n2);
            TreeTableView$TreeTableViewFocusModel treeTableView$TreeTableViewFocusModel = this;
            treeTableView$TreeTableViewFocusModel.setFocusedItem(treeTableView$TreeTableViewFocusModel.getModelItem(n2));
        }
    }

    public void focus(TreeTablePosition<S, ?> treeTablePosition) {
        if (treeTablePosition == null) {
            return;
        }
        this.focus(treeTablePosition.getRow(), (TreeTableColumn<S, ?>)treeTablePosition.getTableColumn());
    }

    @Override
    public boolean isFocused(int n2, TreeTableColumn<S, ?> treeTableColumn) {
        boolean bl2;
        if (n2 < 0 || n2 >= this.getItemCount()) {
            return false;
        }
        TreeTablePosition<S, ?> treeTablePosition = this.getFocusedCell();
        boolean bl3 = bl2 = treeTableColumn == null || treeTableColumn.equals(treeTablePosition.getTableColumn());
        return treeTablePosition.getRow() == n2 && bl2;
    }

    @Override
    public void focus(int n2) {
        if (this.treeTableView.expandedItemCountDirty) {
            this.treeTableView.updateExpandedItemCount(this.treeTableView.getRoot());
        }
        if (n2 < 0 || n2 >= this.getItemCount()) {
            TreeTableView$TreeTableViewFocusModel treeTableView$TreeTableViewFocusModel = this;
            treeTableView$TreeTableViewFocusModel.setFocusedCell(treeTableView$TreeTableViewFocusModel.EMPTY_CELL);
            return;
        }
        this.setFocusedCell(new TreeTablePosition(this.treeTableView, n2, null));
    }

    @Override
    public void focusAboveCell() {
        TreeTablePosition<S, ?> treeTablePosition = this.getFocusedCell();
        if (this.getFocusedIndex() == -1) {
            TreeTableView$TreeTableViewFocusModel treeTableView$TreeTableViewFocusModel = this;
            treeTableView$TreeTableViewFocusModel.focus(treeTableView$TreeTableViewFocusModel.getItemCount() - 1, (TreeTableColumn<S, ?>)treeTablePosition.getTableColumn());
            return;
        }
        if (this.getFocusedIndex() > 0) {
            TreeTableView$TreeTableViewFocusModel treeTableView$TreeTableViewFocusModel = this;
            treeTableView$TreeTableViewFocusModel.focus(treeTableView$TreeTableViewFocusModel.getFocusedIndex() - 1, (TreeTableColumn<S, ?>)treeTablePosition.getTableColumn());
        }
    }

    @Override
    public void focusBelowCell() {
        TreeTablePosition<S, ?> treeTablePosition = this.getFocusedCell();
        if (this.getFocusedIndex() == -1) {
            this.focus(0, (TreeTableColumn<S, ?>)treeTablePosition.getTableColumn());
            return;
        }
        if (this.getFocusedIndex() != this.getItemCount() - 1) {
            TreeTableView$TreeTableViewFocusModel treeTableView$TreeTableViewFocusModel = this;
            treeTableView$TreeTableViewFocusModel.focus(treeTableView$TreeTableViewFocusModel.getFocusedIndex() + 1, (TreeTableColumn<S, ?>)treeTablePosition.getTableColumn());
        }
    }

    @Override
    public void focusLeftCell() {
        TreeTablePosition<S, ?> treeTablePosition = this.getFocusedCell();
        if (((TablePositionBase)treeTablePosition).getColumn() <= 0) {
            return;
        }
        this.focus(treeTablePosition.getRow(), this.getTableColumn((TreeTableColumn<S, ?>)treeTablePosition.getTableColumn(), -1));
    }

    @Override
    public void focusRightCell() {
        TreeTablePosition<S, ?> treeTablePosition = this.getFocusedCell();
        if (((TablePositionBase)treeTablePosition).getColumn() == this.getColumnCount() - 1) {
            return;
        }
        this.focus(treeTablePosition.getRow(), this.getTableColumn((TreeTableColumn<S, ?>)treeTablePosition.getTableColumn(), 1));
    }

    @Override
    public void focusPrevious() {
        if (this.getFocusedIndex() == -1) {
            ((FocusModel)this).focus(0);
            return;
        }
        if (this.getFocusedIndex() > 0) {
            ((TableFocusModel)this).focusAboveCell();
        }
    }

    @Override
    public void focusNext() {
        if (this.getFocusedIndex() == -1) {
            ((FocusModel)this).focus(0);
            return;
        }
        if (this.getFocusedIndex() != this.getItemCount() - 1) {
            ((TableFocusModel)this).focusBelowCell();
        }
    }

    private int getColumnCount() {
        return this.treeTableView.getVisibleLeafColumns().size();
    }

    private TreeTableColumn<S, ?> getTableColumn(TreeTableColumn<S, ?> treeTableColumn, int n2) {
        int n3 = this.treeTableView.getVisibleLeafIndex(treeTableColumn);
        return this.treeTableView.getVisibleLeafColumn(n3 += n2);
    }
}

