/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import javafx.collections.ObservableList;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTablePosition;
import javafx.scene.control.TreeTableView;

public abstract class TreeTableView$TreeTableViewSelectionModel<S>
extends TableSelectionModel<TreeItem<S>> {
    private final TreeTableView<S> treeTableView;

    public TreeTableView$TreeTableViewSelectionModel(TreeTableView<S> treeTableView) {
        if (treeTableView == null) {
            throw new NullPointerException("TreeTableView can not be null");
        }
        this.treeTableView = treeTableView;
    }

    public abstract ObservableList<TreeTablePosition<S, ?>> getSelectedCells();

    public TreeTableView<S> getTreeTableView() {
        return this.treeTableView;
    }

    @Override
    public TreeItem<S> getModelItem(int n2) {
        return this.treeTableView.getTreeItem(n2);
    }

    @Override
    protected int getItemCount() {
        return this.treeTableView.getExpandedItemCount();
    }

    @Override
    public void focus(int n2) {
        this.focus(n2, null);
    }

    @Override
    public int getFocusedIndex() {
        return this.getFocusedCell().getRow();
    }

    @Override
    public void selectRange(int n2, TableColumnBase<TreeItem<S>, ?> tableColumnBase, int n3, TableColumnBase<TreeItem<S>, ?> tableColumnBase2) {
        int n4 = this.treeTableView.getVisibleLeafIndex((TreeTableColumn)tableColumnBase);
        int n5 = this.treeTableView.getVisibleLeafIndex((TreeTableColumn)tableColumnBase2);
        while (n2 <= n3) {
            for (int i2 = n4; i2 <= n5; ++i2) {
                this.select(n2, this.treeTableView.getVisibleLeafColumn(i2));
            }
            ++n2;
        }
    }

    private void focus(int n2, TreeTableColumn<S, ?> treeTableColumn) {
        this.focus(new TreeTablePosition(this.getTreeTableView(), n2, treeTableColumn));
    }

    private void focus(TreeTablePosition<S, ?> treeTablePosition) {
        if (this.getTreeTableView().getFocusModel() == null) {
            return;
        }
        this.getTreeTableView().getFocusModel().focus(treeTablePosition.getRow(), (TreeTableColumn<S, ?>)treeTablePosition.getTableColumn());
    }

    private TreeTablePosition<S, ?> getFocusedCell() {
        if (this.treeTableView.getFocusModel() == null) {
            return new TreeTablePosition(this.treeTableView, -1, null);
        }
        return this.treeTableView.getFocusModel().getFocusedCell();
    }
}

