/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.collections.NonIterableChange$GenericAddRemoveChange;
import com.sun.javafx.scene.control.ConstrainedColumnResize;
import com.sun.javafx.scene.control.ConstrainedColumnResize$ResizeMode;
import com.sun.javafx.scene.control.TableColumnComparatorBase$TreeTableColumnComparator;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.event.WeakEventHandler;
import javafx.scene.AccessibleAttribute;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ControlUtils;
import javafx.scene.control.FocusModel;
import javafx.scene.control.ScrollToEvent;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Skin;
import javafx.scene.control.SortEvent;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableUtil;
import javafx.scene.control.TableUtil$SortEventType;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeItem$TreeModificationEvent;
import javafx.scene.control.TreeSortMode;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTablePosition;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView$1;
import javafx.scene.control.TreeTableView$10;
import javafx.scene.control.TreeTableView$11;
import javafx.scene.control.TreeTableView$12;
import javafx.scene.control.TreeTableView$2;
import javafx.scene.control.TreeTableView$3;
import javafx.scene.control.TreeTableView$4;
import javafx.scene.control.TreeTableView$5;
import javafx.scene.control.TreeTableView$6;
import javafx.scene.control.TreeTableView$7;
import javafx.scene.control.TreeTableView$8;
import javafx.scene.control.TreeTableView$9;
import javafx.scene.control.TreeTableView$EditEvent;
import javafx.scene.control.TreeTableView$ResizeFeatures;
import javafx.scene.control.TreeTableView$StyleableProperties;
import javafx.scene.control.TreeTableView$TreeTableViewArrayListSelectionModel;
import javafx.scene.control.TreeTableView$TreeTableViewFocusModel;
import javafx.scene.control.TreeTableView$TreeTableViewSelectionModel;
import javafx.scene.control.TreeUtil;
import javafx.scene.control.TreeView;
import javafx.scene.control.skin.TreeTableViewSkin;
import javafx.util.Callback;

@DefaultProperty(value="root")
public class TreeTableView<S>
extends Control {
    private static final EventType<?> EDIT_ANY_EVENT = new EventType<Event>(Event.ANY, "TREE_TABLE_VIEW_EDIT");
    private static final EventType<?> EDIT_START_EVENT = new EventType(TreeTableView.editAnyEvent(), "EDIT_START");
    private static final EventType<?> EDIT_CANCEL_EVENT = new EventType(TreeTableView.editAnyEvent(), "EDIT_CANCEL");
    private static final EventType<?> EDIT_COMMIT_EVENT = new EventType(TreeTableView.editAnyEvent(), "EDIT_COMMIT");
    public static final Callback<TreeTableView$ResizeFeatures, Boolean> UNCONSTRAINED_RESIZE_POLICY = new TreeTableView$1();
    public static final Callback<TreeTableView$ResizeFeatures, Boolean> CONSTRAINED_RESIZE_POLICY_ALL_COLUMNS = ConstrainedColumnResize.forTreeTable(ConstrainedColumnResize$ResizeMode.AUTO_RESIZE_ALL_COLUMNS);
    public static final Callback<TreeTableView$ResizeFeatures, Boolean> CONSTRAINED_RESIZE_POLICY_LAST_COLUMN = ConstrainedColumnResize.forTreeTable(ConstrainedColumnResize$ResizeMode.AUTO_RESIZE_LAST_COLUMN);
    public static final Callback<TreeTableView$ResizeFeatures, Boolean> CONSTRAINED_RESIZE_POLICY_NEXT_COLUMN = ConstrainedColumnResize.forTreeTable(ConstrainedColumnResize$ResizeMode.AUTO_RESIZE_NEXT_COLUMN);
    public static final Callback<TreeTableView$ResizeFeatures, Boolean> CONSTRAINED_RESIZE_POLICY_SUBSEQUENT_COLUMNS = ConstrainedColumnResize.forTreeTable(ConstrainedColumnResize$ResizeMode.AUTO_RESIZE_SUBSEQUENT_COLUMNS);
    public static final Callback<TreeTableView$ResizeFeatures, Boolean> CONSTRAINED_RESIZE_POLICY_FLEX_NEXT_COLUMN = ConstrainedColumnResize.forTreeTable(ConstrainedColumnResize$ResizeMode.AUTO_RESIZE_FLEX_HEAD);
    public static final Callback<TreeTableView$ResizeFeatures, Boolean> CONSTRAINED_RESIZE_POLICY_FLEX_LAST_COLUMN;
    @Deprecated(since="20")
    public static final Callback<TreeTableView$ResizeFeatures, Boolean> CONSTRAINED_RESIZE_POLICY;
    public static final Callback<TreeTableView, Boolean> DEFAULT_SORT_POLICY;
    private boolean expandedItemCountDirty = true;
    private Map<Integer, SoftReference<TreeItem<S>>> treeItemCacheMap = new HashMap<Integer, SoftReference<TreeItem<S>>>();
    private final ObservableList<TreeTableColumn<S, ?>> columns = FXCollections.observableArrayList();
    private final ObservableList<TreeTableColumn<S, ?>> visibleLeafColumns = FXCollections.observableArrayList();
    private final ObservableList<TreeTableColumn<S, ?>> unmodifiableVisibleLeafColumns = FXCollections.unmodifiableObservableList(this.visibleLeafColumns);
    private ObservableList<TreeTableColumn<S, ?>> sortOrder = FXCollections.observableArrayList();
    double contentWidth;
    private boolean isInited = false;
    private final EventHandler<TreeItem$TreeModificationEvent<S>> rootEvent = serializable -> {
        boolean bl2 = false;
        for (serializable = ((Event)serializable).getEventType(); serializable != null; serializable = ((EventType)((Object)serializable)).getSuperType()) {
            if (!serializable.equals(TreeItem.expandedItemCountChangeEvent())) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            this.expandedItemCountDirty = true;
            this.requestLayout();
        }
    };
    private final ListChangeListener<TreeTableColumn<S, ?>> columnsObserver = new TreeTableView$3(this);
    private final WeakHashMap<TreeTableColumn<S, ?>, Integer> lastKnownColumnIndex = new WeakHashMap();
    private final InvalidationListener columnVisibleObserver = observable -> this.updateVisibleLeafColumns();
    private final InvalidationListener columnSortableObserver = object -> {
        object = (TreeTableColumn)((BooleanProperty)object).getBean();
        if (!this.getSortOrder().contains(object)) {
            return;
        }
        this.doSort(TableUtil$SortEventType.COLUMN_SORTABLE_CHANGE, object);
    };
    private final InvalidationListener columnSortTypeObserver = object -> {
        object = (TreeTableColumn)((ObjectProperty)object).getBean();
        if (!this.getSortOrder().contains(object)) {
            return;
        }
        this.doSort(TableUtil$SortEventType.COLUMN_SORT_TYPE_CHANGE, object);
    };
    private final InvalidationListener columnComparatorObserver = object -> {
        object = (TreeTableColumn)((SimpleObjectProperty)object).getBean();
        if (!this.getSortOrder().contains(object)) {
            return;
        }
        this.doSort(TableUtil$SortEventType.COLUMN_COMPARATOR_CHANGE, object);
    };
    private final InvalidationListener cellSelectionModelInvalidationListener = observable -> {
        boolean bl2 = ((BooleanProperty)observable).get();
        this.pseudoClassStateChanged(PSEUDO_CLASS_CELL_SELECTION, bl2);
        this.pseudoClassStateChanged(PSEUDO_CLASS_ROW_SELECTION, !bl2);
    };
    private WeakEventHandler<TreeItem$TreeModificationEvent<S>> weakRootEventListener;
    private final WeakInvalidationListener weakColumnVisibleObserver = new WeakInvalidationListener(this.columnVisibleObserver);
    private final WeakInvalidationListener weakColumnSortableObserver = new WeakInvalidationListener(this.columnSortableObserver);
    private final WeakInvalidationListener weakColumnSortTypeObserver = new WeakInvalidationListener(this.columnSortTypeObserver);
    private final WeakInvalidationListener weakColumnComparatorObserver = new WeakInvalidationListener(this.columnComparatorObserver);
    private final WeakListChangeListener<TreeTableColumn<S, ?>> weakColumnsObserver = new WeakListChangeListener(this.columnsObserver);
    private final WeakInvalidationListener weakCellSelectionModelInvalidationListener = new WeakInvalidationListener(this.cellSelectionModelInvalidationListener);
    private ObjectProperty<TreeItem<S>> root;
    private BooleanProperty showRoot;
    private ObjectProperty<TreeTableColumn<S, ?>> treeColumn;
    private ObjectProperty<TreeTableView$TreeTableViewSelectionModel<S>> selectionModel;
    private ObjectProperty<TreeTableView$TreeTableViewFocusModel<S>> focusModel;
    private ReadOnlyIntegerWrapper expandedItemCount;
    private BooleanProperty editable;
    private ReadOnlyObjectWrapper<TreeTablePosition<S, ?>> editingCell;
    private BooleanProperty tableMenuButtonVisible;
    private ObjectProperty<Callback<TreeTableView$ResizeFeatures, Boolean>> columnResizePolicy;
    private ObjectProperty<Callback<TreeTableView<S>, TreeTableRow<S>>> rowFactory;
    private ObjectProperty<Node> placeholder;
    private DoubleProperty fixedCellSize;
    private ObjectProperty<TreeSortMode> sortMode;
    private ReadOnlyObjectWrapper<Comparator<TreeItem<S>>> comparator;
    private ObjectProperty<Callback<TreeTableView<S>, Boolean>> sortPolicy;
    private ObjectProperty<EventHandler<SortEvent<TreeTableView<S>>>> onSort;
    private ObjectProperty<EventHandler<ScrollToEvent<Integer>>> onScrollTo;
    private ObjectProperty<EventHandler<ScrollToEvent<TreeTableColumn<S, ?>>>> onScrollToColumn;
    private boolean sortingInProgress;
    private boolean sortLock;
    private TableUtil$SortEventType lastSortEventType;
    private Object[] lastSortEventSupportInfo;
    private static final String DEFAULT_STYLE_CLASS = "tree-table-view";
    private static final PseudoClass PSEUDO_CLASS_CELL_SELECTION;
    private static final PseudoClass PSEUDO_CLASS_ROW_SELECTION;

    public TreeTableView() {
        this(null);
    }

    public TreeTableView(TreeItem<S> treeItem) {
        TreeTableView treeTableView = this;
        this.root = new TreeTableView$4(treeTableView, treeTableView, "root");
        this.expandedItemCount = new ReadOnlyIntegerWrapper(this, "expandedItemCount", 0);
        this.sortLock = false;
        this.lastSortEventType = null;
        this.lastSortEventSupportInfo = null;
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setAccessibleRole(AccessibleRole.TREE_TABLE_VIEW);
        this.setRoot(treeItem);
        this.updateExpandedItemCount(treeItem);
        this.setSelectionModel(new TreeTableView$TreeTableViewArrayListSelectionModel(this));
        this.setFocusModel(new TreeTableView$TreeTableViewFocusModel(this));
        this.getColumns().addListener(this.weakColumnsObserver);
        this.getSortOrder().addListener(listChangeListener$Change -> this.doSort(TableUtil$SortEventType.SORT_ORDER_CHANGE, listChangeListener$Change));
        this.getProperties().addListener(mapChangeListener$Change -> {
            if (mapChangeListener$Change.wasAdded() && "TableView.contentWidth".equals(mapChangeListener$Change.getKey())) {
                if (mapChangeListener$Change.getValueAdded() instanceof Number) {
                    this.setContentWidth((Double)mapChangeListener$Change.getValueAdded());
                }
                this.getProperties().remove("TableView.contentWidth");
            }
        });
        TreeTableView treeTableView2 = this;
        treeTableView2.pseudoClassStateChanged(PseudoClass.getPseudoClass(treeTableView2.getColumnResizePolicy().toString()), true);
        this.isInited = true;
    }

    public static <S> EventType<TreeTableView$EditEvent<S>> editAnyEvent() {
        return EDIT_ANY_EVENT;
    }

    public static <S> EventType<TreeTableView$EditEvent<S>> editStartEvent() {
        return EDIT_START_EVENT;
    }

    public static <S> EventType<TreeTableView$EditEvent<S>> editCancelEvent() {
        return EDIT_CANCEL_EVENT;
    }

    public static <S> EventType<TreeTableView$EditEvent<S>> editCommitEvent() {
        return EDIT_COMMIT_EVENT;
    }

    @Deprecated(since="8u20")
    public static int getNodeLevel(TreeItem<?> treeItem) {
        return TreeView.getNodeLevel(treeItem);
    }

    public final void setRoot(TreeItem<S> treeItem) {
        this.rootProperty().set(treeItem);
    }

    public final TreeItem<S> getRoot() {
        if (this.root == null) {
            return null;
        }
        return (TreeItem)this.root.get();
    }

    public final ObjectProperty<TreeItem<S>> rootProperty() {
        return this.root;
    }

    public final void setShowRoot(boolean bl2) {
        this.showRootProperty().set(bl2);
    }

    public final boolean isShowRoot() {
        if (this.showRoot == null) {
            return true;
        }
        return this.showRoot.get();
    }

    public final BooleanProperty showRootProperty() {
        if (this.showRoot == null) {
            TreeTableView treeTableView = this;
            this.showRoot = new TreeTableView$5(treeTableView, treeTableView, "showRoot", true);
        }
        return this.showRoot;
    }

    public final ObjectProperty<TreeTableColumn<S, ?>> treeColumnProperty() {
        if (this.treeColumn == null) {
            this.treeColumn = new SimpleObjectProperty<Object>(this, "treeColumn", null);
        }
        return this.treeColumn;
    }

    public final void setTreeColumn(TreeTableColumn<S, ?> treeTableColumn) {
        this.treeColumnProperty().set(treeTableColumn);
    }

    public final TreeTableColumn<S, ?> getTreeColumn() {
        if (this.treeColumn == null) {
            return null;
        }
        return (TreeTableColumn)this.treeColumn.get();
    }

    public final void setSelectionModel(TreeTableView$TreeTableViewSelectionModel<S> treeTableView$TreeTableViewSelectionModel) {
        this.selectionModelProperty().set(treeTableView$TreeTableViewSelectionModel);
    }

    public final TreeTableView$TreeTableViewSelectionModel<S> getSelectionModel() {
        if (this.selectionModel == null) {
            return null;
        }
        return (TreeTableView$TreeTableViewSelectionModel)this.selectionModel.get();
    }

    public final ObjectProperty<TreeTableView$TreeTableViewSelectionModel<S>> selectionModelProperty() {
        if (this.selectionModel == null) {
            TreeTableView treeTableView = this;
            this.selectionModel = new TreeTableView$6(treeTableView, treeTableView, "selectionModel");
        }
        return this.selectionModel;
    }

    public final void setFocusModel(TreeTableView$TreeTableViewFocusModel<S> treeTableView$TreeTableViewFocusModel) {
        this.focusModelProperty().set(treeTableView$TreeTableViewFocusModel);
    }

    public final TreeTableView$TreeTableViewFocusModel<S> getFocusModel() {
        if (this.focusModel == null) {
            return null;
        }
        return (TreeTableView$TreeTableViewFocusModel)this.focusModel.get();
    }

    public final ObjectProperty<TreeTableView$TreeTableViewFocusModel<S>> focusModelProperty() {
        if (this.focusModel == null) {
            this.focusModel = new SimpleObjectProperty<TreeTableView$TreeTableViewFocusModel<S>>(this, "focusModel");
        }
        return this.focusModel;
    }

    public final ReadOnlyIntegerProperty expandedItemCountProperty() {
        return this.expandedItemCount.getReadOnlyProperty();
    }

    private void setExpandedItemCount(int n2) {
        this.expandedItemCount.set(n2);
    }

    public final int getExpandedItemCount() {
        if (this.expandedItemCountDirty) {
            TreeTableView treeTableView = this;
            treeTableView.updateExpandedItemCount(treeTableView.getRoot());
        }
        return this.expandedItemCount.get();
    }

    public final void setEditable(boolean bl2) {
        this.editableProperty().set(bl2);
    }

    public final boolean isEditable() {
        if (this.editable == null) {
            return false;
        }
        return this.editable.get();
    }

    public final BooleanProperty editableProperty() {
        if (this.editable == null) {
            this.editable = new SimpleBooleanProperty(this, "editable", false);
        }
        return this.editable;
    }

    private void setEditingCell(TreeTablePosition<S, ?> treeTablePosition) {
        this.editingCellPropertyImpl().set(treeTablePosition);
    }

    public final TreeTablePosition<S, ?> getEditingCell() {
        if (this.editingCell == null) {
            return null;
        }
        return (TreeTablePosition)this.editingCell.get();
    }

    public final ReadOnlyObjectProperty<TreeTablePosition<S, ?>> editingCellProperty() {
        return this.editingCellPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<TreeTablePosition<S, ?>> editingCellPropertyImpl() {
        if (this.editingCell == null) {
            this.editingCell = new ReadOnlyObjectWrapper(this, "editingCell");
        }
        return this.editingCell;
    }

    public final BooleanProperty tableMenuButtonVisibleProperty() {
        if (this.tableMenuButtonVisible == null) {
            this.tableMenuButtonVisible = new SimpleBooleanProperty(this, "tableMenuButtonVisible");
        }
        return this.tableMenuButtonVisible;
    }

    public final void setTableMenuButtonVisible(boolean bl2) {
        this.tableMenuButtonVisibleProperty().set(bl2);
    }

    public final boolean isTableMenuButtonVisible() {
        if (this.tableMenuButtonVisible == null) {
            return false;
        }
        return this.tableMenuButtonVisible.get();
    }

    public final void setColumnResizePolicy(Callback<TreeTableView$ResizeFeatures, Boolean> callback) {
        this.columnResizePolicyProperty().set(callback);
    }

    public final Callback<TreeTableView$ResizeFeatures, Boolean> getColumnResizePolicy() {
        if (this.columnResizePolicy == null) {
            return UNCONSTRAINED_RESIZE_POLICY;
        }
        return (Callback)this.columnResizePolicy.get();
    }

    public final ObjectProperty<Callback<TreeTableView$ResizeFeatures, Boolean>> columnResizePolicyProperty() {
        if (this.columnResizePolicy == null) {
            TreeTableView treeTableView = this;
            this.columnResizePolicy = new TreeTableView$7(treeTableView, treeTableView, "columnResizePolicy", UNCONSTRAINED_RESIZE_POLICY);
        }
        return this.columnResizePolicy;
    }

    public final ObjectProperty<Callback<TreeTableView<S>, TreeTableRow<S>>> rowFactoryProperty() {
        if (this.rowFactory == null) {
            this.rowFactory = new SimpleObjectProperty<Callback<TreeTableView<S>, TreeTableRow<S>>>(this, "rowFactory");
        }
        return this.rowFactory;
    }

    public final void setRowFactory(Callback<TreeTableView<S>, TreeTableRow<S>> callback) {
        this.rowFactoryProperty().set(callback);
    }

    public final Callback<TreeTableView<S>, TreeTableRow<S>> getRowFactory() {
        if (this.rowFactory == null) {
            return null;
        }
        return (Callback)this.rowFactory.get();
    }

    public final ObjectProperty<Node> placeholderProperty() {
        if (this.placeholder == null) {
            this.placeholder = new SimpleObjectProperty<Node>(this, "placeholder");
        }
        return this.placeholder;
    }

    public final void setPlaceholder(Node node) {
        this.placeholderProperty().set(node);
    }

    public final Node getPlaceholder() {
        if (this.placeholder == null) {
            return null;
        }
        return (Node)this.placeholder.get();
    }

    public final void setFixedCellSize(double d2) {
        this.fixedCellSizeProperty().set(d2);
    }

    public final double getFixedCellSize() {
        if (this.fixedCellSize == null) {
            return -1.0;
        }
        return this.fixedCellSize.get();
    }

    public final DoubleProperty fixedCellSizeProperty() {
        if (this.fixedCellSize == null) {
            this.fixedCellSize = new TreeTableView$8(this, -1.0);
        }
        return this.fixedCellSize;
    }

    public final ObjectProperty<TreeSortMode> sortModeProperty() {
        if (this.sortMode == null) {
            this.sortMode = new SimpleObjectProperty<TreeSortMode>(this, "sortMode", TreeSortMode.ALL_DESCENDANTS);
        }
        return this.sortMode;
    }

    public final void setSortMode(TreeSortMode treeSortMode) {
        this.sortModeProperty().set(treeSortMode);
    }

    public final TreeSortMode getSortMode() {
        if (this.sortMode == null) {
            return TreeSortMode.ALL_DESCENDANTS;
        }
        return (TreeSortMode)((Object)this.sortMode.get());
    }

    private void setComparator(Comparator<TreeItem<S>> comparator) {
        this.comparatorPropertyImpl().set(comparator);
    }

    public final Comparator<TreeItem<S>> getComparator() {
        if (this.comparator == null) {
            return null;
        }
        return (Comparator)this.comparator.get();
    }

    public final ReadOnlyObjectProperty<Comparator<TreeItem<S>>> comparatorProperty() {
        return this.comparatorPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<Comparator<TreeItem<S>>> comparatorPropertyImpl() {
        if (this.comparator == null) {
            this.comparator = new ReadOnlyObjectWrapper(this, "comparator");
        }
        return this.comparator;
    }

    public final void setSortPolicy(Callback<TreeTableView<S>, Boolean> callback) {
        this.sortPolicyProperty().set(callback);
    }

    public final Callback<TreeTableView<S>, Boolean> getSortPolicy() {
        if (this.sortPolicy == null) {
            return DEFAULT_SORT_POLICY;
        }
        return (Callback)this.sortPolicy.get();
    }

    public final ObjectProperty<Callback<TreeTableView<S>, Boolean>> sortPolicyProperty() {
        if (this.sortPolicy == null) {
            TreeTableView treeTableView = this;
            this.sortPolicy = new TreeTableView$9(treeTableView, treeTableView, "sortPolicy", DEFAULT_SORT_POLICY);
        }
        return this.sortPolicy;
    }

    public void setOnSort(EventHandler<SortEvent<TreeTableView<S>>> eventHandler) {
        this.onSortProperty().set(eventHandler);
    }

    public EventHandler<SortEvent<TreeTableView<S>>> getOnSort() {
        if (this.onSort != null) {
            return (EventHandler)this.onSort.get();
        }
        return null;
    }

    public ObjectProperty<EventHandler<SortEvent<TreeTableView<S>>>> onSortProperty() {
        if (this.onSort == null) {
            this.onSort = new TreeTableView$10(this);
        }
        return this.onSort;
    }

    @Override
    protected void layoutChildren() {
        if (this.expandedItemCountDirty) {
            TreeTableView treeTableView = this;
            treeTableView.updateExpandedItemCount(treeTableView.getRoot());
        }
        super.layoutChildren();
    }

    public void scrollTo(int n2) {
        ControlUtils.scrollToIndex(this, n2);
    }

    public void setOnScrollTo(EventHandler<ScrollToEvent<Integer>> eventHandler) {
        this.onScrollToProperty().set(eventHandler);
    }

    public EventHandler<ScrollToEvent<Integer>> getOnScrollTo() {
        if (this.onScrollTo != null) {
            return (EventHandler)this.onScrollTo.get();
        }
        return null;
    }

    public ObjectProperty<EventHandler<ScrollToEvent<Integer>>> onScrollToProperty() {
        if (this.onScrollTo == null) {
            this.onScrollTo = new TreeTableView$11(this);
        }
        return this.onScrollTo;
    }

    public void scrollToColumn(TreeTableColumn<S, ?> treeTableColumn) {
        ControlUtils.scrollToColumn(this, treeTableColumn);
    }

    public void scrollToColumnIndex(int n2) {
        if (this.getColumns() != null) {
            TreeTableView treeTableView = this;
            ControlUtils.scrollToColumn(treeTableView, (TableColumnBase)treeTableView.getColumns().get(n2));
        }
    }

    public void setOnScrollToColumn(EventHandler<ScrollToEvent<TreeTableColumn<S, ?>>> eventHandler) {
        this.onScrollToColumnProperty().set(eventHandler);
    }

    public EventHandler<ScrollToEvent<TreeTableColumn<S, ?>>> getOnScrollToColumn() {
        if (this.onScrollToColumn != null) {
            return (EventHandler)this.onScrollToColumn.get();
        }
        return null;
    }

    public ObjectProperty<EventHandler<ScrollToEvent<TreeTableColumn<S, ?>>>> onScrollToColumnProperty() {
        if (this.onScrollToColumn == null) {
            this.onScrollToColumn = new TreeTableView$12(this);
        }
        return this.onScrollToColumn;
    }

    public int getRow(TreeItem<S> treeItem) {
        return TreeUtil.getRow(treeItem, this.getRoot(), this.expandedItemCountDirty, this.isShowRoot());
    }

    public TreeItem<S> getTreeItem(int n2) {
        TreeItem<S> treeItem;
        if (n2 < 0) {
            return null;
        }
        int n3 = n2 = this.isShowRoot() ? n2 : n2 + 1;
        if (this.expandedItemCountDirty) {
            TreeTableView treeTableView = this;
            treeTableView.updateExpandedItemCount(treeTableView.getRoot());
        } else if (this.treeItemCacheMap.containsKey(n2)) {
            treeItem = this.treeItemCacheMap.get(n2);
            if ((treeItem = ((SoftReference)((Object)treeItem)).get()) != null) {
                return treeItem;
            }
        }
        treeItem = TreeUtil.getItem(this.getRoot(), n2, this.expandedItemCountDirty);
        this.treeItemCacheMap.put(n2, new SoftReference<TreeItem<S>>(treeItem));
        return treeItem;
    }

    public int getTreeItemLevel(TreeItem<?> treeItem) {
        TreeItem<S> treeItem2 = this.getRoot();
        if (treeItem == null) {
            return -1;
        }
        if (treeItem == treeItem2) {
            return 0;
        }
        int n2 = 0;
        for (treeItem = treeItem.getParent(); treeItem != null; treeItem = treeItem.getParent()) {
            ++n2;
            if (treeItem == treeItem2) break;
        }
        return n2;
    }

    public final ObservableList<TreeTableColumn<S, ?>> getColumns() {
        return this.columns;
    }

    public final ObservableList<TreeTableColumn<S, ?>> getSortOrder() {
        return this.sortOrder;
    }

    public boolean resizeColumn(TreeTableColumn<S, ?> treeTableColumn, double d2) {
        if (treeTableColumn == null || Double.compare(d2, 0.0) == 0) {
            return false;
        }
        boolean bl2 = this.getColumnResizePolicy().call(new TreeTableView$ResizeFeatures<S>(this, treeTableColumn, d2));
        return bl2;
    }

    public void edit(int n2, TreeTableColumn<S, ?> treeTableColumn) {
        if (!this.isEditable() || treeTableColumn != null && !treeTableColumn.isEditable()) {
            return;
        }
        if (n2 < 0 && treeTableColumn == null) {
            this.setEditingCell(null);
            return;
        }
        this.setEditingCell(new TreeTablePosition(this, n2, treeTableColumn));
    }

    public ObservableList<TreeTableColumn<S, ?>> getVisibleLeafColumns() {
        return this.unmodifiableVisibleLeafColumns;
    }

    public int getVisibleLeafIndex(TreeTableColumn<S, ?> treeTableColumn) {
        return this.getVisibleLeafColumns().indexOf(treeTableColumn);
    }

    public TreeTableColumn<S, ?> getVisibleLeafColumn(int n2) {
        if (n2 < 0 || n2 >= this.visibleLeafColumns.size()) {
            return null;
        }
        return (TreeTableColumn)this.visibleLeafColumns.get(n2);
    }

    boolean isSortingInProgress() {
        return this.sortingInProgress;
    }

    public void sort() {
        Object object;
        Object object2;
        ArrayList arrayList;
        this.sortingInProgress = true;
        ObservableList object32 = this.getSortOrder();
        Comparator<TreeItem<S>> comparator = this.getComparator();
        this.setComparator(object32.isEmpty() ? null : new TableColumnComparatorBase$TreeTableColumnComparator(object32));
        TreeTableView treeTableView = this;
        TreeTableView$TreeTableViewSelectionModel<S> treeTableView$TreeTableViewSelectionModel = new SortEvent<TreeTableView>(treeTableView, treeTableView);
        this.fireEvent((Event)((Object)treeTableView$TreeTableViewSelectionModel));
        if (((Event)((Object)treeTableView$TreeTableViewSelectionModel)).isConsumed()) {
            this.sortingInProgress = false;
            return;
        }
        treeTableView$TreeTableViewSelectionModel = this.getSelectionModel();
        ArrayList arrayList2 = arrayList = treeTableView$TreeTableViewSelectionModel == null ? null : new ArrayList(treeTableView$TreeTableViewSelectionModel.getSelectedCells());
        if (treeTableView$TreeTableViewSelectionModel != null) {
            treeTableView$TreeTableViewSelectionModel.startAtomic();
        }
        if ((object2 = this.getSortPolicy()) == null) {
            this.sortingInProgress = false;
            return;
        }
        object2 = object2.call(this);
        if (arrayList != null && this.getSortMode() == TreeSortMode.ALL_DESCENDANTS) {
            object = new HashSet();
            for (TreeTablePosition treeTablePosition : arrayList) {
                if (treeTablePosition.getTreeItem() == null) continue;
                for (TreeItem treeItem = treeTablePosition.getTreeItem().getParent(); treeItem != null && object.add(treeItem); treeItem = treeItem.getParent()) {
                    treeItem.getChildren();
                }
            }
        }
        if (treeTableView$TreeTableViewSelectionModel != null) {
            treeTableView$TreeTableViewSelectionModel.stopAtomic();
        }
        if (object2 == null || !((Boolean)object2).booleanValue()) {
            this.sortLock = true;
            TableUtil.handleSortFailure(object32, this.lastSortEventType, this.lastSortEventSupportInfo);
            this.setComparator(comparator);
            this.sortLock = false;
        } else {
            if (treeTableView$TreeTableViewSelectionModel instanceof TreeTableView$TreeTableViewArrayListSelectionModel) {
                object = (TreeTableView$TreeTableViewArrayListSelectionModel)treeTableView$TreeTableViewSelectionModel;
                ObservableList observableList = ((TreeTableView$TreeTableViewSelectionModel)object).getSelectedCells();
                ArrayList<TreeTablePosition> arrayList3 = new ArrayList<TreeTablePosition>();
                if (arrayList != null) {
                    for (TreeTablePosition treeTablePosition : arrayList) {
                        if (observableList.contains(treeTablePosition)) continue;
                        arrayList3.add(treeTablePosition);
                    }
                }
                if (!arrayList3.isEmpty()) {
                    int n2 = arrayList == null ? 0 : arrayList.size();
                    NonIterableChange$GenericAddRemoveChange nonIterableChange$GenericAddRemoveChange = new NonIterableChange$GenericAddRemoveChange(0, n2, arrayList3, observableList);
                    ((TreeTableView$TreeTableViewArrayListSelectionModel)object).fireCustomSelectedCellsListChangeEvent(nonIterableChange$GenericAddRemoveChange);
                }
            }
            if (treeTableView$TreeTableViewSelectionModel != null) {
                treeTableView$TreeTableViewSelectionModel.setSelectedIndex(this.getRow((TreeItem)treeTableView$TreeTableViewSelectionModel.getSelectedItem()));
            }
            ((FocusModel)this.getFocusModel()).focus(treeTableView$TreeTableViewSelectionModel == null ? -1 : treeTableView$TreeTableViewSelectionModel.getSelectedIndex());
        }
        this.sortingInProgress = false;
    }

    public void refresh() {
        this.getProperties().put("recreateKey", Boolean.TRUE);
    }

    private void doSort(TableUtil$SortEventType tableUtil$SortEventType, Object ... objectArray) {
        if (this.sortLock) {
            return;
        }
        this.lastSortEventType = tableUtil$SortEventType;
        this.lastSortEventSupportInfo = objectArray;
        this.sort();
        this.lastSortEventType = null;
        this.lastSortEventSupportInfo = null;
    }

    private void updateExpandedItemCount(TreeItem<S> treeItem) {
        this.setExpandedItemCount(TreeUtil.updateExpandedItemCount(treeItem, this.expandedItemCountDirty, this.isShowRoot()));
        if (this.expandedItemCountDirty) {
            this.treeItemCacheMap.clear();
        }
        this.expandedItemCountDirty = false;
    }

    private void updateRootExpanded() {
        if (!this.isShowRoot() && this.getRoot() != null && !this.getRoot().isExpanded()) {
            this.getRoot().setExpanded(true);
        }
    }

    private void setContentWidth(double d2) {
        this.contentWidth = d2;
        if (this.isInited) {
            this.getColumnResizePolicy().call(new TreeTableView$ResizeFeatures(this, null, 0.0));
        }
    }

    private void updateVisibleLeafColumns() {
        ArrayList arrayList = new ArrayList();
        TreeTableView treeTableView = this;
        treeTableView.buildVisibleLeafColumns(treeTableView.getColumns(), arrayList);
        this.visibleLeafColumns.setAll(arrayList);
        this.getColumnResizePolicy().call(new TreeTableView$ResizeFeatures(this, null, 0.0));
    }

    private void buildVisibleLeafColumns(List<TreeTableColumn<S, ?>> object, List<TreeTableColumn<S, ?>> list) {
        object = object.iterator();
        while (object.hasNext()) {
            TreeTableColumn treeTableColumn = (TreeTableColumn)object.next();
            if (treeTableColumn == null) continue;
            boolean bl2 = !((TableColumnBase)treeTableColumn).getColumns().isEmpty();
            if (bl2) {
                this.buildVisibleLeafColumns(((TableColumnBase)treeTableColumn).getColumns(), list);
                continue;
            }
            if (!treeTableColumn.isVisible()) continue;
            list.add(treeTableColumn);
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return TreeTableView$StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return TreeTableView.getClassCssMetaData();
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new TreeTableViewSkin(this);
    }

    @Override
    public Object queryAccessibleAttribute(AccessibleAttribute accessibleAttribute, Object ... objectArray) {
        switch (accessibleAttribute) {
            case ROW_COUNT: {
                return this.getExpandedItemCount();
            }
            case COLUMN_COUNT: {
                return this.getVisibleLeafColumns().size();
            }
            case SELECTED_ITEMS: {
                Object object = (ObservableList)super.queryAccessibleAttribute(accessibleAttribute, objectArray);
                ArrayList arrayList = new ArrayList();
                if (object != null) {
                    object = object.iterator();
                    while (object.hasNext()) {
                        Object object2 = (TreeTableRow)object.next();
                        if ((object2 = (List)((Node)object2).queryAccessibleAttribute(accessibleAttribute, objectArray)) == null) continue;
                        arrayList.addAll(object2);
                    }
                }
                return FXCollections.observableArrayList(arrayList);
            }
            case FOCUS_ITEM: {
                Node node = (Node)super.queryAccessibleAttribute(accessibleAttribute, objectArray);
                if (node == null) {
                    return null;
                }
                Node node2 = (Node)node.queryAccessibleAttribute(accessibleAttribute, objectArray);
                if (node2 != null) {
                    return node2;
                }
                return node;
            }
            case CELL_AT_ROW_COLUMN: {
                TreeTableRow treeTableRow = (TreeTableRow)super.queryAccessibleAttribute(accessibleAttribute, objectArray);
                if (treeTableRow != null) {
                    return ((Node)treeTableRow).queryAccessibleAttribute(accessibleAttribute, objectArray);
                }
                return null;
            }
            case MULTIPLE_SELECTION: {
                TreeTableView$TreeTableViewSelectionModel<S> treeTableView$TreeTableViewSelectionModel = this.getSelectionModel();
                return treeTableView$TreeTableViewSelectionModel != null && treeTableView$TreeTableViewSelectionModel.getSelectionMode() == SelectionMode.MULTIPLE;
            }
        }
        return super.queryAccessibleAttribute(accessibleAttribute, objectArray);
    }

    static /* synthetic */ void access$000(TreeTableView treeTableView, EventType eventType, EventHandler eventHandler) {
        treeTableView.setEventHandler(eventType, eventHandler);
    }

    static /* synthetic */ void access$100(TreeTableView treeTableView, EventType eventType, EventHandler eventHandler) {
        treeTableView.setEventHandler(eventType, eventHandler);
    }

    static /* synthetic */ void access$200(TreeTableView treeTableView, EventType eventType, EventHandler eventHandler) {
        treeTableView.setEventHandler(eventType, eventHandler);
    }

    static {
        CONSTRAINED_RESIZE_POLICY = CONSTRAINED_RESIZE_POLICY_FLEX_LAST_COLUMN = ConstrainedColumnResize.forTreeTable(ConstrainedColumnResize$ResizeMode.AUTO_RESIZE_FLEX_TAIL);
        DEFAULT_SORT_POLICY = new TreeTableView$2();
        PSEUDO_CLASS_CELL_SELECTION = PseudoClass.getPseudoClass("cell-selection");
        PSEUDO_CLASS_ROW_SELECTION = PseudoClass.getPseudoClass("row-selection");
    }
}

