/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.scene.control.ReadOnlyUnbackedObservableList;
import com.sun.javafx.scene.control.behavior.TreeCellBehavior;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener$Change;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.scene.AccessibleAttribute;
import javafx.scene.control.ControlUtils;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.MultipleSelectionModelBase;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeItem$TreeModificationEvent;
import javafx.scene.control.TreeView;

class TreeView$TreeViewBitSetSelectionModel<T>
extends MultipleSelectionModelBase<TreeItem<T>> {
    private TreeView<T> treeView = null;
    private ChangeListener<TreeItem<T>> rootPropertyListener = (observableValue, treeItem, treeItem2) -> {
        this.updateDefaultSelection();
        this.updateTreeEventListener((TreeItem<T>)treeItem, (TreeItem<T>)treeItem2);
    };
    private EventHandler<TreeItem$TreeModificationEvent<T>> treeItemListener = treeItem$TreeModificationEvent -> {
        Integer n2;
        if (this.getSelectedIndex() == -1 && this.getSelectedItem() == null) {
            return;
        }
        TreeItem treeItem = treeItem$TreeModificationEvent.getTreeItem();
        if (treeItem == null) {
            return;
        }
        this.treeView.expandedItemCountDirty = true;
        int n3 = this.treeView.getRow(treeItem);
        int n4 = 0;
        ListChangeListener$Change listChangeListener$Change = treeItem$TreeModificationEvent.getChange();
        if (listChangeListener$Change != null) {
            listChangeListener$Change.next();
        }
        do {
            int n5;
            int n6;
            int n7;
            int n8 = listChangeListener$Change == null ? 0 : listChangeListener$Change.getAddedSize();
            int n9 = n7 = listChangeListener$Change == null ? 0 : listChangeListener$Change.getRemovedSize();
            if (treeItem$TreeModificationEvent.wasExpanded()) {
                n4 += treeItem.getExpandedDescendentCount(false) - 1;
                ++n3;
                continue;
            }
            if (treeItem$TreeModificationEvent.wasCollapsed()) {
                treeItem.getExpandedDescendentCount(false);
                n8 = treeItem.previousExpandedDescendentCount;
                n6 = this.getSelectedIndex();
                boolean bl2 = n6 >= n3 + 1 && n6 < n3 + n8;
                boolean bl3 = false;
                ((ReadOnlyUnbackedObservableList)this.selectedIndices)._beginChange();
                int n10 = n3 + 1;
                n5 = n3 + n8;
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int i2 = n10; i2 < n5; ++i2) {
                    if (!((SelectionModel)this).isSelected(i2)) continue;
                    bl3 = true;
                    arrayList.add(i2);
                }
                if (!arrayList.isEmpty()) {
                    ((ReadOnlyUnbackedObservableList)this.selectedIndices)._nextRemove(((ReadOnlyUnbackedObservableList)this.selectedIndices).indexOf(arrayList.get(0)), arrayList);
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    int n11 = (Integer)iterator.next();
                    this.startAtomic();
                    ((SelectionModel)this).clearSelection(n11);
                    this.stopAtomic();
                }
                ((ReadOnlyUnbackedObservableList)this.selectedIndices)._endChange();
                if (bl2 && bl3) {
                    ((SelectionModel)this).select(n3);
                }
                n4 += -n8 + 1;
                ++n3;
                continue;
            }
            if (treeItem$TreeModificationEvent.wasPermutated()) continue;
            if (treeItem$TreeModificationEvent.wasAdded()) {
                n4 += ControlUtils.isTreeItemIncludingAncestorsExpanded(treeItem) ? n8 : 0;
                n3 = this.treeView.getRow(treeItem$TreeModificationEvent.getChange().getAddedSubList().get(0));
                continue;
            }
            if (!treeItem$TreeModificationEvent.wasRemoved()) continue;
            n3 += treeItem$TreeModificationEvent.getFrom() + 1;
            ObservableList<Integer> observableList = ((MultipleSelectionModel)this).getSelectedIndices();
            n6 = this.getSelectedIndex();
            ObservableList observableList2 = ((MultipleSelectionModel)this).getSelectedItems();
            TreeItem treeItem3 = (TreeItem)this.getSelectedItem();
            List list = treeItem$TreeModificationEvent.getChange().getRemoved();
            if (ControlUtils.isTreeItemIncludingAncestorsExpanded(treeItem)) {
                n5 = observableList2.stream().map(treeItem2 -> ControlUtils.getIndexOfChildWithDescendant(treeItem, treeItem2)).max(Comparator.naturalOrder()).orElse(-1);
                if (treeItem$TreeModificationEvent.getFrom() <= n5 || n5 == -1) {
                    n4 -= n7;
                }
            }
            for (n5 = 0; n5 < observableList.size() && !observableList2.isEmpty() && (n7 = ((Integer)observableList.get(n5)).intValue()) <= observableList2.size(); ++n5) {
                int n12;
                Object object;
                if (list.size() != 1 || observableList2.size() != 1 || treeItem3 == null || !treeItem3.equals(list.get(0)) || n6 >= this.getItemCount() || treeItem3.equals(object = this.getModelItem(n12 = n6 == 0 ? 0 : n6 - 1))) continue;
                this.select((TreeItem<T>)object);
            }
        } while (treeItem$TreeModificationEvent.getChange() != null && treeItem$TreeModificationEvent.getChange().next());
        this.shiftSelection(n3, n4, null);
        if ((treeItem$TreeModificationEvent.wasAdded() || treeItem$TreeModificationEvent.wasRemoved()) && (n2 = (Integer)TreeCellBehavior.getAnchor(this.treeView, null)) != null && ((SelectionModel)this).isSelected(n2 + n4)) {
            TreeCellBehavior.setAnchor(this.treeView, n2 + n4, false);
        }
    };
    private WeakChangeListener<TreeItem<T>> weakRootPropertyListener = new WeakChangeListener<TreeItem<TreeItem<T>>>(this.rootPropertyListener);
    private WeakEventHandler<TreeItem$TreeModificationEvent<T>> weakTreeItemListener;
    private InvalidationListener showRootListener;

    public TreeView$TreeViewBitSetSelectionModel(TreeView<T> treeView) {
        if (treeView == null) {
            throw new IllegalArgumentException("TreeView can not be null");
        }
        this.treeView = treeView;
        this.treeView.rootProperty().addListener(this.weakRootPropertyListener);
        this.showRootListener = observable -> this.shiftSelection(0, treeView.isShowRoot() ? 1 : -1, null);
        this.treeView.showRootProperty().addListener(new WeakInvalidationListener(this.showRootListener));
        this.updateTreeEventListener(null, treeView.getRoot());
        this.updateDefaultSelection();
    }

    private void updateTreeEventListener(TreeItem<T> treeItem, TreeItem<T> treeItem2) {
        if (treeItem != null && this.weakTreeItemListener != null) {
            treeItem.removeEventHandler(TreeItem.expandedItemCountChangeEvent(), this.weakTreeItemListener);
        }
        if (treeItem2 != null) {
            this.weakTreeItemListener = new WeakEventHandler<TreeItem$TreeModificationEvent<TreeItem$TreeModificationEvent<T>>>(this.treeItemListener);
            treeItem2.addEventHandler(TreeItem.expandedItemCountChangeEvent(), this.weakTreeItemListener);
        }
    }

    @Override
    public void selectAll() {
        int n2 = TreeCellBehavior.getAnchor(this.treeView, -1);
        super.selectAll();
        TreeCellBehavior.setAnchor(this.treeView, n2, false);
    }

    @Override
    public void select(TreeItem<T> treeItem) {
        if (treeItem == null && this.getSelectionMode() == SelectionMode.SINGLE) {
            ((SelectionModel)this).clearSelection();
            return;
        }
        if (treeItem != null) {
            for (TreeItem<T> treeItem2 = treeItem.getParent(); treeItem2 != null; treeItem2 = treeItem2.getParent()) {
                treeItem2.setExpanded(true);
            }
        }
        this.treeView.updateExpandedItemCount(this.treeView.getRoot());
        int n2 = this.treeView.getRow(treeItem);
        if (n2 == -1) {
            this.setSelectedIndex(-1);
            this.setSelectedItem(treeItem);
            return;
        }
        ((SelectionModel)this).select(n2);
    }

    @Override
    public void clearAndSelect(int n2) {
        TreeCellBehavior.setAnchor(this.treeView, n2, false);
        super.clearAndSelect(n2);
    }

    @Override
    protected void focus(int n2) {
        if (this.treeView.getFocusModel() != null) {
            this.treeView.getFocusModel().focus(n2);
        }
        this.treeView.notifyAccessibleAttributeChanged(AccessibleAttribute.FOCUS_ITEM);
    }

    @Override
    protected int getFocusedIndex() {
        if (this.treeView.getFocusModel() == null) {
            return -1;
        }
        return this.treeView.getFocusModel().getFocusedIndex();
    }

    @Override
    protected int getItemCount() {
        if (this.treeView == null) {
            return 0;
        }
        return this.treeView.getExpandedItemCount();
    }

    @Override
    public TreeItem<T> getModelItem(int n2) {
        if (this.treeView == null) {
            return null;
        }
        if (n2 < 0 || n2 >= this.treeView.getExpandedItemCount()) {
            return null;
        }
        return this.treeView.getTreeItem(n2);
    }

    private void updateDefaultSelection() {
        ((SelectionModel)this).clearSelection();
        TreeView$TreeViewBitSetSelectionModel treeView$TreeViewBitSetSelectionModel = this;
        treeView$TreeViewBitSetSelectionModel.focus(treeView$TreeViewBitSetSelectionModel.getItemCount() > 0 ? 0 : -1);
    }
}

